<?php
/** 
 * This template can be overridden by copying it to yourtheme/wp-amp/comments.php.
 *
 * @var $this AMPHTML_Template
 * @version 9.3.0
 */
/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
    return;
}
?>
<div id="comments" class="comments-area">
    <?php if ( have_comments() ) : ?>
        <h3 class="comments-title">
            <?php
            $comments_number = get_comments_number();
            if ( '1' === $comments_number ) {
                /* translators: %s: post title */
                printf( _x( 'One Reply to &ldquo;%s&rdquo;', 'comments title', 'amphtml' ), get_the_title() );
            } else {
                printf( /* translators: 1: number of comments, 2: post title */
                _nx( '%1$s Reply to &ldquo;%2$s&rdquo;', '%1$s Replies to &ldquo;%2$s&rdquo;', $comments_number, 'comments title', 'amphtml' ), number_format_i18n( $comments_number ), get_the_title() );
            }
            ?>
        </h3>
        <ul class="comment-list">
            <?php
            wp_list_comments( array(
                'avatar_size' => 24,
                'reply_text'  => false,
            ) );
            ?>
        </ul>
        <?php
    endif; // Check for have_comments().
    // If comments are closed and there are comments, let's leave a little note, shall we?
    if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
        ?>
        <p class="no-comments"><?php _e( 'Comments are closed.', 'amphtml' ); ?></p>
        <?php
    endif;
    ?>
</div>