<?php  
 defined('BASEPATH') OR exit('No direct script access allowed');  
 class Video extends CI_Controller { 
      public function __construct(){
          parent::__construct();
          $this->load->model("Basic_operation","basic_operation",true);  
          $this->load->library('form_validation'); 
          
          $auth = $this->session->userdata;
          if(empty($auth)){
               redirect(site_url().'main/login/');
          }

          
          if(empty($auth['role'])){
               redirect(site_url().'main/login/');
          } 
      } 
 
      public function index(){  
           $auth = $this->session->userdata;
          if($auth['role']==1){
             $this->db->select('users.*,videos.*,users.name as user_name');
             $this->db->from('videos');
             $this->db->join('users','users.id=videos.user_id');
             $data["fetch_data"] = $this->db->get()->result(); 
             
          }else{
              $data["fetch_data"] = $this->basic_operation->UniqueSelect('videos',array('user_id'=>$auth['id']));
          }  
           $this->load->view("admin/video", $data);  
      }  
      public function form_validation()  
      {        
               $auth = $this->session->userdata;
               if($auth['membership_type'] !=1){
                 redirect(site_url().'main/login/');  
               }
               if(!empty($_FILES['video_file']['name']) && !empty($_FILES['video_file']['tmp_name'])){
               $config['upload_path'] = './uploads/';
               $config['allowed_types'] = 'mp4|MKV|3GP';
               $config['encrypt_name'] = TRUE;
               $this->load->library('upload', $config);
               if (!$this->upload->do_upload('video_file')) {
                    $error = array('error' => $this->upload->display_errors());
                    $data["fetch_data"] = $this->basic_operation->selectData('videos');   
                    $data['error']=$error; 
                    $this->load->view("admin/video", $data);
                    
                    } else {
                    $d = $this->upload->data();
                    $data=array(
                         'video_title'=>$d['file_name'],
                         'user_id'=>$auth['id'],
                         'status'=>$this->input->post('status'),
                         'longitude'=>$auth['longitude'],
                        'latitude' =>$auth['latitude']
                    );     
                 }
               }else{
                    $data=array(
                         'user_id'=>$auth['id'],
                         'status'=>$this->input->post('status'),
                        'longitude'=>$auth['longitude'],
                        'latitude' =>$auth['latitude']
                    ); 
               }
               if($this->input->post("update"))  
               {  
                    $this->basic_operation->updateDetails('videos',$data, array('id'=>$this->input->post("hidden_id"))); 
                    $this->session->set_flashdata('success','Video Updated Successfully.');
                    redirect(base_url() . "video/index");  
               } 
               if($this->input->post("insert"))  
               { 
                  
                    $this->basic_operation->insertData('videos',$data);  
                    $this->session->set_flashdata('success','Video Added Successfully.');
                    redirect(base_url() . "video/index");  
               }           
      }  
     
      public function delete(){  
           $id = $this->uri->segment(3);  
           $this->basic_operation->deleteData('videos',array('id'=>$id));  
           $this->session->set_flashdata('success','Video Deleted Successfully.');
           redirect(base_url() . "video/index");  
      }  
       
      public function update(){  
          $auth = $this->session->userdata;
           $user_id = $this->uri->segment(3);  
            $data["user_data"] = $this->basic_operation->Uniqueselect('videos',array('id'=>$user_id));  
           $data["fetch_data"] = $this->basic_operation->UniqueSelect('videos',array('user_id'=>$auth['id']));  
           $this->load->view("admin/video", $data);  
      }
     
     public function getDistanceBetweenPoints($lat1, $lon1, $lat2, $lon2) {
          $theta = $lon1 - $lon2;
          $miles = (sin(deg2rad($lat1)) * sin(deg2rad($lat2))) + (cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta)));
          $miles = acos($miles);
          $miles = rad2deg($miles);
          $miles = $miles * 60 * 1.1515;
          $feet = $miles * 5280;
          $yards = $feet / 3;
          $kilometers = $miles * 1.609344;
          $meters = $kilometers * 1000;
          return compact('miles','feet','yards','kilometers','meters'); 
      }
      
 } 