<?php  
 defined('BASEPATH') OR exit('No direct script access allowed');  
 class Slots extends CI_Controller { 
      public function __construct(){
          parent::__construct();
          $this->load->model("Basic_operation","basic_operation",true);  
          $this->load->library('form_validation'); 
          
          $auth = $this->session->userdata;
          if(empty($auth)){
               redirect(site_url().'main/login/');
          }

          
          if(empty($auth['role'])){
               redirect(site_url().'main/login/');
          } 
      } 
 
      public function index(){  
           $auth = $this->session->userdata;
          if($auth['role']==1){
                $this->db->select('slots.*,users.name as vendor_name');
                $this->db->from('slots');
                $this->db->join('users', 'users.id = slots.user_id','left');
                $data['fetch_data'] = $this->db->get()->result(); 
          }else{
              $data["fetch_data"] = $this->basic_operation->UniqueSelect('slots',array('user_id'=>$auth['id']));
          } 
           $this->load->view("admin/slot", $data);  
      }  
      public function form_validation()  
      {        
            $auth = $this->session->userdata;
            $data=array(
                 'slot'=>$this->input->post('slot'),
                 'user_id'=>$auth['id'],
                 'status'=>$this->input->post('status'),
                 'longitude'=>$auth['longitude'],
                'latitude' =>$auth['latitude']
            );     
                
               if($this->input->post("update"))  
               {  
                    $this->basic_operation->updateDetails('slots',$data, array('id'=>$this->input->post("hidden_id")));  
                    $this->session->set_flashdata('success','Slot Updated Successfully.');
                    redirect(base_url() . "slots/index");  
               } 
               if($this->input->post("insert"))  
               {  
                    $this->basic_operation->insertData('slots',$data); 
                    $this->session->set_flashdata('success','Slot Added Successfully.');
                    redirect(base_url() . "slots/index");  
               }           
      }  
     
      public function delete(){  
           $id = $this->uri->segment(3);  
           $this->basic_operation->deleteData('slots',array('id'=>$id));
           $this->session->set_flashdata('success','Slot Deleted Successfully.');
           redirect(base_url() . "slots/index");  
      }  
       
      public function update(){ 
          $auth = $this->session->userdata;
           $user_id = $this->uri->segment(3);  
            $data["user_data"] = $this->basic_operation->Uniqueselect('slots',array('id'=>$user_id));  
           $data["fetch_data"] = $this->basic_operation->UniqueSelect('slots',array('user_id'=>$auth['id']));  
           $this->load->view("admin/slot", $data);  
      }
     
     public function getDistanceBetweenPoints($lat1, $lon1, $lat2, $lon2) {
          $theta = $lon1 - $lon2;
          $miles = (sin(deg2rad($lat1)) * sin(deg2rad($lat2))) + (cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta)));
          $miles = acos($miles);
          $miles = rad2deg($miles);
          $miles = $miles * 60 * 1.1515;
          $feet = $miles * 5280;
          $yards = $feet / 3;
          $kilometers = $miles * 1.609344;
          $meters = $kilometers * 1000;
          return compact('miles','feet','yards','kilometers','meters'); 
      }
      
 } 