<?php  
 defined('BASEPATH') OR exit('No direct script access allowed');  
 class Job extends CI_Controller { 
      public function __construct(){
          parent::__construct();
          $this->load->model("Basic_operation","basic_operation",true);  
          $this->load->library('form_validation'); 
          
          $auth = $this->session->userdata;
          if(empty($auth)){
               redirect(site_url().'main/login/');
          }

          
          if(empty($auth['role'])){
               redirect(site_url().'main/login/');
          } 
      } 
 
      public function index(){  
           $auth = $this->session->userdata;
          if($auth['role']==1){
             $this->db->select('users.*,jobs.*,users.name as user_name');
             $this->db->from('jobs');
             $this->db->join('users','users.id=jobs.vendor_id');
             $data["fetch_data"] = $this->db->get()->result();  
          }else{
              $data["fetch_data"] = $this->basic_operation->UniqueSelect('jobs',array('vendor_id'=>$auth['id']));
          }   
           $this->load->view("admin/job", $data);  
      }  
      public function form_validation()  
      {        
               $auth = $this->session->userdata;
               if(!empty($_FILES['image_file']['name']) && !empty($_FILES['image_file']['tmp_name'])){
               $config['upload_path'] = './uploads/';
               $config['allowed_types'] = 'jpeg|jpg|png';
               $config['encrypt_name'] = TRUE;
               $this->load->library('upload', $config);
               if (!$this->upload->do_upload('image_file')) {
                    $error = array('error' => $this->upload->display_errors());
                    $data["fetch_data"] = $this->basic_operation->selectData('services');   
                    $data['error']=$error; 
                    $this->load->view("admin/service", $data);
                    
               }else{
               $d = $this->upload->data();
               $data=array(
                 'job_image'=>$d['file_name'],
                 'vendor_id'=>$auth['id'],
                 'vendor_name'=>$auth['name'],
                 'status'=>$this->input->post('status'),
                 'job_title' =>$this->input->post('job_title'),
                 'job_type' =>$this->input->post('job_type'),
                 'salery' =>$this->input->post('salery'),
                 'job_description' =>$this->input->post('job_description'),
                 'address' =>$this->input->post('address'),
                 'mobile' =>$this->input->post('mobile'),
                ); 
               }
               }else{
                  $data=array(
                     'vendor_id'=>$auth['id'],
                     'vendor_name'=>$auth['name'],
                     'status'=>$this->input->post('status'),
                     'job_title' =>$this->input->post('job_title'),
                     'job_type' =>$this->input->post('job_type'),
                     'salery' =>$this->input->post('salery'),
                     'job_description' =>$this->input->post('job_description'),
                     'address' =>$this->input->post('address'),
                     'mobile' =>$this->input->post('mobile'),
                  ); 
               }
               if($this->input->post("update"))  
               {  
                    $this->basic_operation->updateDetails('jobs',$data, array('job_id'=>$this->input->post("hidden_id"))); 
                    $this->session->set_flashdata('success','Job Updated Successfully.');
                    redirect(base_url() . "job/index");  
               } 
               if($this->input->post("insert"))  
               {  
                    $this->basic_operation->insertData('jobs',$data); 
                    $this->session->set_flashdata('success','Job Added Successfully.');
                    redirect(base_url() . "job/index");  
               } 
      }  
     
      public function delete(){  
           $id = $this->uri->segment(3);  
           $this->basic_operation->deleteData('jobs',array('job_id'=>$id)); 
           $this->session->set_flashdata('success','Job Deleted Successfully.');
           redirect(base_url() . "job/index");  
      }  
       
      public function update(){  
          $auth = $this->session->userdata;
           $job_id = $this->uri->segment(3);  
           $data["user_data"] = $this->basic_operation->Uniqueselect('jobs',array('job_id'=>$job_id));  
           $data["fetch_data"] = $this->basic_operation->UniqueSelect('jobs',array('vendor_id'=>$auth['id']));  
           $this->load->view("admin/job", $data);  
      }
     
     public function getDistanceBetweenPoints($lat1, $lon1, $lat2, $lon2) {
          $theta = $lon1 - $lon2;
          $miles = (sin(deg2rad($lat1)) * sin(deg2rad($lat2))) + (cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta)));
          $miles = acos($miles);
          $miles = rad2deg($miles);
          $miles = $miles * 60 * 1.1515;
          $feet = $miles * 5280;
          $yards = $feet / 3;
          $kilometers = $miles * 1.609344;
          $meters = $kilometers * 1000;
          return compact('miles','feet','yards','kilometers','meters'); 
      }
      
 } 