<?php  
 defined('BASEPATH') OR exit('No direct script access allowed');  
 class Gallery extends CI_Controller { 
      public function __construct(){
          parent::__construct();
          $this->load->model("Basic_operation","basic_operation",true);  
          $this->load->library('form_validation'); 
          $this->load->library('session');
          $auth = $this->session->userdata;
          if(empty($auth)){
               redirect(site_url().'main/login/');
          }

          
          if(empty($auth['role']) || $auth['role']==3){
               redirect(site_url().'main/login/');
          } 
      } 
 
      public function index(){  
          $auth = $this->session->userdata;
          if($auth['role']==1){
             $this->db->select('users.*,galleries.*');
             $this->db->from('galleries');
             $this->db->join('users','users.id=galleries.user_id');
             $results=$this->db->get()->result();
             $data["fetch_data"] = $results; 
          }else{
              $data["fetch_data"] = $this->basic_operation->UniqueSelect('galleries',array('user_id'=>$auth['id']));
          }   
           $this->load->view("admin/gallery", $data);  
      }  
      public function form_validation()  
      {        
               $auth = $this->session->userdata;
               if($auth['membership_type']==3){
                   redirect(site_url().'main/login/'); 
               }
               if(!empty($_FILES['image_file']['name']) && !empty($_FILES['image_file']['tmp_name'])){
               $config['upload_path'] = './uploads/';
               $config['allowed_types'] = 'jpeg|jpg|png';
               $config['encrypt_name'] = TRUE;
               $this->load->library('upload', $config);
               if (!$this->upload->do_upload('image_file')) {
                    $error = array('error' => $this->upload->display_errors());
                    $data["fetch_data"] = $this->basic_operation->selectData('galleries');   
                    $data['error']=$error; 
                    $this->load->view("admin/gallery", $data);
                    
                    } else {
                    $d = $this->upload->data();
                    $data=array(
                         'image'=>$d['file_name'],
                         'user_id'=>$auth['id'],
                         'status'=>$this->input->post('status'),
                         'longitude'=>$auth['longitude'],
                         'latitude' =>$auth['latitude']
                    );     
                 }
               }else{
                    $data=array(
                         'user_id'=>$auth['id'],
                         'status'=>$this->input->post('status'),
                        'longitude'=>$auth['longitude'],
                        'latitude' =>$auth['latitude']
                    ); 
               }
               if($this->input->post("update"))  
               {    
                    $this->basic_operation->updateDetails('galleries',$data, array('id'=>$this->input->post("hidden_id")));  
                    $this->session->set_flashdata('success','Gallery Updated Successfully.');
                    redirect(base_url() . "gallery/index");  
               } 
               if($this->input->post("insert"))  
               {   
                
                   $rowsCount=$this->basic_operation->matchedRowCount('galleries',array('user_id'=>$auth['id']));
                   if($rowsCount <= $auth['gallery_counter']){
                    $this->basic_operation->insertData('galleries',$data); 
                    $this->session->set_flashdata('success','Gallery Added Successfully.');
                    redirect(base_url() . "gallery/index"); 
                   }
                   else{
                      $this->session->set_flashdata('error','For Add more You have Need To Upgrade !.'); 
                      redirect(base_url() . "gallery/index");
                   }
               }           
      }  
     
      public function delete(){  
           $id = $this->uri->segment(3);  
           $this->basic_operation->deleteData('galleries',array('id'=>$id));  
            $this->session->set_flashdata('success','Gallery Deleted Successfully.');
           redirect(base_url() . "gallery/index");  
      }  
       
      public function update(){  
           $auth = $this->session->userdata;
           $user_id = $this->uri->segment(3);  
            $data["user_data"] = $this->basic_operation->Uniqueselect('galleries',array('id'=>$user_id));  
           $data["fetch_data"] = $this->basic_operation->UniqueSelect('galleries',array('user_id'=>$auth['id'])); 
           $this->load->view("admin/gallery", $data);  
      }
     
     public function getDistanceBetweenPoints($lat1, $lon1, $lat2, $lon2) {
          $theta = $lon1 - $lon2;
          $miles = (sin(deg2rad($lat1)) * sin(deg2rad($lat2))) + (cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta)));
          $miles = acos($miles);
          $miles = rad2deg($miles);
          $miles = $miles * 60 * 1.1515;
          $feet = $miles * 5280;
          $yards = $feet / 3;
          $kilometers = $miles * 1.609344;
          $meters = $kilometers * 1000;
          return compact('miles','feet','yards','kilometers','meters'); 
      }
      
 } 