<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Data extends CI_Controller {

    public function __construct() 
     {
        Parent::__construct();
        
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $method = $_SERVER['REQUEST_METHOD'];
        if($method == "OPTIONS") {
        die();
        } 
        
        $this->load->database();
        $this->load->model("Basic_operation","basic_operation",true);
        $this->load->library('form_validation');
     }
    public function index(){
        $nearByMe=150000;
        $data=array();
        $colletion=array();
        $productsvendor=array();
        $videos=array();
        $offers=array();
        $saloons=array();
        $spa=array();
        
        if ($this->input->server('REQUEST_METHOD') == 'POST' && !empty($this->input->post('latitude')) && !empty($this->input->post('longitude') )){
            
            $userLatitude=(double)$this->input->post('latitude');
            $userLongitude=(double)$this->input->post('longitude');
            $gender=$this->input->post('gender');
            
            $this->db->select('users.*,users.name as user_name,users.company_logo as image,products.user_id');
            $this->db->group_by('products.user_id');
            $this->db->from('users','users.banned_users=unban');
            $this->db->join('products', 'products.user_id = users.id and products.status=1', 'inner');
            $results = $this->db->get()->result();
            foreach($results as $result){
             $distance=$this->getDistanceBetweenPointsNew($userLatitude,$userLongitude,(double)$result->latitude,(double)$result->longitude,'Km');
                if($distance <= $nearByMe){
                    $productsvendor[]=$result;
                }
            }
            $pv=array(
                'type'=>'Product Vendors',
                'id'=>1,
                'data'=>$productsvendor
                );
            $this->db->select('users.*, videos.*,users.name as user_name');
            $this->db->from('users','users.banned_users=unban');
            $this->db->join('videos', 'videos.user_id = users.id and videos.status=1 and videos.approved=1', 'inner');
            $this->db->group_by('videos.user_id');
            $results = $this->db->get()->result();
            foreach($results as $result){
             $distance=$this->getDistanceBetweenPointsNew($userLatitude,$userLongitude,(double)$result->latitude,(double)$result->longitude,'Km');
                if($distance <= $nearByMe){
                    $videos[]=$result;
                    
                }
            }
            $v=array(
                'type'=>'Golden Salon',
                'id'=>2,
                'data'=>$videos
                );
            $this->db->select('id,image,user_id,latitude,longitude');
            $this->db->from('offers');
            $results2 = $this->db->get()->result();
            foreach($results2 as $result2){
             $distance2=$this->getDistanceBetweenPointsNew($userLatitude,$userLongitude,(double)$result2->latitude,(double)$result2->longitude,'Km');
                if($distance2 <= $nearByMe){
                    $offers[]=$result2;
                }
            }
             $o=array(
                'type'=>'Offer',
                'id'=>3,
                'data'=>$offers
                );
            $this->db->select('users.*, services.user_id,users.name as user_name,users.company_logo as image');
            $this->db->from('users','users.banned_users=unban');
            $this->db->join('services', 'services.user_id = users.id and services.status=1 and services.category=1', 'inner');
            if(!empty($gender)){
            $this->db->where('services.gender', $gender);
            }
            $this->db->group_by('services.user_id');
            $results3 = $this->db->get()->result();
            foreach($results3 as $result3){
             $distance3=$this->getDistanceBetweenPointsNew($userLatitude,$userLongitude,(double)$result3->latitude,(double)$result3->longitude,'Km');
                if($distance3 <= $nearByMe){
                    $saloons[]=$result3;
                }
            }
             $s=array(
                'type'=>'Saloon',
                'id'=>4,
                'data'=>$saloons
                );
            $this->db->select('users.*, services.user_id,users.name as user_name,users.company_logo as image');
            $this->db->from('users','users.banned_users=unban');
            $this->db->join('services', 'services.user_id = users.id and services.status=1 and services.category=2', 'inner');
            if(!empty($gender)){
            $this->db->where('services.gender', $gender);
            }
            $this->db->group_by('services.user_id');
            $results4 = $this->db->get()->result();
           
            foreach($results4 as $result4){
             $distance4=$this->getDistanceBetweenPointsNew($userLatitude,$userLongitude,(double)$result4->latitude,(double)$result4->longitude,'Km');
                if($distance4 <= $nearByMe){
                    $spa[]=$result4;
                }
            }
             $sp=array(
                'type'=>'Spa',
                'id'=>5,
                'data'=>$spa
                );
            $data=array(
                $v,$s,$sp,$pv
                );
                $collection=array(
                'error'=>false,
                'message'=>'Request completed successfully.',
                'data'=>$data,
                'offers'=>$offers,
                );
        }else{
               $collection=array(
                'error'=>true,
                'message'=>'Data Not found Something Went Wrong',
                'data'=>array($data),
                'offers'=>$offers,
                );
        }
        
        
        echo json_encode($collection);
    }
    
    public function filteredData(){
            $nearByMe=150000;
        if ($this->input->server('REQUEST_METHOD') == 'POST'){
            $data=array();
            $price='';
            $userLatitude=(double)$this->input->post('latitude');
            $userLongitude=(double)$this->input->post('longitude');
            $service=$this->input->post('service');
            $vendor=$this->input->post('vendor');
            $price=$this->input->post('price');
            if(!empty($price)){
            $priceArr=explode('-',$price);
            $priceFrom=(int)$priceArr[0];
            $priceTo=(int)$priceArr[1];
            }
            
    
            $this->db->select('services.*,users.*,users.company_logo as image,services.image as service_image,users.name as user_name');
            $this->db->group_by('services.user_id');
            $this->db->from('services','services.status=1');
            $this->db->join('users', 'services.user_id = users.id', 'inner');
            if(!empty($service)){
            $this->db->like('services.name', $service);
            }
            if(!empty($vendor)){
            $this->db->or_like('services.vendor_name', $vendor);
            }
            if(!empty($price)){
            $this->db->where('services.price >=',$priceFrom);
            $this->db->where('services.price <=',$priceTo);
            }
            $results3 = $this->db->get()->result();
            foreach($results3 as $result3){
             $distance3=$this->getDistanceBetweenPointsNew($userLatitude,$userLongitude,(double)$result3->latitude,(double)$result3->longitude,'Km');
                if($distance3 <= $nearByMe){
                    $data=$result3;
                }
            }
          if(!empty($data)){
              $myData=array($data);
          } else{
              $myData=array();
          }
          $collection=array(
                'error'=>false,
                'message'=>'Request completed successfully.',
                'data'=>$myData
                ); 
          echo json_encode($collection);
        }
    }
    public function getFlashWish(){
        $count=$this->db->count_all('wishes');
        if($count > 0){
            $this->db->select('title,description,id');
            $this->db->limit(1);
            $this->db->order_by("id", "desc");
            $results=$this->db->get('wishes')->result();
            $collection=array(
                    'error'=>false,
                    'message'=>'Request completed successfully',
                    'data'=>@$results[0],
            ); 
        }else{
           $collection=array(
                    'error'=>false,
                    'message'=>'No data found',
                   
            );  
        }
        
        echo json_encode($collection);
    }
    public function viewAlls($id){
       switch ($id) {
            case 1:
                $this->db->select('*,company_logo as image,id as user_id,name as user_name');
                $this->db->from('users');
                $this->db->where('business_category','3');
                $results = $this->db->get()->result();
                $collection=array(
                        'error'=>false,
                        'message'=>'Request completed successfully',
                        'type'=>'Product Vendors',
                        'data'=>$results,
                        );
                break;
            case 2:
                $this->db->select('users.*, videos.*,users.name as user_name');
                $this->db->from('users','users.banned_users=unban');
                $this->db->join('videos', 'videos.user_id = users.id and videos.status=1', 'inner');
                $this->db->group_by('videos.user_id');
                $results = $this->db->get()->result();
                $collection=array(
                        'error'=>false,
                        'message'=>'Request completed successfully',
                        'type'=>'Videos',
                        'data'=>$results,
                        );
                break;
            case 3:
                $this->db->select('id,image,user_id');
                $this->db->from('offers');
                $results = $this->db->get()->result();
                $collection=array(
                        'error'=>false,
                        'message'=>'Request completed successfully',
                        'type'=>'Offers',
                        'data'=>$results,
                        );
                break;
            case 4:
                $this->db->select('users.*, services.*,users.name as user_name');
                $this->db->from('users','users.banned_users=unban');
                $this->db->join('services', 'services.user_id = users.id and services.status=1 and services.category=1', 'inner');
                $this->db->group_by('services.user_id');
                $results = $this->db->get()->result();
                $collection=array(
                        'error'=>false,
                        'message'=>'Request completed successfully',
                        'type'=>'Saloon',
                        'data'=>$results,
                        );
                break;
            case 5:
                $this->db->select('users.*, services.*,users.name as user_name');
                $this->db->from('users','users.banned_users=unban');
                $this->db->join('services', 'services.user_id = users.id and services.status=1 and services.category=2', 'inner');
                $this->db->group_by('services.user_id');
                $results = $this->db->get()->result();
                
                $collection=array(
                        'error'=>false,
                        'message'=>'Request completed successfully',
                        'type'=>'Spa',
                        'data'=>$results,
                        );
                break;
            default:
                
        }
        echo json_encode($collection);
    }
    
    public function checkForReview(){
        $user_id=$this->input->post('user_id');
        $vendor_id=$this->input->post('vendor_id');
        $num_rows=$this->basic_operation->matchedRowCount('bookings',array('user_id'=>$user_id,'vendor_id'=>$vendor_id));
        if($num_rows > 0){
            $collection=array(
                'error'=>false,
                'message'=>'Bookings are available on this vendor',
                );
        }else{
            $collection=array(
                'error'=>false,
                'message'=>'Bookings are not available on this vendor',
                );
        }
        echo json_encode($collection);
    }
    
    public function addToCart(){
       if ($this->input->server('REQUEST_METHOD') == 'POST'){
        $this->form_validation->set_rules('service_id', 'Service id', 'required');
        $this->form_validation->set_rules('user_id', 'user id', 'required');
        if ($this->form_validation->run() == FALSE) {
           
            $array = array(
                'error'    => true,
                'user_id' => form_error('user_id'),
                'service_id' => form_error('service_id'),
              );
        }else{
            $user_id=$this->input->post('user_id');
            $service_id=$this->input->post('service_id');
            $services=explode(',',$service_id);
            $form_data = array(
                 'user_id'   => $this->input->post('user_id'),
            );
            foreach($services as $service){
              $ServiceData  =$this->basic_operation->Uniqueselect('services',array('id'=>$service));
              $ServiceDetails=$ServiceData[0];
              $form_data['vendor_id']=$ServiceDetails->user_id;
              $form_data['service_id']=$ServiceDetails->id;
              $this->basic_operation->insertData('carts',$form_data);
            }
            $array=array(
                 'error'=>false,
                 'message'=>'Added To Cart Successfully'
             );
            
        }
        echo json_encode($array);
        }
        
    }
    
    public function myCart(){
        $user_id=$this->input->post('user_id');
        $this->db->select('carts.*,carts.id as cart_id,users.*, services.*,users.name as user_name,services.name as service_name');
        $this->db->from('carts');
        $this->db->join('services', 'services.id = carts.service_id');
        $this->db->join('users', 'users.id = carts.vendor_id');
        $this->db->where('carts.user_id',$user_id);
        $CartResults = $this->db->get()->result();
       
        $collection=array(
                'error'=>false,
                'message'=>'Request completed successfully',
                'data'=>$CartResults,
                );
        echo json_encode($collection);
        
    }
    
    public function deleteCartService(){
        $cart_id=$this->input->post('cart_id');
        $user_id=$this->input->post('user_id');
        $this->basic_operation->deleteData('carts',array('user_id'=>$user_id,'id'=>$cart_id));
        $collection=array(
                'error'=>false,
                'message'=>'Deleted From Cart',
            );
        echo json_encode($collection);
    }
    
    public function viewAllSaloon(){
        $this->db->select('users.*, services.*,users.name as user_name');
        $this->db->from('users','users.banned_users=unban');
        $this->db->join('services', 'services.user_id = users.id and services.status=1 and services.category=1', 'inner');
        $results = $this->db->get()->result();
        $collection=array(
                'error'=>false,
                'message'=>'Request completed successfully',
                'data'=>$results,
                );
        echo json_encode($collection);
    }
    
    public function viewAllSPA(){
        $this->db->select('users.*, services.*,users.name as user_name');
        $this->db->from('users','users.banned_users=unban');
        $this->db->join('services', 'services.user_id = users.id and services.status=1 and services.category=2', 'inner');
        $results = $this->db->get()->result();
        
        $collection=array(
                'error'=>false,
                'message'=>'Request completed successfully',
                'data'=>$results,
                );
        echo json_encode($collection);
    }
    
    public function viewAllOffer(){
        
        $this->db->select('id,image,user_id');
        $this->db->from('offers');
        $this->db->order_by('date', 'desc');
        $results = $this->db->get()->result();
        $collection=array(
                'error'=>false,
                'message'=>'Request completed successfully',
                'data'=>$results,
                );
        echo json_encode($collection);
    }
    
    public function viewAllVideo(){
        $this->db->select('users.*, videos.*,users.name as user_name');
        $this->db->from('users','users.banned_users=unban');
        $this->db->join('videos', 'videos.user_id = users.id and videos.status=1', 'inner');
        $results = $this->db->get()->result();
        $collection=array(
                'error'=>false,
                'message'=>'Request completed successfully',
                'data'=>$results,
                );
        echo json_encode($collection);
    }
    
    public function viewAllProduct(){
        $this->db->select(' products.*,users.name as user_name');
        $this->db->from('users','users.banned_users=unban');
        $this->db->join('products', 'products.user_id = users.id and products.status=1', 'inner');
        $results = $this->db->get()->result();
        $collection=array(
                'error'=>false,
                'message'=>'Request completed successfully',
                'data'=>$results,
                );
        echo json_encode($collection);
    }
    
    public function viewAllGallery(){
        $this->db->select('users.*, galleries.*,users.name as user_name');
        $this->db->from('users','users.banned_users=unban');
        $this->db->join('galleries', 'galleries.user_id = users.id and galleries.status=1', 'inner');
        $results = $this->db->get()->result();
        $collection=array(
                'error'=>false,
                'message'=>'Request completed successfully',
                'data'=>$results,
                );
        echo json_encode($collection);
    }
    
    
    public function vendorGallery(){
       $this->load->model('Basic_operation','basic_operation',true);
        if ($this->input->server('REQUEST_METHOD') == 'POST'){
            $vendor_id=$this->input->post('vendor_id');
            $this->db->select('*');
            $this->db->from('galleries');
            $this->db->where('user_id', $vendor_id);
            $results = $this->db->get()->result();
            $collection=array(
                    'error'=>false,
                    'message'=>'Request completed successfully',
                    'data'=>$results,
                    );
        echo json_encode($collection);
        }
    }
    
    public function vendorService(){
       $this->load->model('Basic_operation','basic_operation',true);
        if ($this->input->server('REQUEST_METHOD') == 'POST'){
            $vendor_id=$this->input->post('vendor_id');
            $this->db->select('*');
            $this->db->from('services');
            $this->db->where('user_id', $vendor_id);
            $results = $this->db->get()->result();
            $collection=array(
                    'error'=>false,
                    'message'=>'Request completed successfully',
                    'data'=>$results,
                    );
        echo json_encode($collection);
        }
    }
    
    public function vendorSlots(){
       $this->load->model('Basic_operation','basic_operation',true);
        if ($this->input->server('REQUEST_METHOD') == 'POST'){
            $vendor_id=$this->input->post('vendor_id');
            $this->db->select('*');
            $this->db->from('slots');
            $this->db->where('user_id', $vendor_id);
            $results = $this->db->get()->result();
            $collection=array(
                    'error'=>false,
                    'message'=>'Request completed successfully',
                    'data'=>$results,
                    );
        echo json_encode($collection);
        }
    }
    public function viewAllProductVendors(){
        $this->load->model('Basic_operation','basic_operation',true);
        if ($this->input->server('REQUEST_METHOD') == 'POST' || $this->input->server('REQUEST_METHOD') == 'GET'){
            $this->db->select('*,company_logo as image,id as user_id,name as user_name');
            $this->db->from('users');
            $this->db->where('business_category','3');
            $results = $this->db->get()->result();
            $collection=array(
                    'error'=>false,
                    'message'=>'Request completed successfully',
                    'data'=>$results,
                    );
            echo json_encode($collection);
        }
    }
    public function vendorProducts(){
        $this->load->model('Basic_operation','basic_operation',true);
        if ($this->input->server('REQUEST_METHOD') == 'POST'){
            $vendor_id=$this->input->post('vendor_id');
            $this->db->select('products.*,users.*');
            $this->db->from('products');
            $this->db->group_by('products.user_id');
            $this->db->join('users', 'products.user_id = users.id', 'inner');
            $this->db->where('user_id',$vendor_id);
            $results = $this->db->get()->result();
            $collection=array(
                    'error'=>false,
                    'message'=>'Request completed successfully',
                    'data'=>$results,
                    );
            echo json_encode($collection);
        }
    }
    
    public function vendorReviews(){
       $this->load->model('Basic_operation','basic_operation',true);
        if ($this->input->server('REQUEST_METHOD') == 'POST'){
            $vendor_id=$this->input->post('vendor_id');
            $this->db->select('reviews.*,users.name as user_name');
            $this->db->from('users','users.banned_users=unban');
            $this->db->order_by("id", "desc");
            $this->db->join('reviews', 'reviews.user_id = users.id and reviews.status=1 and reviews.vendor_id='.$vendor_id.'', 'inner');
            $results = $this->db->get()->result();
            $collection=array(
                    'error'=>false,
                    'message'=>'Request completed successfully',
                    'data'=>$results,
                    );
        echo json_encode($collection);
        }
    }

    public function serviceReviews(){
       $this->load->model('Basic_operation','basic_operation',true);
        if ($this->input->server('REQUEST_METHOD') == 'POST'){
            $service_id=$this->input->post('service_id');
            $this->db->select('reviews.*,users.name as user_name');
            $this->db->from('users','users.banned_users=unban');
            $this->db->order_by("id", "desc");
            $this->db->join('reviews', 'reviews.user_id = users.id', 'inner');
            $this->db->where(['reviews.service_id'=>$service_id]);
            $results = $this->db->get()->result();
            $collection=array(
                    'error'=>false,
                    'message'=>'Request completed successfully',
                    'data'=>$results,
                    );
        echo json_encode($collection);
        }
    }
    
    
    public function checkEmailAvailibility(){
        $data=array();
        $this->load->model('Basic_operation','basic_operation',true);
        if ($this->input->server('REQUEST_METHOD') == 'POST'){
            $email=$this->input->post('email');
            if($this->basic_operation->validateEntry('users',$email)===true){
                 $data=array(
                     'error'=>false,
                     'message'=>'Email is Available'
                     );
            }else{
                $data=array(
                     'error'=>false,
                     'message'=>'Email is not Available'
                     );
            }
            echo json_encode($data);
        }
    }
    
    public function register_transection_fail(){
        $this->load->library('form_validation');
        $this->load->model('Basic_operation','basic_operation',true);
        if ($this->input->server('REQUEST_METHOD') == 'POST'){
        $this->load->library('curl');
        $this->form_validation->set_rules('transection_id', 'transection_id', 'required');
        $this->form_validation->set_rules('message', 'message', 'required');
        $this->form_validation->set_rules('price', 'price', 'required');
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
        if ($this->form_validation->run() == FALSE) {
           
            $array = array(
                'error'    => true,
                'transection_id' => form_error('transection_id'),
                'email' => form_error('email'),
                'price' => form_error('price'),
                'message' => form_error('message')
              );
        }else{
            $form_data = array(
            'transection_id' => $this->input->post('transection_id'),
            'email'   => $this->input->post('email'),
            'price'   => $this->input->post('price'),
            'message'  => $this->input->post('message')
        );
        
            $this->basic_operation->insertData('registration_transection_failures',$form_data);
             $data=array(
                 'error'=>false,
                 'message'=>'Transection Data saved Successfully'
                 );
            
            echo json_encode($data);
        
        }
        }
    }
    
    public function service_booking(){
        $this->load->library('form_validation');
        $this->load->model('Basic_operation','basic_operation',true);
        if ($this->input->server('REQUEST_METHOD') == 'POST'){
        $this->load->library('curl');
        #$this->form_validation->set_rules('transection_id', 'transection id', 'required');
        $this->form_validation->set_rules('service_id', 'Service id', 'required');
        $this->form_validation->set_rules('user_id', 'user id', 'required');
        #$this->form_validation->set_rules('payment_type', 'Payment type', 'required');
        if ($this->form_validation->run() == FALSE) {
           
            $array = array(
                'error'    => true,
                #'transection_id' => form_error('transection_id'),
                'user_id' => form_error('user_id'),
                'service_id' => form_error('service_id'),
                #'payment_type' => form_error('payment_type')
              );
        }else{
            $user_id=$this->input->post('user_id');
            $service_id=$this->input->post('service_id');
            $services=explode(',',$service_id);
            $orderId='ORDER'.strtoupper(uniqid());
            $form_data = array(
                'transection_id' => $this->input->post('transection_id')?$this->input->post('transection_id'):'',
                'user_id'   => $this->input->post('user_id'),
                'booking_date'  => date('d-m-Y'),
                'order_id'=>$orderId,
                'payment_type'=>$this->input->post('payment_type')?$this->input->post('payment_type'):''
            );
            foreach($services as $service){
              $ServiceData  =$this->basic_operation->Uniqueselect('services',array('id'=>$service));
              $ServiceDetails=$ServiceData[0];
              $form_data['vendor_id']=$ServiceDetails->user_id;
              $form_data['service_id']=$ServiceDetails->id;
              $form_data['price']=$ServiceDetails->price;
              $this->basic_operation->insertData('bookings',$form_data);
            }
            $this->basic_operation->deleteData('carts',array('user_id'=>$user_id));
             $array=array(
                 'error'=>false,
                 'message'=>'Transection Data saved Successfully'
             );
            
        }
        echo json_encode($array);
        }
    }
    
    public function my_booking(){
        if ($this->input->server('REQUEST_METHOD') == 'POST'){
        $user_id=$this->input->post('user_id');
        if(!empty($user_id)){
        $this->db->select('bookings.*,services.image,services.description, services.name as service_name,services.price,users.name as vendor_name,users.address as vendor_address');
        $this->db->from('bookings');
        $this->db->join('users', 'users.id = bookings.vendor_id');
        $this->db->join('services', 'services.id = bookings.service_id');
        $this->db->where('bookings.user_id', $user_id);
        $this->db->group_by(array('order_id'));
        $results = $this->db->get()->result();
        
        foreach($results as $result){
            $order_id=$result->order_id;
            $this->db->where(['order_id'=>$order_id]);
            $this->db->from('bookings');
            $result->total_service_count=$this->db->count_all_results();
            $this->db->select('*');
            $this->db->where(['order_id'=>$order_id]);
            $this->db->from('bookings');
            $services=$this->db->get()->result();
            $subtotal=0;
            foreach($services as $service){
                $subtotal+=$service->price;
            }
            $result->price=$subtotal;
            
        }
        $collection=array(
                    'error'=>false,
                    'message'=>'Request completed successfully',
                    'data'=>$results,
                    );
        echo json_encode($collection);
        }
        }   
    }
    
    public function my_booking_details(){
        if ($this->input->server('REQUEST_METHOD') == 'POST'){
        $user_id=$this->input->post('user_id');
        $order_id=$this->input->post('order_id');
        if(!empty($user_id)){
        $this->db->select('bookings.*,services.*,services.name as service_name,services.id as service_id,services.price,users.name as vendor_name,users.address as vendor_address');
        $this->db->from('bookings');
        $this->db->join('users', 'users.id = bookings.vendor_id');
        $this->db->join('services', 'services.id = bookings.service_id');
        $this->db->where(array('bookings.user_id'=>$user_id,'bookings.order_id'=>$order_id));
        $results = $this->db->get()->result();
        foreach($results as $result){
            $review=$this->db->where(['user_id'=>$user_id,'service_id'=>$result->service_id])->get('reviews')->row();
            if(!empty($review)){
                $result->my_rating_points=$review->rating;
                $result->my_rating_msg=$review->message;
            }else{
                $result->my_rating_points='';
                $result->my_rating_msg='';
            }
        }
        $collection=array(
                    'error'=>false,
                    'message'=>'Request completed successfully',
                    'data'=>$results,
                    );
        echo json_encode($collection);
        }
        }   
    }
    
     public function transection_fail_service_booking(){
        $this->load->library('form_validation');
        $this->load->model('Basic_operation','basic_operation',true);
        if ($this->input->server('REQUEST_METHOD') == 'POST'){
        $this->load->library('curl');
        $this->form_validation->set_rules('transection_id', 'transection_id', 'required');
        $this->form_validation->set_rules('service_id', 'service_id', 'required');
        $this->form_validation->set_rules('user_id', 'user_id', 'required');
        $this->form_validation->set_rules('price', 'price', 'required');
        $this->form_validation->set_rules('vendor_id', 'vendor_id', 'required');
        $this->form_validation->set_rules('slot_id', 'slot_id', 'required');
        $this->form_validation->set_rules('message', 'message', 'required');
        $this->form_validation->set_rules('booking_date', 'booking_date', 'required');
        if ($this->form_validation->run() == FALSE) {
           
            $array = array(
                'error'    => true,
                'transection_id' => form_error('transection_id'),
                'vendor_id' => form_error('vendor_id'),
                'slot_id' => form_error('slot_id'),
                'price' => form_error('price'),
                'user_id' => form_error('user_id'),
                'service_id' => form_error('service_id'),
                'message' => form_error('message'),
                'booking_date' => form_error('booking_date')
              );
        }else{
            $form_data = array(
            'transection_id' => $this->input->post('transection_id'),
            'user_id'   => $this->input->post('user_id'),
            'price'   => $this->input->post('price'),
            'slot_id'   => $this->input->post('slot_id'),
            'service_id'  => $this->input->post('service_id'),
            'vendor_id'  => $this->input->post('vendor_id'),
            'message'  => $this->input->post('message'),
            'booking_date'  => $this->input->post('booking_date')
        );
        
            $this->basic_operation->insertData('booking_transection_failures',$form_data);
             $data=array(
                 'error'=>false,
                 'message'=>'Transection Data saved Successfully'
                 );
            
            echo json_encode($data);
        
        }
        }
    }
    
        public function send_review(){
        $this->load->library('form_validation');
        $this->load->model('Basic_operation','basic_operation',true);
        if ($this->input->server('REQUEST_METHOD') == 'POST'){
         $this->form_validation->set_rules('user_id', 'user_id', 'required');
         $this->form_validation->set_rules('vendor_id', 'vendor_id', 'required');
         $this->form_validation->set_rules('rating', 'rating', 'required');
         if($this->form_validation->run() == FALSE){
           
            $data = array(
                'error'    => true,
                'vendor_id' => form_error('vendor_id'),
                'rating' => form_error('rating'),
                'user_id' => form_error('user_id')
              );
        }else{
           $form_data = array(
            'user_id'   => $this->input->post('user_id'),
            'rating'    =>  $this->input->post('rating'),
            'message'   => $this->input->post('message')?$this->input->post('message'):'',
            'vendor_id'  => $this->input->post('vendor_id'),
            'service_id'  => $this->input->post('service_id')
            );
        
            $this->basic_operation->insertData('reviews',$form_data);
            $this->db->select('*');
            $this->db->from('reviews');
            $this->db->where('vendor_id',$this->input->post('vendor_id'));
            $results2 = $this->db->get()->result();
            $user_counter=0;
            $user_counter=count($results2);
            $total_rate=0;
            $dd['review_data']=$results2;
            foreach($dd['review_data'] as $res2){
                $total_rate+=$res2->rating;
            }
            $total_rating=$total_rate/$user_counter;
            $this->basic_operation->updateDetails('users',array('rating'=>$total_rating),array('id'=>$this->input->post('vendor_id')));
             $data=array(
                 'error'=>false,
                 'message'=>' Review send Successfully'
                 );
        }
        }else{
           $data=array(
                 'error'=>true,
                 'message'=>' Only Post method allowed'
                 );
        }
        echo json_encode($data);
    }
    
    
    public function add_my_favourites(){
        $this->load->library('form_validation');
        $this->load->model('Basic_operation','basic_operation',true);
        if ($this->input->server('REQUEST_METHOD') == 'POST'){
         $this->form_validation->set_rules('user_id', 'user_id', 'required');
         $this->form_validation->set_rules('vendor_id', 'vendor_id', 'required');
         $this->form_validation->set_rules('service_id', 'service_id', 'required');
        if($this->form_validation->run() == FALSE){
           
            $array = array(
                'error'    => true,
                'vendor_id' => form_error('vendor_id'),
                'user_id' => form_error('user_id'),
                'service_id' => form_error('service_id')
              );
              echo json_encode($array);
        }else{
           if($this->input->post('flag')=='0'){
               $form_data = array(
                'user_id'   => $this->input->post('user_id'),
                'vendor_id'  => $this->input->post('vendor_id'),
                'service_id'  => $this->input->post('service_id')
                );
            $this->basic_operation->deleteData('my_favourites',$form_data);
            $data=array(
                 'error'=>false,
                 'message'=>' Deleted From Favourites'
                 );
           }else{
           $form_data = array(
            'user_id'   => $this->input->post('user_id'),
            'vendor_id'  => $this->input->post('vendor_id'),
            'service_id'  => $this->input->post('service_id')
            );
        
            $this->basic_operation->insertData('my_favourites',$form_data);
            $data=array(
                 'error'=>false,
                 'message'=>' Added To Favourites'
                 );
            }
            echo json_encode($data);
        
        }
        }
    }
    
    public function my_favourites(){
        if ($this->input->server('REQUEST_METHOD') == 'POST'){
        $user_id=$this->input->post('user_id');
        if(!empty($user_id)){
        $this->db->select('my_favourites.*,services.*,my_favourites.id as favourite_id,users.mobile,users.id as vendor_id,users.name as vendor_name,users.address as vendor_address');
        $this->db->from('my_favourites');
        $this->db->join('users', 'users.id = my_favourites.vendor_id');
        $this->db->join('services', 'services.id = my_favourites.service_id');
        $this->db->where('my_favourites.user_id', $user_id);
        $results = $this->db->get()->result();
        $collection=array(
                    'error'=>false,
                    'message'=>'Request completed successfully',
                    'data'=>$results,
                    );
        
        }else{
            $collection=array(
                    'error'=>true,
                    'message'=>'User id Required',
                    );
        }
        echo json_encode($collection);
        }   
    }
    
   public function viewGoldenSalon(){
        $this->db->select('users.*, services.*,users.name as user_name,users.company_logo as image');
        $this->db->from('users','users.banned_users=unban');
        $this->db->join('services', 'services.user_id = users.id and services.status=1 and services.category=1', 'inner');
        $this->db->where(array('users.membership_type'=>1,'users.business_category'=>1));
        $results = $this->db->get()->result();
        $collection=array(
                'error'=>false,
                'message'=>'Request completed successfully',
                'data'=>$results,
                );
        echo json_encode($collection);
   }
    
    public function getVendorDetails(){
         if ($this->input->server('REQUEST_METHOD') == 'POST'){
            $user_id=$this->input->post('user_id');
            $vendor_id=$this->input->post('vendor_id');
            
            $this->db->select('users.*,about_company.quotes,about_company.website,about_company.whatsapp,users.id as user_id,users.name as user_name,users.company_logo as image');
            $this->db->from('users','users.banned_users=unban');
            $this->db->join('about_company', 'about_company.user_id = users.id', 'left');
           
            $this->db->where('users.id',$vendor_id);
            $vendor_details = $this->db->get()->result();
            if(count($vendor_details)<= 0){
                $vendor_details ='';
            }else{
                $vendor_details =$vendor_details[0];
                $this->db->select('mobile');
                $this->db->from('mobile_numbers');
                $this->db->where('mobile_numbers.user_id',$vendor_details->user_id);
                $vendor_mobiles = $this->db->get()->result();
                if(count($vendor_mobiles) >0){
                    $vendor_mobile=['mobile'=>$vendor_details->mobile];
                    array_push($vendor_mobiles,$vendor_mobile);
                    $vendor_details->mobile=$vendor_mobiles;
                }else{
                   $vendor_mobile=['mobile'=>$vendor_details->mobile];
                   $vendor_mobiles=[];
                   array_push($vendor_mobiles,$vendor_mobile); 
                   $vendor_details->mobile=$vendor_mobiles;
                }
                
            }
             $vendor_details->latitude =  ($vendor_details->latitude == '0.00000000')?'77.02660000':$vendor_details->latitude;
            
            $vendor_details->longitude =  ($vendor_details->longitude == '0.00000000')?'77.02660000':$vendor_details->longitude;
            
            $this->db->select('videos.*,videos.video_title as image,users.name as user_name');
            $this->db->from('users','users.banned_users=unban');
            $this->db->join('videos', 'videos.user_id = users.id and videos.status=1', 'inner');
            $this->db->where(['videos.user_id'=>$vendor_id,'videos.approved'=>1]);
            $results = $this->db->get()->result();
            $v=$results;
                
            $this->db->select('galleries.*,users.name as user_name');
            $this->db->from('galleries','galleries.status=1');
            $this->db->join('users', 'galleries.user_id = users.id', 'inner');
            $this->db->where(['galleries.user_id'=>$vendor_id,'galleries.approved'=>1]);
            $galleries = $this->db->get()->result();
            $g=$galleries;
            
            foreach($v as $video){
               unset($video->video_title); 
               unset($video->date); 
               array_push($g,$video);
        
            }
            
    
            $this->db->select('id,image,user_id,latitude,longitude');
            $this->db->from('offers');
            $this->db->where('offers.user_id',$vendor_id);
            $results2 = $this->db->get()->result();
            $o=$results2;
             
             
            $this->db->select('users.*, services.*,users.name as user_name,services.id as service_id,users.id as vendor_id');
            $this->db->from('users','users.banned_users=unban');
            $this->db->join('services', 'services.user_id = users.id and services.status=1', 'inner');
            if(!empty($gender)){
            $this->db->where('services.gender', $gender);
            }
            $this->db->where('services.user_id',$vendor_id);
            $results3 = $this->db->get()->result();
            $s=$results3;
            foreach($s as $x){
                if($this->basic_operation->matchedRowCount('my_favourites',array('user_id'=>$user_id,'service_id'=>$x->service_id))){
                    $x->favourite_status="1";
                }else{
                    $x->favourite_status="0";
                }
            }
            
                $collection=array(
                'error'=>false,
                'message'=>'Request completed successfully.',
                'vendor'=>$vendor_details,
                'Services'=>$s,
                'Offers'=>$o,
                'Gallery'=>$g
                );
                
         }else{
             $collection=array(
                'error'=>true,
                'message'=>'Get Request Not allowed',
                );
         }
         echo json_encode($collection);
        
    }
    
    public function getAllJobs(){
            $this->db->select('jobs.*');
            $this->db->from('jobs','jobs.status=1');
            $this->db->where(['jobs.status'=>1]);
            $jobs = $this->db->get()->result();
            
                $collection=array(
                'error'=>false,
                'message'=>'Request completed successfully.',
                'jobs'=>$jobs,
                );
                
            echo json_encode($collection);
        
    }
    
    
    public function getDistanceBetweenPointsNew($latitude1, $longitude1, $latitude2, $longitude2, $unit = 'Mi') {
        $theta = $longitude1 - $longitude2;
        $distance = sin(deg2rad($latitude1)) * sin(deg2rad($latitude2)) + cos(deg2rad($latitude1)) * cos(deg2rad($latitude2)) * cos(deg2rad($theta));
    
        $distance = acos($distance); 
        $distance = rad2deg($distance); 
        $distance = $distance * 60 * 1.1515;
    
        switch($unit) 
        { 
            case 'Mi': break;
            case 'Km' : $distance = $distance * 1.609344; 
        }
    
        return (round($distance,2)); 
    }

}