<?php  
 defined('BASEPATH') OR exit('No direct script access allowed');  
 class Admin extends CI_Controller { 
      public function __construct(){
        Parent::__construct();
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $method = $_SERVER['REQUEST_METHOD'];
        if($method == "OPTIONS") {
        die();
        } 
          $this->load->database();
          $this->load->model("Basic_operation","basic_operation",true);  
          $this->load->library('form_validation'); 
          
          $auth = $this->session->userdata;
          if(empty($auth)){
              redirect(site_url().'main/login/');
          }
    
          
          if(empty($auth['role'])){
              redirect(site_url().'main/login/');
          } 
      } 
 
      public function index(){  
           $this->db->select('*');
           $this->db->from('users');
           $this->db->where('role','2');
           $data["fetch_data"] = $this->db->get()->result();
           $data['user_type']='vendors';
           $this->load->view("admin/index",$data);  
      } 
      
       public function customers(){  
           $this->db->select('*');
           $this->db->from('users');
           $this->db->where('role','3');
           $data["fetch_data"] = $this->db->get()->result();
           $data['user_type']='customers';
           $this->load->view("admin/index",$data);  
      } 
      public function all_bookings(){
          
            $data = $this->session->userdata;
        
	        if($data['role']==1){
                $this->db->select('bookings.*, services.name as service_name,services.price,users.name as vendor_name,users.address as vendor_address,customer.name as  customer_name');
                $this->db->from('bookings');
                $this->db->join('users', 'users.id = bookings.vendor_id');
                $this->db->join('users as customer', 'customer.id = bookings.user_id');
                $this->db->join('services', 'services.id = bookings.service_id');
                $this->db->group_by(['order_id','user_id']);
                $data['fetch_data'] = $this->db->get()->result(); 
            }else{
                $this->db->select('bookings.*, services.name as service_name,services.price,users.name as vendor_name,users.address as vendor_address,customer.name as  customer_name');
                $this->db->from('bookings');
                $this->db->join('users', 'users.id = bookings.vendor_id');
                $this->db->join('users as customer', 'customer.id = bookings.user_id');
                $this->db->join('services', 'services.id = bookings.service_id');
                $this->db->where('bookings.vendor_id', $data['id']);
                $this->db->group_by(['order_id','user_id']);
                $data['fetch_data'] = $this->db->get()->result();
            }
            $this->load->view('admin/booking', $data);
        
          
      }
      
      public function view($id){
        
        $data["user"] = $this->basic_operation->Uniqueselect('users',array('id'=>$id));
        $data["products"] = $this->basic_operation->Uniqueselect('products',array('user_id'=>$id));
        $data["services"] = $this->basic_operation->Uniqueselect('services',array('user_id'=>$id));
        $data["slots"] = $this->basic_operation->Uniqueselect('slots',array('user_id'=>$id));
        $data["galleries"] = $this->basic_operation->Uniqueselect('galleries',array('user_id'=>$id));
        $data["offers"] = $this->basic_operation->Uniqueselect('offers',array('user_id'=>$id));
        $data["offers"] = $this->basic_operation->Uniqueselect('offers',array('user_id'=>$id));
        $data["videos"] = $this->basic_operation->Uniqueselect('videos',array('user_id'=>$id));
        
        $this->load->view("admin/details",$data);
        
     }
     
     public function getbookingDetail($order_id){
            $this->db->select('bookings.*, services.name as service_name,services.price,users.name as vendor_name,users.address as vendor_address,customer.name as  customer_name');
            $this->db->from('bookings');
            $this->db->join('users', 'users.id = bookings.vendor_id');
            $this->db->join('users as customer', 'customer.id = bookings.user_id');
            $this->db->join('services', 'services.id = bookings.service_id');
            $this->db->where('bookings.order_id', $order_id);
            $data['fetch_data'] = $this->db->get()->result();
            $this->load->view("admin/booking_details",$data);
     }
     
     public function edit($id){
         $data["user_data"] = $this->basic_operation->Uniqueselect('users',array('id'=>$id));  
           $data["fetch_data"] = $this->basic_operation->selectData('users');  
           $this->load->view("admin/edit", $data);
     }
     
    public function update(){
        $auth= $this->session->userdata;
        $data=array(
                 'banned_users'=>$this->input->post('banned_users'),
                 'gallery_counter'=>$this->input->post('gallery_counter'),
                 'video_counter' =>$this->input->post('video_counter')
            ); 
       if($this->input->post("update"))  
       {    
            $this->basic_operation->updateDetails('users',$data, array('id'=>$this->input->post("hidden_id")));  
            $this->session->set_flashdata('success','User Updated Successfully.');
            redirect(base_url() . "admin/index");  
       } 
    }
    
    public function about(){
        $auth=$this->session->userdata;
        $data=array(
           'about'=>$this->input->post('about'),
           'address'=>$this->input->post('address'),
           'opening_hour'=>$this->input->post('opening_hour'),
           'opening_hours'=>$this->input->post('opening_hours'),
           'whatsapp'=>$this->input->post('whatsapp'),
           'website'=>$this->input->post('website'),
           'quotes'=>$this->input->post('quotes'),
           'user_id'=>$auth['id']
           );
        $this->db->delete('mobile_numbers',['user_id'=>$auth['id']]);
        $mobiles=$this->input->post('mobiles');
        if(!empty($mobiles)){
            $mobs=explode(',',$mobiles);
                foreach($mobs as $mob){
                    $this->db->insert('mobile_numbers',['mobile'=>$mob,'user_id'=>$auth['id']]);
                }
            }
       if($this->input->post("insert"))  
       {    
            $this->basic_operation->insertData('about_company',$data); 
            $this->basic_operation->updateDetails('users',array('office_time'=>$data['opening_hour'],'shop_time'=>$data['opening_hour']), array('id'=>$data["user_id"]));
            $this->session->set_flashdata('success','Information Saved  Successfully.');
            redirect(base_url() . "main/index");  
       }  
       
       if($this->input->post("update"))  
       {    
            $this->basic_operation->updateDetails('about_company',$data,array('id'=>$this->input->post("hidden_id")));
            $this->basic_operation->updateDetails('users',array('office_time'=>$data['opening_hour'],'shop_time'=>$data['opening_hour']), array('id'=>$data["user_id"]));
            $this->session->set_flashdata('success','Information Updated  Successfully.');
            redirect(base_url() . "main/index");  
       }  
    }
    
    public function addWishes(){
        if($this->input->post("insert")){
            //   if(!empty($_FILES['image_file']['name']) && !empty($_FILES['image_file']['tmp_name'])){
            //   $config['upload_path'] = './uploads/';
            //   $config['allowed_types'] = 'jpeg|jpg|png';
            //   $config['encrypt_name'] = TRUE;
            //   $this->load->library('upload', $config);
            //   if (!$this->upload->do_upload('image_file')) {
            //         $error = array('error' => $this->upload->display_errors());
            //         $data['errorsss']=$error; 
            //         $this->load->view("index", $data);
            //         } else{
            //         $d = $this->upload->data();
                    $data=array(
                         'status'=>$this->input->post('status'),
                         'title'=>$this->input->post('title'),
                         'description'=>$this->input->post('description'),
                         
                    );
                    $this->db->update('wishes',$data);  
                    $this->session->set_flashdata('success','Information Saved  Successfully.');
                    redirect(base_url() . "main/index");  

            //  }
            //  }
        }
        
    }
    
    public function approveGallery($id,$status){
       $this->basic_operation->updateDetails('galleries',array('approved'=>$status),array('id'=>$id));  
       $this->session->set_flashdata('success','Status Updated  Successfully.');
       redirect($_SERVER['HTTP_REFERER']);
    }
    
    public function approveVideo($id,$status){
       $this->basic_operation->updateDetails('videos',array('approved'=>$status),array('id'=>$id));  
       $this->session->set_flashdata('success','Status Updated  Successfully.');
       redirect($_SERVER['HTTP_REFERER']);
    }
    
      
 } 