<?php
/**
 * The template for displaying home page.
 *
 * Template Name: Custom Home Page
 *
 * @package Medical Supplements Store
 */

get_header(); ?>

<?php /** slider section **/ ?>
<?php
	// Get pages set in the customizer (if any)
	$pages = array();
	for ( $count = 1; $count <= 5; $count++ ) {
		$mod = absint( get_theme_mod( 'medical_supplements_store_slidersettings-page-' . $count ) );
		if ( 'page-none-selected' != $mod ) {
			$pages[] = $mod;
		}
	}
	if( !empty($pages) ) :
		$args = array(
			'posts_per_page' => 5,
			'post_type' => 'page',
			'post__in' => $pages,
			'orderby' => 'post__in'
		);
		$query = new WP_Query( $args );
		if ( $query->have_posts() ) :
			$count = 1;
			?>
			<div class="slider-main">
				<div id="slider" class="nivoSlider">
					<?php
						$medical_supplements_store_n = 0;
					while ( $query->have_posts() ) : $query->the_post();
							
							$medical_supplements_store_n++;
							$medical_supplements_store_slideno[] = $medical_supplements_store_n;
							$medical_supplements_store_slidetitle[] = get_the_title();
							$medical_supplements_store_slidelink[] = esc_url(get_permalink());
							?>
								<img src="<?php the_post_thumbnail_url('full'); ?>" title="#slidecaption<?php echo esc_attr( $medical_supplements_store_n ); ?>" />
							<?php
						$count++;
					endwhile;
						wp_reset_postdata();
					?>
				</div>

				<?php
				$medical_supplements_store_k = 0;
			    foreach( $medical_supplements_store_slideno as $medical_supplements_store_sln ){ ?>
					<div id="slidecaption<?php echo esc_attr( $medical_supplements_store_sln ); ?>" class="nivo-html-caption">
						<div class="slide-cap  ">
							<div class="container">
								<a href="<?php echo esc_url( $medical_supplements_store_slidelink[$medical_supplements_store_k] ); ?>"><h2><?php echo esc_html( $medical_supplements_store_slidetitle[$medical_supplements_store_k] ); ?></h2></a>
							</div>
						</div>
					</div>
		    	<?php $medical_supplements_store_k++;
				} ?>
			</div>
		<?php else : ?>
				<div class="header-no-slider"></div>
			<?php
		endif;
	else : ?>
			<div class="header-no-slider"></div>
		<?php
	endif;
?>
<?php do_action( 'medical_supplements_store_after_slider' ); ?>

<div id="custom-page-services">
	<div class="container">
		<div class="row">
			<div class="col-md-3 col-sm-3">
				<div class="row">
			      	<?php if( get_theme_mod( 'medical_supplements_store_delivery','' ) != '') { ?>
				      	<div class="col-md-3">
				      		<i class="fas fa-truck"></i>
				      	</div>
				      	<div class="col-md-9">
				      		<h6><?php echo esc_html( get_theme_mod('medical_supplements_store_delivery',__('Free Delivery','medical-supplements-store')) ); ?></h6>
				      		<p><?php echo esc_html( get_theme_mod('medical_supplements_store_delivery_line',__('orders over $39.99','medical-supplements-store')) ); ?></p>
				      	</div>
			      	<?php } ?>
		      	</div>
		  	</div>
		 	<div class="col-md-3 col-sm-3">
		 		<div class="row">
			  		<?php if( get_theme_mod( 'medical_supplements_store_return','' ) != '') { ?>
			  			<div class="col-md-3">
				      		<i class="fas fa-share"></i>
				      	</div>
				      	<div class="col-md-9">
				      		<h6><?php echo esc_html( get_theme_mod('medical_supplements_store_return',__('365 Days Return','medical-supplements-store') )); ?></h6>
				      		<p><?php echo esc_html( get_theme_mod('medical_supplements_store_return_line',__('Nutriseed guarantee','medical-supplements-store') )); ?></p>
				      	</div>
			  		<?php } ?>
			  	</div>
		    </div>
		    <div class="col-md-3 col-md-3">
		    	<div class="row">
			    	<?php if( get_theme_mod( 'medical_supplements_store_satisfy','' ) != '') { ?>
				    	<div class="col-md-3">
					      	<i class="fas fa-thumbs-up"></i>
				      	</div>
				      	<div class="col-md-9">
				      		<h6><?php echo esc_html( get_theme_mod('medical_supplements_store_satisfy',__('98% Satisfaction','medical-supplements-store') )); ?></h6>
				      		<p><?php echo esc_html( get_theme_mod('medical_supplements_store_satisfy_line',__('5 Start Review','medical-supplements-store') )); ?></p>
				      	</div>
			  		<?php } ?>
			  	</div>
		    </div>
		    <div class="col-md-3 col-sm-3">
		    	<div class="row">
			  		<?php if( get_theme_mod( 'medical_supplements_store_points','' ) != '') { ?>
			  			<div class="col-md-3">
					      	<i class="fas fa-star"></i>
				      	</div>
				      	<div class="col-md-9">
				      		<h6><?php echo esc_html( get_theme_mod('medical_supplements_store_points',__('Loyalty Points','medical-supplements-store') )); ?></h6>
				      		<p><?php echo esc_html( get_theme_mod('medical_supplements_store_points_line',__('With Each Order','medical-supplements-store') )); ?></p>
				      	</div>
			    	<?php } ?>
			    </div>
		    </div>
		</div>
	</div>
</div>

<?php do_action( 'medical_supplements_store_after_service' ); ?>

<section id="our-products">
	<div class="container">
        <?php if( get_theme_mod('medical_supplements_store_sec1_title') != ''){ ?>     
            <h3><?php echo esc_html(get_theme_mod('medical_supplements_store_sec1_title',__('BEST SELLERS','medical-supplements-store'))); ?></h3>
        <?php }?>
			<?php $pages = array();
			for ( $count = 0; $count <= 0; $count++ ) {
				$mod = intval( get_theme_mod( 'medical_supplements_store_product_page' . $count ));
				if ( 'page-none-selected' != $mod ) {
				  $pages[] = $mod;
				}
			}
			if( !empty($pages) ) :
			  $args = array(
			    'post_type' => 'page',
			    'post__in' => $pages,
			    'orderby' => 'post__in'
			  );
			  $query = new WP_Query( $args );
			  if ( $query->have_posts() ) :
			    $count = 0;
					while ( $query->have_posts() ) : $query->the_post(); ?>
					    <div class="box-image">
					        <p><?php the_content(); ?></p>
					        <div class="clearfix"></div>
					    </div>
					<?php $count++; endwhile; ?>
			  <?php else : ?>
			      <div class="no-postfound"></div>
			  <?php endif;
			endif;
			wp_reset_postdata(); ?>
		    <div class="clearfix"></div>		
	</div>
</section>

<?php do_action( 'medical_supplements_store_after_product' ); ?>

<div class="container">
  <?php while ( have_posts() ) : the_post(); ?>
        <?php the_content(); ?>
    <?php endwhile; // end of the loop. ?>
</div>

<?php get_footer(); ?>