<?php
/**
 * Medical Supplements Store functions and definitions
 *
 * @package Medical Supplements Store
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */

/* Theme Setup */
if ( ! function_exists( 'medical_supplements_store_setup' ) ) :

function medical_supplements_store_setup() {

	$GLOBALS['content_width'] = apply_filters( 'medical_supplements_store_content_width', 640 );

	load_theme_textdomain( 'medical-supplements-store', get_template_directory() . '/languages' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'woocommerce' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'custom-logo', array(
		'height'      => 240,
		'width'       => 240,
		'flex-height' => true,
	) );
	add_image_size('medical-supplements-store-homepage-thumb',240,145,true);
	
       register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'medical-supplements-store' ),
	) );

	add_theme_support( 'custom-background', array(
		'default-color' => 'f1f1f1'
	) );
	/*
	* Enable support for Post Formats.
	*
	* See: https://codex.wordpress.org/Post_Formats
	*/
	add_theme_support( 'post-formats', array('image','video','gallery','audio',) );

	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, icons, and column width.
	 */
	add_editor_style( array( 'css/editor-style.css', medical_supplements_store_font_url() ) );

	// Dashboard Theme Notification
	global $pagenow;
	
	if ( is_admin() && ('themes.php' == $pagenow) && isset( $_GET['activated'] ) ) {
		add_action( 'admin_notices', 'medical_supplements_store_activation_notice' );
	}	
}
endif;
add_action( 'after_setup_theme', 'medical_supplements_store_setup' );


// Dashboard Theme Notification
function medical_supplements_store_activation_notice() {
	echo '<div class="welcome-notice notice notice-success is-dismissible">';
		echo '<h2>'. esc_html__( 'Thank You!!!!!', 'medical-supplements-store' ) .'</h2>';
		echo '<p>'. esc_html__( 'Much grateful to you for choosing our medical supplement theme from themescaliber. we praise you for opting our services over others. we are obliged to invite you on our welcome page to render you with our outstanding services.', 'medical-supplements-store' ) .'</p>';
		echo '<p><a href="'. esc_url( admin_url( 'themes.php?page=medical_supplements_store_guide' ) ) .'" class="button button-primary">'. esc_html__( 'Click Here...', 'medical-supplements-store' ) .'</a></p>';
	echo '</div>';
}

/* Theme Widgets Setup */
function medical_supplements_store_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Blog Sidebar', 'medical-supplements-store' ),
		'description'   => __( 'Appears on blog page sidebar', 'medical-supplements-store' ),
		'id'            => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Page Sidebar', 'medical-supplements-store' ),
		'description'   => __( 'Appears on page sidebar', 'medical-supplements-store' ),
		'id'            => 'sidebar-2',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Thid Column Sidebar', 'medical-supplements-store' ),
		'description'   => __( 'Appears on page sidebar', 'medical-supplements-store' ),
		'id'            => 'sidebar-3',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer Nav 1', 'medical-supplements-store' ),
		'description'   => __( 'Appears on footer', 'medical-supplements-store' ),
		'id'            => 'footer-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer Nav 2', 'medical-supplements-store' ),
		'description'   => __( 'Appears on footer', 'medical-supplements-store' ),
		'id'            => 'footer-2',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer Nav 3', 'medical-supplements-store' ),
		'description'   => __( 'Appears on footer', 'medical-supplements-store' ),
		'id'            => 'footer-3',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer Nav 4', 'medical-supplements-store' ),
		'description'   => __( 'Appears on footer', 'medical-supplements-store' ),
		'id'            => 'footer-4',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
}
add_action( 'widgets_init', 'medical_supplements_store_widgets_init' );

/* Theme Font URL */
function medical_supplements_store_font_url(){
	$font_url = '';
	$font_family = array();
	$font_family[] = 'Exo:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i';
	$font_family[] = 'Open+Sans:300,300i,400,400i,600,600i,700,700i,800,800i';

	$query_args = array(
		'family'	=> urlencode(implode('|',$font_family)),
	);
	$font_url = add_query_arg($query_args,'//fonts.googleapis.com/css');
	return $font_url;
}
	
/* Theme enqueue scripts */
function medical_supplements_store_scripts() {
	wp_enqueue_style( 'medical-supplements-store-font', medical_supplements_store_font_url(), array() );	
	wp_enqueue_style( 'bootstrap', get_template_directory_uri().'/css/bootstrap.css' );
	wp_enqueue_style( 'medical-supplements-store-basic-style', get_stylesheet_uri() );
	wp_style_add_data( 'medical-supplements-store-style', 'rtl', 'replace' );
	wp_enqueue_style( 'medical-supplements-store-effect', get_template_directory_uri().'/css/effect.css' );
	wp_enqueue_style( 'font-awesome', get_template_directory_uri().'/css/fontawesome-all.css' );

	wp_enqueue_style( 'jquery-nivo-slider', get_template_directory_uri().'/css/nivo-slider.css' );
	wp_enqueue_script( 'jquery-nivo-slider', get_template_directory_uri() . '/js/jquery.nivo.slider.js', array('jquery') );	
	wp_enqueue_script( 'medical-supplements-store-customscripts', get_template_directory_uri() . '/js/custom.js', array('jquery') );
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'medical_supplements_store_scripts' );

/*radio button sanitization*/

function medical_supplements_store_sanitize_choices( $input, $setting ) {
    global $wp_customize; 
    $control = $wp_customize->get_control( $setting->id ); 
    if ( array_key_exists( $input, $control->choices ) ) {
        return $input;
    } else {
        return $setting->default;
    }
}

// URL DEFINES
define('MEDICAL_SUPPLEMENTS_STORE_SITE_URL','https://www.themescaliber.com/');
define('MEDICAL_SUPPLEMENTS_STORE_FREE_THEME_DOC','http://themescaliber.com/doc/free-medical-supplements/','medical-supplements-store');
define('MEDICAL_SUPPLEMENTS_STORE_SUPPORT','https://wordpress.org/support/theme/medical-supplements-store/','medical-supplements-store');
define('MEDICAL_SUPPLEMENTS_STORE_REVIEW','https://www.themescaliber.com/topic/reviews-and-testimonials','medical-supplements-store');
define('MEDICAL_SUPPLEMENTS_STORE_BUY_NOW','https://www.themescaliber.com/themes/premium-medical-supplements-wordpress-theme','medical-supplements-store');
define('MEDICAL_SUPPLEMENTS_STORE_LIVE_DEMO','https://themescaliber.com/medical-supplements-store-pro/','medical-supplements-store');
define('MEDICAL_SUPPLEMENTS_STORE_PRO_DOC','https://www.themescaliber.com/doc/medical-supplements-store-pro/','medical-supplements-store');
define('MEDICAL_SUPPLEMENTS_STORE_CHILD_THEME','https://developer.wordpress.org/themes/advanced-topics/child-themes/','medical-supplements-store');
define('MEDICAL_SUPPLEMENTS_STORE_DEMO_DATA','https://themescaliber.com/doc/medical-supplement-demo.xml.zip','medical-supplements-store');
function medical_supplements_store_credit_link() {
    echo "<a href=".esc_url(MEDICAL_SUPPLEMENTS_STORE_SITE_URL)." target='_blank'>".esc_html__('ThemesCaliber','medical-supplements-store')."</a>";
}

// Change number or products per row to 3
add_filter('loop_shop_columns', 'loop_columns');
	if (!function_exists('loop_columns')) {
		function loop_columns() {
	return 3; // 3 products per row
	}
}

/* Custom template tags for this theme. */
require get_template_directory() . '/inc/template-tags.php';

/* Implement the Custom Header feature. */
require get_template_directory() . '/inc/custom-header.php';

/* Customizer additions. */
require get_template_directory() . '/inc/customizer.php';
/* Implement the About theme page */
require get_template_directory() . '/inc/dashboard/getstart.php';