<?php 
/**
 * The header for our theme.
 *
 * Displays all of the <head> section 
 *
 * @package Erzen
 */
 ?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no"/>
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
	<?php wp_head(); ?>
</head> 
  
<body <?php body_class(); ?>>

	<div class="main_wrap">
		<?php  
		$h_comlogo_img = get_template_directory_uri().'';
		$erzen_header_section = get_theme_mod('erzen_header_section_hideshow');
		if ($erzen_header_section =='show') { 
		$erzen_email_icon = get_theme_mod('erzen_header_email_icon');
		$erzen_phone_icon = get_theme_mod('erzen_header_phone_icon');
		$erzen_time_icon = get_theme_mod('erzen_header_time_icon');
		$erzen_email_value = get_theme_mod('erzen_header_email_value');
		$erzen_phone_value = get_theme_mod('erzen_header_phone_value');
		$erzen_time_value = get_theme_mod('erzen_header_time_value');
		?>
		<header class="header_area">
			<div class="header_top sbb">
				<div class="container">
					<div class="row">
						<div class="col-md-4">
							<span class="header_info"><?php echo esc_html(get_theme_mod('erzen-header_year')); ?></span>	
						</div>
						<div class="col-md-8">
							<ul class="header_link">
						<?php
						if (!empty($erzen_email_value)) {
							?>
								<li><i class="fa fa-envelope"></i><?php echo esc_html($erzen_email_value); ?></li>
						<?php }
						if (!empty($erzen_phone_value)) {
							?>       
							   <li><i class="fa fa-phone"></i><?php echo esc_html($erzen_phone_value); ?></li>
						<?php }
						if (!empty($erzen_time_value)) {
							?> 
							   <li><i class="fa fa-clock-o"></i><span><?php echo esc_html($erzen_time_value); ?></span></li>
						<?php }
							?>
							</ul>
						</div>
					</div>
				</div>
			</div>
			<?php } ?>
			<div class="sticky-anchor"></div>
			<div class="header_btm">
				<div class="container">
					<div class="row">
						<div class="col-sm-3 col-xs-6">
							
						<?php	
						 if (has_custom_logo()) :
						?> 
							<span><?php the_custom_logo(); ?></span>
						 <?php  
						else : ?>
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="logo">
							<span class="site-title"><?php bloginfo( 'title' ); ?></span>
							</a>
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="tagc">
								<span class="site-description"><?php bloginfo( 'description' ); ?></span>
							</a> 
						<?php 
						endif;?>
						
						</div>
						  <div class="col-sm-9 menu_col col-xs-6">
							<nav class="menu-top-container">
								<?php wp_nav_menu( array
									('container'        => 'ul', 
									'theme_location'    => 'primary', 
									'menu_class'        => 'menu', 
									'items_wrap'        => '<ul class="menu">%3$s</ul>',
									'fallback_cb'       => 'erzen_wp_bootstrap_navwalker::fallback',
									'walker'            => new erzen_wp_bootstrap_navwalker()
									)); 
								?>          
						   </nav>
						</div>
					</div>
				</div>
			</div>
		</header>