<?php
class User extends Base{

    public  $data;
    protected static $userTableName="users_app";

    function __construct(){
        parent::__construct();
    }





    // Check if username/password is incorrect
    public  function loginUser($data=array()){
        $response=new GenricResponse();
        try {
            $conditions=array('where'=>array('mobileNo'=>$data['mobileNo']));
            if(!empty($this->checkUserExists($conditions))){
                $userData=$this->getUserInfoByMobile($data['mobileNo']);
                $unsetArray=array('token');
                $getUserData=array();
                $getUserData=$this->arrayIndexUnsetCode($unsetArray,$userData);
                $getUserData['message']="You have successfully login";
                $getUserData['statuscode']=Constants::$HTTP_CREATED;
                $getUserData['status']=Constants::$SUCCESS;
                $getUserData['timestamp']=time();
                $dataArray[]=$getUserData;
            }else{
                $dataArray[] = array('status' => 401, 'message' =>"Mobile does not Exists!");
            }

            if(!empty($dataArray)){
                $user_id=$dataArray[0]['id'];
                $device_type=$data['device_type'];
                $this->run("UPDATE users_app SET device_type='".$device_type."' WHERE id='".$user_id."'");
                
                $result = $this->run("SELECT SUM(adv_points) as TotalAdvPoints FROM users_adv_points WHERE user_id='".$user_id."'");
                $setting = $this->run("SELECT * FROM admin_setting WHERE id='1'");
                $settings=mysqli_fetch_assoc($setting);
                if (!$result) {
                    throw new exception(mysqli_error($this->link));
                }
                $userAdvPoints=mysqli_fetch_assoc($result);
                $dataArray[0]['TotalAdvPoints']=$userAdvPoints['TotalAdvPoints'];
                $dataArray[0]['VideoPerDay']=$settings['video_per_days'];
                echo json_encode($dataArray);
                exit;
            }
        } catch (Exception $e) {
            $response->getResponse($e->getMessage(),Constants::$HTTP_NOT_FOUND,null);
        } finally {
            return $response;
        }
    }
    /*==== User Registration ====*/
    public function userRegistration($data=array()){
        $usersTable=self::$userTableName;
        if(!empty($data)){
            $response=new GenricResponse();
            try {
                if (array_key_exists('password',$data) && !empty($data['password'])) {
                    $password= $data['password'];
                    $data['password']=md5($data['password']);
                }
                if (array_key_exists('dob',$data) && !empty($data['dob'])) {
                    $dob=str_replace("/","-",$data['dob']);
                    $data['dob']=date('Y-m-d',strtotime($dob));
                }
                $conditions=array('where'=>array('email'=>$data['email']));
                if(empty($this->checkUserExists($conditions))){
                    $conditions2=array('where'=>array('mobileNo'=>$data['mobileNo']));
                if(empty($this->checkUserExists($conditions2))){
                    $userId=$this->insertData($usersTable,$data);
                    if(!empty($userId)){
                        
                    $fullName = explode(" ", $data["name"]);
                    $address[]=[ 
                     "address1"=> $data["building"],
                     "address2"=> $data["area"],
                     "company"=> "",
                     "city"=> $data["emirates"],
                     "province"=> $data["emirates"],
                     "phone"=> $data["mobileNo"],
                     "zip"=> "",
                     "last_name"=> $fullName[1],
                     "first_name"=> $fullName[0],
                     "country"=> "United Arab Emirates"
                        ];

                $apiResponse = httpPostRegister("https://4ebbff4045fbc800b17f84835563078f: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@hop-u-com.myshopify.com/admin/api/2020-07/customers.json",
                	array( "customer"=> array(
                		"first_name"=> $fullName[0],
                		"last_name"=> $fullName[1],
                		"email"=> $data['email'],
                    	"phone"=> $data['mobileNo'],
                    	"verified_email"=> true,
                        "addresses"=> $address,
                        "password"=> $password,
                        "password_confirmation"=> $password,
                        "send_email_welcome"=> false
                		))
                );

                $json_output = json_decode($apiResponse, JSON_PRETTY_PRINT);

                $customer_id=$json_output['customer']['id'];
                $address_id=$json_output['customer']['addresses'][0]['id'];
                        
                        
                        $email=$data['email'];
                        $this->run("UPDATE users_app SET customer_id='".$customer_id."' , address_id='".$address_id."' WHERE email='".$email."'");
                        $userresult = $this->run("SELECT * FROM users_app WHERE email='".$email."'");
                        $userData=mysqli_fetch_assoc($userresult);
                        $this->run("INSERT INTO user_chars(user_id)values('".$userData['id']."')");
                        $unsetArray=array('created_at','updated_at');
                        $getUserData=array();
                        $setting = $this->run("SELECT * FROM admin_setting WHERE id='1'");
                        $settings=mysqli_fetch_assoc($setting);
                        $userData['VideoPerDay']=$settings['video_per_days'];
                        // $getUserData=$this->arrayIndexUnsetCode($unsetArray,$userData);
                        $getUserData['message']="You have successfully registered";
                        $getUserData['statuscode']=Constants::$HTTP_CREATED;
                        $getUserData['status']=Constants::$SUCCESS;
                        $getUserData['timestamp']=time();
                        $getUserData['details']=$userData;
                        $dataArray[]=$getUserData;
                    }
                    }else{
                       $dataArray[] = array('status' => '201', 'message' =>" Mobile already exists"); 
                    }
                }else{
                    $dataArray[] = array('status' => '201', 'message' =>"Email already exists");
                }
                if(!empty($dataArray)){
                    echo json_encode($dataArray);
                    exit;
                }
            } catch (Exception $e) {
                $response->getResponse($e->getMessage(),Constants::$HTTP_SERVER_ERROR,null);
            } finally {
                return $response;
            }
        }
        return false;
    }

    /*==== Change Password Code ====*/
    public function changePassword($data=array()){
        if(!empty($data)){
            $response=new GenricResponse();
            try {
                if((array_key_exists('user_id',$data))&&!empty($data['user_id'])){
                    $userId=$data['user_id'];
                    $oldPassword=md5($data['old_password']);
                    $newPassword=md5($data['new_password']);
                    if($this->checkUserExists($userId)) {
                        $result = $this->run("SELECT id FROM users WHERE password='".$oldPassword."' && id='".$userId."'");
                        if (!$result) {
                            throw new exception(mysqli_error($this->link));
                        }
                        if(mysqli_num_rows($result)<=0){
                            $dataArray[] = array('status' => '404','message' =>"Old Password does not matched");
                            $response->getResponse("Old Password does not matched",Constants::$HTTP_CREATED,$dataArray);
                        }else{
                            $queryUpdateToken="UPDATE users SET password='".$newPassword."' WHERE id='".$userId."'";
                            if($this->run($queryUpdateToken)===false){
                                throw new Exception("Failed to update password");
                            }
                            $getUserData=$this->getUserInfoById($userId);
                            $unsetArray=array('password','accessToken','token','referrer_id','approverd','deviceId');
                            $getUserData=$this->arrayIndexUnsetCode($unsetArray,$getUserData);
                            $getUserData=array();
                            $getUserData['message']="You have successfully changed your password";
                            $getUserData['statuscode']=Constants::$HTTP_CREATED;
                            $getUserData['status']=Constants::$SUCCESS;
                            $getUserData['timestamp']=time();
                            $dataArray[]=$getUserData;
                        }
                    }else{
                        $dataArray[] = array('status' => '404', 'message' =>"Your email does not exists");
                    }
                }else{
                    $dataArray[] = array('status' => 'error', 'responseCode' => '404','message' =>"You are not verified user");
                }   
                if(!empty($dataArray)){
                    echo json_encode($dataArray);
                    exit;
                }
            } catch (Exception $e) {
                $response->getResponse($e->getMessage(),Constants::$HTTP_SERVER_ERROR,null);
            } finally {
                return $response;
            }
        }
        return false;
    }
    /*==== Get user information by userid ====*/
    public function getUserInfoById($id=""){
        $userTable=self::$userTableName;
        if(!empty($id)){
            try {
                $result = $this->run("SELECT * FROM ".$userTable." WHERE id=".$id);
                if (!$result) {
                    throw new exception(mysqli_error($this->link));
                }
                $data['status']='200';
                $data['message']='Request Completed Successfully';
                $data['details']=mysqli_fetch_assoc($result);
                return array($data);
            } catch (Exception $e) {
                return $response->getResponse($e->getMessage(),Constants::$HTTP_SERVER_ERROR,null);
            }
        }else{
            return false;
        }
        return false;
    }

    /*==== Check user Exists or not ====*/
    public function checkUserExists($conditions=array()){
        $userTable=self::$userTableName;
        if(!empty($conditions)){
            try {
                $sql = 'SELECT id ';
                $sql .= ' FROM '.$userTable;
                if(array_key_exists("where",$conditions)){
                    $sql .= ' WHERE ';
                    $i = 0;
                    foreach($conditions['where'] as $key => $value){
                        $pre = ($i > 0)?' OR ':'';
                        $sql .= $pre.$key." = '".$value."'";
                        $i++;
                    }
                }
                $result = $this->run($sql);
                if (!$result) {
                    throw new exception(mysqli_error($this->link));
                }
                if ($result->num_rows>0) {
                    return true;
                }
                return false;
            } catch (Exception $e) {
                return $response->getResponse($e->getMessage(),Constants::$HTTP_SERVER_ERROR,null);
            }
        }else{
            return false;
        }
        return false;
    }

    /*==== Forgot Password Code ====*/
    public function forgotPassword($data=array()){
        if(!empty($data)){
            $response=new GenricResponse();
            try {
                if((array_key_exists('user_id',$data))&&!empty($data['user_id'])){
                    $userId=$data['user_id'];
                    $newPassword=$data['new_password'];
                    if($this->checkUserExists($userId)) {
                        $queryUpdateToken="UPDATE users SET password='".$newPassword."' WHERE id='".$userId."'";
                        if($this->run($queryUpdateToken)===false){
                            throw new Exception("Failed to update password");
                        }
                        $getUserData=$this->getUserInfoById($userId);
                        $unsetArray=array('password','accessToken','token','referrer_id','approverd','deviceId');
                        $getUserData=$this->arrayIndexUnsetCode($unsetArray,$getUserData);
                        $dataArray[]=$getUserData;

                        $response->getResponse("You have successfully changed your password",Constants::$HTTP_CREATED,$dataArray);
                    }else{
                        $dataArray[] = array('status' => 'error', 'responseCode' => '404','msg' =>"Your email does not exists");
                        $response->getResponse("Your email does not exists",Constants::$HTTP_CREATED,$dataArray);
                    }
                }else{
                    $dataArray[] = array('status' => 'error', 'responseCode' => '404','msg' =>"You are not verified user");
                    $response->getResponse("You are not verified user",Constants::$HTTP_CREATED,$dataArray);
                }   
            } catch (Exception $e) {
                $response->getResponse($e->getMessage(),Constants::$HTTP_SERVER_ERROR,null);
            } finally {
                return $response;
            }
        }
        return false;
    }

 /*==== Get user information by user email ====*/
    public function getUserInfoByEmail($email=""){
        if(!empty($email)){
            try {
                $result = $this->run("SELECT * FROM users_app WHERE email='".$email."'");
                if (!$result) {
                    throw new exception(mysqli_error($this->link));
                }
                return mysqli_fetch_assoc($result);
            } catch (Exception $e) {
                return $response->getResponse($e->getMessage(),Constants::$HTTP_SERVER_ERROR,null);
            }
        }
        return false;
    }
    
    public function getUserInfoByMobile($mobile=""){
        if(!empty($mobile)){
            try {
                $result = $this->run("SELECT * FROM users_app WHERE mobileNo='".$mobile."'");
                if (!$result) {
                    throw new exception(mysqli_error($this->link));
                }
                return mysqli_fetch_assoc($result);
            } catch (Exception $e) {
                return $response->getResponse($e->getMessage(),Constants::$HTTP_SERVER_ERROR,null);
            }
        }
        return false;
    }
    
        /*==== Get user information by userid ====*/
    public function getQuestions($category=""){
        $QuizTable='quizs';
        if(!empty($category)){
            try {
                $result = $this->run("SELECT * FROM ".$QuizTable." WHERE category=".$category);
                if (!$result) {
                    throw new exception(mysqli_error($this->link));
                }
                $arr=array();
                print_r($result);
                if(mysqli_num_rows($result) > 0 ){
	              $rows= mysqli_fetch_assoc($result);
	              print_r($rows);
                // while(){
                //     $arr[]=$rows;
                // }
                }
                $data['status']='200';
                $data['message']='Request Completed Successfully';
                $data['details']=$arr;
                return array($data);
            } catch (Exception $e) {
                return $response->getResponse($e->getMessage(),Constants::$HTTP_SERVER_ERROR,null);
            }
        }else{
            return false;
        }
        return false;
    }
}
