<?php
/**
 * Auther : Waseem Ahmad
 * Version : 1.0
 * Email : waseem.ahmad970@gmail.com
 * Controller Name : Base Class
 * Commnets : Its used for base curd operations
 **/
class Base extends DB{
	function __construct(){
		//new BaseController();
	}
	/*===== Get Protocol =====*/
	public function getProtocal(){
		return stripos($_SERVER['SERVER_PROTOCOL'],'https') === true ? 'https://' : 'http://';
	}
	/*===== Get Domain Name =====*/
	public function getDomain(){
		return $this->getProtocal().$_SERVER['HTTP_HOST'];
	}
    /*===== Get Api Base Url =====*/
    public function getApiBaseUrl(){
        return $this->getProtocal().$_SERVER['HTTP_HOST']."/api/";
    }

	/*==== Array Index Unset Code ====*/
    public function arrayIndexUnsetCode($arrIndex=array(),$data=array()){
        if(!empty($arrIndex) && !empty($data)){
            foreach ($arrIndex as $value) {
                unset($data[$value]);
            }
            return $data;
        }
        return array();
    }

    /*==== Genrate Random Number ====*/
    public function genrateRandomNumber($length=6,$data=""){
        $token = "";
        $codeAlphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        $codeAlphabet.= "abcdefghijklmnopqrstuvwxyz";
        $codeAlphabet.= "0123456789";
        $max = strlen($codeAlphabet); // edited
        for ($i=0; $i < $length; $i++) {
            $token .= $codeAlphabet[$this->crypto_rand_secure(0, $max-1)];
        }
        if(!empty($data)){
            $token=$data.$token;
        }
        return $token;
    }

    /*==== Random Number Genrate ====*/
    public function crypto_rand_secure($min, $max){
        $range = $max - $min;
        if ($range < 1) return $min; // not so random...
        $log = ceil(log($range, 2));
        $bytes = (int) ($log / 8) + 1; // length in bytes
        $bits = (int) $log + 1; // length in bits
        $filter = (int) (1 << $bits) - 1; // set all lower bits to 1
        do {
            $rnd = hexdec(bin2hex(openssl_random_pseudo_bytes($bytes)));
            $rnd = $rnd & $filter; // discard irrelevant bits
        } while ($rnd > $range);
        return $min + $rnd;
    }
	
    /*======== Insert Data ========*/   
    public function insertData($table,$data){
        try{
            $keys="";
            foreach ($data as $key => $dataVal) {
                $keys.=$key."='".$dataVal."',";
            }
            $values=trim($keys,',');
            /*print_r($values);
            exit;*/ 
            return $this->run("insert into {$table} SET {$values}");
        }catch(Exception $e){
            return "Error: " . $e->getMessage();
        }
    }

    /*======== Update Data ========*/   
    public function updateData($table,$conditions=array(),$data=array()){
        $keys=$update_cond="";
        try{
            foreach ($data as $key => $dataVal) {
                $keys.=$key."='".$dataVal."',";
            }
            if(array_key_exists("where",$conditions)){
                $update_cond .= 'WHERE ';
                $i = 0;
                foreach($conditions['where'] as $key => $value){
                    $pre = ($i > 0)?' AND ':'';
                    $update_cond .= $pre.$key." = '".$value."'";
                    $i++;
                }
            }
            $values=trim($keys,','); 
            /*echo "update {$table} SET {$values} {$update_cond}";
            exit();*/
            return $this->run("update {$table} SET {$values} {$update_cond}");
        }catch(Exception $e){
            return "Error: " . $e->getMessage();
        }
    }

    /*=======Get And Based Records ==========*/
    public function getRows($table,$conditions=array()){
        try{
            $selectFields="";
            if(!empty($conditions['select'])){
                foreach ($conditions['select'] as $key => $value) {
                    $selectFields.="`".$value."`,";
                }
            }
            $sql = 'SELECT ';
            $sql .= array_key_exists("select",$conditions)?trim($selectFields,','):'*';
            $sql .= ' FROM '.$table;
            if(array_key_exists("where",$conditions)){
                $sql .= ' WHERE ';
                $i = 0;
                foreach($conditions['where'] as $key => $value){
                    $pre = ($i > 0)?' AND ':'';
                    $sql .= $pre.$key." = '".$value."'";
                    $i++;
                }
            }        
            if(array_key_exists("order_by",$conditions)){
                $sql .= ' ORDER BY '.$conditions['order_by']; 
            }        
            if(array_key_exists("start",$conditions) && array_key_exists("limit",$conditions)){
                $sql .= ' LIMIT '.$conditions['start'].','.$conditions['limit']; 
            }elseif(!array_key_exists("start",$conditions) && array_key_exists("limit",$conditions)){
                $sql .= ' LIMIT '.$conditions['limit']; 
            }

            //echo $sql;
            $result =  $this->run($sql);
            //$data=array();
            if(array_key_exists("return_type",$conditions) && $conditions['return_type'] != 'all'){
                switch($conditions['return_type']){
                    case 'count':
                    $data = $result->num_rows;
                    break;
                    case 'single':
                    $data = $result->fetch_assoc();
                    break;
                    default:
                    $data = '';
                }
            }else{
                if($result->num_rows > 0){
                    while($row = $result->fetch_assoc()){
                        $data[] = $row;
                    }
                }
            }
            return !empty($data)?$data:false;
        }catch(Exception $e){
            return "Error: " . $e->getMessage();
        }
    }
    /*==== Fetch all record ====*/
    public function fetchAllRecord($result){
        if($result->num_rows>0){
            while($row = $result->fetch_assoc()){
                $data[] = $row;
            }
            return $data;
        }else{
            return array();
        }        
    }

    /*==== Form Empty Validation Code ====*/
    public function formEmptyValidation($fields=array(),$fieldsValues=array()){
        $errorField=array();
        if(!empty($fields)&&!empty($fieldsValues)){
            foreach ($fields as $value) {
                if(!array_key_exists($value,$fieldsValues)){
                    $errorField[]="Please must be enter ".str_replace('_'," ",$value);
                }elseif(empty($fieldsValues[$value])){
                    $errorField[]="Please enter ".str_replace('_'," ",$value);
                }
            }
        }
        return $errorField;
    }

    /*==== Status Message Code ====*/
    public function getStatusMessage($status=0){
        if($status==0){
            $statusMsg="fresh request";
        }elseif ($status==1) {
            $statusMsg="approved";
        }elseif ($status==2) {
            $statusMsg="confirmed";
        }elseif ($status==3) {
            $statusMsg="completed";
        }elseif ($status==4) {
            $statusMsg="completed by admin";
        }elseif ($status==5) {
            $statusMsg="canceled";
        }
        return $statusMsg;
    }

    /*==== Convert Base64 To Image ====*/
    public function base64ToImage($data=array())
    {
        if(!empty($data)){
            $imageBin = base64_decode($data['base64_code']);
            $size = getImageSizeFromString($imageBin);
            // Check the MIME type to be sure that the binary data is an image
            $fileName=trim($data['file_name']);
            if (empty($size['mime']) || strpos($size['mime'], 'image/') !== 0) {
                $pdf_file = $data['path'].$fileName."-file.pdf";
                $uploadCode=file_put_contents($pdf_file,$imageBin);
                if(!empty($uploadCode)){
                    return $fileName."-file.pdf";
                }
                //die('Base64 value is not a valid image');
            }
            $ext = substr($size['mime'], 6);
            if (!in_array($ext, ['png','jpeg','jpg','pdf'])) {
                die('Unsupported image type');
            }
            $img_file = $data['path'].$fileName.".".$ext;
            $uploadCode=file_put_contents($img_file, $imageBin);
            if(!empty($uploadCode)){
                return $fileName.".".$ext;
            }
        }
    }

    /*==== Push Notification ====*/
    public function sendPushNotification($conditions=array()) {
        if(!empty($conditions)){
            if(array_key_exists('user_id', $conditions)&&!empty($conditions['user_id'])){
                $firebase_url = 'https://fcm.googleapis.com/fcm/send';
                $firebaseApiKey="AAAARHgOr8A:APA91bFZWTBgZJhuwDkhqIVnHUWveffY6WHvqZySfk6t1QGyt5sCck4B6-0beCEskoD6BFEKQl_TINli-OnjS0Hlta7lzWcr4680t_1PJBZ7VvP92t9dw4s8VExL2iSsCHAjwwpL04Wg";
                $condition=array('return_type'=>'single','where'=>array('id'=>$conditions['user_id']));
                $getResults=$this->getRows('users',$condition);
                if(!empty($getResults)){
                    $userToken=$getResults['fcm_token'];
                    $userTitle=$getResults['name'];
                    unset($conditions['user_id']);
                    $data = array("to" =>$userToken,"notification" =>array('title'=>$userTitle,'body'=>$conditions['message']));
                    $data_string = json_encode($data);
                    $headers = array('Authorization: key='.$firebaseApiKey,'Content-Type: application/json');
                    $ch = curl_init();  
                    curl_setopt( $ch,CURLOPT_URL,$firebase_url);                                                                 
                    curl_setopt( $ch,CURLOPT_POST, true );  
                    curl_setopt( $ch,CURLOPT_HTTPHEADER, $headers );
                    curl_setopt( $ch,CURLOPT_RETURNTRANSFER, true );
                    curl_setopt( $ch,CURLOPT_POSTFIELDS, $data_string);
                    $result = curl_exec($ch);
                    curl_close ($ch);
                }                
            }
        }
        return true;
    }

    /*==== Get User ID based on request id ====*/
    public function getUserId($tableName="",$conditions=array())
    {
        $condition=array('return_type'=>'single','where'=>$conditions);
        $getResults=$this->getRows($tableName,$condition);
        if(!empty($getResults)){
            return $getResults['user_id'];
        }
        return false;
    }
}
?>