<?php 
require_once('header.php');
require_once('functions.php');

(float)$selfemployed=((float)getAllRowCount('occupation','self-employed')/(float)getAllRowCount(1,1))*100;
$mgr='manager,supervisors';
(float)$manager=((float)getAllRowCount('occupation',$mgr)/(float)getAllRowCount(1,1))*100;
(float)$skilled=((float)getAllRowCount('occupation','skilled professional')/(float)getAllRowCount(1,1))*100;
(float)$otherprofessional=((float)getAllRowCount('occupation','other professional')/(float)getAllRowCount(1,1))*100;
(float)$nonemployed=((float)getAllRowCount('occupation','non-employed')/(float)getAllRowCount(1,1))*100;
(float)$student=((float)getAllRowCount('occupation','student')/(float)getAllRowCount(1,1))*100;

?>
        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">

            <div class="row page-titles mx-0">
                <div class="col p-md-0">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0)">Dashboard</a></li>
                        <li class="breadcrumb-item active"><a href="javascript:void(0)">Occupation Users</a></li>
                    </ol>
                </div>
            </div>
            <!-- row -->

            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title"> Occupation Based Users Percentage List</h4>
                                <div class="table-responsive">
                                    <table class="table table-striped table-bordered zero-configuration">
                                     <thead>
                                        <tr>
                                            <th>Manager,Supervisors</th>
                                            <th>Self-Employed</th>
                                            <th>Skilled Professional</th>
                                            <th>Other Professional</th>
                                            <th>Non-Employed</th>
                                            <th>Student</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td><?php echo round($manager).' %';?></td>
                                            <td><?php echo round($selfemployed).' %';?></td>
                                            <td><?php echo round($skilled).' %';?></td>
                                            <td><?php echo round($otherprofessional).' %';?></td>
                                            <td><?php echo round($nonemployed).' %';?></td>
                                            <td><?php echo round($student).' %';?></td>
                                        </tr>     
                                    </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- #/ container -->
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        
        
        <!--**********************************
            Footer start
        ***********************************-->
        <div class="footer">
            <div class="copyright">
                <p>Copyright &copy; Designed & Developed by AimstoramGroup <?php echo date('Y'); ?></p>
            </div>
        </div>
        <!--**********************************
            Footer end
        ***********************************-->
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!--**********************************
        Scripts
    ***********************************-->
    <script src="plugins/common/common.min.js"></script>
    <script src="js/custom.min.js"></script>
    <script src="js/settings.js"></script>
    <script src="js/gleek.js"></script>
    <script src="js/styleSwitcher.js"></script>

    <script src="plugins/tables/js/jquery.dataTables.min.js"></script>
    <script src="plugins/tables/js/datatable/dataTables.bootstrap4.min.js"></script>
    <script src="plugins/tables/js/datatable-init/datatable-basic.min.js"></script>

</body>
</html>

