<?php
class User extends Base{

    public  $data;
    protected static $userTableName="users";

    function __construct(){
        parent::__construct();
    }





    // Check if username/password is incorrect
    public  function loginUser($data=array()){
        $response=new GenricResponse();
        try {
            if (array_key_exists('password',$data) && !empty($data['password'])) {
                $data['password']=md5($data['password']);
            }
            $conditions=array('where'=>array('email'=>$data['email'],'password'=>$data['password']),'position'=>['position']);
            if(!empty($this->checkUserExists($conditions))){
                $userData=$this->getUserInfoByEmail($data['email']);
                $unsetArray=array('token');
                $getUserData=array();
                $getUserData=$this->arrayIndexUnsetCode($unsetArray,$userData);
                $getUserData['message']="You have successfully login";
                $getUserData['statuscode']=Constants::$HTTP_CREATED;
                $getUserData['status']=Constants::$SUCCESS;
                $getUserData['timestamp']=time();
                $dataArray[]=$getUserData;
            }else{
                $dataArray[] = array('status' => 401, 'message' =>"Credentails does not match");
            }

            if(!empty($dataArray)){
                echo json_encode($dataArray);
                exit;
            }
        } catch (Exception $e) {
            $response->getResponse($e->getMessage(),Constants::$HTTP_NOT_FOUND,null);
        } finally {
            return $response;
        }
    }
    /*==== User Registration ====*/
    public function userRegistration($data=array()){
        $usersTable=self::$userTableName;
        if(!empty($data)){
            $response=new GenricResponse();
            try {
                if (array_key_exists('password',$data) && !empty($data['password'])) {
                    $data['password']=md5($data['password']);
                }
                if (array_key_exists('dob',$data) && !empty($data['dob'])) {
                    $dob=str_replace("/","-",$data['dob']);
                    $data['dob']=date('Y-m-d',strtotime($dob));
                }
                $conditions=array('where'=>array('email'=>$data['email']));
                if(empty($this->checkUserExists($conditions))){
                    $userId=$this->insertData($usersTable,$data);
                    if(!empty($userId)){
                        $userData=$this->getUserInfoById($userId);
                        $unsetArray=array('created_at','updated_at');
                        $getUserData=array();
                        $getUserData=$this->arrayIndexUnsetCode($unsetArray,$userData);
                        $getUserData['message']="You have successfully registered";
                        $getUserData['statuscode']=Constants::$HTTP_CREATED;
                        $getUserData['status']=Constants::$SUCCESS;
                        $getUserData['timestamp']=time();
                        $dataArray[]=$getUserData;
                    }
                }else{
                    $dataArray[] = array('status' => '201', 'message' =>"Your email already exists");
                }
                if(!empty($dataArray)){
                    echo json_encode($dataArray);
                    exit;
                }
            } catch (Exception $e) {
                $response->getResponse($e->getMessage(),Constants::$HTTP_SERVER_ERROR,null);
            } finally {
                return $response;
            }
        }
        return false;
    }

    /*==== Change Password Code ====*/
    public function changePassword($data=array()){
        if(!empty($data)){
            $response=new GenricResponse();
            try {
                if((array_key_exists('user_id',$data))&&!empty($data['user_id'])){
                    $userId=$data['user_id'];
                    $oldPassword=md5($data['old_password']);
                    $newPassword=md5($data['new_password']);
                    if($this->checkUserExists($userId)) {
                        $result = $this->run("SELECT id FROM users WHERE password='".$oldPassword."' && id='".$userId."'");
                        if (!$result) {
                            throw new exception(mysqli_error($this->link));
                        }
                        if(mysqli_num_rows($result)<=0){
                            $dataArray[] = array('status' => '404','message' =>"Old Password does not matched");
                            $response->getResponse("Old Password does not matched",Constants::$HTTP_CREATED,$dataArray);
                        }else{
                            $queryUpdateToken="UPDATE users SET password='".$newPassword."' WHERE id='".$userId."'";
                            if($this->run($queryUpdateToken)===false){
                                throw new Exception("Failed to update password");
                            }
                            $getUserData=$this->getUserInfoById($userId);
                            $unsetArray=array('password','accessToken','token','referrer_id','approverd','deviceId');
                            $getUserData=$this->arrayIndexUnsetCode($unsetArray,$getUserData);
                            $getUserData=array();
                            $getUserData['message']="You have successfully changed your password";
                            $getUserData['statuscode']=Constants::$HTTP_CREATED;
                            $getUserData['status']=Constants::$SUCCESS;
                            $getUserData['timestamp']=time();
                            $dataArray[]=$getUserData;
                        }
                    }else{
                        $dataArray[] = array('status' => '404', 'message' =>"Your email does not exists");
                    }
                }else{
                    $dataArray[] = array('status' => 'error', 'responseCode' => '404','message' =>"You are not verified user");
                }   
                if(!empty($dataArray)){
                    echo json_encode($dataArray);
                    exit;
                }
            } catch (Exception $e) {
                $response->getResponse($e->getMessage(),Constants::$HTTP_SERVER_ERROR,null);
            } finally {
                return $response;
            }
        }
        return false;
    }
    /*==== Get user information by userid ====*/
    public function getUserInfoById($id=""){
        $userTable=self::$userTableName;
        if(!empty($id)){
            try {
                $result = $this->run("SELECT * FROM ".$userTable." WHERE id=".$id);
                if (!$result) {
                    throw new exception(mysqli_error($this->link));
                }
                return mysqli_fetch_assoc($result);
            } catch (Exception $e) {
                return $response->getResponse($e->getMessage(),Constants::$HTTP_SERVER_ERROR,null);
            }
        }else{
            return false;
        }
        return false;
    }

    /*==== Check user Exists or not ====*/
    public function checkUserExists($conditions=array()){
        $userTable=self::$userTableName;
        if(!empty($conditions)){
            try {
                $sql = 'SELECT id ';
                $sql .= ' FROM '.$userTable;
                if(array_key_exists("where",$conditions)){
                    $sql .= ' WHERE ';
                    $i = 0;
                    foreach($conditions['where'] as $key => $value){
                        $pre = ($i > 0)?' AND ':'';
                        $sql .= $pre.$key." = '".$value."'";
                        $i++;
                    }
                }
                $result = $this->run($sql);
                if (!$result) {
                    throw new exception(mysqli_error($this->link));
                }
                if ($result->num_rows>0) {
                    return true;
                }
                return false;
            } catch (Exception $e) {
                return $response->getResponse($e->getMessage(),Constants::$HTTP_SERVER_ERROR,null);
            }
        }else{
            return false;
        }
        return false;
    }

    /*==== Forgot Password Code ====*/
    public function forgotPassword($data=array()){
        if(!empty($data)){
            $response=new GenricResponse();
            try {
                if((array_key_exists('user_id',$data))&&!empty($data['user_id'])){
                    $userId=$data['user_id'];
                    $newPassword=$data['new_password'];
                    if($this->checkUserExists($userId)) {
                        $queryUpdateToken="UPDATE users SET password='".$newPassword."' WHERE id='".$userId."'";
                        if($this->run($queryUpdateToken)===false){
                            throw new Exception("Failed to update password");
                        }
                        $getUserData=$this->getUserInfoById($userId);
                        $unsetArray=array('password','accessToken','token','referrer_id','approverd','deviceId');
                        $getUserData=$this->arrayIndexUnsetCode($unsetArray,$getUserData);
                        $dataArray[]=$getUserData;

                        $response->getResponse("You have successfully changed your password",Constants::$HTTP_CREATED,$dataArray);
                    }else{
                        $dataArray[] = array('status' => 'error', 'responseCode' => '404','msg' =>"Your email does not exists");
                        $response->getResponse("Your email does not exists",Constants::$HTTP_CREATED,$dataArray);
                    }
                }else{
                    $dataArray[] = array('status' => 'error', 'responseCode' => '404','msg' =>"You are not verified user");
                    $response->getResponse("You are not verified user",Constants::$HTTP_CREATED,$dataArray);
                }   
            } catch (Exception $e) {
                $response->getResponse($e->getMessage(),Constants::$HTTP_SERVER_ERROR,null);
            } finally {
                return $response;
            }
        }
        return false;
    }

 /*==== Get user information by user email ====*/
    public function getUserInfoByEmail($email=""){
        if(!empty($email)){
            try {
                $result = $this->run("SELECT * FROM users WHERE email='".$email."'");
                if (!$result) {
                    throw new exception(mysqli_error($this->link));
                }
                return mysqli_fetch_assoc($result);
            } catch (Exception $e) {
                return $response->getResponse($e->getMessage(),Constants::$HTTP_SERVER_ERROR,null);
            }
        }
        return false;
    }
}
