<?php
class Bookings extends Base{

    public  $data;
    protected static $bookingRequest="booking_request";
    protected static $bookingFlights="booking_flight";
    protected static $users="users";

    function __construct(){
        parent::__construct();
    }

    /*==== Booking Request Code ====*/
    public function userAddBookingRequest($data=array()){
    	if (!empty($data)) {
            $tableName="booking_request";
            $travel_date=str_replace("/","-",$data['travel_date']);
            $data['travel_date']=date('Y-m-d',strtotime($travel_date));
            $data['serial_number'] = mt_rand(100000, 999999);
            $data['status']=0;
            $data['created_at']=date('Y-m-d h:s:i');
            unset($data['type']);
            $getReturn=$this->insertData($tableName,$data);
            if(!empty($getReturn)){
                return array(array("status"=>"200","result"=>"Booking request has been sent successfully"));
            }
    	}
        return array(array("status"=>"404","result"=>"Booking not sent, please try again.."));
    }

    /*==== Booking Get Request Code ====*/
    public function userGetBookingRequest($data=array()){
        $bookingRequest="booking_request";
        $users="users";
        $sqlConditions="";
        if(!empty($data)&&(array_key_exists('status', $data))){
            $whereConditions['br.status']=$data['status'];
        }else{
            $whereConditions=array('br.status'=>0);
        }
        if(!empty($data)&&(array_key_exists('user_id', $data))){
            $whereConditions['br.user_id']=$data['user_id'];
        }
        if(!empty($whereConditions)){
            $sqlConditions .= ' WHERE ';
            $i = 0;
            foreach($whereConditions as $key => $value){
                $pre = ($i > 0)?' AND ':'';
                $sqlConditions .= $pre.$key." = '".$value."'";
                $i++;
            }
        } 
        $myQuery=$this->run("SELECT br.id as request_id,br.user_id,br.status,u.name,br.travel_from,br.serial_number,br.travel_to,br.travel_date,br.flight_name FROM ".$bookingRequest." as br INNER JOIN ".$users." as u on br.user_id=u.id ".$sqlConditions);
        $getReturn=$this->fetchAllRecord($myQuery);
        if(!empty($getReturn)){
            return $getReturn;
        }
        return array(array("status"=>"404","result"=>"No maching record found!.."));
    }


    /*==== Get Booking Request With Flight Code ====*/
    public function userGetBookingRequestWFlight($data=array()){
        $bookingRequest="booking_request";
        $bookingFlights="booking_flights";
        $users="users";
        $sqlConditions="";
        if(!empty($data)&&(array_key_exists('status', $data))){
            $whereConditions['br.status']=$data['status'];
        }else{
            $whereConditions=array('br.status'=>0);
        }
        if(!empty($data)&&(array_key_exists('user_id', $data))){
            $whereConditions['br.user_id']=$data['user_id'];
        }
        if(!empty($whereConditions)){
            $sqlConditions .= ' WHERE ';
            $i = 0;
            foreach($whereConditions as $key => $value){
                $pre = ($i > 0)?' AND ':'';
                $sqlConditions .= $pre.$key." = '".$value."'";
                $i++;
            }
        } 

        $myQuery=$this->run("SELECT br.id as request_id,bf.id as flight_id,br.user_id,br.status,u.name,br.travel_from,br.serial_number,br.travel_to,br.travel_date,br.flight_name,bf.next_travel_date FROM ".$bookingRequest." as br RIGHT JOIN ".$bookingFlights." as bf on bf.booking_request_id=br.id INNER JOIN ".$users." as u on br.user_id=u.id ".$sqlConditions);
        /*$myQuery=$this->run("SELECT bf.id as flight_id,bf.booking_request_id,u.name,bf.ticket_info,bf.class as flight_class,bf.fare,bf.tax,bf.total,bf.status as bf_status,br.travel_from,br.serial_number,br.travel_to,br.travel_date,br.flight_name FROM ".$bookingFlights." as bf RIGHT JOIN ".$bookingRequest." as br ON br.id=bf.booking_request_id INNER JOIN ".$users." as u on br.user_id=u.id ".$sqlConditions);*/
        $getReturn=$this->fetchAllRecord($myQuery);
        if(!empty($getReturn)){
            return $getReturn;
        }
        return array(array("status"=>"404","result"=>"No maching record found!.."));
    }

    /*==== Approved Booking Request By Manager Code ====*/
    public function userBookingRequestApproved($data=array()){
        $bookingRequest="booking_request";
        if(!empty($data)){
            if(array_key_exists('request_id', $data)){
                $conditions['where']['id']=$data['request_id'];
            }
            $updateData=array();
            $updateData['status']=1;
            $results=$this->updateData($bookingRequest,$conditions,$updateData);
            if(!empty($results)){
                $successMessage="Request has been approved successfully";
                $conditions=array('user_id'=>$this->getUserId($bookingRequest,array('id'=>$data['request_id'])),'message'=>$successMessage);
                $this->sendPushNotification($conditions);
                return array(array("status"=>"200","result"=>$successMessage));
            }
        }
        return array(array("status"=>"404","result"=>"No maching record found!.."));
    }

    /*==== Booking Flight Code ====*/
    public function userAddBookingFlight($data=array()){
        if (!empty($data)) {
            $tableName="booking_flights";
            $data['status']=1;
            if(!empty($data['next_travel_date'])){
	            $next_travel_date=str_replace("/","-",$data['next_travel_date']);
	            $data['next_travel_date']=date('Y-m-d',strtotime($next_travel_date));
            }
            $data['total']=$data['fare']+$data['tax'];
            $data['created_at']=date('Y-m-d h:s:i');
            unset($data['type']);
            $getReturn=$this->insertData($tableName,$data);
            if(!empty($getReturn)){
                $successMessage="Flight has been added successfully";
                $conditions=array('user_id'=>$data['user_id'],'message'=>$successMessage);
                $this->sendPushNotification($conditions);
                return array(array("status"=>"200","result"=>$successMessage));
            }
        }
        return array(array("status"=>"404","result"=>"Flight not added, please try again.."));
    }

    /*==== Booking Get Approved Flight Code ====*/
    public function userGetBookingApprovedFlight($data=array()){
        $bookingFlights="booking_flights";
        $bookingRequest="booking_request";
        $users="users";
        $whereConditions=array();
        $sqlConditions="";
        if(!empty($data)&&(array_key_exists('user_id', $data))){
            $whereConditions['bf.user_id']=$data['user_id'];
        }
        $whereConditions['bf.status']=1;
        if(!empty($whereConditions)){
            $sqlConditions .= ' WHERE ';
            $i = 0;
            foreach($whereConditions as $key => $value){
                $pre = ($i > 0)?' AND ':'';
                $sqlConditions .= $pre.$key." = '".$value."'";
                $i++;
            }
        }
        $myQuery=$this->run("SELECT bf.id as flight_id,bf.booking_request_id,u.name,bf.ticket_info,bf.class as flight_class,bf.fare,bf.tax,bf.total,bf.status as bf_status,br.travel_from,br.serial_number,br.travel_to,br.travel_date,br.flight_name,bf.next_travel_date FROM ".$bookingFlights." as bf RIGHT JOIN ".$bookingRequest." as br ON br.id=bf.booking_request_id INNER JOIN ".$users." as u on br.user_id=u.id ".$sqlConditions);
        $getReturn=$this->fetchAllRecord($myQuery);
        if(!empty($getReturn)){
            return $getReturn;
        }
        return array(array("status"=>"404","result"=>"No maching record found!.."));
    }

    /*==== Request & Flight Status Update ====*/
    public function bookingStatusByRequestFlight($data=array()){
        $bookingFlights="booking_flights";
        $bookingRequest="booking_request";
        if(!empty($data)&& array_key_exists('status',$data)){
            if(!empty($data['status'])){
                $status=$data['status'];
            }else{
                $status=0;
            }
            if(array_key_exists('flight_id', $data)&&array_key_exists('request_id', $data)){
                if(!empty($data['flight_id']) && !empty($data['request_id'])){
                    $conditions=array('tableName'=>$bookingFlights,'where'=>array('booking_request_id'=>$data['request_id'],'id'=>$data['flight_id']));
                    if(!empty($this->checkRecordExists($conditions))){
                        $conditions=array('tableName'=>$bookingFlights,'where'=>array('status'=>$status,'booking_request_id'=>$data['request_id'],'id'=>$data['flight_id']));
                        if(empty($this->checkRecordExists($conditions))){
                            $this->run("UPDATE ".$bookingFlights." SET  status='".$status."' where id='".$data['flight_id']."' && booking_request_id='".$data['request_id']."'");
                            $this->run("UPDATE ".$bookingRequest." SET  status='".$status."' where id='".$data['request_id']."'");
                            return array(array("status"=>"200","result"=>"Flight has been ".$this->getStatusMessage($status)." successfully",'status'=>$status));
                        }else{
                            return array(array("status"=>"204","result"=>"Booking Already Confirmed With Flight Id & Booking Request ID"));
                        }
                    }else{
                        return array(array("status"=>"204","result"=>"Flight Id & Booking Request ID does't Matched"));
                    }
                }
            } 
            return array(array("status"=>"204","result"=>"Flight Id & Booking Request ID is blanked"));
        }        
    }
    
    /*==== Request & Flight Status By Admin Update ====*/
    public function bookingRequestFlightStatusByAdmin($data=array()){
        $bookingFlights="booking_flights";
        $bookingRequest="booking_request";
        if(!empty($data)&& array_key_exists('status',$data)){
            if(!empty($data['status'])){
                $status=$data['status'];
            }else{
                $status=0;
            }
            if(array_key_exists('flight_id', $data) && array_key_exists('request_id', $data) && array_key_exists('file_name', $data)){
                if(!empty($data['flight_id']) && !empty($data['request_id']) && !empty($data['file_name'])){
                    $conditions=array('tableName'=>$bookingFlights,'where'=>array('booking_request_id'=>$data['request_id'],'id'=>$data['flight_id']));
                    if(!empty($this->checkRecordExists($conditions))){
                        $conditions=array('tableName'=>$bookingFlights,'where'=>array('status'=>$status,'booking_request_id'=>$data['request_id'],'id'=>$data['flight_id']));
                        if(empty($this->checkRecordExists($conditions))){
                            $this->run("UPDATE ".$bookingFlights." SET  status='".$status."', ticket_file='".$data['file_name']."' where id='".$data['flight_id']."' && booking_request_id='".$data['request_id']."'");
                            $this->run("UPDATE ".$bookingRequest." SET  status='".$status."' where id='".$data['request_id']."'");
                            $successMessage="Flight has been ".$this->getStatusMessage($status)." successfully";
                            $conditions=array('user_id'=>$this->getUserId($bookingRequest,array('id'=>$data['request_id'])),'message'=>$successMessage);
                            $this->sendPushNotification($conditions);
                            return array(array("status"=>"200","result"=>$successMessage,'status'=>$status));
                        }else{
                            return array(array("status"=>"204","result"=>"Booking Already Confirmed With Flight Id & Booking Request ID"));
                        }
                    }else{
                        return array(array("status"=>"204","result"=>"Flight Id & Booking Request ID does't Matched"));
                    }
                }
            } 
            return array(array("status"=>"204","result"=>"Flight Id & Booking Request ID is blanked"));
        }        
    }

    /*==== Booking checkRecordExists Code ====*/
    public function checkRecordExists($conditions=array()){
        $sql = 'SELECT *';
        $sql .= ' FROM '.$conditions['tableName'];
        if(array_key_exists("where",$conditions)){
            $sql .= ' WHERE ';
            $i = 0;
            foreach($conditions['where'] as $key => $value){
                $pre = ($i > 0)?' AND ':'';
                $sql .= $pre.$key." = '".$value."'";
                $i++;
            }
        }
        $myQuery=$this->run($sql);
        $getReturn=$this->fetchAllRecord($myQuery);
        if(!empty($getReturn)){
            return $getReturn;
        }
        return false;
    }

    /*==== Get Complete Booking Request By Admin Code (Final Tickets) ====*/
    public function getCompleteBookingRequestByAdmin($data=array()){
        $bookingRequest="booking_request";
        $bookingFlights="booking_flights";
        $users="users";
        $sqlConditions="";
        if(!empty($data)&&(array_key_exists('status', $data))){
            $whereConditions['br.status']=$data['status'];
        }else{
            $whereConditions=array('br.status'=>4);
        }
        if(!empty($data)&&(array_key_exists('user_id', $data))){
            $whereConditions['br.user_id']=$data['user_id'];
        }

        if(!empty($whereConditions)){
            $currentDate=date('Y-m-d');
            $sqlConditions .= " WHERE br.travel_date >='".$currentDate."'";
            $i = 1;
            foreach($whereConditions as $key => $value){
                $pre = ($i > 0)?' AND ':'';
                $sqlConditions .= $pre.$key." = '".$value."'";
                $i++;
            }
        } 
        $myQuery=$this->run("SELECT u.name,br.travel_from,br.serial_number,br.travel_to,br.travel_date,br.flight_name,bf.id as flight_id,bf.booking_request_id,bf.status,bf.ticket_info,bf.class as flight_class,bf.ticket_file,bf.fare,bf.tax,bf.total,bf.next_travel_date FROM ".$bookingRequest." as br RIGHT JOIN ".$bookingFlights." as bf ON bf.booking_request_id=br.id INNER JOIN ".$users." as u on br.user_id=u.id ".$sqlConditions);
        $getReturn=$this->fetchAllRecord($myQuery);
        if(!empty($getReturn)){
            array_walk($getReturn, function(&$value,$key){
                $baseUrl=$this->getApiBaseUrl();
                $fileDir="ticketsFiles";
                $filePath=dir(getcwd())->path."/".$fileDir."/";
                $fileName=strtolower(trim($value['name'])."-".trim($value['serial_number']));
                $imageConditions=array('base64_code'=>$value['ticket_file'],'path'=>$filePath,'file_name'=>$fileName);
                $imageName=$this->base64ToImage($imageConditions);
                $imageUrl=$baseUrl.$fileDir."/".$imageName;
                $value['ticket_file']=$imageUrl;
            });
            return $getReturn;
        }
        return array(array("status"=>"404","result"=>"No maching record found!.."));
    } 
    
    /*==== Booking Get Complete Past Request Code ====*/
    public function getCompletePastRequestBookings($data=array()){
        $bookingRequest="booking_request";
        $bookingFlights="booking_flights";
        $users="users";
        $sqlConditions="";
        if(!empty($data)&&(array_key_exists('status', $data))){
            $whereConditions['br.status']=$data['status'];
        }else{
            $whereConditions=array('br.status'=>4);
        }
        if(!empty($data)&&(array_key_exists('user_id', $data))){
            $whereConditions['br.user_id']=$data['user_id'];
        }

        if(!empty($whereConditions)){
            $currentDate=date('Y-m-d');
            $sqlConditions .= " WHERE br.travel_date <'".$currentDate."'";
            $i = 1;
            foreach($whereConditions as $key => $value){
                $pre = ($i > 0)?' AND ':'';
                $sqlConditions .= $pre.$key." = '".$value."'";
                $i++;
            }
        }
        $myQuery=$this->run("SELECT u.name,br.travel_from,br.serial_number,br.travel_to,br.travel_date,br.flight_name,bf.id as flight_id,bf.booking_request_id,bf.ticket_info,bf.class as flight_class,bf.fare,bf.tax,bf.total,bf.status,bf.next_travel_date FROM ".$bookingRequest." as br RIGHT JOIN ".$bookingFlights." as bf ON bf.booking_request_id=br.id INNER JOIN ".$users." as u on br.user_id=u.id ".$sqlConditions);
        $getReturn=$this->fetchAllRecord($myQuery);
        if(!empty($getReturn)){
            return $getReturn;
        }
        return array(array("status"=>"404","result"=>"No maching record found!.."));
    }


    /*==== Get My Booking Booking Request Code ====*/
    public function getMyBookingRequestList($data=array()){
        $bookingRequest="booking_request";
        $users="users";
        $sqlConditions="";
        if(!empty($data)&&(array_key_exists('user_id', $data))){
            $whereConditions['br.user_id']=$data['user_id'];
        }
        if(!empty($whereConditions)){
            $sqlConditions .= ' WHERE ';
            $i = 0;
            foreach($whereConditions as $key => $value){
                $pre = ($i > 0)?' AND ':'';
                $sqlConditions .= $pre.$key." = '".$value."'";
                $i++;
            }
        } 
        $myQuery=$this->run("SELECT br.id as request_id,br.user_id,u.name,br.travel_from,br.serial_number,br.travel_to,br.travel_date,br.flight_name,br.status FROM ".$bookingRequest." as br INNER JOIN ".$users." as u on br.user_id=u.id ".$sqlConditions);
        $getReturn=$this->fetchAllRecord($myQuery);
        if(!empty($getReturn)){
            return $getReturn;
        }
        return array(array("status"=>"404","result"=>"No maching record found!.."));
    }

    /*==== Booking Request Canceled With Status 5 ====*/
    public function bookingRequestCanceled($data=array()){
        $bookingFlights="booking_flights";
        $bookingRequest="booking_request";
        if(!empty($data)&& array_key_exists('status',$data)){
            if(!empty($data['status'])){
                $status=$data['status'];
            }else{
                $status=0;
            }
            if(array_key_exists('request_id', $data)){
                if(!empty($data['request_id'])){
                    $conditions=array('tableName'=>$bookingFlights,'where'=>array('booking_request_id'=>$data['request_id']));
                    if(!empty($this->checkRecordExists($conditions))){
                        $conditions=array('tableName'=>$bookingFlights,'where'=>array('status'=>$status,'booking_request_id'=>$data['request_id']));
                        if(empty($this->checkRecordExists($conditions))){
                            $this->run("UPDATE ".$bookingFlights." SET  status='".$status."' where booking_request_id='".$data['request_id']."'");
                            $this->run("UPDATE ".$bookingRequest." SET  status='".$status."' where id='".$data['request_id']."'");
                            return array(array("status"=>"200","result"=>"Request has been ".$this->getStatusMessage($status)." successfully",'status'=>$status));
                        }else{
                            return array(array("status"=>"204","result"=>"Booking Request Already ".$this->getStatusMessage($status)));
                        }
                    }else{
                        $conditions=array('tableName'=>$bookingRequest,'where'=>array('status'=>$status,'id'=>$data['request_id']));
                        if(empty($this->checkRecordExists($conditions))){
                            $this->run("UPDATE ".$bookingRequest." SET  status='".$status."' where id='".$data['request_id']."'");
                            return array(array("status"=>"200","result"=>"Request has been ".$this->getStatusMessage($status)." successfully",'status'=>$status));
                        }else{
                            return array(array("status"=>"204","result"=>"Booking Request Already ".$this->getStatusMessage($status)));
                        }
                    }
                }
            } 
            return array(array("status"=>"204","result"=>"Booking Request ID is blanked"));
        }        
    }



/*==== My be Unsed ====*/

    /*==== Approved Booking Request By Admin Code ====*/
    public function userBookingFlightApproved($data=array()){
        $bookingFlights="booking_flights";
        if(!empty($data)){
            if(array_key_exists('flight_id', $data)){
                $conditions['where']['id']=$data['flight_id'];
            }
            $updateData=array();
            $updateData['status']=1;
            $results=$this->updateData($bookingFlights,$conditions,$updateData);
            $this->bokkingRequestStatusByFlight($data['flight_id'],1);
            if(!empty($results)){
                return array(array("status"=>"200","result"=>"Flight has been approved successfully"));
            }
        }
        return array(array("status"=>"404","result"=>"No maching record found!.."));
    }

    /*==== Booking Get Flight Code ====*/
    public function userGetBookingFlight($data=array()){
        $bookingFlights="booking_flights";
        $bookingRequest="booking_request";
        $users="users";
        $whereConditions=array();
        $sqlConditions="";
        if(!empty($data)&&(array_key_exists('user_id', $data))){
            $whereConditions['br.user_id']=$data['user_id'];
        }
        $whereConditions['bf.status']=0;
        if(!empty($whereConditions)){
            $sqlConditions .= ' WHERE ';
            $i = 0;
            foreach($whereConditions as $key => $value){
                $pre = ($i > 0)?' AND ':'';
                $sqlConditions .= $pre.$key." = '".$value."'";
                $i++;
            }
        }
        $myQuery=$this->run("SELECT bf.id as flight_id,bf.user_id,bf.booking_request_id,u.name,bf.ticket_info,bf.class as flight_class,bf.fare,bf.tax,bf.total,bf.status as bf_status,br.travel_from,br.serial_number,br.travel_to,br.travel_date,br.flight_name FROM ".$bookingFlights." as bf RIGHT JOIN ".$bookingRequest." as br ON br.id=bf.booking_request_id INNER JOIN ".$users." as u on br.user_id=u.id ".$sqlConditions);
        $getReturn=$this->fetchAllRecord($myQuery);
        if(!empty($getReturn)){
            return $getReturn;
        }
        return array(array("status"=>"404","result"=>"No maching record found!.."));
    }

    /*==== Request Status Update ====*/
    public function bokkingRequestStatusByFlight($flightId='',$status=0){
        $bookingFlights="booking_flights";
        $bookingRequest="booking_request";
        if(!empty($flightId)){
            $myQuery=$this->run("SELECT * FROM ".$bookingFlights." where id=".$flightId);
            $getReturn=$this->fetchAllRecord($myQuery);
            $getResults=current($getReturn);
            $bookingRequestId=0;
            if(!empty($getResults)){
                $bookingRequestId=$getResults['booking_request_id'];
            }
            if(!empty($bookingRequestId)){
                $this->run("UPDATE ".$bookingRequest." SET  status='".$status."' where id='".$bookingRequestId."'");
            }
        }
    } 

    /*==== Booking Get Confirm Request Code ====*/
    public function userGetBookingConfirmRequest($data=array()){
        $bookingRequest="booking_request";
        $bookingFlights="booking_flights";
        $users="users";
        $whereConditions=array('br.status'=>2);
        $sqlConditions="";
        if(!empty($data)&&(array_key_exists('user_id', $data))){
            $whereConditions['br.user_id']=$data['user_id'];
        }
        if(!empty($whereConditions)){
            $sqlConditions .= ' WHERE ';
            $i = 0;
            foreach($whereConditions as $key => $value){
                $pre = ($i > 0)?' AND ':'';
                $sqlConditions .= $pre.$key." = '".$value."'";
                $i++;
            }
        } 
        $myQuery=$this->run("SELECT bf.booking_request_id,u.name,br.status,bf.id as flight_id,br.travel_from,br.serial_number,br.travel_to,br.travel_date,br.flight_name FROM ".$bookingRequest." as br RIGHT JOIN ".$bookingFlights." as bf ON bf.booking_request_id=br.id INNER JOIN ".$users." as u on br.user_id=u.id ".$sqlConditions);
        $getReturn=$this->fetchAllRecord($myQuery);
        if(!empty($getReturn)){
            return $getReturn;
        }
        return array(array("status"=>"404","result"=>"No maching record found!.."));
    }

    /*==== Booking Get Complete Request Code ====*/
    public function getUserCompleteBookings($data=array()){
        $bookingRequest="booking_request";
		$bookingFlights="booking_flights";
        $users="users";
        $whereConditions=array('br.status'=>3);
        $sqlConditions="";
        if(!empty($data)&&(array_key_exists('user_id', $data))){
            $whereConditions['br.user_id']=$data['user_id'];
        }
        if(!empty($whereConditions)){
            $sqlConditions .= ' WHERE ';
            $i = 0;
            foreach($whereConditions as $key => $value){
                $pre = ($i > 0)?' AND ':'';
                $sqlConditions .= $pre.$key." = '".$value."'";
                $i++;
            }
        } 
        $myQuery=$this->run("SELECT u.name,br.travel_from,br.serial_number,br.travel_to,br.travel_date,br.flight_name,bf.id as flight_id,bf.booking_request_id,bf.status,bf.ticket_info,bf.class as flight_class,bf.fare,bf.tax,bf.total FROM ".$bookingRequest." as br RIGHT JOIN ".$bookingFlights." as bf ON bf.booking_request_id=br.id INNER JOIN ".$users." as u on br.user_id=u.id ".$sqlConditions);
        $getReturn=$this->fetchAllRecord($myQuery);
        if(!empty($getReturn)){
            return $getReturn;
        }
        return array(array("status"=>"404","result"=>"No maching record found!.."));
    }
}
