<?php

use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


class PenciSingleCommentsList extends \Elementor\Widget_Base {

	public function get_name() {
		return 'penci-single-comment-list';
	}

	public function get_title() {
		return esc_html__( 'Post - Comment List', 'soledad' );
	}

	public function get_icon() {
		return 'eicon-commenting-o';
	}

	public function get_categories() {
		return [ 'penci-single-builder' ];
	}

	public function get_keywords() {
		return [ 'single', 'comment' ];
	}

	protected function get_html_wrapper_class() {
		return 'pcsb-cml elementor-widget-' . $this->get_name();
	}

	protected function register_controls() {

		$this->start_controls_section( 'content_section', [
			'label' => esc_html__( 'General', 'soledad' ),
			'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
		] );

		$this->add_control( 'comment_heading_style', [
			'label'     => 'Use Custom Heading Title Style',
			'type'      => \Elementor\Controls_Manager::SWITCHER,
			'label_on'  => __( 'Yes', 'soledad' ),
			'label_off' => __( 'No', 'soledad' ),
			'default'   => '',
		] );

		$this->end_controls_section();

		// heading
		$this->start_controls_section( 'section_title_block', array(
			'label'     => __( 'Heading Title', 'soledad' ),
			'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
			'condition' => [ 'comment_heading_style' => 'yes' ]
		) );
		$this->add_control( 'hide_block_heading', array(
			'label' => __( 'Hide Heading Title', 'soledad' ),
			'type'  => \Elementor\Controls_Manager::HIDDEN,
		) );
		$this->add_control( 'heading_title_style', array(
			'label'   => __( 'Choose Style', 'soledad' ),
			'type'    => \Elementor\Controls_Manager::SELECT,
			'default' => '',
			'options' => array(
				''                  => esc_html__( 'Default ( follow Customize )', 'soledad' ),
				'style-1'           => esc_html__( 'Style 1', 'soledad' ),
				'style-2'           => esc_html__( 'Style 2', 'soledad' ),
				'style-3'           => esc_html__( 'Style 3', 'soledad' ),
				'style-4'           => esc_html__( 'Style 4', 'soledad' ),
				'style-5'           => esc_html__( 'Style 5', 'soledad' ),
				'style-6'           => esc_html__( 'Style 6 - Only Text', 'soledad' ),
				'style-7'           => esc_html__( 'Style 7', 'soledad' ),
				'style-9'           => esc_html__( 'Style 8', 'soledad' ),
				'style-8'           => esc_html__( 'Style 9 - Custom Background Image', 'soledad' ),
				'style-10'          => esc_html__( 'Style 10', 'soledad' ),
				'style-11'          => esc_html__( 'Style 11', 'soledad' ),
				'style-12'          => esc_html__( 'Style 12', 'soledad' ),
				'style-13'          => esc_html__( 'Style 13', 'soledad' ),
				'style-14'          => esc_html__( 'Style 14', 'soledad' ),
				'style-15'          => esc_html__( 'Style 15', 'soledad' ),
				'style-16'          => esc_html__( 'Style 16', 'soledad' ),
				'style-2 style-17'  => esc_html__( 'Style 17', 'soledad' ),
				'style-18'          => esc_html__( 'Style 18', 'soledad' ),
				'style-18 style-19' => esc_html__( 'Style 19', 'soledad' ),
				'style-18 style-20' => esc_html__( 'Style 20', 'soledad' ),
			)
		) );
		$this->add_control( 'heading', array(
			'label'   => __( 'Heading Title', 'soledad' ),
			'type'    => \Elementor\Controls_Manager::HIDDEN,
			'default' => __( 'Heading Title', 'soledad' ),
		) );
		$this->add_control( 'heading_title_link', array(
			'label'       => __( 'Title url', 'soledad' ),
			'type'        => \Elementor\Controls_Manager::URL,
			'placeholder' => __( 'https://your-link.com', 'soledad' ),
		) );
		$this->add_control( 'block_title_align', array(
			'label'   => __( 'Heading Align', 'soledad' ),
			'type'    => \Elementor\Controls_Manager::SELECT,
			'default' => '',
			'options' => array(
				''               => esc_html__( 'Default ( follow Customize )', 'soledad' ),
				'pcalign-left'   => esc_html__( 'Left', 'soledad' ),
				'pcalign-center' => esc_html__( 'Center', 'soledad' ),
				'pcalign-right'  => esc_html__( 'Right', 'soledad' )
			)
		) );
		$this->add_control( 'heading_icon_pos', array(
			'label'     => __( 'Align Icon on Style 15', 'soledad' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'default'   => '',
			'options'   => array(
				''              => esc_html__( 'Default ( follow Customize )', 'soledad' ),
				'pciconp-right' => esc_html__( 'Right', 'soledad' ),
				'pciconp-left'  => esc_html__( 'Left', 'soledad' ),
			),
			'condition' => array( 'heading_title_style' => array( 'style-15' ) ),
		) );
		$this->add_control( 'heading_icon', array(
			'label'     => __( 'Custom Icon on Style 15', 'soledad' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'default'   => '',
			'options'   => array(
				''             => esc_html__( 'Default ( follow Customize )', 'soledad' ),
				'pcicon-right' => esc_html__( 'Arrow Right', 'soledad' ),
				'pcicon-left'  => esc_html__( 'Arrow Left', 'soledad' ),
				'pcicon-down'  => esc_html__( 'Arrow Down', 'soledad' ),
				'pcicon-up'    => esc_html__( 'Arrow Up', 'soledad' ),
				'pcicon-star'  => esc_html__( 'Star', 'soledad' ),
				'pcicon-bars'  => esc_html__( 'Bars', 'soledad' ),
				'pcicon-file'  => esc_html__( 'File', 'soledad' ),
				'pcicon-fire'  => esc_html__( 'Fire', 'soledad' ),
				'pcicon-book'  => esc_html__( 'Book', 'soledad' ),
			),
			'condition' => array( 'heading_title_style' => array( 'style-15' ) ),
		) );
		$this->end_controls_section();
		// endheading

		/* custom heading style*/
		$this->start_controls_section( 'section_title_block_style', array(
			'label'     => __( 'Block Heading Title', 'soledad' ),
			'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
			'condition' => [ 'comment_heading_style' => 'yes' ]
		) );

		$this->add_control( 'block_title_color', array(
			'label'     => __( 'Title Color', 'soledad' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'default'   => '',
			'selectors' => array(
				'{{WRAPPER}} .penci-border-arrow .inner-arrow'                                   => 'color: {{VALUE}};',
				'{{WRAPPER}} .penci-border-arrow .inner-arrow a'                                 => 'color: {{VALUE}};',
				'{{WRAPPER}} .home-pupular-posts-title, {{WRAPPER}} .home-pupular-posts-title a' => 'color: {{VALUE}};',
			),
		) );
		$this->add_control( 'block_title_hcolor', array(
			'label'     => __( 'Title Hover Color', 'soledad' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'default'   => '',
			'selectors' => array(
				'{{WRAPPER}} .penci-border-arrow .inner-arrow a:hover' => 'color: {{VALUE}} !important;',
				'{{WRAPPER}} .home-pupular-posts-title a:hover'        => 'color: {{VALUE}} !important;',
			),
		) );
		$this->add_control( 'block_title_bcolor', array(
			'label'     => __( 'Borders Color', 'soledad' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'default'   => '',
			'selectors' => array(
				'{{WRAPPER}} .penci-border-arrow .inner-arrow,' . '{{WRAPPER}} .style-4.penci-border-arrow .inner-arrow:before,' . '{{WRAPPER}} .style-4.penci-border-arrow .inner-arrow:after,' . '{{WRAPPER}} .style-5.penci-border-arrow,' . '{{WRAPPER}} .style-7.penci-border-arrow,' . '{{WRAPPER}} .style-9.penci-border-arrow' => 'border-color: {{VALUE}}',
				'{{WRAPPER}} .penci-border-arrow:before'                                                                                                                                                                                                                                                                               => 'border-top-color: {{VALUE}}',
				'{{WRAPPER}} .style-16.penci-border-arrow:after'                                                                                                                                                                                                                                                                       => 'background-color: {{VALUE}}',
				'{{WRAPPER}} .penci-home-popular-posts'                                                                                                                                                                                                                                                                                => 'border-top-color: {{VALUE}}',
			)
		) );
		$this->add_control( 'btitle_outer_bcolor', array(
			'label'     => __( 'Borders Outer Color', 'soledad' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'default'   => '',
			'selectors' => array(
				'{{WRAPPER}}  .penci-border-arrow:after' => 'border-color: {{VALUE}};'
			)
		) );
		$this->add_control( 'btitle_style10_btopcolor', array(
			'label'     => __( 'Borders Top', 'soledad' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'default'   => '',
			'selectors' => array(
				'{{WRAPPER}} .penci-homepage-title.style-10' => 'border-top-color: {{VALUE}};'
			),
			'condition' => array( 'heading_title_style' => 'style-10' ),
		) );

		$this->add_control( 'btitle_style5_bcolor', array(
			'label'     => __( 'Borders Bottom', 'soledad' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'default'   => '',
			'selectors' => array(
				'{{WRAPPER}} .style-5.penci-border-arrow'              => 'border-color: {{VALUE}};',
				'{{WRAPPER}} .penci-homepage-title.style-10'           => 'border-bottom-color: {{VALUE}};',
				'{{WRAPPER}} .style-12.penci-border-arrow'             => 'border-bottom-color: {{VALUE}};',
				'{{WRAPPER}} .style-11.penci-border-arrow'             => 'border-bottom-color: {{VALUE}};',
				'{{WRAPPER}} .style-5.penci-border-arrow .inner-arrow' => 'border-bottom-color: {{VALUE}};',
			),
			'condition' => array( 'heading_title_style' => array( 'style-5', 'style-10', 'style-11', 'style-12' ) ),
		) );
		$this->add_control( 'btitle_style78_bcolor', array(
			'label'     => __( 'Small Borders Bottom on Style 7 & 8', 'soledad' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'default'   => '',
			'selectors' => array(
				'{{WRAPPER}} .style-7.penci-border-arrow .inner-arrow:before' => 'background-color: {{VALUE}};',
				'{{WRAPPER}} .style-9.penci-border-arrow .inner-arrow:before' => 'background-color: {{VALUE}};'
			),
			'condition' => array( 'heading_title_style' => array( 'style-7', 'style-9' ) ),
		) );
		$this->add_control( 'btitle_shapes_color', array(
			'label'     => __( 'Background Color for Shapes', 'soledad' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'default'   => '',
			'selectors' => array(
				'{{WRAPPER}} .style-13.pcalign-center .inner-arrow:before,{{WRAPPER}} .style-13.pcalign-right .inner-arrow:before'                                         => 'border-left-color: {{VALUE}};',
				'{{WRAPPER}} .style-13.pcalign-center .inner-arrow:after,{{WRAPPER}} .style-13.pcalign-left .inner-arrow:after'                                            => ' border-right-color: {{VALUE}};',
				'{{WRAPPER}} .style-12 .inner-arrow:before,{{WRAPPER}} .style-12.pcalign-right .inner-arrow:after,{{WRAPPER}} .style-12.pcalign-center .inner-arrow:after' => ' border-bottom-color: {{VALUE}};',
				'{{WRAPPER}} .style-11 .inner-arrow:after,{{WRAPPER}} .style-11 .inner-arrow:before'                                                                       => ' border-top-color: {{VALUE}};'
			),
			'condition' => array( 'heading_title_style' => array( 'style-13', 'style-11', 'style-12' ) ),
		) );

		$this->add_control( 'btitle_inshapes_color', array(
			'label'     => __( 'Background Color for Shapes Inside', 'soledad' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'default'   => '',
			'selectors' => array(
				'{{WRAPPER}} .style-11 .inner-arrow:after,{{WRAPPER}} .style-11 .inner-arrow:before' => ' border-right-color: {{VALUE}};'
			),
			'condition' => array( 'heading_title_style' => array( 'style-11' ) ),
		) );

		$this->add_control( 'bgstyle15_color', array(
			'label'       => __( 'Background Color for Icon', 'soledad' ),
			'type'        => \Elementor\Controls_Manager::COLOR,
			'default'     => '',
			'description' => __( 'For Icon on Style 15', 'soledad' ),
			'selectors'   => array(
				'{{WRAPPER}} .style-15.penci-border-arrow:before' => 'background-color: {{VALUE}};',
			),
			'condition'   => array( 'heading_title_style' => array( 'style-15' ) ),
		) );
		$this->add_control( 'iconstyle15_color', array(
			'label'       => __( 'Icon Color', 'soledad' ),
			'type'        => \Elementor\Controls_Manager::COLOR,
			'default'     => '',
			'description' => __( 'For Icon on Style 15', 'soledad' ),
			'selectors'   => array(
				'{{WRAPPER}} .style-15.penci-border-arrow:after' => 'color: {{VALUE}};',
			),
			'condition'   => array( 'heading_title_style' => array( 'style-15' ) ),
		) );
		$this->add_responsive_control( 'iconstyle15_size', array(
			'label'       => __( 'Custom Font Size for Icon', 'soledad' ),
			'type'        => \Elementor\Controls_Manager::SLIDER,
			'description' => __( 'For Icon on Style 15', 'soledad' ),
			'range'       => array( 'px' => array( 'min' => 0, 'max' => 200, ) ),
			'selectors'   => array(
				'{{WRAPPER}} .style-15.penci-border-arrow:after' => 'font-size: {{SIZE}}px;',
			),
			'condition'   => array( 'heading_title_style' => array( 'style-15' ) ),
		) );
		$this->add_control( 'lines_color', array(
			'label'       => __( 'Color for Lines', 'soledad' ),
			'type'        => \Elementor\Controls_Manager::COLOR,
			'default'     => '',
			'description' => __( 'For Lines on Styles 18, 19, 20', 'soledad' ),
			'selectors'   => array(
				'{{WRAPPER}} .style-18.penci-border-arrow:after' => 'color: {{VALUE}}; background-image: linear-gradient( -45deg, transparent, transparent 30%, {{VALUE}} 30%, {{VALUE}} 50%, transparent 50%, transparent 80%, {{VALUE}} 80%);',
				'{{WRAPPER}} .style-19.penci-border-arrow:after' => 'background-image: linear-gradient( -90deg, transparent, transparent 30%, {{VALUE}} 30%, {{VALUE}} 50%, transparent 50%, transparent 80%, {{VALUE}} 80%);',
				'{{WRAPPER}} .style-20.penci-border-arrow:after' => 'background-image: linear-gradient( 0deg, transparent, transparent 30%, {{VALUE}} 30%, {{VALUE}} 50%, transparent 50%, transparent 80%, {{VALUE}} 80%);',
			),
			'condition'   => array(
				'heading_title_style' => array(
					'style-18',
					'style-18 style-19',
					'style-18 style-20'
				)
			),
		) );

		$this->add_control( 'btitle_bgcolor', array(
			'label'     => __( 'Background Color', 'soledad' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'default'   => '',
			'selectors' => array(
				'{{WRAPPER}} .style-2.penci-border-arrow:after'                                                                                                                                                                                                => 'border-color: transparent;border-top-color: {{VALUE}};',
				'{{WRAPPER}} .style-14 .inner-arrow:before,{{WRAPPER}} .style-11 .inner-arrow,' . '{{WRAPPER}} .style-12 .inner-arrow,{{WRAPPER}} .style-13 .inner-arrow,{{WRAPPER}} .style-15 .inner-arrow,' . '{{WRAPPER}} .penci-border-arrow .inner-arrow' => 'background-color: {{VALUE}};',
			)
		) );
		$this->add_control( 'btitle_outer_bgcolor', array(
			'label'     => __( 'Background Outer Color', 'soledad' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'default'   => '',
			'selectors' => array(
				'{{WRAPPER}} .penci-border-arrow:after' => 'background-color: {{VALUE}};'
			)
		) );

		$this->add_control( 'btitle_style9_bgimg', array(
			'label'     => __( 'Select Background Image for Style 9', 'soledad' ),
			'type'      => \Elementor\Controls_Manager::MEDIA,
			//'dynamic'     => array( 'active' => true ),
			//'responsive'  => true,
			//'render_type' => 'template',
			'default'   => array( 'id' => '', 'url' => '' ),
			'selectors' => array( '{{WRAPPER}} .style-8.penci-border-arrow .inner-arrow' => 'background-image: url("{{URL}}");' ),
			'condition' => array( 'heading_title_style' => 'style-8' ),
		) );

		$this->add_control( 'btitle_style9_repeat', array(
			'label'     => esc_html__( 'Background Image Repeat', 'soledad' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'options'   => array(
				'no-repeat' => esc_html__( 'No Repeat', 'soledad' ),
				'repeat'    => esc_html__( 'Repeat', 'soledad' ),
				'repeat-x'  => esc_html__( 'Repeat X', 'soledad' ),
				'repeat-y'  => esc_html__( 'Repeat Y', 'soledad' ),
			),
			'condition' => array( 'heading_title_style' => 'style-8' ),
			'default'   => 'no-repeat',
			'selectors' => array( '{{WRAPPER}} .style-8.penci-border-arrow .inner-arrow' => 'background-repeat: {{VALUE}};' ),
		) );

		$this->add_control( 'btitle_style9_size', array(
			'label'     => esc_html__( 'Background Image Size', 'soledad' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'options'   => array(
				'auto 100%' => esc_html__( 'With Auto - Height 100%', 'soledad' ),
				'100% auto' => esc_html__( 'Width 100% - Height Auto', 'soledad' ),
				'cover'     => esc_html__( 'Cover', 'soledad' ),
				'contain'   => esc_html__( 'Contain', 'soledad' ),
				'auto'      => esc_html__( 'Orininal Size', 'soledad' ),
			),
			'condition' => array( 'heading_title_style' => 'style-8' ),
			'default'   => 'auto 100%',
			'selectors' => array( '{{WRAPPER}} .style-8.penci-border-arrow .inner-arrow' => 'background-size: {{VALUE}};' ),
		) );

		$this->add_control( 'btitle_style9_pos', array(
			'label'     => esc_html__( 'Background Image Position', 'soledad' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'options'   => array(
				'left top'      => esc_html__( 'Left Top', 'soledad' ),
				'left center'   => esc_html__( 'Left Center', 'soledad' ),
				'left bottom'   => esc_html__( 'Left Bottom', 'soledad' ),
				'right top'     => esc_html__( 'Right Top', 'soledad' ),
				'right center'  => esc_html__( 'Right Center', 'soledad' ),
				'right bottom'  => esc_html__( 'Right Bottom', 'soledad' ),
				'center top'    => esc_html__( 'Center Top', 'soledad' ),
				'center center' => esc_html__( 'Center', 'soledad' ),
				'center bottom' => esc_html__( 'Center Bottom', 'soledad' ),
			),
			'condition' => array( 'heading_title_style' => 'style-8' ),
			'default'   => 'left top',
			'selectors' => array( '{{WRAPPER}} .style-8.penci-border-arrow .inner-arrow' => 'background-position: {{VALUE}};' ),
		) );

		$this->add_group_control( Group_Control_Typography::get_type(), array(
			'name'     => 'btitle_typo',
			'label'    => __( 'Block Title Typography', 'soledad' ),
			'selector' => '{{WRAPPER}} .penci-border-arrow .inner-arrow',
		) );
		$this->end_controls_section();
		/* end custom heading*/

		$this->start_controls_section( 'color_style', [
			'label' => esc_html__( 'Color & Styles', 'soledad' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		] );

		$this->add_control( 'comment_listings_settings', [
			'label' => 'Comment Listings',
			'type'  => \Elementor\Controls_Manager::HEADING,
		] );

		$this->add_control( 'author_ava_width', [
			'label'     => 'Author Avatar Width',
			'type'      => \Elementor\Controls_Manager::SLIDER,
			'range'     => array( 'px' => array( 'min' => 0, 'max' => 100, ) ),
			'selectors' => [
				'{{WRAPPER}} .thecomment .author-img'   => 'width:{{SIZE}}px',
				'{{WRAPPER}} .thecomment .comment-text' => 'margin-left:calc({{SIZE}}px + 20px)',
			],
		] );

		$this->add_control( 'author_ava_boderradius', [
			'label'     => 'Author Avatar Borders Radius',
			'type'      => \Elementor\Controls_Manager::SLIDER,
			'range'     => array( 'px' => array( 'min' => 0, 'max' => 100, ) ),
			'selectors' => [ '{{WRAPPER}} .thecomment .author-img' => 'border-radius:{{SIZE}}px;overflow:hidden;' ],
		] );

		$this->add_group_control( \Elementor\Group_Control_Typography::get_type(), array(
			'name'     => 'comment_author_text_typo',
			'label'    => __( 'Typography for Author Name', 'soledad' ),
			'selector' => '{{WRAPPER}} .thecomment .comment-text span.author, {{WRAPPER}} .thecomment .comment-text span.author a',
		) );

		$this->add_control( 'comment_name_color', [
			'label'     => 'Author Name Color',
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => [ '{{WRAPPER}} .thecomment .comment-text span.author, {{WRAPPER}} .thecomment .comment-text span.author a' => 'color:{{VALUE}}' ],
		] );

		$this->add_control( 'comment_name_hcolor', [
			'label'     => 'Author Name Hover Color',
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => [ '{{WRAPPER}} .thecomment .comment-text span.author a:hover' => 'color:{{VALUE}}' ],
		] );

		$this->add_group_control( \Elementor\Group_Control_Typography::get_type(), array(
			'name'     => 'comment_date_typo',
			'label'    => __( 'Typography for Comment Date', 'soledad' ),
			'selector' => '{{WRAPPER}} .thecomment .comment-text span.date',
		) );

		$this->add_control( 'comment_date_color', [
			'label'     => 'Color for Comment Date',
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => [ '{{WRAPPER}} .thecomment .comment-text span.date' => 'color:{{VALUE}}' ],
		] );

		$this->add_group_control( \Elementor\Group_Control_Typography::get_type(), array(
			'name'     => 'comment_content_typo',
			'label'    => __( 'Typography for Comment Content', 'soledad' ),
			'selector' => '{{WRAPPER}} .thecomment .comment-content',
		) );

		$this->add_control( 'comment_content_color', [
			'label'     => 'Color for Comment Content',
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => [ '{{WRAPPER}} .thecomment .comment-content' => 'color:{{VALUE}}' ],
		] );

		$this->add_group_control( \Elementor\Group_Control_Typography::get_type(), array(
			'name'     => 'comment_reply_typo',
			'label'    => __( 'Typography for Reply Button', 'soledad' ),
			'selector' => '{{WRAPPER}} .post-comments span.reply a',
		) );

		$this->add_control( 'comment_reply_color', [
			'label'     => 'Reply Button Color',
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => [ '{{WRAPPER}} .post-comments span.reply a' => 'color:{{VALUE}}' ],
		] );

		$this->add_control( 'comment_reply_hcolor', [
			'label'     => 'Reply Button Hover Color',
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => [ '{{WRAPPER}} .post-comments span.reply a:hover' => 'color:{{VALUE}}' ],
		] );

		$this->add_control( 'comment_item_bcolor', [
			'label'     => 'General Comment Borders Color',
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => [ '{{WRAPPER}} .comments .comment' => 'border-color:{{VALUE}}' ],
		] );

		$this->end_controls_section();

	}

	protected function render() {

		if ( penci_elementor_is_edit_mode() ) {
			$this->preview_content();
		} else {
			$this->builder_content();
		}

	}

	protected function preview_content() {
		$settings = $this->get_settings_for_display();

		$comment_title       = get_comments_number_text( '0 ' . penci_get_setting( 'penci_trans_comment' ), '1 ' . penci_get_setting( 'penci_trans_comment' ), '% ' . penci_get_setting( 'penci_trans_comments' ) );
		$settings['heading'] = $comment_title ? $comment_title : '3 Comments';

		if ( $settings['comment_heading_style'] == 'yes' ) {
			$this->markup_block_title( $settings );
		}
		if ( $settings['comment_heading_style'] != 'yes' ) {
			echo '<div class="post-title-box"><h4 class="post-box-title">';
			comments_number( '0 ' . penci_get_setting( 'penci_trans_comment' ), '1 ' . penci_get_setting( 'penci_trans_comment' ), '% ' . penci_get_setting( 'penci_trans_comments' ) );
			echo '</h4></div>';
		}
		?>
        <div class="comments">
            <div class="comment byuser comment-author-admin even thread-even depth-1" id="comment-62" itemprop=""
                 itemscope="itemscope" itemtype="https://schema.org/UserComments">
                <meta itemprop="discusses" content="Green Corner in My Home">
                <link itemprop="url" href="#comment-62">
                <div class="thecomment">
                    <div class="author-img">
                        <img alt=""
                             src="<?php echo get_template_directory_uri() . '/inc/template-builder/placeholder.php?w=100&h=100'; ?>"
                             width="100" height="100"></div>
                    <div class="comment-text">
                        <span class="author" itemprop="creator" itemtype="https://schema.org/Person"><span
                                    itemprop="name"><a href="http://pencidesign.com/" rel="external nofollow ugc"
                                                       class="url">Penci</a></span></span>
                        <span class="date" datetime="2017-07-19T03:55:55+00:00"
                              title="Wednesday, July 19, 2017, 3:55 am" itemprop="commentTime"><i
                                    class="penci-faicon fa fa-clock-o"></i>July 19, 2017 - 3:55 am</span>
                        <div class="comment-content" itemprop="commentText"><p>Neque porro quisquam est, qui dolorem
                                ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi
                                tempora incidunt ut labore.</p>
                        </div>
                        <span class="reply">
						<a rel="nofollow" class="comment-reply-link"
                           href="#?replytocom=62#respond"
                           data-commentid="62" data-postid="243" data-belowelement="comment-62"
                           data-respondelement="respond" data-replyto="Reply to Penci"
                           aria-label="Reply to Penci">Reply</a>											</span>
                    </div>
                </div>
                <div class="comment byuser comment-author-admin odd alt depth-2" id="comment-63" itemprop=""
                     itemscope="itemscope" itemtype="https://schema.org/UserComments">
                    <meta itemprop="discusses" content="Green Corner in My Home">
                    <link itemprop="url" href="#comment-63">
                    <div class="thecomment">
                        <div class="author-img">
                            <img alt=""
                                 src="<?php echo get_template_directory_uri() . '/inc/template-builder/placeholder.php?w=100&h=100'; ?>"
                                 width="100" height="100"></div>
                        <div class="comment-text">
                            <span class="author" itemprop="creator" itemtype="https://schema.org/Person"><span
                                        itemprop="name"><a href="http://pencidesign.com/" rel="external nofollow ugc"
                                                           class="url">Penci</a></span></span>
                            <span class="date" datetime="2017-07-19T03:56:02+00:00"
                                  title="Wednesday, July 19, 2017, 3:56 am" itemprop="commentTime"><i
                                        class="penci-faicon fa fa-clock-o"></i>July 19, 2017 - 3:56 am</span>
                            <div class="comment-content" itemprop="commentText"><p>Quis autem vel eum iure reprehenderit
                                    qui in ea voluptate velit esse quam nihil.</p>
                            </div>
                            <span class="reply">
						<a rel="nofollow" class="comment-reply-link"
                           href="#?replytocom=63#respond"
                           data-commentid="63" data-postid="243" data-belowelement="comment-63"
                           data-respondelement="respond" data-replyto="Reply to Penci"
                           aria-label="Reply to Penci">Reply</a>											</span>
                        </div>
                    </div>
                </div><!-- #comment-## -->
            </div><!-- #comment-## -->
            <div class="comment byuser comment-author-admin even thread-odd thread-alt depth-1" id="comment-64"
                 itemprop="" itemscope="itemscope" itemtype="https://schema.org/UserComments">
                <meta itemprop="discusses" content="Green Corner in My Home">
                <link itemprop="url" href="#comment-64">
                <div class="thecomment">
                    <div class="author-img">
                        <img alt=""
                             src="<?php echo get_template_directory_uri() . '/inc/template-builder/placeholder.php?w=100&h=100'; ?>"
                             width="100" height="100"></div>
                    <div class="comment-text">
                        <span class="author" itemprop="creator" itemtype="https://schema.org/Person"><span
                                    itemprop="name"><a href="http://pencidesign.com/" rel="external nofollow ugc"
                                                       class="url">Penci</a></span></span>
                        <span class="date" datetime="2017-07-19T03:56:10+00:00"
                              title="Wednesday, July 19, 2017, 3:56 am" itemprop="commentTime"><i
                                    class="penci-faicon fa fa-clock-o"></i>July 19, 2017 - 3:56 am</span>
                        <div class="comment-content" itemprop="commentText"><p>Et harum quidem rerum facilis est et
                                expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque
                                nihil impedit quo minus id quod maxime placeat facere.</p>
                        </div>
                        <span class="reply">
						<a rel="nofollow" class="comment-reply-link"
                           href="#?replytocom=64#respond"
                           data-commentid="64" data-postid="243" data-belowelement="comment-64"
                           data-respondelement="respond" data-replyto="Reply to Penci"
                           aria-label="Reply to Penci">Reply</a>											</span>
                    </div>
                </div>
            </div><!-- #comment-## -->
        </div>
		<?php
	}

	public static function markup_block_title( $args, $self = null ) {
		$defaults = array(
			'heading_title_style'  => 'style-1',
			'heading'              => '',
			'heading_title_link'   => '',
			'add_title_icon'       => '',
			'block_title_icon'     => '',
			'block_title_ialign'   => '',
			'block_title_align'    => '',
			'heading_icon_pos'     => '',
			'heading_icon'         => '',
			'block_title_marginbt' => '',
		);

		$r = wp_parse_args( $args, $defaults );

		if ( ! $r['heading'] ) {
			return;
		}

		if ( 'video_list' == $r['heading_title_style'] ) {
			return;
		}

		$heading_title = get_theme_mod( 'penci_sidebar_heading_style' ) ? get_theme_mod( 'penci_sidebar_heading_style' ) : 'style-1';
		$heading_align = get_theme_mod( 'penci_sidebar_heading_align' ) ? get_theme_mod( 'penci_sidebar_heading_align' ) : 'pcalign-center';


		if ( $r['heading_title_style'] ) {
			$heading_title = $r['heading_title_style'];
		}

		if ( $r['block_title_align'] ) {
			$heading_align = 'pcalign-' . $r['block_title_align'];
		}

		$heading_icon_pos    = get_theme_mod( 'penci_sidebar_icon_align' ) ? get_theme_mod( 'penci_sidebar_icon_align' ) : 'pciconp-right';
		$heading_icon_design = get_theme_mod( 'penci_sidebar_icon_design' ) ? get_theme_mod( 'penci_sidebar_icon_design' ) : 'pcicon-right';

		if ( $r['heading_icon_pos'] ) {
			$heading_icon_pos = $r['heading_icon_pos'];
		}

		if ( $r['heading_icon'] ) {
			$heading_icon_design = $r['heading_icon'];
		}

		$classes = 'penci-border-arrow penci-homepage-title penci-home-latest-posts';
		$classes .= ' ' . $heading_title;
		$classes .= ' ' . $heading_align;
		$classes .= ' ' . $heading_icon_pos;
		$classes .= ' ' . $heading_icon_design;
		$classes .= $r['block_title_ialign'] ? ' block-title-icon-' . $r['block_title_ialign'] : ' block-title-icon-left';
		?>
        <div class="<?php echo esc_attr( $classes ); ?>">
            <h3 class="inner-arrow">
				<?php
				if ( $r['heading_title_link']['url'] ) {
					$self->add_render_attribute( 'link', 'href', $r['heading_title_link']['url'] );
					if ( $r['heading_title_link']['is_external'] ) {
						$self->add_render_attribute( 'link', 'target', '_blank' );
					}

					if ( $r['heading_title_link']['nofollow'] ) {
						$self->add_render_attribute( 'link', 'rel', 'nofollow' );
					}

					echo '<a ' . $self->get_render_attribute_string( 'link' ) . '>';
				} else {
					echo '<span>';
				}

				if ( $r['add_title_icon'] && $r['block_title_icon'] && 'left' == $r['block_title_ialign'] ) {
					\Elementor\Icons_Manager::render_icon( $r['block_title_icon'] );
				}
				echo do_shortcode( $r['heading'] );
				if ( $r['add_title_icon'] && $r['block_title_icon'] && 'right' == $r['block_title_ialign'] ) {
					\Elementor\Icons_Manager::render_icon( $r['block_title_icon'] );
				}
				if ( $r['heading_title_link'] ) {
					echo '</a>';
				} else {
					echo '</span>';
				}
				?>
            </h3>
        </div>
		<?php
	}

	protected function builder_content() {
		$settings = $this->get_settings_for_display();

		$comment_title       = get_comments_number_text( '0 ' . penci_get_setting( 'penci_trans_comment' ), '1 ' . penci_get_setting( 'penci_trans_comment' ), '% ' . penci_get_setting( 'penci_trans_comments' ) );
		$settings['heading'] = $comment_title;

		if ( $settings['comment_heading_style'] == 'yes' ) {
			$this->markup_block_title( $settings );
		}
		comments_template( '/inc/template-builder/single-elements/comment-template.php', true );
	}
}
