<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


class PenciSingleCommentsForm extends \Elementor\Widget_Base {

	public function get_name() {
		return 'penci-single-comment-form';
	}

	public function get_title() {
		return esc_html__( 'Post - Comment Form', 'soledad' );
	}

	public function get_icon() {
		return 'eicon-form-horizontal';
	}

	public function get_categories() {
		return [ 'penci-single-builder' ];
	}

	public function get_keywords() {
		return [ 'single', 'comment' ];
	}

	protected function get_html_wrapper_class() {
		return 'pcsb-cmf elementor-widget-' . $this->get_name();
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'General', 'soledad' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'hide_heading',
			[
				'label'     => esc_html__( 'Hide Comment Form Heading', 'soledad' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'selectors' => [ '{{WRAPPER}} h3.comment-reply-title' => 'display:none' ],
			]
		);

		$this->add_control(
			'penci_single_comments_remove_name',
			[
				'label'       => esc_html__( 'Hide "Name" field on Comment Form', 'soledad' ),
				'description' => 'Note that: If you want to hide this field - you need go to Dashboard > Settings > Discussion > and un-check to "Comment author must fill out name and email" - check <a href="https://imgresources.s3.amazonaws.com/discussion_settings.png" target="_blank">this image</a> for more.',
				'type'        => \Elementor\Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'penci_single_comments_remove_email',
			[
				'label'       => esc_html__( 'Hide "Email" field on Comment Form', 'soledad' ),
				'description' => 'Note that: If you want to hide this field - you need go to Dashboard > Settings > Discussion > and un-check to "Comment author must fill out name and email" - check <a href="https://imgresources.s3.amazonaws.com/discussion_settings.png" target="_blank">this image</a> for more.',
				'type'        => \Elementor\Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'penci_single_comments_remove_website',
			[
				'label' => esc_html__( 'Hide "Website" field on Comment Form', 'soledad' ),
				'type'  => \Elementor\Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'penci_single_hide_save_fields',
			[
				'label'       => esc_html__( 'Remove checkbox "Save my name, email, and website in this browser for the next time I comment."', 'soledad' ),
				'description' => 'Note that: This checkbox just appears when you use Wordpress from version 4.9.6',
				'type'        => \Elementor\Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'penci_single_gdpr',
			[
				'label' => esc_html__( 'Enable GDPR message on Comment Form', 'soledad' ),
				'type'  => \Elementor\Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'penci_single_gdpr_text',
			[
				'label'   => esc_html__( 'Custom GDPR Message on Comment Form', 'soledad' ),
				'type'    => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( '* By using this form you agree with the storage and handling of your data by this website.', 'soledad' ),
			]
		);

		$this->add_control(
			'submit_btn_align',
			[
				'label'     => __( 'Submit Button Align', 'soledad' ),
				'type'      => \Elementor\Controls_Manager::CHOOSE,
				'default'   => 'left',
				'options'   => array(
					'left'   => array(
						'title' => __( 'Left', 'soledad' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => __( 'Center', 'soledad' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => __( 'Right', 'soledad' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'selectors' => [ '{{WRAPPER}} #respond p.form-submit' => 'text-align:{{VALUE}}' ],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'color_style',
			[
				'label' => esc_html__( 'Color & Styles', 'soledad' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'comment_form_settings',
			[
				'label' => 'Comment Form',
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), array(
				'name'     => 'comment_input_text_typo',
				'label'    => __( 'Typography for Input Text', 'soledad' ),
				'selector' => '{{WRAPPER}} #respond textarea, {{WRAPPER}} #respond input',
			)
		);

		$this->add_control(
			'comment_input_text_color',
			[
				'label'     => 'Input Text Color',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [ '{{WRAPPER}} #respond textarea, {{WRAPPER}} #respond input' => 'color:{{VALUE}}' ],
			]
		);

		$this->add_control(
			'comment_input_border_color',
			[
				'label'     => 'Input Borders Color',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [ '{{WRAPPER}} #respond textarea, {{WRAPPER}} #respond input' => 'border-color:{{VALUE}}' ],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), array(
				'name'     => 'comment_btn_text_typo',
				'label'    => __( 'Typography for Submit Text', 'soledad' ),
				'selector' => '{{WRAPPER}} #respond #submit',
			)
		);

		$this->add_control(
			'comment_submit_bg_color',
			[
				'label'     => 'Submit Background Color',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [ '{{WRAPPER}} #respond #submit' => 'background-color:{{VALUE}}' ],
			]
		);

		$this->add_control(
			'comment_submit_bg_hcolor',
			[
				'label'     => 'Submit Background Hover Color',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [ '{{WRAPPER}} #respond #submit:hover' => 'background-color:{{VALUE}}' ],
			]
		);

		$this->add_control(
			'comment_submit_txt_color',
			[
				'label'     => 'Submit Text Color',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [ '{{WRAPPER}} #respond #submit' => 'color:{{VALUE}}' ],
			]
		);

		$this->add_control(
			'comment_submit_txt_hcolor',
			[
				'label'     => 'Submit Text Hover Color',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [ '{{WRAPPER}} #respond #submit:hover' => 'color:{{VALUE}}' ],
			]
		);

		$this->end_controls_section();

	}

	protected function render() {

		$this->builder_content();
	}


	protected function builder_content() {
		if ( penci_elementor_is_edit_mode() ) {
			add_filter( 'comments_open', function () {
				return true;
			} );
		}
		$settings   = $this->get_settings_for_display();
		$hide_count = 0;
		if ( $settings['penci_single_comments_remove_name'] ) {
			$hide_count += 1;
		}
		if ( $settings['penci_single_comments_remove_email'] ) {
			$hide_count += 1;
		}
		if ( $settings['penci_single_comments_remove_website'] ) {
			$hide_count += 1;
		}

		$commenter = wp_get_current_commenter();
		$req       = get_option( 'require_name_email' );
		$aria_req  = ( $req ? " aria-required='true'" : '' );
		$consent   = empty( $commenter['comment_author_email'] ) ? '' : ' checked="checked"';

		$fields = array(
			'author' => '<p class="comment-form-author"><input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" placeholder="' . penci_get_setting( 'penci_trans_name' ) . '" size="30"' . $aria_req . ' /></p>',

			'email' => '<p class="comment-form-email"><input id="email" name="email" type="text" value="' . esc_attr( $commenter['comment_author_email'] ) . '" placeholder="' . penci_get_setting( 'penci_trans_email' ) . '" size="30"' . $aria_req . ' /></p>',

			'url' => '<p class="comment-form-url"><input id="url" name="url" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) . '" placeholder="' . penci_get_setting( 'penci_trans_website' ) . '" size="30" /></p>',
		);

		if ( $settings['penci_single_comments_remove_name'] ) {
			$fields['author'] = '';
		}
		if ( $settings['penci_single_comments_remove_email'] ) {
			$fields['email'] = '';
		}
		if ( $settings['penci_single_comments_remove_website'] ) {
			$fields['url'] = '';
		}

		if ( ! $settings['penci_single_hide_save_fields'] && version_compare( get_bloginfo( 'version' ), '4.9.6', '>=' ) ) {
			$fields['cookies'] = '<p class="comment-form-cookies-consent"><input id="wp-comment-cookies-consent" name="wp-comment-cookies-consent" type="checkbox" value="yes"' . $consent . ' />' .
				'<span class="comment-form-cookies-text" for="wp-comment-cookies-consent">' . penci_get_setting( 'penci_trans_save_fields' ) . '</span></p>';
		} else {
			$fields['cookies'] = '';
		}

		$custom_comment_field = '<p class="comment-form-comment"><textarea id="comment" name="comment" cols="45" rows="8" placeholder="' . penci_get_setting( 'penci_trans_your_comment' ) . '" aria-required="true"></textarea></p>';  //label removed for cleaner layout

		$gdrp_mess = '';
		if ( $settings['penci_single_gdpr'] ) {
			$mess_default = $settings['penci_single_gdpr_text'] ? do_shortcode( $settings['penci_single_gdpr_text'] ) : esc_html__( '* By using this form you agree with the storage and handling of your data by this website.', 'soledad' );

			if ( $mess_default ) {
				$gdrp_mess .= '<div class="penci-gdpr-message">';
				$gdrp_mess .= do_shortcode( $mess_default );
				$gdrp_mess .= '</div>';
			}
		}

		echo '<div class="post-comments penci-comments-hide-' . $hide_count . '" id="comments">';

		comment_form( array(
			'comment_field'        => $custom_comment_field,
			'comment_notes_after'  => '',
			'logged_in_as'         => '',
			'comment_notes_before' => '',
			'title_reply'          => '<span>' . penci_get_setting( 'penci_trans_leave_a_comment' ) . '</span>',
			'cancel_reply_link'    => penci_get_setting( 'penci_trans_cancel_reply' ),
			'label_submit'         => penci_get_setting( 'penci_trans_submit' ),
			'fields'               => apply_filters( 'comment_form_default_fields', $fields ),
			'submit_field'         => $gdrp_mess . '<p class="form-submit">%1$s %2$s</p>',
		) );

		echo '</div>';
	}
}
