<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


class PenciArchiveTaxonomy extends Widget_Base {

	public function get_title() {
		return esc_html__( 'Archive - Taxonomies', 'soledad' );
	}

	public function get_icon() {
		return 'eicon-text';
	}

	public function get_categories() {
		return [ 'penci-custom-archive-builder' ];
	}

	public function get_keywords() {
		return [ 'archive', 'taxonomies' ];
	}

	protected function get_html_wrapper_class() {
		return 'pcab-txnm elementor-widget-' . $this->get_name();
	}

	public function get_name() {
		return 'penci-archive-taxonomies';
	}

	protected function register_controls() {

		$this->start_controls_section( 'content_section', [
			'label' => esc_html__( 'General', 'soledad' ),
			'tab'   => Controls_Manager::TAB_CONTENT,
		] );

		$this->add_control( 'tax_showall', [
			'label'   => esc_html__( 'Term Listing', 'soledad' ),
			'type'    => Controls_Manager::SELECT,
			'default' => 'all',
			'options' => [
				'all'    => 'All Items',
				'child'  => 'Child Items',
				'custom' => 'Custom Items'
			]
		] );

		$this->add_control( 'taxonomies', [
			'label'       => esc_html__( 'Select the Post Taxonomies Term.', 'soledad' ),
			'type'        => 'penci_el_autocomplete',
			'search'      => 'penci_get_taxonomies_by_query',
			'render'      => 'penci_get_taxonomies_title_by_id',
			'taxonomy'    => get_object_taxonomies( 'post' ),
			'multiple'    => true,
			'label_block' => true,
			'condition'   => [
				'tax_showall' => 'custom',
			],
		] );

		$this->add_control( 'taxonomies_ex', [
			'label'       => esc_html__( 'Select the Excluded Post Taxonomies Term.', 'soledad' ),
			'type'        => 'penci_el_autocomplete',
			'search'      => 'penci_get_taxonomies_by_query',
			'render'      => 'penci_get_taxonomies_title_by_id',
			'taxonomy'    => get_object_taxonomies( 'post' ),
			'multiple'    => true,
			'label_block' => true,
		] );

		$this->add_control( 'term_style', [
			'label'   => 'Display Style',
			'type'    => Controls_Manager::SELECT,
			'default' => 's1',
			'options' => [
				's1' => 'Style 1',
				's2' => 'Style 2',
				's3' => 'Style 3',
				's4' => 'Style 4',
			]
		] );

		$this->add_control( 'orderby', [
			'label'     => esc_html__( 'Order By', 'soledad' ),
			'type'      => Controls_Manager::SELECT,
			'default'   => 'name',
			'options'   => [
				'name'       => 'Name',
				'slug'       => 'Slug',
				'term_id'    => 'ID',
				'term_order' => 'Term Order',
				'count'      => 'Term Count',
			],
			'condition' => [
				'tax_showall!' => 'custom',
			],
		] );

		$this->add_control( 'order', [
			'label'     => esc_html__( 'Order', 'soledad' ),
			'type'      => Controls_Manager::SELECT,
			'default'   => 'ASC',
			'options'   => [
				'DESC' => 'DESC',
				'ASC'  => 'ASC',
			],
			'condition' => [
				'tax_showall!' => 'custom',
			],
		] );

		$this->add_control( 'number', [
			'label'       => esc_html__( 'Limit Terms to Show', 'soledad' ),
			'description' => esc_html__( 'This option is visible on frontend only.', 'soledad' ),
			'type'        => Controls_Manager::NUMBER,
			'condition'   => [
				'tax_showall!' => 'custom',
			],
		] );

		$this->add_control( 'tax_showcount', [
			'label' => esc_html__( 'Show Posts Count', 'soledad' ),
			'type'  => Controls_Manager::SWITCHER,
		] );

		$this->end_controls_section();

		$this->start_controls_section( 'color_style', [
			'label' => esc_html__( 'Color & Styles', 'soledad' ),
			'tab'   => Controls_Manager::TAB_STYLE,
		] );

		$this->add_responsive_control( 'term_spacing', [
			'label'     => 'Spacing Between each Term',
			'type'      => Controls_Manager::SLIDER,
			'selectors' => [ '{{WRAPPER}} .pctmp-term-list li:not(:last-child)' => 'margin-right:{{SIZE}}px' ],
		] );

		$this->add_group_control( Group_Control_Typography::get_type(), array(
			'name'     => 'term_typo',
			'label'    => __( 'Typography for Term', 'soledad' ),
			'selector' => '{{WRAPPER}} .pctmp-term-item',
		) );

		$this->add_control( 'term_color', [
			'label'     => 'Term Color',
			'type'      => Controls_Manager::COLOR,
			'selectors' => [ '{{WRAPPER}} .pctmp-term-item' => 'color:{{VALUE}}' ],
		] );

		$this->add_control( 'term_hcolor', [
			'label'     => 'Term Hover Color',
			'type'      => Controls_Manager::COLOR,
			'selectors' => [ '{{WRAPPER}} a.pctmp-term-item:hover' => 'color:{{VALUE}}' ],
		] );

		$this->add_control( 'term_bgcolor', [
			'label'     => 'Term Background Color',
			'type'      => Controls_Manager::COLOR,
			'selectors' => [ '{{WRAPPER}} .pctmp-term-item' => 'background-color:{{VALUE}}' ],
		] );

		$this->add_control( 'term_bghcolor', [
			'label'     => 'Term Background Hover Color',
			'type'      => Controls_Manager::COLOR,
			'selectors' => [ '{{WRAPPER}} a.pctmp-term-item:hover' => 'background-color:{{VALUE}}' ],
		] );

		$this->add_control( 'term_bcolor', [
			'label'     => 'Term Background Borders Color',
			'type'      => Controls_Manager::COLOR,
			'selectors' => [ '{{WRAPPER}} .pctmp-term-item' => 'border-color:{{VALUE}}' ],
		] );

		$this->add_control( 'term_bhcolor', [
			'label'     => 'Term Background Borders Hover Color',
			'type'      => Controls_Manager::COLOR,
			'selectors' => [ '{{WRAPPER}} a.pctmp-term-item:hover' => 'border-color:{{VALUE}}' ],
		] );

		$this->add_control( 'term_padding', [
			'label'      => 'Term Item Padding',
			'type'       => Controls_Manager::DIMENSIONS,
			'size_units' => array( 'px', '%', 'em' ),
			'selectors'  => array(
				'{{WRAPPER}} .pctmp-term-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
			),
		] );

		$this->add_control( 'term_border', [
			'label'      => 'Term Item Border',
			'type'       => Controls_Manager::DIMENSIONS,
			'size_units' => array( 'px', '%', 'em' ),
			'selectors'  => array(
				'{{WRAPPER}} .pctmp-term-item' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
			),
		] );

		$this->add_control( 'term_border_style', [
			'label'     => 'Term Borders Style',
			'type'      => Controls_Manager::SELECT,
			'options'   => [
				'dotted' => 'Dotted',
				'dashed' => 'Dashed',
				'solid'  => 'Solid',
				'double' => 'Double',
				'groove' => 'Groove',
				'ridge'  => 'Ridge',
				'inset'  => 'Inset',
				'outset' => 'Outset',
			],
			'selectors' => [ '{{WRAPPER}} .pctmp-term-item' => 'border-style:{{VALUE}}' ],
		] );

		$this->add_control( 'term_border_radius', [
			'label'      => 'Term Item Borders Radius',
			'type'       => Controls_Manager::DIMENSIONS,
			'size_units' => array( 'px', '%', 'em' ),
			'selectors'  => array(
				'{{WRAPPER}} .pctmp-term-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
			),
		] );

		$this->end_controls_section();

	}

	protected function render() {

		if ( penci_elementor_is_edit_mode() ) {
			$this->preview_content();
		} else {
			$this->builder_content();
		}

	}

	protected function preview_content() {
		$settings   = $this->get_settings();
		$term_style = $settings['term_style'];
		$taxonomies = $settings['taxonomies'];
		$count      = '';
		$demo_lists = [
			'Sport',
			'Football',
			'Tennis',
			'Volleyball',
			'Joke',
		];
		if ( $settings['tax_showall'] == 'custom' && ! empty( $taxonomies ) ) {
			?>
            <div class="pc-tax-lists">
                <ul class="pctmp-term-list term-style-<?php echo esc_attr( $term_style ); ?>">
					<?php foreach ( $taxonomies as $term_id ) {
						$term = get_term( $term_id );
						if ( $settings['tax_showcount'] ) {
							$count = '<span class="count">(' . $term->count . ')</span>';
						}
						echo '<li><a class="pctmp-term-item" href="' . get_term_link( $term->term_id ) . '">' . esc_html( $term->name ) . $count . '</a></li>';
					} ?>
                </ul>
            </div>
			<?php
		} else {
			?>
            <div class="pc-tax-lists">
                <ul class="pctmp-term-list term-style-<?php echo esc_attr( $term_style ); ?>">
					<?php foreach ( $demo_lists as $list ) {
						if ( $settings['tax_showcount'] ) {
							$count = '<span class="count">(' . rand( 0, 99 ) . ')</span>';
						}
						echo '<li><a class="pctmp-term-item" href="#">' . $list . $count . '</a></li>';
					} ?>
                </ul>
            </div>
			<?php
		}
	}

	protected function builder_content() {
		$settings   = $this->get_settings();
		$term_style = $settings['term_style'];
		$taxonomies = $settings['taxonomies'];
		$queries    = get_queried_object();
		$count      = '';
		if ( ! isset( $queries->taxonomy ) || ( $settings['tax_showall'] == 'custom' && empty( $taxonomies ) ) ) {
			return false;
		}

		$args = [
			'taxonomy' => $queries->taxonomy,
			'orderby'  => $settings['orderby'],
			'order'    => $settings['order'],
		];

		if ( $settings['taxonomies_ex'] ) {
			$args['exclude'] = $settings['taxonomies_ex'];
		}

		if ( $settings['number'] ) {
			$args['number'] = $settings['number'];
		}

		if ( $settings['tax_showall'] == 'child' ) {
			$args['child_of'] = $queries->term_id;
		}

		$terms = get_terms( $args );
		if ( $terms && $settings['tax_showall'] !== 'custom' ) {
			?>
            <div class="pc-tax-lists">
                <ul class="pctmp-term-list term-style-<?php echo esc_attr( $term_style ); ?>">
					<?php foreach ( $terms as $term ) {
						if ( $settings['tax_showcount'] ) {
							$count = '<span class="count">(' . $term->count . ')</span>';
						}
						echo '<li><a class="pctmp-term-item" href="' . get_term_link( $term->term_id ) . '">' . esc_html( $term->name ) . $count . '</a></li>';
					} ?>
                </ul>
            </div>
			<?php
		} elseif ( $settings['tax_showall'] == 'custom' && ! empty( $taxonomies ) ) {
			?>
            <div class="pc-tax-lists">
                <ul class="pctmp-term-list term-style-<?php echo esc_attr( $term_style ); ?>">
					<?php foreach ( $taxonomies as $term_id ) {
						$term = get_term( $term_id );
						if ( $settings['tax_showcount'] ) {
							$count = '<span class="count">(' . $term->count . ')</span>';
						}
						echo '<li><a class="pctmp-term-item" href="' . get_term_link( $term->term_id ) . '">' . esc_html( $term->name ) . $count . '</a></li>';
					} ?>
                </ul>
            </div>
			<?php
		}
	}
}
