<?php
$group_color   = 'Typo & Color';
$group_heading = 'Heading';

vc_map( array(
	'base'          => 'penci_video_playlist',
	'icon'          => get_template_directory_uri() . '/images/vc-icon.png',
	'category'      => 'Soledad',
	'html_template' => get_template_directory() . '/inc/js_composer/shortcodes/video_playlist/frontend.php',
	'weight'        => 700,
	'name'          => __( 'Penci Video Playlist', 'soledad' ),
	'description'   => __( 'Video playlist block', 'soledad' ),
	'controls'      => 'full',
	'params'        => array_merge(
		array(
			array(
				'type'       => 'dropdown',
				'heading'    => __( 'Block Columns', 'soledad' ),
				'param_name' => 'penci_block_width',
				'std'        => 3,
				'value'      => array(
					__( '1 Column ( Small Container Width)', 'soledad' )    => '1',
					__( '2 Columns ( Medium Container Width )', 'soledad' ) => '2',
					__( '3 Columns ( Large Container Width )', 'soledad' )  => '3',
				),
			),
			array(
				'type'        => 'exploded_textarea',
				'heading'     => esc_html__( 'Videos List', 'soledad' ),
				'param_name'  => 'videos_list',
				'std'         => '',
				'description' => 'Enter each video url in a seprated line. Supports: YouTube and Vimeo videos only.<br><span style="color: red;font-weight: bold;">Note Important</span>: If  you use video come from youtube, please go to Customize > General > Extra Options > YouTube API Key and enter an api key.</span>'
			),
			array(
				'type'             => 'checkbox',
				'heading'          => esc_html__( 'Hide video duration', 'soledad' ),
				'param_name'       => 'hide_duration',
				'edit_field_class' => 'vc_col-sm-6',
				'value'            => array( __( 'Yes', 'soledad' ) => 'yes' ),
			),
			array(
				'type'             => 'checkbox',
				'heading'          => esc_html__( 'Hide video order number', 'soledad' ),
				'param_name'       => 'hide_order_number',
				'edit_field_class' => 'vc_col-sm-6',
				'value'            => array( __( 'Yes', 'soledad' ) => 'yes' ),
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Title Length for Video', 'soledad' ),
				'param_name' => 'video_title_length',
				'value'      => '10',
				'std'        => '10',
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Unique ID for Save & Clear Caching', 'soledad' ),
				'param_name' => 'block_id',
				'value'      => rand( 1000, 100000 ),
				'std'        => rand( 1000, 100000 ),
			),
		),
		array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Title Style', 'soledad' ),
				'param_name' => 'heading_title_style',
				'std'        => '',
				'value'      => array(
					esc_html__( 'Default ( follow Customize )', 'soledad' ) => '',
					esc_html__( 'Style 1', 'soledad' )                      => 'style-1',
					esc_html__( 'Style 2', 'soledad' )                      => 'style-2',
					esc_html__( 'Style 3', 'soledad' )                      => 'style-3',
					esc_html__( 'Style 4', 'soledad' )                      => 'style-4',
					esc_html__( 'Style 5', 'soledad' )                      => 'style-5',
					esc_html__( 'Style 6', 'soledad' )                      => 'style-6',
					esc_html__( 'Style 7', 'soledad' )                      => 'style-7',
					esc_html__( 'Style 8', 'soledad' )                      => 'style-9',
					esc_html__( 'Style 9', 'soledad' )                      => 'style-8',
					esc_html__( 'Style 9', 'soledad' )                      => 'style-8',
					esc_html__( 'Style 10', 'soledad' )                     => 'style-10',
					esc_html__( 'Style 11', 'soledad' )                     => 'style-11',
					esc_html__( 'Style 12', 'soledad' )                     => 'style-12',
					esc_html__( 'Style 13', 'soledad' )                     => 'style-13',
					esc_html__( 'Style 14', 'soledad' )                     => 'style-14',
					esc_html__( 'Style 15', 'soledad' )                     => 'style-15',
					esc_html__( 'Style 16', 'soledad' )                     => 'style-16',
					esc_html__( 'Style 17', 'soledad' )                     => 'style-2 style-17',
					esc_html__( 'Style 18', 'soledad' )                     => 'style-18',
					esc_html__( 'Style 19', 'soledad' )                     => 'style-18 style-19',
					esc_html__( 'Style 20', 'soledad' )                     => 'style-18 style-20',
					esc_html__( 'Style Video List', 'soledad' )             => 'video_list',
				),
				'group'      => 'Heading',
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Heading Title', 'soledad' ),
				'param_name'  => 'heading',
				'value'       => '',
				'std'         => esc_html__( 'Block Title', 'soledad' ),
				'admin_label' => true,
				'description' => esc_html__( 'A title for this block, if you leave it blank the block will not have a title', 'soledad' ),
				'group'       => 'Heading',
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Title Url', 'soledad' ),
				'param_name'  => 'heading_title_link',
				'std'         => '',
				'description' => esc_html__( 'A custom url when the block title is clicked', 'soledad' ),
				'group'       => 'Heading',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Align', 'soledad' ),
				'param_name' => 'heading_title_align',
				'std'        => '',
				'value'      => array(
					esc_html__( 'Default ( follow Customize )', 'soledad' ) => '',
					esc_html__( 'Left', 'soledad' )                         => 'pcalign-left',
					esc_html__( 'Center', 'soledad' )                       => 'pcalign-center',
					esc_html__( 'Right', 'soledad' )                        => 'pcalign-right',
				),
				'group'      => 'Heading',
			),
			array(
				'type'        => 'dropdown',
				'heading'     => 'Align Icon on Style 15',
				'value'       => array(
					'Default( follow Customize )' => '',
					'Right'                       => 'pciconp-right',
					'Left'                        => 'pciconp-left',
				),
				'param_name'  => 'heading_icon_pos',
				'description' => '',
				'dependency'  => array( 'element' => 'heading_title_style', 'value' => array( 'style-15' ) ),
				'group'       => 'Heading',
			),
			array(
				'type'        => 'dropdown',
				'heading'     => 'Custom Icon on Style 15',
				'value'       => array(
					'Default( follow Customize )' => '',
					'Arrow Right'                 => 'pcicon-right',
					'Arrow Left'                  => 'pcicon-left',
					'Arrow Down'                  => 'pcicon-down',
					'Arrow Up'                    => 'pcicon-up',
					'Star'                        => 'pcicon-star',
					'Bars'                        => 'pcicon-bars',
					'File'                        => 'pcicon-file',
					'Fire'                        => 'pcicon-fire',
					'Book'                        => 'pcicon-book',
				),
				'param_name'  => 'heading_icon',
				'description' => '',
				'dependency'  => array( 'element' => 'heading_title_style', 'value' => array( 'style-15' ) ),
				'group'       => 'Heading',
			),
		),
		Penci_Vc_Params_Helper::params_heading_typo_color(),
		array(
			array(
				'type'             => 'textfield',
				'param_name'       => 'post_title_css',
				'heading'          => esc_html__( 'Extra colors', 'soledad' ),
				'value'            => '',
				'group'            => $group_color,
				'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Background list videos', 'soledad' ),
				'param_name'       => 'list_video_bgcolor',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Video title color', 'soledad' ),
				'param_name'       => 'video_title_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Video title hover color', 'soledad' ),
				'param_name'       => 'video_title_hover_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Video duration color', 'soledad' ),
				'param_name'       => 'duration_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Video order number color', 'soledad' ),
				'param_name'       => 'order_number_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Video order number background color', 'soledad' ),
				'param_name'       => 'order_number_bgcolor',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Item video border color', 'soledad' ),
				'param_name'       => 'item_video_border_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Item video hover background and border color', 'soledad' ),
				'param_name'       => 'item_video_bg_hcolor',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Scroll bar background color', 'soledad' ),
				'param_name'       => 'scrollbar_bg_hcolor',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
		),
		Penci_Vc_Params_Helper::extra_params()
	)
) );
