<?php
$group_color = 'Typo & Color';
$group = 'Slider settings';
vc_map( array(
	'base'          => 'penci_custom_sliders',
	'icon'          => get_template_directory_uri() . '/images/vc-icon.png',
	'category'      => 'Soledad',
	'html_template' => get_template_directory() . '/inc/js_composer/shortcodes/custom_sliders/frontend.php',
	'weight'        => 700,
	'name'          => __( 'Penci Custom Slider', 'soledad' ),
	'description'   => __( 'Custom Slider Block', 'soledad' ),
	'controls'      => 'full',
	'params'        => array_merge(
		Penci_Vc_Params_Helper::params_container_width(),
		array(
			array(
				'type'       => 'param_group',
				'heading'    => 'Slider',
				'param_name' => 'penci_slides',
				'value'      => urlencode( json_encode( array(
					array(
						'heading'             => __( 'Slide 1 Heading', 'soledad' ),
						'description'         => __( 'Click edit button to change this text. Lorem ipsum dolor sit amet consectetur adipiscing elit dolor', 'soledad' ),
						'button_text'         => __( 'Click Here', 'soledad' ),
						'button_text2'        => __( 'Click Here', 'soledad' ),
						'background_color'    => '#833ca3',
						'content_color'       => '#fff',
						'text_align'          => 'center',
						'horizontal_position' => 'middle',
						'vertical_position'   => 'center',
					),
					array(
						'heading'             => __( 'Slide 2 Heading', 'soledad' ),
						'description'         => __( 'Click edit button to change this text. Lorem ipsum dolor sit amet consectetur adipiscing elit dolor', 'soledad' ),
						'button_text'         => __( 'Click Here', 'soledad' ),
						'button_text2'        => __( 'Click Here', 'soledad' ),
						'background_color'    => '#4054b2',
						'content_color'       => '#fff',
						'text_align'          => 'center',
						'horizontal_position' => 'middle',
						'vertical_position'   => 'center',
					),
					array(
						'heading'             => __( 'Slide 3 Heading', 'soledad' ),
						'description'         => __( 'Click edit button to change this text. Lorem ipsum dolor sit amet consectetur adipiscing elit dolor', 'soledad' ),
						'button_text'         => __( 'Click Here', 'soledad' ),
						'button_text2'        => __( 'Click Here', 'soledad' ),
						'background_color'    => '#1abc9c',
						'content_color'       => '#fff',
						'text_align'          => 'center',
						'horizontal_position' => 'middle',
						'vertical_position'   => 'center',
					)
				) ) ),
				'params'     => array(
					array(
						'type'        => 'textfield',
						'heading'     => __( 'Title', 'soledad' ),
						'param_name'  => 'heading',
						'admin_label' => true
					),
					array(
						'type'       => 'textfield',
						'heading'    => __( 'Description', 'soledad' ),
						'param_name' => 'description',
					),
					array(
						'type'       => 'textfield',
						'heading'    => __( 'Button Text 1', 'soledad' ),
						'param_name' => 'button_text',
					),
					array(
						'type'       => 'textfield',
						'heading'    => __( 'Button Link 1', 'soledad' ),
						'param_name' => 'button_link',
					),
					array(
						'type'       => 'textfield',
						'heading'    => __( 'Button Text 2', 'soledad' ),
						'param_name' => 'button_text2',
					),
					array(
						'type'       => 'textfield',
						'heading'    => __( 'Button Link 2', 'soledad' ),
						'param_name' => 'button_link2',
					),
					array(
						'type'       => 'textfield',
						'heading'    => __( 'Image Url', 'soledad' ),
						'param_name' => 'url_feat_img',
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Content Color', 'soledad' ),
						'param_name' => 'content_color',
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Background Color', 'soledad' ),
						'param_name' => 'background_color',
					),
					array(
						'type'       => 'attach_image',
						'heading'    => esc_html__( 'Background Image', 'soledad' ),
						'param_name' => 'background_image',
					),
					array(
						'type'       => 'dropdown',
						'heading'    => __( 'Horizontal Position', 'soledad' ),
						'param_name' => 'horizontal_position',
						'std'        => 'center',
						'value'      => array(
							__( 'Center', 'soledad' ) => 'center',
							__( 'Left', 'soledad' )   => 'left',
							__( 'Right', 'soledad' )  => 'right',
						),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => __( 'Vertical Position', 'soledad' ),
						'param_name' => 'vertical_position',
						'std'        => 'center',
						'value'      => array(
							__( 'Middle', 'soledad' ) => 'middle',
							__( 'Top', 'soledad' )    => 'top',
							__( 'Bottom', 'soledad' ) => 'bottom',
						),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => __( 'Text Align', 'soledad' ),
						'param_name' => 'text_align',
						'std'        => 'center',
						'value'      => array(
							__( 'Center', 'soledad' ) => 'center',
							__( 'Left', 'soledad' )   => 'left',
							__( 'Right', 'soledad' )  => 'right',
						),
					),

					array(
						'type'       => 'dropdown',
						'heading'    => __( 'Enable Overlay Background Color', 'soledad' ),
						'param_name' => 'bg_item_overlay',
						'std'        => '',
						'value' => array(
							__( 'Default', 'soledad' ) => '',
							__( 'Yes', 'soledad' )     => 'yes',
							__( 'No', 'soledad' )      => 'no',
						),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Overlay Background Opacity', 'soledad' ),
						'param_name' => 'bgoverlay_opacity',
						'value'      => array(
							'Default'    => '',
							'0'    => '0',
							'0.05' => '0.05',
							'0.1'  => '0.1',
							'0.15' => '0.15',
							'0.2'  => '0.2',
							'0.25' => '0.25',
							'0.3'  => '0.3',
							'0.35' => '0.35',
							'0.4'  => '0.4',
							'0.45' => '0.45',
							'0.5'  => '0.5',
							'0.55' => '0.55',
							'0.6'  => '0.6',
							'0.65' => '0.65',
							'0.7'  => '0.7',
							'0.75' => '0.75',
							'0.8'  => '0.8',
							'0.85' => '0.85',
							'0.9'  => '0.9',
							'0.95' => '0.95',
							'1'    => '1',
						)
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Overlay Background Color', 'soledad' ),
						'param_name' => 'bgoverlay_color',
					),
					array(
						'type'             => 'penci_number',
						'param_name'       => 'bgoverlay_padding',
						'heading'          => __( 'Overlay Background Padding', 'soledad' ),
						'value'            => '',
						'std'              => '',
						'suffix'           => 'px',
						'min'              => 1,
					),
				)
			),

			array(
				'type'             => 'penci_only_number',
				'heading'          => esc_html__( 'Slides Height', 'soledad' ),
				'param_name'       => 'slides_height',
				'value'            => '',
				'std'              => '',
				'min'              => 0,
				'max'              => 1000,
				'suffix'           => 'px',
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'penci_only_number',
				'heading'          => esc_html__( 'Ratio Height/Width .Unit is %. E.g: 50', 'soledad' ),
				'param_name'       => 'slides_img_ratio',
				'value'            => '',
				'std'              => '',
				'min'              => 0,
				'max'              => 100,
				'suffix'           => '%',
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'penci_number',
				'param_name'       => 'content_max_width',
				'heading'          => __( 'Content Width', 'soledad' ),
				'value'            => '',
				'std'              => '',
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'penci_number',
				'param_name'       => 'slides_paddingl',
				'heading'          => __( 'Content Padding Left', 'soledad' ),
				'value'            => '',
				'std'              => '',
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'penci_number',
				'param_name'       => 'slides_paddingr',
				'heading'          => __( 'Content Padding Right', 'soledad' ),
				'value'            => '',
				'std'              => '',
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'penci_number',
				'param_name'       => 'slides_paddingt',
				'heading'          => __( 'Content Padding Top', 'soledad' ),
				'value'            => '',
				'std'              => '',
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'penci_number',
				'param_name'       => 'slides_paddingb',
				'heading'          => __( 'Content Padding Bottom', 'soledad' ),
				'value'            => '',
				'std'              => '',
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => 'vc_col-sm-6',
			),

			// Slider
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Autoplay', 'soledad' ),
				'param_name' => 'autoplay',
				'value'      => array( esc_html__( 'Yes', 'soledad' ) => 'yes' ),
				'std'        => 'yes',
				'group'      => $group,
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Slider Loop', 'soledad' ),
				'param_name' => 'loop',
				'value'      => array( esc_html__( 'Yes', 'soledad' ) => 'yes' ),
				'std'        => 'yes',
				'group'      => $group,
			),
			array(
				'type'       => 'textfield',
				'param_name' => 'auto_time',
				'heading'    => esc_html__( 'Slider Auto Time (at x seconds)', 'soledad' ),
				'value'      => 4000,
				'group'      => $group,
			),
			array(
				'type'       => 'textfield',
				'param_name' => 'speed',
				'heading'    => esc_html__( 'Slider Speed (at x seconds)', 'soledad' ),
				'value'      => 800,
				'group'      => $group,
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show next/prev buttons', 'soledad' ),
				'param_name' => 'shownav',
				'value'      => array( esc_html__( 'Yes', 'soledad' ) => 'yes' ),
				'std'        => 'yes',
				'group'      => $group,
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show dots navigation', 'soledad' ),
				'param_name' => 'showdots',
				'value'      => array( esc_html__( 'Yes', 'soledad' ) => 'yes' ),
				'group'      => $group,
			),
			array(
				'type'       => 'dropdown',
				'heading'    => __( 'Content Animation', 'soledad' ),
				'param_name' => 'content_animation',
				'std'        => 'fadeInUp',
				'group'      => $group,
				'value'      => array(
					__( 'None', 'soledad' )          => '',
					__( 'Fade In Up', 'soledad' )    => 'fadeInUp',
					__( 'Fade In Down', 'soledad' )  => 'fadeInDown',
					__( 'Fade In Left', 'soledad' )  => 'fadeInLeft',
					__( 'Fade In Right', 'soledad' ) => 'fadeInRight'
				),
			),
			
			// Custom css
			array(
				'type'             => 'textfield',
				'param_name'       => 'heading_style1_settings',
				'heading'          => esc_html__( 'Text', 'soledad' ),
				'value'            => '',
				'group'            => $group_color,
				'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
			),
			array(
				'type'       => 'penci_number',
				'param_name' => 'heading_spacing',
				'heading'    => __( 'Margin bottom', 'soledad' ),
				'value'      => '',
				'std'        => '',
				'suffix'     => 'px',
				'min'        => 1,
				'group'      => $group_color,
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Text Color', 'soledad' ),
				'param_name'       => 'heading_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'penci_number',
				'param_name'       => 'heading_size',
				'heading'          => __( 'Font Size', 'soledad' ),
				'value'            => '',
				'std'              => '',
				'suffix'           => 'px',
				'min'              => 1,
				'group'            => $group_color,
			),
			array(
				'type'       => 'google_fonts',
				'group'      => $group_color,
				'param_name' => 'heading_typography',
				'value'      => '',
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Overlay Background Color', 'soledad' ),
				'param_name' => 'heading_overlay',
				'value'      => array( esc_html__( 'Yes', 'soledad' ) => 'yes' ),
				'group'      => $group_color,
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Overlay Background Opacity', 'penci-framework' ),
				'param_name' => 'heading_bgoverlay_opacity',
				'value'      => array(
					'0'    => '0',
					'0.05' => '0.05',
					'0.1'  => '0.1',
					'0.15' => '0.15',
					'0.2'  => '0.2',
					'0.25' => '0.25',
					'0.3'  => '0.3',
					'0.35' => '0.35',
					'0.4'  => '0.4',
					'0.45' => '0.45',
					'0.5'  => '0.5',
					'0.55' => '0.55',
					'0.6'  => '0.6',
					'0.65' => '0.65',
					'0.7'  => '0.7',
					'0.75' => '0.75',
					'0.8'  => '0.8',
					'0.85' => '0.85',
					'0.9'  => '0.9',
					'0.95' => '0.95',
					'1'    => '1',
				),
				'std'        => '0.4',
				'group'      => $group_color
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Overlay Background Color', 'soledad' ),
				'param_name'       => 'heading_bgoverlay_color',
				'group'            => $group_color,
			),
			array(
				'type'             => 'penci_number',
				'param_name'       => 'heading_bgoverlay_padding',
				'heading'          => __( 'Overlay Background Padding', 'soledad' ),
				'value'            => '',
				'std'              => '',
				'suffix'           => 'px',
				'min'              => 1,
				'group'            => $group_color,
			),
			array(
				'type'             => 'textfield',
				'param_name'       => 'section_style_description',
				'heading'          => esc_html__( 'Description', 'soledad' ),
				'value'            => '',
				'group'            => $group_color,
				'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
			),
			array(
				'type'       => 'penci_number',
				'param_name' => 'desc_spacing',
				'heading'    => __( 'Margin bottom', 'soledad' ),
				'value'      => '',
				'std'        => '',
				'suffix'     => 'px',
				'min'        => 1,
				'group'      => $group_color,
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Color', 'soledad' ),
				'param_name'       => 'desc_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'penci_number',
				'param_name'       => 'desc_size',
				'heading'          => __( 'Font Size', 'soledad' ),
				'value'            => '',
				'std'              => '',
				'suffix'           => 'px',
				'min'              => 1,
				'group'            => $group_color,
			),
			array(
				'type'       => 'google_fonts',
				'group'      => $group_color,
				'param_name' => 'desc_typo',
				'value'      => '',
			),

			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Overlay Background Color', 'soledad' ),
				'param_name' => 'description_overlay',
				'value'      => array( esc_html__( 'Yes', 'soledad' ) => 'yes' ),
				'group'      => $group_color,
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Overlay Background Opacity', 'penci-framework' ),
				'param_name' => 'desc_bgoverlay_opacity',
				'value'      => array(
					'0'    => '0',
					'0.05' => '0.05',
					'0.1'  => '0.1',
					'0.15' => '0.15',
					'0.2'  => '0.2',
					'0.25' => '0.25',
					'0.3'  => '0.3',
					'0.35' => '0.35',
					'0.4'  => '0.4',
					'0.45' => '0.45',
					'0.5'  => '0.5',
					'0.55' => '0.55',
					'0.6'  => '0.6',
					'0.65' => '0.65',
					'0.7'  => '0.7',
					'0.75' => '0.75',
					'0.8'  => '0.8',
					'0.85' => '0.85',
					'0.9'  => '0.9',
					'0.95' => '0.95',
					'1'    => '1',
				),
				'std'        => '0.4',
				'group'      => $group_color
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Overlay Background Color', 'soledad' ),
				'param_name'       => 'desc_bgoverlay_color',
				'group'            => $group_color,
			),
			array(
				'type'             => 'penci_number',
				'param_name'       => 'desc_bgoverlay_padding',
				'heading'          => __( 'Overlay Background Padding', 'soledad' ),
				'value'            => '',
				'std'              => '',
				'suffix'           => 'px',
				'min'              => 1,
				'group'            => $group_color,
			),

			// Button 1
			array(
				'type'             => 'textfield',
				'param_name'       => 'section_style_btn1',
				'heading'          => esc_html__( 'Button 1', 'soledad' ),
				'value'            => '',
				'group'            => $group_color,
				'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
			),
			array(
				'type'             => 'penci_number',
				'param_name'       => 'button1_width',
				'heading'          => __( 'Button Width', 'soledad' ),
				'value'            => '',
				'std'              => '',
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => ' vc_col-sm-6',
				'group'            => $group_color,
			),
			array(
				'type'             => 'penci_number',
				'param_name'       => 'button1_height',
				'heading'          => __( 'Button Height', 'soledad' ),
				'value'            => '',
				'std'              => '',
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => ' vc_col-sm-6',
				'group'            => $group_color,
			),
			array(
				'type'             => 'penci_number',
				'param_name'       => 'button1_border_width',
				'heading'          => __( 'Border Width', 'soledad' ),
				'value'            => '',
				'std'              => '',
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => ' vc_col-sm-6',
				'group'            => $group_color,
			),
			array(
				'type'             => 'penci_number',
				'param_name'       => 'button1_border_radius',
				'heading'          => __( 'Border Radius', 'soledad' ),
				'value'            => '',
				'std'              => '',
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => ' vc_col-sm-6',
				'group'            => $group_color,
			),
			array(
				'type'             => 'penci_number',
				'param_name'       => 'button1_size',
				'heading'          => __( 'Font Size', 'soledad' ),
				'value'            => '',
				'std'              => '',
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => 'vc_col-sm-6',
				'group'            => $group_color,
			),
			array(
				'type'       => 'google_fonts',
				'group'      => $group_color,
				'param_name' => 'button1_typo',
				'value'      => '',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Button Text Color', 'soledad' ),
				'param_name'       => 'button1_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Button Background Color', 'soledad' ),
				'param_name'       => 'button1_bgcolor',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Button Border Color', 'soledad' ),
				'param_name'       => 'button1_border_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Button Text Hover Color', 'soledad' ),
				'param_name'       => 'button1_hcolor',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Button Background Hover Color', 'soledad' ),
				'param_name'       => 'button1_hbgcolor',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Button Border Hover Color', 'soledad' ),
				'param_name'       => 'button1_hbordercolor',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),


			// Button 2
			array(
				'type'             => 'textfield',
				'param_name'       => 'section_style_btn2',
				'heading'          => esc_html__( 'Button 2', 'soledad' ),
				'value'            => '',
				'group'            => $group_color,
				'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
			),
			array(
				'type'             => 'penci_number',
				'param_name'       => 'button2_width',
				'heading'          => __( 'Button Width', 'soledad' ),
				'value'            => '',
				'std'              => '',
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => ' vc_col-sm-6',
				'group'            => $group_color,
			),
			array(
				'type'             => 'penci_number',
				'param_name'       => 'button2_height',
				'heading'          => __( 'Button Height', 'soledad' ),
				'value'            => '',
				'std'              => '',
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => ' vc_col-sm-6',
				'group'            => $group_color,
			),
			array(
				'type'             => 'penci_number',
				'param_name'       => 'button2_border_width',
				'heading'          => __( 'Border Width', 'soledad' ),
				'value'            => '',
				'std'              => '',
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => ' vc_col-sm-6',
				'group'            => $group_color,
			),
			array(
				'type'             => 'penci_number',
				'param_name'       => 'button2_border_radius',
				'heading'          => __( 'Border Radius', 'soledad' ),
				'value'            => '',
				'std'              => '',
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => ' vc_col-sm-6',
				'group'            => $group_color,
			),
			array(
				'type'             => 'penci_number',
				'param_name'       => 'button2_size',
				'heading'          => __( 'Font size', 'soledad' ),
				'value'            => '',
				'std'              => '',
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => 'vc_col-sm-6',
				'group'            => $group_color,
			),
			array(
				'type'       => 'google_fonts',
				'group'      => $group_color,
				'param_name' => 'button2_typo',
				'value'      => '',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Button Text Color', 'soledad' ),
				'param_name'       => 'button2_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Button Background Color', 'soledad' ),
				'param_name'       => 'button2_bgcolor',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Button Border Color', 'soledad' ),
				'param_name'       => 'button2_border_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Button Text Hover Color', 'soledad' ),
				'param_name'       => 'button2_hcolor',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Button Background Hover Color', 'soledad' ),
				'param_name'       => 'button2_hbgcolor',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Button Border Hover Color', 'soledad' ),
				'param_name'       => 'button2_hbordercolor',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
		),
		Penci_Vc_Params_Helper::extra_params()
	)
) );