<?php

namespace SoledadFW\Customizer\Control;
class Code extends Control_Abstract {

	/**
	 * Customize control type.
	 *
	 * @since 4.9.0
	 * @var string
	 */
	public $type = 'soledad-fw-code';

	/**
	 * Type of code that is being edited.
	 *
	 * @since 4.9.0
	 * @var string
	 */
	public $code_type = '';

	/**
	 * Code editor settings.
	 *
	 * @see wp_enqueue_code_editor()
	 * @since 4.9.0
	 * @var array|false
	 */
	public $editor_settings = array();

	/**
	 * Enqueue control related scripts/styles.
	 *
	 * @since 4.9.0
	 */
	public function enqueue() {
		$this->editor_settings = wp_enqueue_code_editor(
			array_merge(
				array(
					'type'       => $this->code_type,
					'codemirror' => array(
						'indentUnit' => 2,
						'tabSize'    => 2,
					),
				),
				$this->editor_settings
			)
		);
	}

	/**
	 * Refresh the parameters passed to the JavaScript via JSON.
	 *
	 * @return array Array of parameters passed to the JavaScript.
	 * @see WP_Customize_Control::json()
	 *
	 * @since 4.9.0
	 *
	 */
	public function json() {
		$json                    = parent::json();
		$json['editor_settings'] = $this->editor_settings;
		$json['input_attrs']     = $this->input_attrs;

		return $json;
	}

	/**
	 * Render a JS template for control display.
	 *
	 * @since 4.9.0
	 */
	public function content_template() {
		?>
        <# var elementIdPrefix = 'el' + String( Math.random() ); #>
        <# if ( data.label ) { #>
        <label for="{{ elementIdPrefix }}_editor" class="customize-control-title">
            {{ data.label }}
        </label>
        <# } #>
        <# if ( data.description ) { #>
        <span class="description customize-control-description">{{{ data.description }}}</span>
        <# } #>
        <div class="customize-control-notifications-container"></div>
        <textarea id="{{ elementIdPrefix }}_editor"
        <# _.each( _.extend( { 'class': 'code' }, data.input_attrs ), function( value, key ) { #>
        {{{ key }}}="{{ value }}"
        <# }); #>
        ></textarea>
		<?php
	}
}
