<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Brand;
use Auth;
use App\Year;
use App\Carmodel;
use App\City;
use App\Nation;
use App\Varient;
use App\Sliderimage;
use App\Insurancepartner;
use App\Peoplesay;
use App\Recentnews;
use App\User;
use App\Taxinvoice;
use App\Receipt;
use App\Policyschedule;
use App\Policycertificate;
use Response;
use App\Passingpapers;
use App\Licence;
use App\Registrationcard;
use App\Logo;
use App\Policy;
use App\Fees;
use App\Query;
use DB;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function welcome()
    {
        return view('welcome');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {

        $users = DB::table('queries')->join('users', 'queries.id', '=', 'users.query_id')->where('users.role_id', '=', 1)->select('queries.*','users.*')->get();
        
        return view('home', ['users'=>$users]);
    }

    public function login(Request $request)

    {
        $data =  $request->input();

        $email = $data['email'];

        $password = $data['password'];


        $checkLogin = User::where(['email'=>$email])->get();

        if (count($checkLogin) > 0 and  Hash::check($password, $checkLogin[0]->password))

        {
            $data =  $request->input();

            $email = $data['email'];


         if( $checkLogin[0]->role_id == '0'){

            return redirect('/home');

         }

		else{ 

		if($checkLogin[0]->role_id == '1'){

			return redirect('/profile');

				

			}

		 }   

        }



        else

        {

           return back()->with('message', 'Credentials doesnt match our records.');

        }

   

          

    }

    

    public function brands()
    {

        $brands = Brand::all();
        return view('brands', ["brands" => $brands]);
    }

    public function models()
    {

        $models = Carmodel::all();
        return view('models', ["models" => $models]);
    }

    public function varients()
    {
        
        $varients = Varient::all();
        return view('varients', ["varients" => $varients]);
    }

    public function years()
    {

        $years = Year::all();
        return view('years', ["years" => $years]);
    }

    public function cities()
    {

        $cities = City::all();
        return view('cities', ["cities" => $cities]);
    }

    public function nations()
    {

        $nations = Nation::all();
        return view('nations', ["nations" => $nations]);
    }

    public function sliderimages()
    {

        $sliderimages = Sliderimage::all();
        return view('sliderimages', ["sliderimages" => $sliderimages]);
    }

    public function insurancepartners()
    {

        $insurancepartners = Insurancepartner::all();
        return view('insurancepartners', ["insurancepartners" => $insurancepartners]);
    }

    public function peoplesays()
    {

        $peoplesays = Peoplesay::all();
        return view('peoplesays', ["peoplesays" => $peoplesays]);
    }

    public function recentnews()
    {

        $recentnews = Recentnews::all();
        return view('recentnews', ["recentnews" => $recentnews]);
    }

    public function editviewbrands(Request $request, $id)
    {

        $brands = Brand::where('id', $id)->get();
        $years = Year::all();
        return view('edit_view_brands', ["brands" => $brands, "years" => $years]);
    }

    public function editviewmodels(Request $request, $id)
    {

        $brands = Brand::all();
        $years = Year::all();
        $models = Carmodel::where('id', $id)->get();
        return view('edit_view_models', ["brands" => $brands, "years" => $years, "models"=>$models]);
    }

    public function editviewvarients(Request $request, $id)
    {

        $brands = Brand::all();
        $years = Year::all();
        $models = Carmodel::all();
        $varients = Varient::where('id', $id)->get();
        return view('edit_view_varients', ["brands" => $brands, "years" => $years, "models"=>$models, "varients"=>$varients]);
    }

    public function editviewsliderimages(Request $request, $id)
    {

        $sliderimages = Sliderimage::where('id', $id)->get();
        return view('edit_view_sliderimages', ["sliderimages" => $sliderimages]);
    }

    public function editviewrecentnews(Request $request, $id)
    {

        $recentnews = Recentnews::where('id', $id)->get();
        return view('edit_view_recentnews', ["recentnews" => $recentnews]);
    }

    public function editviewpeoplesays(Request $request, $id)
    {

        $peoplesays = Peoplesay::where('id', $id)->get();
        return view('edit_view_peoplesays', ["peoplesays" => $peoplesays]);
    }

    public function addviewrecentnews()
    {

        return view('add_view_recentnews');
    }

    public function addviewpeoplesays()
    {

        return view('add_view_peoplesays');
    }

    public function addviewinsurancepartners()
    {

        return view('add_view_insurancepartners');
    }



    public function addviewbrands()
    {

        $years = Year::all();
        return view('add_view_brands', ["years" => $years]);
    }

    public function policies()
    {

        $policies = Policy::all();
        return view('policies', ["policies" => $policies]);
    }


    public function addviewpolicies()
    {

        return view('add_policies');
    }

    public function editviewpolicies($id)
    {

        $policies = Policy::where('id', $id)->get();
       
        return view('edit_view_policies', ["policies"=>$policies]);
    }

    public function fees()
    {

        $fees = Fees::all();
        return view('fees', ["fees"=>$fees]);
    }

    public function addviewfees()
    {

        return view('add_view_fees');
    }

    public function makepayment()
    {

        $fees = Fees::all();
        $policies = Policy::all();
        return view('make_payment', ["fees"=>$fees, "policies"=>$policies]);
    }



    public function sitelogo()
    {

        $websites = Logo::all();
        return view('website_logo', ["websites" => $websites]);
    }


    public function add_view_sitelogo()
    {

        return view('add_view_websitelogo');
    }


    public function addviewmodels()
    {

        $brands = Brand::all();
        $years = Year::all();
        return view('add_view_models', ["brands" => $brands, "years" => $years]);
    }

    public function addviewvarients()
    {

        $brands = Brand::all();
        $models = Carmodel::all();
        $years = Year::all();
        return view('add_view_varients', ["brands" => $brands, "models" => $models, "years" => $years]);
    }

    public function addviewsliderimages()
    {

        return view('add_view_sliderimages');
    }

    public function addviewyears()
    {
        return view('add_view_years');
    }

    public function addviewcities()
    {
        return view('add_view_cities');
    }

    public function addviewnations()
    {
        return view('add_view_nations');
    }

    public function sentrequests()
    {
        
        $id = Auth::id();
        $users = DB::table('queries')->join('users', 'queries.id', '=', 'users.query_id')->where('users.id','=', $id )->select('queries.*','users.*')->get();
        //echo"<pre>"; print_R($users); die;
        // $users = DB::table('users')->join('queries', 'users.query_id', '=', 'queries.id')->where('users.role_id', '=', 1)->select('users.*')->get();
        
        return view('sent_requests', ['users'=>$users]);
    }

    public function uploaddocuments()
    {
        return view('upload_documents');
    }

    public function profile()
    {
        
        $id = Auth::id();
        $users = User::where('id', $id)->get();
        return view('profile', ["users" => $users]);
    }
    
     public function editprofile($id)
    {
       
        $profiles = User::where('id', $id)->get();
        return view('edit_profile', ["profiles" => $profiles]);
    }
    
   public function block(Request $request, $id){

            $block = new User;
                                $block->block = 0;
                    
                                User::where('id', $id)->update(['block'=>0]);
            
            return back()->with('message', 'User Blocked  Succesfully.');
        }
        
         public function unblock(Request $request, $id){

            $unblock = new User;
                                $unblock->block = 1;
                    
                                User::where('id', $id)->update(['block'=>1]);
                                
                                return back()->with('message', 'User Unblocked  Succesfully.');
        }
    

  public function downloaddocuments()
    {

        $id = Auth::id();
        
        $policycertificates = Policycertificate::where('user_id',$id)->get();
        $policyschedules = Policyschedule::where('user_id',$id)->get();
        $receipts = Receipt::where('user_id',$id)->get();
        $invoices = Taxinvoice::where('user_id',$id)->get();
        
        if($policycertificates->count() > 0 && $policyschedules->count() > 0 && $receipts->count() > 0 && $invoices->count() > 0){
            
            $images = json_decode($policycertificates[0]->policy_certificate,true);
            
            $scheduleimages = json_decode($policyschedules[0]->policy_schedule,true);
            
            $receiptimages = json_decode($receipts[0]->receipt,true);
            
            $invoiceimages = json_decode($invoices[0]->tax_invoice,true);
         
        return view('download_documents', ['policycertificates'=>$policycertificates, 'images'=>$images, 'policyschedules'=>$policyschedules, 'scheduleimages'=>$scheduleimages, 'receipts'=>$receipts,  'receiptimages'=>$receiptimages, 'invoices'=>$invoices, 'invoiceimages'=>$invoiceimages]);
        
        } 
        
        else{
            
        //     $images = Policycertificate::where('user_id',$id)->get();
        // $scheduleimages = Policyschedule::where('user_id',$id)->get();
        // $receiptimages = Receipt::where('user_id',$id)->get();
        // $invoiceimages = Taxinvoice::where('user_id',$id)->get();
        
            return view('download_documents_else');
            
        }
    }

    public function adminupload($id)
    {

        // $users = User::where('id', $id);
        return view('admin_upload_documents', ['id'=>$id]);
    }

    public function certificatedownload($id)
    {

         $certificate = Policycertificate::where('id', $id)->get();
         $images = json_decode($certificate[0]->policy_certificate,true);
         
         //$document = $certificate[0]->policy_certificate;
         foreach($images as $image)
         
         
         $file = public_path('/images')."/$image";

         $header = array(
             'content-type: application/pdf/jpg/jpeg',
         );

        return Response::download($file, $image, $header);
    }

    public function scheduledownload($id)
    {

         $schedule = Policyschedule::where('id', $id)->get();
         
         $images = json_decode($schedule[0]->policy_schedule,true);
         
         //$document = $certificate[0]->policy_certificate;
         foreach($images as $image)
         
         //echo"<pre>"; print_R($document); die;
         $file = public_path('/images')."/$image";

         $header = array(
             'content-type: application/pdf/jpg/jpeg',
         );

        return Response::download($file, $image, $header);
    }

    public function receiptdownload($id)
    {

         $receipt = Receipt::where('id', $id)->get();
        // echo"<pre>"; print_R(json_decode($receipt[0]->receipt,true)); die;
         $images = json_decode($receipt[0]->receipt,true);
         //$document = $certificate[0]->policy_certificate;
         foreach($images as $image)
         
         //echo"<pre>"; print_R($document); die;
         $file = public_path('/images')."/$image";

         $header = array(
             'content-type: application/pdf/jpg/jpeg',
         );

        return Response::download($file, $image, $header);
    }

    public function invoicedownload($id)
    {

         $invoice = Taxinvoice::where('id', $id)->get();
         $images = json_decode($invoice[0]->tax_invoice,true);
         //$document = $certificate[0]->policy_certificate;
         foreach($images as $image)
         
         //echo"<pre>"; print_R($document); die;
         $file = public_path('/images')."/$image";

         $header = array(
             'content-type: application/pdf/jpg/jpeg',
         );

        return Response::download($file, $image, $header);
    }


 public function licence_download($id)
    {

         $licence = Licence::where('id', $id)->get();
         $images = json_decode($licence[0]->licence,true);
         //$document = $certificate[0]->policy_certificate;
         foreach($images as $image)
         
         
         $file = public_path('/images')."/$image";

         $header = array(
             'content-type: application/pdf/jpg/jpeg',
         );

        return Response::download($file, $image, $header);
    }
    
     public function card_download($id)
    {

         $card = Registrationcard::where('id', $id)->get();
         $images = json_decode($card[0]->registration_card,true);
         //$document = $certificate[0]->policy_certificate;
         foreach($images as $image)
         
         
         $file = public_path('/images')."/$image";

         $header = array(
             'content-type: application/pdf/jpg/jpeg',
         );

        return Response::download($file, $image, $header);
    }
    
     public function passing_download($id)
    {

   

         $passing = Passingpapers::where('id', $id)->get();
         $images = json_decode($passing[0]->passing_papers,true);
         if ($images)
{
         //$document = $certificate[0]->policy_certificate;
         foreach($images as $image)
         
         
         $file = public_path('/images')."/$image";

         $header = array(
             'content-type: application/pdf/jpg/jpeg',
         );

        return Response::download($file, $image, $header);
}
    }

    public function checkdocuments($id)
    {

        $images = Passingpapers::where('user_id', $id)->get();
        $licencesimages = Licence::where('user_id', $id)->get();
        $cardimages = Registrationcard::where('user_id', $id)->get();
        
       
  
        if($images->count() > 0 && $licencesimages->count() > 0 && $cardimages->count() > 0){

        $passingpapers = json_decode($images[0]->passing_papers,true);
        
        $licences = json_decode($licencesimages[0]->licence,true);
        
        $registrationcards = json_decode($cardimages[0]->registration_card,true);
        
        
        
        return view('check_documents', ['passingpapers'=>$passingpapers, 'images'=>$images, 'licences'=>$licences, 'licencesimages'=>$licencesimages, 'registrationcards'=>$registrationcards, 'cardimages'=>$cardimages]);
    }
    
    else{
        
        // $passingpapers = Passingpapers::where('user_id', $id)->get()->toArray();
        // $licences = Licence::where('user_id', $id)->get()->toArray();
        // $registrationcards = Registrationcard::where('user_id', $id)->get()->toArray();
        
        return view('check_document_else');
        
    }
}

    public function logout(Request $request)
    {
        Auth::logout();


        return redirect('home');
    }

}
