<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package Grd
 */

if ( 'full-content' == grd_get_layout() ) {
	return;
}

$col = 'col-md-4 mf-widget-col-4';

if ( grd_is_catalog() || is_singular('product') || is_singular('service') || grd_is_service() ) {
    $col = 'col-md-3';
}

$sidebar = 'blog-sidebar';

if( is_page() ) {
    $sidebar = 'page-sidebar';
} elseif ( grd_is_catalog() || (function_exists('is_product') && is_product()) ) {
    $sidebar = 'shop-sidebar';
} elseif ( grd_is_service() || is_singular( 'service' ) ) {
    $sidebar = 'service-sidebar';
}
?>

<aside id="primary-sidebar" class="widgets-area primary-sidebar <?php echo esc_attr( $sidebar ) ?> col-xs-12 col-sm-12 <?php echo esc_attr( $col ) ?>">
    <div class="grd-widget">
        <?php
        if (is_active_sidebar($sidebar)) {
            dynamic_sidebar($sidebar);
        }
        ?>
    </div>
</aside><!-- #secondary -->
