<?php
/**
 * @package grd
 */
$page_header = grd_get_page_header_image();

if ( ! $page_header ) {
	return;
}

$css_item    = 'hide-title';
$breadcrumbs = false;
$title_color = '';
$images_show = '';
$bg_show     = '';

if ( isset( $page_header['elements'] ) && $page_header['elements'] ) {
	$els = $page_header['elements'];

	if ( in_array( 'title', $els ) ) {
		$css_item = '';
	}

	if ( in_array( 'breadcrumb', $els ) ) {
		$breadcrumbs = true;
	}
}

if ( isset( $page_header['parallax'] ) && $page_header['parallax'] ) {
	$css_item .= ' parallax';
}


if ( isset( $page_header['bg_image'] ) && $page_header['bg_image'] ) {
	$css_item .= ' has-image';
} else {
	$css_item .= ' no-image';
}

if ( isset( $page_header['title_color'] ) && $page_header['title_color'] ) {
	$title_color = 'style=" color:' . $page_header['title_color'] . '"';
}

if ( isset( $page_header['bg_image'] ) && $page_header['bg_image'] ) {
	$images_show = 'style="background-image: url(' . esc_url( $page_header['bg_image'] ) . ')"';
}

if ( isset( $page_header['color_image'] ) && $page_header['color_image'] ) {
	$bg_show = '<span style="background-color: ' . $page_header['color_image'] . '"></span>';
}

?>
<div class="page-header <?php echo esc_attr( $css_item ); ?>">
    <div class="page-header-content">
        <div class="featured-image" <?php echo wp_kses($images_show, wp_kses_allowed_html('post')) ?> ><?php echo wp_kses($bg_show, wp_kses_allowed_html('post')) ?></div>
        <div class="container">
            <div class="header-box">
                <div class="page-title">
					<?php
                    if(is_home()){
	                    the_archive_title( '<h2 ' . $title_color . '>', '</h2>' );
                    }else{
	                    the_archive_title( '<h1 ' . $title_color . '>', '</h1>' );
                    }
					?>
                </div>
                <div class="header-breadcrumb">
					<?php
					if ( $breadcrumbs ) {
						grd_get_breadcrumbs();
					}
					?>
                </div>
            </div>
        </div>
    </div>
</div>