<?php
/**
 * Hooks for template logo
 *
 * @package Solo
 */

$logo  = grd_get_option( 'logo_image' );
$logo_sticky = grd_get_option( 'logo_image_sticky' );
$class_logo = '';
if(! empty($logo_sticky)){
	$class_logo = 'show-logo-sticky';
}


if ( ! $logo ) {
	$logo = get_template_directory_uri() . '/img/logo.png';
	if( grd_get_option( 'header_layout' ) == 'v3'){
		$logo = get_template_directory_uri() . '/img/logo-v3.png';
	}
}

?>
	<a href="<?php echo esc_url( home_url() ) ?>" class="logo <?php echo esc_attr( $class_logo ) ?>">
		<img src="<?php echo esc_url( $logo ); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>" class="logo logo-main">
		<?php if(! empty($logo_sticky)) : ?>
			<img src="<?php echo esc_url( $logo_sticky ); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>" class="logo logo-sticky">
		<?php endif;?>
	</a>
<?php

printf(
	'<%1$s class="site-title"><a href="%2$s" rel="home">%3$s</a></%1$s>',
	is_home() || is_front_page() ? 'h1' : 'p',
	esc_url( home_url( '' ) ),
	get_bloginfo( 'name' )
);
?>
<h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>
