<?php
/**
 * Template part for displaying header v1.
 *
 * @package grd
 */

?>

<div class="header-main clearfix">
    <div class="header-bar">
        <div class="container">
            <div class="row header-row">
                <div class="site-logo col-md-3 col-sm-4 col-xs-8">
					<?php get_template_part( 'parts/logo' ); ?>
                </div>
                <?php if ( is_active_sidebar( 'header-bar' ) && intval( grd_get_option( 'header_item_search' ) ) ) : ?>
                    <div class="highlights col-md-9 col-sm-8 col-xs-4">
                        <?php
                        ob_start();
                        dynamic_sidebar( 'header-bar' );
                        $output = ob_get_clean();

                        echo apply_filters( 'grd_header_bar', $output );
                        ?>
                        <ul class="search-bar">
                            <?php grd_extra_search(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <div class="navbar-toggle col-xs-3"><?php grd_menu_icon(); ?></div>
            </div>
        </div>
    </div>
    <div class="header-menu">
        <div class="container">
			<?php do_action( 'grd_before_header' ); ?>
            <div class="site-menu">
                <nav id="site-navigation" class="main-nav primary-nav nav">
					<?php
					if ( has_nav_menu( 'primary' ) ) {
						wp_nav_menu(
							array(
								'theme_location' => 'primary',
								'container'      => false,
							)
						);
					}
					?>
                </nav>
                <ul class="menu-extra">
					<?php grd_header_social(); ?>
					<?php grd_extra_schedule(); ?>
                </ul>
            </div>
        </div>
    </div>
</div>