<?php
/**
 * Template part for displaying header v1.
 *
 * @package grd
 */

?>

<div class="header-main clearfix">
    <div class="container">
        <div class="row menu-row">
            <div class="site-logo col-lg-3 col-md-9 col-sm-9 col-xs-9">
                <?php get_template_part( 'parts/logo' ); ?>
            </div>
            <div class="header-content col-md-9 col-sm-9 col-xs-12">
                <?php do_action( 'grd_before_header_v3' ); ?>
                <div class="site-menu">
                    <nav id="site-navigation" class="main-nav primary-nav nav">
                        <?php
                        if( has_nav_menu('primary') ) {
	                        wp_nav_menu(
		                        array(
			                        'theme_location' => 'primary',
			                        'container'      => false,
		                        )
	                        );
                        }
                        ?>
                    </nav>
                    <?php
                    $block = grd_get_option( 'menu_extra_block' );
                    ?>
                </div>
            </div>
            <div class="navbar-toggle col-xs-3"><?php grd_menu_icon(); ?></div>
        </div>
    </div>
</div>