<?php
/**
 * Template part for displaying header v1.
 *
 * @package grd
 */

?>

<div class="header-main clearfix">
    <div class="header-bar">
        <div class="container">
            <div class="row header-row">
                <div class="site-logo col-lg-3 col-xs-9 col-sm-9 col-xs-12">
		            <?php get_template_part( 'parts/logo' ); ?>
                </div>
	            <?php if ( is_active_sidebar( 'header-bar' ) ) : ?>
                    <div class="highlights col-lg-9 col-md-12 col-xs-12 text-right pull-right">
                        <?php
                            ob_start();
                            dynamic_sidebar( 'header-bar' );
                            $output = ob_get_clean();

                            echo apply_filters( 'grd_header_bar', $output );
                        ?>
                    </div>
	            <?php endif; ?>
                <div class="navbar-toggle col-xs-3"><?php grd_menu_icon(); ?></div>
             </div>
         </div>
    </div>
    <div class="header-menu">
        <div class="container">
            <?php do_action( 'grd_before_header' ); ?>
            <div class="site-menu">
                <ul class="menu-extra">
                    <?php grd_extra_cart(); ?>
                    <?php grd_extra_search(); ?>
                    <?php grd_extra_schedule(); ?>
                </ul>
                <nav id="site-navigation" class="main-nav primary-nav nav">
                    <?php
                    if( has_nav_menu('primary') ) {
	                    wp_nav_menu(
		                    array(
			                    'theme_location' => 'primary',
			                    'container'      => false,
		                    )
	                    );
                    }
                    ?>
                </nav>
            </div>
        </div>
    </div>
</div>