<?php
/**
 * @package grd
 */
global $mf_post;

$size = 'grd-blog-thumb';

$css_class = '';

$excerpt_length = intval( grd_get_option( 'blog_classic_excerpt_length' ) );

if ( 'grid' == grd_get_option( 'blog_view' ) ) {
	$size      = 'grd-blog-grid-thumb';
	$css_class = 'col-xs-6 col-sm-6';

	if ( grd_get_option( 'blog_grid_columns' ) == '2' ) {
		$css_class .= ' blog-wrapper-col-2 col-md-6';
	} else {
		if ( 'full-content' == grd_get_layout() ) {
			$css_class .= ' blog-wrapper-col-3 col-md-4';
		} else {
			$css_class .= ' blog-wrapper-col-2 col-md-6';
		}
	}

	$excerpt_length = intval( grd_get_option( 'blog_grid_excerpt_length' ) );
}

if ( isset( $mf_post['css'] ) ) {
	$css_class .= $mf_post['css'];
}

if ( isset( $mf_post['excerpt_length'] ) ) {
	$excerpt_length = $mf_post['excerpt_length'];
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $css_class ); ?>>
    <div class="blog-wrapper">
		<?php if ( has_post_thumbnail() ) : ?>
            <div class="entry-thumbnail">
                <a href="<?php the_permalink() ?>">
	                <?php grd_entry_thumbnail( $size );?>
					<?php
					$hname = '';
					if ( grd_is_service() ) {
						$categorySevice = wp_get_post_terms( get_the_ID(), 'service_category' );
						if ( ! is_wp_error( $categorySevice ) && ! empty( $categorySevice ) ) {
							$hname = $categorySevice[0]->name;
						}
					} elseif ( grd_is_portfolio() ) {
						$categoryPortfolio = wp_get_post_terms( get_the_ID(), 'portfolio_category' );
						if ( ! is_wp_error( $categoryPortfolio ) && ! empty( $categoryPortfolio ) ) {
							$hname = $categoryPortfolio[0]->name;
						}
					} else {
						$category = get_the_terms( get_the_ID(), 'category' );
                        if (! empty( $category ) ) {
                            $hname = $category[0]->name;
                        }
					}
					if( ! empty($hname) ) {
						echo '<span class="meta-cat">' . esc_html( $hname ) . '</span>';
					}
					?>
                </a>
            </div>
		<?php endif; ?>
        <header class="entry-header">
            <div class="entry-meta">
				<?php grd_entry_meta() ?>
            </div><!-- .entry-meta -->
            <h2 class="entry-title"><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h2>
        </header><!-- .entry-header -->
		<?php if ( grd_get_option( 'blog_view' ) == 'classic' ): ?>
            <div class="entry-content clearfix">
				<?php grd_content_descr( 30 ); ?>
            </div><!-- .entry-content -->
		<?php endif; ?>
        <footer class="entry-footer clearfix">
            <a href="<?php the_permalink() ?>" class="read-more"><span class="svg-icon icon-right-arrow"><svg><use
                                xlink:href="#right-arrow"></use></svg></span> <?php echo esc_html__( 'Read More', 'grd' ); ?>
            </a>
        </footer>
    </div>
</article><!-- #post-## -->