<?php
/**
 * @package grd
 */

?>
<?php $element = grd_portfolio_thumbnail(); ?>
<article id="post-<?php the_ID(); ?>" class="<?php echo esc_attr($element['portfolio_class']) ?> element-item portfolio-wrapper portfolio-item <?php grd_portfolio_slug();?>" data-category="<?php grd_portfolio_slug();?>">
	<div class="content-item">
		<div class="entry-header">
			<a href="<?php the_permalink(); ?>" class="entry-thumbnail">
				<?php the_post_thumbnail($element['size']); ?>
			</a>
			<a href="<?php the_permalink(); ?>" class="entry-title">
				<h3 class="title"><?php the_title(); ?></h3>
			</a>
		</div><!-- .entry-header -->

		<div class="entry-content">
			<div  class="entry-title">
				<a href="<?php the_permalink(); ?>"><h3 class="title"><?php the_title(); ?></h3></a>
				<div class="entry-meta">
					<?php grd_portfolio_category(); ?>
				</div>
			</div>

			<a href="<?php the_permalink(); ?>" class="entry-read-more">
				<div class="read-more">
					<span class="svg-icon icon-right-arrow"><svg viewBox="0 0 20 20"><use xlink:href="#right-arrow"></use></svg></span>
					<?php esc_html_e( 'Read more', 'grd' ); ?>
				</div>
			</a>
		</div><!-- .entry-content -->

	</div>

</article>
