(function ($) {
    'use strict';

    var grd = grd || {};
    grd.init = function () {
        grd.$body = $(document.body),
            grd.$window = $(window),
            grd.$header = $('#masthead');

        // Header
        this.activeHeaderMenu();
        this.menuBlock();
        this.searchToggle();
        this.mobileMenu();

        // Single Portfolio
        this.portfolioFilter();

        // Single Portfolio
        this.teamBox();

        // Product
        this.productQuickView();
        this.productQuantity();

        // Scroll Top
        this.scrollTop();
        this.portfolioLayout();
        this.progressbarShortcode();
        this.portfolioLoadingAjax();

        this.postEntryFormat();
        this.stickyHeader();
    };
// Sticky Header
	grd.stickyHeader = function () {
		if ( !grd.$body.hasClass( 'header-sticky' ) ) {
			return;
		}

		grd.$window.on( 'scroll', function () {
			var scrollTop = 20,
				scroll = grd.$window.scrollTop(),
				hHeader = grd.$header.outerHeight( true ),
				hTopBar = $( '.topbar' ).outerHeight( true );

			scrollTop = scrollTop + hHeader + hTopBar;

			if ( scroll > scrollTop ) {
				grd.$header.addClass( 'minimized' );
				$( '#grd-header-minimized' ).addClass( 'minimized' );
			} else {
				grd.$header.removeClass( 'minimized' );
				$( '#grd-header-minimized' ).removeClass( 'minimized' );
			}
		} );

		grd.$window.on( 'resize', function () {
			var hHeader = grd.$header.outerHeight( true ),
				$h = $( '#grd-header-minimized' );

			if ( !grd.$body.hasClass( 'header-transparent' ) ) {
				$h.height( hHeader );
			}
		} ).trigger( 'resize' );
	};
    // Menu Block Right
    grd.menuBlock = function () {
        var $el = $('.menu-block-right'),
            $el_v3 = $('.menu-block-right-v3');

        grd.$window.on('resize', function () {
            var $wContainer = $('.container').width(),
                width = ( grd.$window.width() - $wContainer ) / 2;

            $el.css({
                'width': width,
                'right': width * -1
            });

            $el_v3.css({
                'width': width,
                'right': (width - 15) * -1
            });
        }).trigger('resize');
    };

    grd.postEntryFormat = function () {
        $('.post_format-post-format-video').fitVids({customSelector: 'iframe, video'});


    };

    // Team Box
    grd.teamBox = function () {
        var $el         = $('.box-banner');
        grd.$window.on('resize', function () {
            var $wContainer = $('.container').width(),
                $wLeft      = ($wContainer / 12 ) * 3 - 15,
                $wempty      = ( grd.$window.width() - $wContainer ) / 2 - 15,
                $wImage     = ($wLeft + $wempty) - 40;

            $el.css({
                'width': $wImage,
                'left': ( $wImage + 20 ) * -1
            });
        }).trigger('resize');
    };

    // Search toggle
    grd.searchToggle = function () {
        $('a.toggle-search').on('click', function (e) {
            e.preventDefault();
            $(this).parent().toggleClass('show-search');
        });
    };

    // Mobile Menu
    grd.mobileMenu = function () {
        var $mobileMenu = $('#primary-mobile-nav');
        grd.$header.on('click', '#mf-navbar-toggle', function (e) {
            e.preventDefault();
            $mobileMenu.toggleClass('open');
            grd.$body.toggleClass('open-canvas-panel');
        });

        $mobileMenu.find('.menu .menu-item-has-children > a').prepend('<span class="toggle-menu-children"></span>');

        $mobileMenu.on('click', '.menu-item-has-children > a, .menu-item-has-children > span', function (e) {
            e.preventDefault();
            openSubMenus($(this));
        });

        $mobileMenu.on('click', '.close-canvas-mobile-panel', function (e) {
            e.preventDefault();
            grd.$body.removeClass('open-canvas-panel');
            $('#primary-mobile-nav').removeClass('open');
        });

        $('#off-canvas-layer').on('click', function (e) {
            e.preventDefault();
            grd.$body.removeClass('open-canvas-panel');
            $('#primary-mobile-nav').removeClass('open');
        });

        grd.$window.on('resize', function () {
            if (grd.$window.width() > 1200) {
                if ($mobileMenu.hasClass('open')) {
                    $mobileMenu.removeClass('open');
                    grd.$body.removeClass('open-canvas-panel');
                }
            }
        });

        function openSubMenus($menu) {
            $menu.closest('li').siblings().find('ul').slideUp();
            $menu.closest('li').siblings().removeClass('active');
            $menu.closest('li').siblings().find('li').removeClass('active');

            $menu.closest('li').children('ul').slideToggle();
            $menu.closest('li').toggleClass('active');
        }
    };

    // Hover Active Header
    grd.activeHeaderMenu = function () {
        var $el, leftPos, childWidth, newWidth, $origWidth, itemWidth, newItemWidth,
            $mainNav = grd.$header.find('ul.menu');

        $mainNav.find('li:last-child').addClass('last-child');
        $mainNav.append('<li id="mf-active-menu" class="mf-active-menu"></li>');
        var $magicLine = $('#mf-active-menu'),
            space;

        $origWidth = 0;

        if ($mainNav.children('li.current-menu-item, li.current-menu-ancestor, li.current-menu-parent').length > 0) {

            itemWidth = $mainNav.children('li.current-menu-item, li.current-menu-ancestor, li.current-menu-parent').outerWidth();

            //childWidth = $mainNav.children('li.current-menu-item, li.current-menu-ancestor, li.current-menu-parent').children('a').outerWidth();
            childWidth = $mainNav.children('li.current-menu-item, li.current-menu-ancestor, li.current-menu-parent').outerWidth();

            space = ((itemWidth - childWidth / 2)) / 2;

            childWidth = childWidth / 2;

            $magicLine
                .width(childWidth)
                .css('left', $mainNav.children('li.current-menu-item, li.current-menu-ancestor, li.current-menu-parent').position().left + space)
                .data('origLeft', $magicLine.position().left)
                .data('origWidth', $magicLine.width());

            $origWidth = $magicLine.data('origWidth');
        }

        $mainNav.children('li').hover(function () {
            $el = $(this);

            newItemWidth = $el.outerWidth();

            newWidth = $el.children('a').outerWidth();

            space = ((newItemWidth - newWidth / 2)) / 2;

            newWidth = newWidth / 2;

            leftPos = $el.position().left + space;
            $magicLine.stop().animate({
                left : leftPos,
                width: newWidth
            });

        }, function () {
            $magicLine.stop().animate({
                left : $magicLine.data('origLeft'),
                width: $origWidth
            });
        });

    };

    /**
     * Initialize isotope for portfolio items
     */
    grd.portfolioFilter = function () {
        var $items = $('.mf-list-portfolio');

        if (!$items.length) {
            return;
        }

        var options = {
            itemSelector      : '.project-wrapper',
            transitionDuration: '0.7s'
        };

        $items.imagesLoaded(function () {
            $(this.elements).isotope(options);
        });

        var $filter = $('.nav-filter');

        $filter.on('click', 'a', function (e) {
            e.preventDefault();

            var $this = $(this),
                selector = $this.attr('data-filter');

            $filter.find('a').removeClass('active');
            $(this).addClass('active');
            $this.closest('.nav-section').next('.mf-list-portfolio').isotope({
                filter: selector
            });
        });
    };

    /**
     * Toggle product quick view
     */
    grd.productQuickView = function() {

        grd.$body.on('click', '.quick_view_button', function(e) {
            e.preventDefault();
            var $a = $(this);
            quickViewMethod($a)

        });

        function quickViewMethod($a) {
            var url = $a.attr('href'),
                $modal = $('#quick-view-modal'),
                $product = $modal.find('.product'),
                $product_sumary = $modal.find('.product-summary'),
                $product_images = $modal.find('.product-images-wrapper'),
                $button = $modal.find('.modal-header .close-modal').first().clone();

            $product.hide().addClass('invisible');
            $product_sumary.html('');
            $product_images.html('');
            $modal.addClass('loading');
            grd.openModal($modal);

            $.get(url, function(response) {
                var $html = $(response),
                    $response_summary = $html.find('#content').find('.entry-summary'),
                    $response_images = $html.find('#content').find('.product-images-content'),
                    $product_thumbnails = $response_images.find('#product-thumbnails'),
                    $variations = $response_summary.find('.variations_form'),
                    $carousel = $response_images.find('#product-images'),
                    productClasses = $html.find('.product').attr('class');

                // Remove unused elements
                $product_thumbnails.remove();
                $product.addClass(productClasses);
                $product_sumary.html($response_summary);
                $product_images.html($response_images);
                $product.show().prepend($button);

                //Force height for images
                $carousel.not('.slick-initialized').slick({
                    slidesToShow  : 1,
                    slidesToScroll: 1,
                    infinite      : false,
                    prevArrow     : '<span class="svg-icon icon-arrow-left slick-prev-arrow"><svg><use xlink:href="#arrow-left"></use></svg></span>',
                    nextArrow     : '<span class="svg-icon icon-arrow-right slick-next-arrow"><svg><use xlink:href="#arrow-right"></use></svg></span>'
                });

                $modal.removeClass('loading');
                $product.removeClass('invisible');

                $carousel.find('.photoswipe').on('click', function(e) {
                    e.preventDefault();
                });

                if ( typeof wc_add_to_cart_variation_params !== 'undefined' ) {
                    $variations.wc_variation_form();
                    $variations.find('.variations select').change();
                }

                if ( typeof $.fn.tawcvs_variation_swatches_form !== 'undefined' ) {
                    $variations.tawcvs_variation_swatches_form();
                }

                $carousel.imagesLoaded(function() {
                    $carousel.addClass('loaded');
                });

                grd.productVatiation();

                $(document.body).trigger('grd_quick_view_request_success', [$response_summary]);
            }, 'html');
        }

        $('#quick-view-modal').on('click', function(e) {
            var target = e.target;
            if ( $(target).closest('div.product').length <= 0 ) {
                grd.closeModal();
            }
        });

        grd.$body.on('click', '.close-modal', function(e) {
            e.preventDefault();
            grd.closeModal();
        });
    };

    /**
     * Open modal
     *
     * @param $modal
     * @param tab
     */
    grd.openModal = function($modal) {
        grd.$body.addClass('modal-open');
        $modal.fadeIn();
        $modal.addClass('open');
    };

    // Style Variation
    grd.productVatiation = function() {
        // soopas_variation_swatches_form
        grd.$body.on('tawcvs_initialized', function() {
            $('.variations_form').unbind('tawcvs_no_matching_variations');
            $('.variations_form').on('tawcvs_no_matching_variations', function(event, $el) {
                event.preventDefault();
                $el.addClass('selected');

                $('.variations_form').find('.woocommerce-variation.single_variation').show();
                if ( typeof wc_add_to_cart_variation_params !== 'undefined' ) {
                    $('.variations_form').find('.single_variation').slideDown(200).html('<p>' + wc_add_to_cart_variation_params.i18n_no_matching_variations_text + '</p>');
                }
            });

        });

        $('.variations_form').find('td.value').each(function() {
            if ( !$(this).find('.variation-selector').hasClass('hidden') ) {
                $(this).addClass('show-select');
            } else {
                $(this).prev().addClass('show-label');
            }
        });
    };

    /**
     * Open modal
     *
     * @param $modal
     * @param tab
     */
    grd.openModal = function($modal) {
        grd.$body.addClass('modal-open');
        $modal.fadeIn();
        $modal.addClass('open');
    };

    /**
     * Close modal
     */
    grd.closeModal = function() {
        grd.$body.removeClass('modal-open');
        $('.grd-modal').fadeOut(function() {
            grd.$body.find('#menu-extra-search, #menu-extra-login').removeClass('show');
            $(this).removeClass('open');
        });
    };

    /**
     * Change product quantity
     */
    grd.productQuantity = function() {
        grd.$body.on('click', '.quantity .increase, .quantity .decrease', function(e) {
            e.preventDefault();

            var $this = $(this),
                $qty = $this.siblings('.qty'),
                current = parseInt($qty.val(), 10),
                min = parseInt($qty.attr('min'), 10),
                max = parseInt($qty.attr('max'), 10);

            min = min ? min : 1;
            max = max ? max : current + 1;

            if ( $this.hasClass('decrease') && current > min ) {
                $qty.val(current - 1);
                $qty.trigger('change');
            }
            if ( $this.hasClass('increase') && current < max ) {
                $qty.val(current + 1);
                $qty.trigger('change');
            }
        });
    };

    // Toggle Menu Sidebar
    grd.menuSideBar = function() {
        $('#menu-sidebar-panel').find('li.menu-item-has-children > a').on('click', function(e) {
            e.preventDefault();

            $(this).closest('li').siblings().find('ul.sub-menu').slideUp();
            $(this).closest('li').siblings().removeClass('active');

            $(this).closest('li').children('ul.sub-menu').slideToggle();
            $(this).closest('li').toggleClass('active');

        });
    };

    // Scroll Top
    grd.scrollTop = function () {
        var $scrollTop = $('#scroll-top');
        grd.$window.scroll(function () {
            if (grd.$window.scrollTop() > grd.$window.height()) {
                $scrollTop.addClass('show-scroll');
            } else {
                $scrollTop.removeClass('show-scroll');
            }
        });

        // Scroll effect button top
        $scrollTop.on('click', function (event) {
            event.preventDefault();
            $('html, body').stop().animate({
                    scrollTop: 0
                },
                800
            );
        });
    };

	grd.portfolioLayout = function() {
		if ( !grd.$body.hasClass('grd-portfolio-isotope') ) {
			return;
		}


		var $portfolioList = $('#grd_portfolio_grid'),
		options = {
			itemSelector: '.portfolio-wrapper',
			layoutMode  : 'fitRows',
		};

		if ( grd.$body.hasClass('portfolio-modern') ) {
			options = {
				itemSelector: '.portfolio-wrapper',
				layoutMode  : 'masonry',
				masonry     : {
					columnWidth: '.portfolio-sizer',
					gutter     : '.gutter-sizer'
				}
			};
		}
		$portfolioList.imagesLoaded(function() {
			$portfolioList.isotope(options);
		});


		$('#portfolio-cats-filters').on('click', '.button', function () {
			var filterValue = $(this).attr('data-filter');

			$portfolioList.isotope({filter: filterValue});
		});

		$('.button-group').each( function( i, buttonGroup ) {
			var $buttonGroup = $( buttonGroup );
			$buttonGroup.on( 'click', 'span', function() {
				$buttonGroup.find('.active').removeClass('active');
				$( this ).addClass('active');
			});
		});

		if ( grd.$body.hasClass('portfolio_full-width') ) {
			$('#filters').addClass('container');
		}


	};

	grd.progressbarShortcode = function() {
		$('.grd-progressbar').waypoint(function() {
			$('.grd-progressbar .line-progress').addClass('animate_progress');

		}, { offset: '100%' });
	};

	/**
	 * Portfolio ajax
	 */
	grd.portfolioLoadingAjax = function () {

		if (!grd.$body.hasClass('grd-portfolio')) {
			return;
		}

		// Blog page
		grd.$body.on('click', '.pag-2 .next', function (e) {
			e.preventDefault();

			if ($(this).data('requestRunning')) {
				return;
			}

			$(this).data('requestRunning', true);

			var $postList = $('#grd_portfolio_grid'),
				$pagination = $(this).parents('.navigation'),
				$parent = $(this).parent();

			$parent.addClass('loader');

			$.get(
				$(this).attr('href'),
				function (response) {
					var $content = $(response).find('#grd_portfolio_grid').children('.portfolio-wrapper'),
						pagination_html = $(response).find('.navigation').html();

					$pagination.html(pagination_html);

					$postList.append($content);

					$content.imagesLoaded(function () {
						$postList.isotope( 'appended', $content );
						$pagination.find('.next').data('requestRunning', false);
						$parent.removeClass('loader');
					});
				}
			);
		});
	};

    /**
     * Document ready
     */
    $(function () {
        grd.init();
    });

})(jQuery);