<?php
/**
 * Custom functions for nav menu
 *
 * @package Grd
 */


/**
 * Display numeric pagination
 *
 * @since 1.0
 * @return void
 */
function grd_numeric_pagination() {
	global $wp_query;

	if ( $wp_query->max_num_pages < 2 ) {
		return;
	}


	?>
	<nav class="navigation paging-navigation numeric-navigation">
		<?php
		$big  = 999999999;
		$args = array(
			'base'      => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
			'total'     => $wp_query->max_num_pages,
			'current'   => max( 1, get_query_var( 'paged' ) ),
			'prev_text' => '<i class="fa fa-angle-left"></i>',
			'next_text' => '<i class="fa fa-angle-right"></i>',
			'type'      => 'plain',
		);

		if ( is_post_type_archive( 'project' ) && 'ajax' == grd_get_option( 'project_nav_type' ) ) :
			$args['prev_text'] = '';
			$args['next_text'] = sprintf( '<span class="load-more">%s</span><span class="grd-loading">%s</span>', esc_html__( 'Load More', 'grd' ), esc_html__( 'Loading', 'grd' ) );
		endif;

		echo paginate_links( $args );
		?>
	</nav>
	<?php
}

/**
 * Display navigation to next/previous set of posts when applicable.
 *
 * @since 1.0
 * @return void
 */
function grd_paging_nav() {
	global $wp_query;
	// Don't print empty markup if there's only one page.
	if ( $GLOBALS['wp_query']->max_num_pages < 2 ) {
		return;
	}
	?>
    <nav class="navigation paging-navigation numeric-navigation">
		<?php
		$big  = 999999999;
		$args = array(
			'base'      => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
			'total'     => $wp_query->max_num_pages,
			'current'   => max( 1, get_query_var( 'paged' ) ),
			'prev_text' => '<i class="fa fa-angle-left"></i>',
			'next_text' => '<i class="fa fa-angle-right"></i>',
			'type'      => 'plain',
		);

		if ( is_post_type_archive( 'project' ) && 'ajax' == grd_get_option( 'project_nav_type' ) ) :
			$args['prev_text'] = '';
			$args['next_text'] = sprintf( '<span class="load-more">%s</span><span class="grd-loading">%s</span>', esc_html__( 'Load More', 'grd' ), esc_html__( 'Loading', 'grd' ) );
		endif;

		echo paginate_links( $args );
		?>
    </nav>
	<?php
}


/**
 * Display navigation to next/previous post when applicable.
 *
 * @since 1.0
 * @return void
 */
function grd_post_nav() {
	// Don't print empty markup if there's nowhere to navigate.
	$previous = ( is_attachment() ) ? get_post( get_post()->post_parent ) : get_adjacent_post( false, '', true );
	$next     = get_adjacent_post( false, '', false );

	if ( ! $next && ! $previous ) {
		return;
	}
	?>
	<nav class="navigation post-navigation" role="navigation">
		<div class="nav-links">
			<?php
            $prev_text = esc_html__( '&laquo; Previous Post', 'grd' );
            $next_text = esc_html__( 'Next Topic &raquo;', 'grd' );
			previous_post_link( '<div class="nav-previous">%link</div>', _x( '<div class="nav-title">%title</div><span class="meta-nav">' . $prev_text . '</span>', 'grd' ) );
			next_post_link( '<div class="nav-next">%link</div>', _x( '<div class="nav-title">%title</div> <span class="meta-nav">' . $next_text . '</span>', 'grd' ) );
			?>
		</div><!-- .nav-links -->
	</nav><!-- .navigation -->
	<?php
}

/**
 * Display navigation to next/previous post when applicable.
 *
 * @since 1.0
 * @return void
 */
function grd_portfolio_nav() {
	if ( grd_get_option( 'portfolio_single_nav' ) == true ) {
		// Don't print empty markup if there's nowhere to navigate.
		$previous = ( is_attachment() ) ? get_post( get_post()->post_parent ) : get_adjacent_post( false, '', true );
		$next     = get_adjacent_post( false, '', false );

		if ( ! $next && ! $previous ) {
			return;
		}
		?>
		<nav class="navigation post-navigation portfolio-navigation" role="navigation">
			<div class="nav-links">
				<?php
                $prev_text = esc_html__( 'PREV', 'grd' );
                $next_text = esc_html__( 'NEXT', 'grd' );
				previous_post_link( '<div class="nav-previous">%link</div>', _x( '<span class="fa fa-chevron-left"></span><span class="meta-nav">' . $prev_text . '</span>', 'grd' ) );
				if(grd_get_option('portfolio_single_project')){
					$link = grd_get_option('portfolio_single_project');
					echo sprintf("<div class='nav-project'><a href='%s'><i class='fa fa-th' aria-hidden='true'></i></a></div>",esc_url($link));
				}
				next_post_link( '<div class="nav-next">%link</div>', _x( '<span class="meta-nav">' . $next_text . '</span><span class="fa fa-chevron-right"></span>', 'grd' ) );
				?>
			</div><!-- .nav-links -->
		</nav><!-- .navigation -->
		<?php
	}
}
