<?php

/**
 * Class for all WooCommerce template modification
 *
 * @version 1.0
 */
class Grd_WooCommerce {
	/**
	 * @var string Layout of current page
	 */
	public $layout;

	/**
	 * @var string shop view
	 */
	public $new_duration;

	/**
	 * Construction function
	 *
	 * @since  1.0
	 * @return Grd_WooCommerce
	 */
	function __construct() {
		// Check if Woocomerce plugin is actived
		if ( ! in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
			return;
		}

		// Define all hook
		add_action( 'template_redirect', array( $this, 'hooks' ) );

	}

	/**
	 * Hooks to WooCommerce actions, filters
	 *
	 * @since  1.0
	 * @return void
	 */
	function hooks() {

		// WooCommerce Styles
		add_filter( 'woocommerce_enqueue_styles', array( $this, 'wc_styles' ) );

		// Remove breadcrumb, use theme's instead
		remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );

		// Add box shadow
		add_action( "woocommerce_before_shop_loop_item", array( $this, 'after_box_shadow' ), 9 );
		add_action( "woocommerce_after_shop_loop_item", array( $this, 'before_box_shadow' ), 20 );

		// Remove badges
		remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash' );

		// Add toolbars for shop page
		add_filter( 'woocommerce_show_page_title', '__return_false' );

		// Remove Rating Product
		remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );

		// Addtocart Button
		remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
		add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_add_to_cart', 15 );

		// Quick View Button
		add_action( 'woocommerce_before_shop_loop_item_title', array( $this, 'show_quick_view_product' ) );

		// Remove product link
		remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
		remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 10 );

		// Add box images
		add_action( "woocommerce_before_shop_loop_item_title", array( $this, 'after_box_images' ), 9 );
		add_action( "woocommerce_before_shop_loop_item_title", array( $this, 'before_box_images' ), 20 );

		// Add link to product title in shop loop
		remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title' );
		add_action( 'woocommerce_shop_loop_item_title', array( $this, 'show_product_loop_title' ) );

		// Add box content
		add_action( "woocommerce_shop_loop_item_title", array( $this, 'after_box_started' ), 9 );
		add_action( "woocommerce_after_shop_loop_item_title", array( $this, 'before_box_started' ), 10 );

		// Change text button add to cart
		add_filter( 'woocommerce_product_add_to_cart_text', array( $this, 'change_text_button' ) );

		// Change next and prev text
		add_filter( 'woocommerce_pagination_args', array( $this, 'pagination_args' ) );

		// Remove flash single product
		remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );

		// Check shownumber related single product
		add_filter( 'woocommerce_output_related_products_args', array( $this, 'related_custom_number' ) );

		// Add product Attribute
		add_filter( 'grd_after_single_product_image', array( $this, 'product_thumbnails' ) );

		// Add ribbons product
		add_action( 'woocommerce_before_shop_loop_item', array( $this, 'product_ribbons' ), 10 );

		if ( ! intval( grd_get_option( 'related_product' ) ) ) {
			remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );

		}

		// Change possition cross sell
		remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );
		add_action( 'woocommerce_after_cart', 'woocommerce_cross_sell_display' );

		// Change columns and total of cross sell
		add_filter( 'woocommerce_cross_sells_columns', array( $this, 'cross_sells_columns' ) );
		add_filter( 'woocommerce_cross_sells_total', array( $this, 'cross_sells_numbers' ) );

	}


	/**
	 * Change next and previous icon of pagination nav
	 *
	 * @since  1.0
	 */
	function pagination_args( $args ) {
		$args['prev_text'] = '<i class="fa fa-angle-left"></i>';
		$args['next_text'] = '<i class="fa fa-angle-right"></i>';

		return $args;
	}

	/**
	 * Print new product title shop page with link inside
	 */
	function show_product_loop_title() {
		?><h4><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h4><?php
	}

	/**
	 * Print new product title shop page with link inside
	 */
	function show_quick_view_product() {
		?><a class="button quick_view_button" href="<?php the_permalink() ?>"><i class="fa fa-eye"></i></a><?php
	}

	/**
	 * Add box content
	 */
	function after_box_shadow() {
		echo "<div class='box-shadow'>";
	}

	function before_box_shadow() {
		echo "</div>";
	}

	/**
	 * Add box content images
	 */
	function after_box_images() {
		echo "<div class='box-images'>";
	}

	function before_box_images() {
		echo "</div>";
	}


	/**
	 * Add box content
	 */
	function after_box_started() {
		echo "<div class='box-content'>";
	}

	function before_box_started() {
		echo "</div>";
	}

	//  Change "" text by your text you want to see
	function change_text_button() {
		return "";
	}

	//  Check shownumber related single product
	function related_custom_number( $args ) {
		$number_post            = grd_get_option( 'related_product_numbers' );
		$number_column          = grd_get_option( 'related_product_columns' );
		$args['posts_per_page'] = $number_post; // 4 related products
		$args['columns']        = $number_column; // arranged in 2 columns

		return $args;
	}

	/**
	 * Remove default woocommerce styles
	 *
	 * @since  1.0
	 *
	 * @param  array $styles
	 *
	 * @return array
	 */
	function wc_styles( $styles ) {
		//unset( $styles['woocommerce-layout'] );
		unset( $styles['woocommerce-smallscreen'] );

		return $styles;
	}

	/**
	 * Get product thumnails
	 *
	 * @since  1.0.0
	 * @return string
	 */
	function product_thumbnails() {
		global $post, $product, $woocommerce;

		if ( is_single() ) {
			return;
		}

		$attachment_ids = $product->get_gallery_image_ids();
		$video_position = intval( get_post_meta( $product->get_id(), 'video_position', true ) );
		$video_thumb    = get_post_meta( $product->get_id(), 'video_thumbnail', true );
		if ( $video_thumb ) {
			$video_thumb = wp_get_attachment_image( $video_thumb, apply_filters( 'single_product_small_thumbnail_size', 'shop_thumbnail' ) );
		}

		if ( $attachment_ids || $video_thumb ) {
			$loop    = 1;
			$columns = apply_filters( 'woocommerce_product_thumbnails_columns', 3 );
			?>
            <div class="product-thumbnails" id="product-thumbnails">
                <div class="thumbnails <?php echo 'columns-' . $columns; ?>"><?php

					$image_thumb = get_the_post_thumbnail( $post->ID, apply_filters( 'single_product_small_thumbnail_size', 'shop_thumbnail' ) );

					if ( $image_thumb ) {

						printf(
							'<div>%s</div>',
							$image_thumb
						);

					}

					if ( $attachment_ids ) {
						foreach ( $attachment_ids as $attachment_id ) {

							if ( $video_thumb ) {
								if ( intval( $video_position ) == $loop + 1 ) {
									printf(
										'<div class="video-thumb">%s</div>',
										$video_thumb
									);
								}
							}

							echo apply_filters(
								'woocommerce_single_product_image_thumbnail_html',
								sprintf(
									'<div>%s</div>',
									wp_get_attachment_image( $attachment_id, apply_filters( 'single_product_small_thumbnail_size', 'shop_thumbnail' ) )
								),
								$attachment_id,
								$post->ID
							);

							$loop ++;
						}
					}

					if ( $video_thumb ) {
						if ( $video_position > count( $attachment_ids ) + 1 ) {
							printf(
								'<div class="video-thumb">%s</div>',
								$video_thumb
							);
						}
					}

					?>
                </div>
            </div>
			<?php
		}

	}

	/**
	 * Change number of columns when display cross sells products
	 *
	 * @param  int $cl
	 *
	 * @return int
	 */
	function cross_sells_columns( $cross_columns ) {
		return apply_filters( 'grd_cross_sells_columns', 4 );
	}

	/**
	 * Change number of columns when display cross sells products
	 *
	 * @param  int $cl
	 *
	 * @return int
	 */
	function cross_sells_numbers( $cross_numbers ) {
		return apply_filters( 'grd_cross_sells_total', 4 );
	}

	/**
	 * Display badge for new product or featured product
	 *
	 * @since 1.0
	 */
	function product_ribbons() {
		global $product;

		if ( ! intval( grd_get_option( 'show_badges' ) ) ) {
			return;
		}

		$output = array();
		// Change the default sale ribbon
		if ( $product->is_featured() ) {
			$hot = grd_get_option( 'hot_text' );
			if ( ! $hot ) {
				$hot = esc_html__( 'Hot', 'grd' );
			}
			$output[] = '<span class="featured ribbon">' . esc_html( $hot ) . '</span>';
		}

		if ( $output ) {
			printf( '<span class="ribbons">%s</span>', implode( '', $output ) );
		}
	}
}