<?php
/**
 * Hooks for template nav menus
 *
 * @package Grd
 */

/**
 * Get our wp_nav_menu() fallback, wp_page_menu(), to show a home link.
 *
 * @since 1.0
 *
 * @param array $args Configuration arguments.
 *
 * @return array
 */
function grd_page_menu_args( $args ) {
	$args['show_home'] = true;

	return $args;
}

add_filter( 'wp_page_menu_args', 'grd_page_menu_args' );

/**
 * Get Menu extra cart
 *
 * @since  1.0.0
 *
 *
 * @return string
 */
if ( ! function_exists( 'grd_extra_cart' ) ) :
	function grd_extra_cart() {

		if ( ! function_exists( 'woocommerce_mini_cart' ) ) {
			return '';
		}

		if ( ! intval( grd_get_option( 'header_item_cart' ) ) ) {
			return;
		}
		global $woocommerce;

		ob_start();
		woocommerce_mini_cart();
		$mini_cart = ob_get_clean();

		$mini_content = sprintf( '	<div class="widget_shopping_cart_content">%s</div>', $mini_cart );

		$icon_cart = '<span class="text-mobile">' . esc_html__( "Shopping Cart", "grd" ) . '</span><span class="svg-icon icon-cart"><svg><use xlink:href="#cart"></use></svg></span>';
		$icon_cart = apply_filters( 'grd_icon_cart', $icon_cart );

		printf(
			'<li class="extra-menu-item menu-item-cart mini-cart woocommerce">
			<a class="cart-contents" href="%s">
				%s
			</a>
			<div class="grd-mini-cart-content">
			%s
			</div>
		</li>',
			esc_url( wc_get_cart_url() ),
			$icon_cart,
			$mini_content
		);

	}
endif;

/**
 * Get Menu extra schedule
 *
 * @since  1.0.0
 *
 *
 * @return string
 */
if ( ! function_exists( 'grd_extra_schedule' ) ) :
	function grd_extra_schedule() {
		if ( ! intval( grd_get_option( 'header_item_schedule' ) ) ) {
			return;
		}
		$schedule_text = grd_get_option( 'header_item_schedule_text' );
		if ( empty( $schedule_text ) ) {
			return;
		}

		$schedule_box  = '';
		$schedule_icon = grd_get_option( 'header_item_schedule_icon' );
		$schedule_text = '<i class="fa fa-' . esc_attr( $schedule_icon ) . '"></i>' . wp_kses( $schedule_text, wp_kses_allowed_html( 'post' ) );
		$schedule_link = grd_get_option( 'header_item_schedule_link' );

		if ( grd_get_option( 'header_layout' ) !== 'v1' ) {
			if ( $schedule_link ) {
				echo '<li class="extra-menu-item menu-item-schedule schedule"><div class="schedule-box">
	             <a class="schedule-btn" href="' . esc_url( $schedule_link ) . '">' . $schedule_text . '</a></div></li>';
			} else {
				echo '<li class="extra-menu-item menu-item-schedule schedule"><div class="schedule-box">' . $schedule_text . $schedule_box . '</div></li>';
			}
		}

		if ( grd_get_option( 'header_layout' ) == 'v1' ) {
			$schedule_box = '<div class="schedule-content"><a href="' . esc_url( $schedule_link ) . '">' . esc_html( grd_get_option( 'header_item_schedule_text' ) ) . '</a></div>';
			echo '<li class="extra-menu-item menu-item-schedule schedule"><span class="text-mobile">' . esc_html__( "Schedule", "grd" ) . '</span><i class="fa fa-' . esc_attr( $schedule_icon ) . '"></i>' . $schedule_box . '</li>';
		}
	}
endif;

/**
 * Get Menu extra search
 *
 * @since  1.0.0
 *
 *
 * @return string
 */

if ( ! function_exists( 'grd_extra_search' ) ) :
	function grd_extra_search() {
		if ( ! intval( grd_get_option( 'header_item_search' ) ) ) {
			return;
		}

		echo '<li class="extra-menu-item menu-item-search">
				<a href="#" class="toggle-search">
					<span class="svg-icon icon-search"><svg><use xlink:href="#search"></use></svg></span>
					<span class="svg-icon icon-cancel"><svg><use xlink:href="#cancel"></use></svg></span>
				</a>';
		get_search_form();
		echo '</li>';
	}
endif;

/**
 * Add extra items to the end of primary menu
 *
 * @since  1.0.0
 *
 * @param  string $items Items list
 * @param  object $args Menu options
 *
 * @return string
 */
function grd_nav_menu_extra_items( $items, $args ) {
	if ( 'primary' != $args->theme_location ) {
		return $items;
	}

	if ( ! intval( grd_get_option( 'header_item_search' ) ) ) {
		return $items;
	}

	if ( grd_get_option( 'header_layout' ) == 'v3' ) {
		$items .= sprintf(
			'<li class="extra-menu-item menu-item-search">
				<a href="#" class="toggle-search">
					<i class="fa fa-search" aria-hidden="true"></i>
					<i class="fa fa-close" aria-hidden="true"></i>
				</a>
				<form method="get" class="search-form" action="%s">
					<input type="search" class="search-field" placeholder="%s..." value="" name="s">
					<input type="submit" class="search-submit" value="Search">
				</form>
			</li>',
			esc_url( home_url( '/' ) ),
			esc_attr__( 'Search', 'grd' )
		);
	}

	return $items;
}

add_filter( 'wp_nav_menu_items', 'grd_nav_menu_extra_items', 10, 2 );