<?php
/**
 * Hooks for frontend display
 *
 * @package Grd
 */


/**
 * Adds custom classes to the array of body classes.
 *
 * @since 1.0
 *
 * @param array $classes Classes for the body element.
 *
 * @return array
 */
function grd_body_classes( $classes ) {
	$header_layout = grd_get_option( 'header_layout' );

	// Adds a class of group-blog to blogs with more than 1 published author.
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}
	if ( grd_is_portfolio() && grd_get_option( 'portfolio_layout' ) == 'classic' ) {
		$classes[] = 'portfolio-classic';
	}
	if ( grd_is_portfolio() && grd_get_option( 'portfolio_layout' ) == 'modern' ) {
		$classes[] = 'portfolio-modern';
	}
	if ( grd_is_portfolio() && grd_get_option( 'portfolio_layout' ) == 'full-width' ) {
		$classes[] = 'portfolio-layout-full-width';
	}
	if ( intval( grd_get_option( 'header_sticky' ) ) ) {
		$classes[] = 'header-sticky';
	}

	if ( ( is_archive() || is_author() || is_category() || is_home() || is_tag() ) && 'post' == get_post_type() ) {
		if ( grd_get_option( 'blog_layout' ) == 'masonry' ) {
			$classes[] = 'blog-masonry';
		}
	}

	if ( is_singular( 'post' ) ) {
		$classes[] = grd_get_option( 'single_post_layout' );
	} elseif ( grd_is_blog() ) {
		$classes[] = 'blog-' . grd_get_option( 'blog_view' );
		$classes[] = grd_get_option( 'blog_layout' );
		$classes[] = 'blog-page';
	} elseif ( grd_is_portfolio() ) {
		if ( grd_get_option( 'portfolio_cats_filters' ) == '1' ) {
			$classes[] = 'grd-portfolio-isotope';
		}
		$classes[] = 'grd-portfolio';
	} elseif ( grd_is_service() ) {
		if ( grd_get_option( 'service_columns' ) == '2' ) {
			$classes[] = 'service-col-2';
		} elseif ( grd_get_option( 'service_columns' ) == '3' ) {
			$classes[] = 'service-col-3';
		} elseif ( grd_get_option( 'service_columns' ) == '4' ) {
			$classes[] = 'service-col-4';
		}
		$classes[] = 'grd-service';
	} else {
		$classes[] = grd_get_layout();
	}

	if ( ! is_active_sidebar( 'header-bar' ) || grd_get_option( 'topbar_enable' ) == 0 ) {
		$classes[] = 'hide-topbar';
	}

	if ( grd_get_option( 'footer_widget_middle_phone' ) == '' ) {
		$classes[] = 'hide-middle_phone';
	}

	if ( grd_get_option( 'header_transparent' ) == 1 && grd_get_option( 'header_layout' ) == 'v3' ) {
		$classes[] = 'header-transparent';
	}

	if ( intval( grd_get_option( 'header_sticky' ) ) ) {
		$classes[] = 'header-sticky';
	}

	$classes[] = 'header-' . $header_layout;

	return $classes;
}

add_filter( 'body_class', 'grd_body_classes' );

if ( ! function_exists( 'grd_content_columns' ) ) :

	/**
	 * Display CSS classes for content columns
	 *
	 * @param string $layout
	 */
	function grd_content_columns( $layout = null ) {
		echo implode( ' ', grd_get_content_columns( $layout ) );
	}

endif;

if ( ! function_exists( 'grd_get_content_columns' ) ) :
	/**
	 * Get CSS classes for content columns
	 *
	 * @param string $layout
	 *
	 * @return array
	 */
	function grd_get_content_columns( $layout = null ) {
		$layout = $layout ? $layout : grd_get_layout();

		if ( 'full-content' == $layout ) {
			return array( 'col-md-12', 'col-sm-12', 'col-xs-12' );
		}

		if ( grd_is_catalog() || is_singular('product') || is_singular('service') || grd_is_service() ) {
			return array( 'col-md-9', 'col-sm-12', 'col-xs-12' );
		}

		return array( 'col-md-8', 'col-sm-12', 'col-xs-12' );
	}

endif;

if ( ! function_exists( 'grd_get_layout' ) ) :
	/**
	 * Get layout base on current page
	 *
	 * @return string
	 */
	function grd_get_layout() {
		$layout = grd_get_option( 'blog_layout' );

		if ( is_404() ) {
			$layout = 'full-content';
		} elseif ( is_singular( 'post' ) ) {
			if ( get_post_meta( get_the_ID(), 'custom_page_layout', true ) ) {
				$layout = get_post_meta( get_the_ID(), 'layout', true );
			} else {
				$layout = grd_get_option( 'single_post_layout' );
			}
		} elseif ( is_page_template( array( 'template-fullwidth.php', 'template-homepage.php' ) ) ) {
			$layout = 'full-content';
		} elseif ( is_page() ) {
			if ( get_post_meta( get_the_ID(), 'custom_page_layout', true ) ) {
				$layout = get_post_meta( get_the_ID(), 'layout', true );
			} else {
				$layout = grd_get_option( 'page_layout' );
			}
		} elseif ( is_singular( 'portfolio' ) || grd_is_portfolio() ) {
			$layout = 'full-content';
		} elseif ( grd_is_service() ) {
			$layout = 'full-content';
		} elseif ( is_singular( 'service' ) ) {
			$layout = grd_get_option( 'single_service_layout' );
		} elseif ( grd_is_catalog() ) {
			$layout = grd_get_option( 'shop_layout' );
		} elseif ( function_exists( 'is_product' ) && is_product() ) {
			$layout = grd_get_option( 'single_product_layout' );
		}

		return apply_filters( 'grd_site_layout', $layout );
	}

endif;