<?php
/**
 * Custom functions that act in the footer.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package grd
 */

/**
 *  Display footer widget
 */
function grd_footer_widgets() {

	if ( grd_get_option( 'footer_widget' ) == 0 ) {
		return '';
	}

	if ( is_active_sidebar( 'footer-sidebar-1' ) == false &&
	     is_active_sidebar( 'footer-sidebar-2' ) == false &&
	     is_active_sidebar( 'footer-sidebar-3' ) == false &&
	     is_active_sidebar( 'footer-sidebar-4' ) == false ) {
		return '';
	}
	?>

    <div id="footer-widgets" class="footer-widgets g widgets-area">
        <div class="container">
            <div class="row">

				<?php
				$columns = max( 1, absint( grd_get_option( 'footer_widget_columns' ) ) );

				$col_class = 'col-xs-12 col-sm-6 col-md-' . floor( 12 / $columns );
				for ( $i = 1; $i <= $columns; $i ++ ) :
					?>
                    <div class="footer-sidebar footer-<?php echo esc_attr( $i ) ?> <?php echo esc_attr( $col_class ) ?>">
						<?php dynamic_sidebar( "footer-sidebar-$i" ); ?>
                    </div>
				<?php endfor; ?>

            </div>
        </div>
    </div>
	<?php
}

add_action( 'grd_before_footer', 'grd_footer_widgets', 20, 1 );

/**
 *  Display footer widget
 */
function grd_footer_widgets_middle() {

	if ( grd_get_option( 'footer_widget_middle' ) == 0 ) {
		return '';
	}

	?>

    <div id="footer-widgets-middle" class="footer-widgets widgets-area footer-middle">
        <div class="container">
            <div class="row">
				<?php

				if ( grd_get_option( 'footer_widget_middle_email' ) ) {
					echo '<div class="col-xs-12 col-sm-4 col-md-4 email" ><i class="fa fa-envelope"></i> ' . wp_kses( grd_get_option( 'footer_widget_middle_email' ), wp_kses_allowed_html( 'post' ) ) . '</div>';
				}

				if ( grd_get_option( 'footer_widget_middle_phone' ) ) {
					echo '<div class="col-xs-12 col-sm-4 col-md-4 phone" ><div>' . esc_html__( 'Call Us On', 'grd' ) . '</div><span>' . wp_kses( grd_get_option( 'footer_widget_middle_phone' ), wp_kses_allowed_html( 'post' ) ) . '</span></div>';
				}

				grd_footer_social();

				?>
            </div>
        </div>
    </div>
	<?php
}

add_action( 'grd_before_footer', 'grd_footer_widgets_middle', 20, 1 );

function grd_footer_social() {

	$footer_socials = grd_get_option( 'footer_widget_middle_social' );

	if ( empty( $footer_socials ) ) {
		return;
	}

	?>
    <div class="col-xs-12 col-sm-4 col-md-4 social">
        <div class="socials footer-social">
			<?php

			echo '<span>' . esc_html__( 'We Are Social', 'grd' ) . '</span>';
			$socials = (array) grd_get_socials();

			foreach ( $footer_socials as $social ) {
				foreach ( $socials as $name => $label ) {
					$link_url = $social['link_url'];

					if ( preg_match( '/' . $name . '/', $link_url ) ) {

						if ( $name == 'google' ) {
							$name = 'google-plus';
						}

						printf( '<a href="%s" target="_blank"><i class="fa fa-%s"></i></a>', esc_url( $link_url ), esc_attr( $name ) );
						break;
					}
				}
			}
			?>
        </div>
    </div>
	<?php
}

/**
 *  Display site footer
 */
function grd_footer() {
	$copyright = grd_get_option( 'footer_copyright' );

    if( empty( $copyright ) ) {
        return;
    }
	?>
    <div class="container footer-info">
	<div class="col-sm-12">
		<div class="col-sm-6">
        <div class="footer-copyright text-left">
			<?php echo do_shortcode( wp_kses( grd_get_option( 'footer_copyright' ), wp_kses_allowed_html( 'post' ) ) ); ?>
        </div>
		</div>
		<div class="footer-copyright  col-sm-6">
		
		<?php dynamic_sidebar('footer copyright menu');?>
		</div>
		</div>
    </div>
	<?php
}

add_action( 'grd_footer', 'grd_footer' );

/**
 * Adds quick view modal to footer
 */
if ( ! function_exists( 'grd_quick_view_modal' ) ) :
	function grd_quick_view_modal() {
		if ( is_page_template( 'template-coming-soon-page.php' ) ) {
			return;
		}
		?>

        <div id="quick-view-modal" class="quick-view-modal grd-modal woocommerce" tabindex="-1" role="dialog">
            <div class="modal-header">
                <a href="#" class="close-modal">
                    <span class="svg-icon icon-cancel"><svg><use xlink:href="#cancel"></use></svg></span>
                </a>
            </div>
            <div class="modal-content">
                <div class="container">
                    <div class="grd-product-content">
                        <div class="product">
                            <div class="row">
                                <div class="col-md-7 col-sm-12 col-xs-12 product-images-wrapper">
                                </div>
                                <div class="col-md-4 col-sm-12 col-xs-12 col-md-offset-1 product-summary">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="grd-loader"></div>
        </div>

		<?php
	}

endif;

add_action( 'wp_footer', 'grd_quick_view_modal' );

/**
 * Display back to top
 *
 * @since 1.0.0
 */
function grd_back_to_top() {
	if ( ! intval( grd_get_option( 'back_to_top' ) ) ) {
		return;
	}
	?>
    <a id="scroll-top" class="backtotop" href="#page-top">
        <i class="fa fa-angle-double-up"></i>
    </a>
	<?php
}

add_action( 'wp_footer', 'grd_back_to_top' );


/**
 * Adds photoSwipe dialog element
 */
function grd_gallery_images_lightbox() {

	if ( ! is_singular() ) {
		return;
	}

	?>
    <div id="pswp" class="pswp" tabindex="-1" role="dialog" aria-hidden="true">

        <div class="pswp__bg"></div>

        <div class="pswp__scroll-wrap">

            <div class="pswp__container">
                <div class="pswp__item"></div>
                <div class="pswp__item"></div>
                <div class="pswp__item"></div>
            </div>

            <div class="pswp__ui pswp__ui--hidden">

                <div class="pswp__top-bar">


                    <div class="pswp__counter"></div>

                    <button class="pswp__button pswp__button--close"
                            title="<?php esc_attr_e( 'Close (Esc)', 'grd' ) ?>"></button>

                    <button class="pswp__button pswp__button--share"
                            title="<?php esc_attr_e( 'Share', 'grd' ) ?>"></button>

                    <button class="pswp__button pswp__button--fs"
                            title="<?php esc_attr_e( 'Toggle fullscreen', 'grd' ) ?>"></button>

                    <button class="pswp__button pswp__button--zoom"
                            title="<?php esc_attr_e( 'Zoom in/out', 'grd' ) ?>"></button>

                    <div class="pswp__preloader">
                        <div class="pswp__preloader__icn">
                            <div class="pswp__preloader__cut">
                                <div class="pswp__preloader__donut"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="pswp__share-modal pswp__share-modal--hidden pswp__single-tap">
                    <div class="pswp__share-tooltip"></div>
                </div>

                <button class="pswp__button pswp__button--arrow--left"
                        title="<?php esc_attr_e( 'Previous (arrow left)', 'grd' ) ?>">
                </button>

                <button class="pswp__button pswp__button--arrow--right"
                        title="<?php esc_attr_e( 'Next (arrow right)', 'grd' ) ?>">
                </button>

                <div class="pswp__caption">
                    <div class="pswp__caption__center"></div>
                </div>

            </div>

        </div>

    </div>
	<?php
}

add_action( 'wp_footer', 'grd_gallery_images_lightbox' );

/**
 * Add off mobile menu to footer
 *
 * @since 1.0.0
 */
function grd_off_canvas_mobile_menu() {
	?>
    <div class="primary-mobile-nav" id="primary-mobile-nav" role="navigation">
        <div class="mobile-nav-content">
            <a href="#" class="close-canvas-mobile-panel"></a>
			<?php
			wp_nav_menu( array(
				'theme_location' => 'primary',
				'container'      => false,
			) );
			?>
            <ul class="menu-extra">
				<?php
				if ( grd_get_option( 'header_layout' ) == 'v1' ) {
					grd_extra_cart();
					grd_extra_schedule();
				} elseif ( grd_get_option( 'header_layout' ) == 'v2' ) {
					grd_extra_cart();
					grd_extra_search();
					grd_extra_schedule();
				} elseif ( grd_get_option( 'header_layout' ) == 'v4' ) {
					grd_extra_schedule();
					grd_header_social();
				}
				?>
            </ul>
        </div>
    </div>
	<?php
}

add_action( 'wp_footer', 'grd_off_canvas_mobile_menu' );

/**
 * Display a layer to close canvas panel everywhere inside page
 *
 * @since 1.0.0
 */

if ( ! function_exists( 'grd_site_canvas_layer' ) ) :
	function grd_site_canvas_layer() {
		?>
        <div id="off-canvas-layer" class="grd-off-canvas-layer"></div>
		<?php
	}

endif;

add_action( 'wp_footer', 'grd_site_canvas_layer' );