<?php
/**
 * Hooks for template archive
 *
 * @package Grd
 */


/**
 * Sets the authordata global when viewing an author archive.
 *
 * This provides backwards compatibility with
 * http://core.trac.wordpress.org/changeset/25574
 *
 * It removes the need to call the_post() and rewind_posts() in an author
 * template to print information about the author.
 *
 * @since 1.0
 * @global WP_Query $wp_query WordPress Query object.
 * @return void
 */
function grd_setup_author() {
	global $wp_query;

	if ( $wp_query->is_author() && isset( $wp_query->post ) ) {
		$GLOBALS['authordata'] = get_userdata( $wp_query->post->post_author );
	}
}

add_action( 'wp', 'grd_setup_author' );


/**
 * Change the Tag Cloud's Font Sizes.
 *
 * @since 1.0.0
 *
 * @param array $args
 *
 * @return array
 */
function grd_change_tag_cloud_font_sizes( array $args ) {
	$args['smallest'] = '12';
	$args['largest']  = '18';

	return $args;
}

add_filter( 'widget_tag_cloud_args', 'grd_change_tag_cloud_font_sizes' );

/*
 * Project categories filter
 */
if ( ! function_exists( 'grd_portfolio_isotope' ) ) {
	function grd_portfolio_isotope() {
		if ( ! intval( grd_get_option( 'portfolio_cats_filters' ) ) ) {
			return;
		}
		$cats = array();
		global $wp_query;

		$cats_number = grd_get_option( 'portfolio_cat_number' );
		$count       = 0;

		while ( $wp_query->have_posts() ) {

			$wp_query->the_post();
			$post_categories = wp_get_post_terms( get_the_ID(), 'portfolio_category' );

			foreach ( $post_categories as $cat ) {
				if ( empty( $cats[ $cat->term_id ] ) ) {
					$cats[ $cat->term_id ] = array( 'name' => $cat->name, 'slug' => $cat->slug, );
				}
			}

		}
		$list_category = array();
		foreach ( $cats as $category ) {
			if ( $count == $cats_number ):break; endif;
			$slug            = esc_attr( $category['slug'] );
			$name            = $category['name'];
			$list_category[] = "<span class='button' data-filter='.$slug'>$name</span>";
			$count ++;
		}
		$list_category = implode( ' ', $list_category );
		$viewall       = esc_html__( 'View all', 'grd' );

		printf( "<div class='container text-center categories-filter portfolio-cats-filter' id='portfolio-cats-filters'>
						<div id='filters' class='button-group'><span class='button active' data-filter='*'>%s</span>%s</div></div>",
			$viewall, $list_category );
	}
}

add_action( 'grd_portfolio_before_content', 'grd_portfolio_isotope' );
/**
 * Check is portfolio
 *
 * @since  1.0
 */
if ( ! function_exists( 'grd_portfolio_category' ) ) {
	function grd_portfolio_category() {
		$terms = get_the_terms( get_the_ID(), 'portfolio_category' );
		if ( $terms && ! is_wp_error( $terms ) ) :
			printf(
				'<a class="category" href="%s">%s</a>',
				esc_url( get_term_link( $terms[0]->term_id, 'portfolio_category' ) ),
				$terms[0]->name
			);
		endif;
	}
}

/**
 * Get portfolio slug
 *
 * @since  1.0
 */
if ( ! function_exists( 'grd_portfolio_slug' ) ) {
	function grd_portfolio_slug() {
		$terms = get_the_terms( get_the_ID(), 'portfolio_category' );

		if ( $terms && ! is_wp_error( $terms ) ) :
			$cat = [];
			foreach ( $terms as $term ) {
				$cat[] = $term->slug;
			}
			printf( '%s', implode(' ', $cat) );
		endif;
	}
}

/**
 * Portfolio Featured Image
 *
 * @since  1.0
 */
if ( ! function_exists( 'grd_portfolio_single_thumbnail' ) ) {
	function grd_portfolio_single_thumbnail() {

		if ( is_singular( 'portfolio' ) ) {
			return;
		}

		if ( get_post_meta( get_the_ID(), 'hide_thumb', true ) == '0' ) {
			echo '<div class="col-xs-12 entry-thumbnail">' . the_post_thumbnail() . '</div>';
		}
	}
}
/**
 * Portfolio Featured Image
 *
 * @since  1.0
 */
if ( ! function_exists( 'grd_portfolio_single_title' ) ) {
	function grd_portfolio_single_title() {

		if ( is_singular( 'portfolio' ) ) {
			return;
		}

		if ( get_post_meta( get_the_ID(), 'hide_title', true ) == '0' ):
			echo '<div class="col-xs-12 content-title">' . the_title( '<h3 class="entry-title">', '</h3>' ) . '</div>';
		endif;
	}
}


if ( ! function_exists( 'grd_portfolio_loop' ) ) :
	function grd_portfolio_loop() {
		global $grd_portfolio_loop, $wp_query;

		$grd_portfolio_loop['portfolio_layout']  = grd_get_option( 'portfolio_layout' );
		$grd_portfolio_loop['current_portfolio'] = $wp_query->current_post;
		if ( grd_get_option( 'portfolio_layout' ) == 'modern' ) {

			$grd_portfolio_loop['size']            = 'grd-portfolio-free1';
			$grd_portfolio_loop['portfolio_class'] = '';
			$mod                                   = $wp_query->current_post % 8;
			if ( in_array( $mod, array( 1, 3 ) ) ) {
				$grd_portfolio_loop['size']            = 'grd-portfolio-free2';
				$grd_portfolio_loop['portfolio_class'] = 'portfolio-wide';
			} elseif ( $mod == 2 ) {
				$grd_portfolio_loop['size']            = 'grd-portfolio-free3';
				$grd_portfolio_loop['portfolio_class'] = 'portfolio-full';
			}

		}
	}

endif;

add_action( 'grd_portfolio_loop', 'grd_portfolio_loop' );


/**
 * Add icon list as svg at the footer
 * It is hidden
 */
function grd_include_shadow_icons() {
	echo '<div id="del-svg-defs" class="del-svg-defs hidden">';
	include get_template_directory() . '/img/sprite.svg';
	echo '</div>';
}

add_action( 'grd_before_site', 'grd_include_shadow_icons' );