<?php
/**
 * Hooks for comment ajax
 *
 * @package Grd
 */

/**
 * Custom fields comment form
 *
 * @since  1.0
 *
 * @return  array  $fields
 */
function grd_comment_form_fields() {
	global $commenter, $aria_req;

	$fields = array(
		'author' => '<p class="comment-form-author col-md-6 col-sm-12">' .
		            '<label>' . esc_html__( 'Name *', 'grd' ) . '</label>'.
			'<input id ="author" name="author" type="text" required value="' . esc_attr( $commenter['comment_author'] ) .
			'" size    ="30"' . $aria_req . ' /></p>',

		'email'  => '<p class="comment-form-email col-md-6 col-sm-12">' .
		            '<label>' . esc_html__( 'Email *', 'grd' ) . '</label>'.
			'<input id ="email" name="email" type="email" required value="' . esc_attr( $commenter['comment_author_email'] ) .
			'" size    ="30"' . $aria_req . ' /></p>',

		'url'    => '<p class="comment-form-url col-md-12 col-sm-12">' .
		            '<label>' . esc_html__( 'Website', 'grd' ) . '</label>'.
			'<input id ="url" name="url" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) .
			'" size    ="30" /></p>'
	);

	return $fields;
}

add_filter( 'comment_form_default_fields', 'grd_comment_form_fields' );

// Moving the Comment Text Field to Bottom
function grd_move_comment_field_to_bottom( $fields ) {
	$comment_field = $fields['comment'];
	unset( $fields['comment'] );
	$fields['comment'] = $comment_field;
	return $fields;
}

add_filter( 'comment_form_fields', 'grd_move_comment_field_to_bottom' );