<?php
/**
 * Registering meta boxes
 *
 * All the definitions of meta boxes are listed below with comments.
 *
 * For more information, please visit:
 * @link http://www.deluxeblogtips.com/meta-box/
 */


/**
 * Enqueue script for handling actions with meta boxes
 *
 * @since 1.0
 *
 * @param string $hook
 */
function grd_meta_box_scripts( $hook ) {
	// Detect to load un-minify scripts when WP_DEBUG is enable
	$min = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

	if ( in_array( $hook, array( 'post.php', 'post-new.php' ) ) ) {
		wp_enqueue_script( 'grd-meta-boxes', get_template_directory_uri() . "/js/backend/meta-boxes$min.js", array( 'jquery' ), '20181007', true );
	}
}
add_action( 'admin_enqueue_scripts', 'grd_meta_box_scripts' );

/**
 * Registering meta boxes
 *
 * Using Meta Box plugin: http://www.deluxeblogtips.com/meta-box/
 *
 * @see http://www.deluxeblogtips.com/meta-box/docs/define-meta-boxes
 *
 * @param array $meta_boxes Default meta boxes. By default, there are no meta boxes.
 *
 * @return array All registered meta boxes
 */
function grd_register_meta_boxes( $meta_boxes ) {
	// Post format's meta box
	$meta_boxes[] = array(
		'id'       => 'post-format-settings',
		'title'    => esc_html__( 'Format Details', 'grd' ),
		'pages'    => array( 'post' ),
		'context'  => 'normal',
		'priority' => 'high',
		'autosave' => true,
		'fields'   => array(
			array(
				'name'  => esc_html__( 'Gallery', 'grd' ),
				'id'    => 'gallery',
				'type'  => 'image_advanced',
				'class' => 'gallery',
			),
			array(
				'name'  => esc_html__( 'Video', 'grd' ),
				'id'    => 'video',
				'type'  => 'textarea',
				'cols'  => 20,
				'rows'  => 2,
				'class' => 'video',
			),
		),
	);

	//Page Header Settings
	$meta_boxes[] = array(
		'id'       => 'page-header-settings',
		'title'    => esc_html__( 'Page Header Settings', 'grd' ),
		'pages'    => array( 'post', 'page', 'portfolio', 'service', 'product' ),
		'context'  => 'normal',
		'priority' => 'high',
		'fields'   => array(
			array(
				'name'  => esc_html__( 'Hide Page Header', 'grd' ),
				'id'    => 'hide_page_header',
				'type'  => 'checkbox',
				'std'   => false,
				'class' => 'hide-homepage',
			),
			array(
				'name'  => esc_html__( 'Hide Breadcrumb', 'grd' ),
				'id'    => 'hide_breadcrumb',
				'type'  => 'checkbox',
				'std'   => false,
				'class' => 'hide-homepage',
			),
			array(
				'name'  => esc_html__( 'Hide Title', 'grd' ),
				'id'    => 'hide_title',
				'type'  => 'checkbox',
				'std'   => false,
				'class' => 'hide-homepage',
			),
			array(
				'name' => esc_html__( 'Hide Parallax', 'grd' ),
				'id'   => 'hide_parallax',
				'type' => 'checkbox',
				'std'  => false,
				'class' => 'hide-homepage',
			),
			array(
				'name'             => esc_html__( 'Background Image', 'grd' ),
				'id'               => 'page_bg',
				'type'             => 'image_advanced',
				'max_file_uploads' => 1,
				'std'              => false,
			),

		),
	);

	// Service
	$meta_boxes[] = array(
		'id'       => 'service_general',
		'title'    => esc_html__( 'General', 'grd' ),
		'pages'    => array( 'service' ),
		'context'  => 'normal',
		'priority' => 'high',
		'autosave' => true,
		'fields'   => array(
			array(
				'name'  => esc_html__( 'Service Icon SVG', 'grd' ),
				'id'    => 'service_icon',
				'type'  => 'textarea',
				'cols'  => 20,
				'rows'  => 1,
				'class' => 'service-icon',
			),
		)
	);

	// Portfolio
	$meta_boxes[] = array(
		'id'       => 'portfolio_general',
		'title'    => esc_html__( 'General', 'grd' ),
		'pages'    => array( 'portfolio' ),
		'context'  => 'normal',
		'priority' => 'high',
		'autosave' => true,
		'fields'   => array(
			array(
				'name' => esc_html__( 'Hide Featured Image', 'grd' ),
				'id'   => 'hide_thumb',
				'type' => 'checkbox',
				'std'  => false,
				'class' => 'hide-homepage',
			),
		)
	);

	return $meta_boxes;
}

add_filter( 'rwmb_meta_boxes', 'grd_register_meta_boxes' );

function grd_notice__success() {

	if ( ! function_exists('grd_vc_addons_init') ) {
		return;
	}

	$versions = get_plugin_data( WP_PLUGIN_DIR . '/grd-addons/grd-addons.php' );
	if ( version_compare( $versions['Version'], '1.1', '>=' ) ) {
		return;
	}

	?>
    <div class="notice notice-info is-dismissible">
        <p><strong><?php esc_html_e( 'The Grd Addons plugin needs to be updated to 1.1 to ensure maximum compatibility with this theme. If you do not update it, your widgets will be lost.', 'grd' ); ?></strong></p>
    </div>
	<?php
}
add_action( 'admin_notices', 'grd_notice__success' );