<?php
/**
 * Grd theme customizer
 *
 * @package Martfury
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Grd_Customize {
	/**
	 * Customize settings
	 *
	 * @var array
	 */
	protected $config = array();

	/**
	 * The class constructor
	 *
	 * @param array $config
	 */
	public function __construct( $config ) {
		$this->config = $config;

		if ( ! class_exists( 'Kirki' ) ) {
			return;
		}

		$this->register();
	}

	/**
	 * Register settings
	 */
	public function register() {

		/**
		 * Add the theme configuration
		 */
		if ( ! empty( $this->config['theme'] ) ) {
			Kirki::add_config(
				$this->config['theme'], array(
					'capability'  => 'edit_theme_options',
					'option_type' => 'theme_mod',
				)
			);
		}

		/**
		 * Add panels
		 */
		if ( ! empty( $this->config['panels'] ) ) {
			foreach ( $this->config['panels'] as $panel => $settings ) {
				Kirki::add_panel( $panel, $settings );
			}
		}

		/**
		 * Add sections
		 */
		if ( ! empty( $this->config['sections'] ) ) {
			foreach ( $this->config['sections'] as $section => $settings ) {
				Kirki::add_section( $section, $settings );
			}
		}

		/**
		 * Add fields
		 */
		if ( ! empty( $this->config['theme'] ) && ! empty( $this->config['fields'] ) ) {
			foreach ( $this->config['fields'] as $name => $settings ) {
				if ( ! isset( $settings['settings'] ) ) {
					$settings['settings'] = $name;
				}

				Kirki::add_field( $this->config['theme'], $settings );
			}
		}
	}

	/**
	 * Get config ID
	 *
	 * @return string
	 */
	public function get_theme() {
		return $this->config['theme'];
	}

	/**
	 * Get customize setting value
	 *
	 * @param string $name
	 *
	 * @return bool|string
	 */
	public function get_option( $name ) {

		$default = $this->get_option_default( $name );

		return get_theme_mod( $name, $default );
	}

	/**
	 * Get default option values
	 *
	 * @param $name
	 *
	 * @return mixed
	 */
	public function get_option_default( $name ) {
		if ( ! isset( $this->config['fields'][ $name ] ) ) {
			return false;
		}

		return isset( $this->config['fields'][ $name ]['default'] ) ? $this->config['fields'][ $name ]['default'] : false;
	}
}

/**
 * This is a short hand function for getting setting value from customizer
 *
 * @param string $name
 *
 * @return bool|string
 */
function grd_get_option( $name ) {
	global $grd_customize;

	$value = false;

	if ( class_exists( 'Kirki' ) ) {
		$value = Kirki::get_option( 'grd', $name );
	} elseif ( ! empty( $grd_customize ) ) {
		$value = $grd_customize->get_option( $name );
	}

	return apply_filters( 'grd_get_option', $value, $name );
}


/**
 * Get default option values
 *
 * @param $name
 *
 * @return mixed
 */
function grd_get_option_default( $name ) {
	global $grd_customize;

	if ( empty( $grd_customize ) ) {
		return false;
	}

	return $grd_customize->get_option_default( $name );
}

/**
 * Move some default sections to `general` panel that registered by theme
 *
 * @param object $wp_customize
 */
function grd_customize_modify( $wp_customize ) {
	$wp_customize->get_section( 'title_tagline' )->panel     = 'general';
	$wp_customize->get_section( 'static_front_page' )->panel = 'general';
}

add_action( 'customize_register', 'grd_customize_modify' );


/**
 * Get customize settings
 *
 * @return array
 */
function grd_customize_settings() {
	/**
	 * Customizer configuration
	 */

	$settings = array(
		'theme' => 'grd',
	);

	$panels = array(
		'general'     => array(
			'priority' => 10,
			'title'    => esc_html__( 'General', 'grd' ),
		),
		'typography'  => array(
			'priority' => 10,
			'title'    => esc_html__( 'Typography', 'grd' ),
		),
		'styling'     => array(
			'priority' => 10,
			'title'    => esc_html__( 'Styling', 'grd' ),
		),
		'header'      => array(
			'priority' => 10,
			'title'    => esc_html__( 'Header', 'grd' ),
		),
		'page'        => array(
			'title'      => esc_html__( 'Page', 'grd' ),
			'priority'   => 10,
			'capability' => 'edit_theme_options',
		),
		'blog'        => array(
			'title'      => esc_html__( 'Blog', 'grd' ),
			'priority'   => 10,
			'capability' => 'edit_theme_options',
		),
		'services'    => array(
			'title'      => esc_html__( 'Services', 'grd' ),
			'priority'   => 10,
			'capability' => 'edit_theme_options',
		),
		'portfolio'   => array(
			'title'      => esc_html__( 'Portfolio', 'grd' ),
			'priority'   => 10,
			'capability' => 'edit_theme_options',
		),
		'woocommerce' => array(
			'priority' => 10,
			'title'    => esc_html__( 'Woocommerce', 'grd' ),
		),
	);

	$sections = array(
		'extra_settings'               => array(
			'title'       => esc_html__( 'Extra Settings', 'grd' ),
			'description' => '',
			'priority'    => 165,
			'capability'  => 'edit_theme_options',
			'panel'       => 'general',
		),
		'topbar'                       => array(
			'title'       => esc_html__( 'Topbar', 'grd' ),
			'description' => '',
			'priority'    => 5,
			'capability'  => 'edit_theme_options',
			'panel'       => 'header',
		),
		'header'                       => array(
			'title'       => esc_html__( 'Header', 'grd' ),
			'description' => '',
			'priority'    => 10,
			'capability'  => 'edit_theme_options',
			'panel'       => 'header',
		),
		'logo'                         => array(
			'title'       => esc_html__( 'Logo', 'grd' ),
			'description' => '',
			'priority'    => 10,
			'capability'  => 'edit_theme_options',
			'panel'       => 'header',
		),
		'body_typo'                    => array(
			'title'       => esc_html__( 'Body', 'grd' ),
			'description' => '',
			'priority'    => 210,
			'capability'  => 'edit_theme_options',
			'panel'       => 'typography',
		),
		'heading_typo'                 => array(
			'title'       => esc_html__( 'Heading', 'grd' ),
			'description' => '',
			'priority'    => 10,
			'capability'  => 'edit_theme_options',
			'panel'       => 'typography',
		),
		'header_typo'                  => array(
			'title'       => esc_html__( 'Header', 'grd' ),
			'description' => '',
			'priority'    => 10,
			'capability'  => 'edit_theme_options',
			'panel'       => 'typography',
		),
		'footer_typo'                  => array(
			'title'       => esc_html__( 'Footer', 'grd' ),
			'description' => '',
			'priority'    => 10,
			'capability'  => 'edit_theme_options',
			'panel'       => 'typography',
		),
		'color_scheme'                 => array(
			'title'       => esc_html__( 'Color Scheme', 'grd' ),
			'description' => '',
			'priority'    => 10,
			'capability'  => 'edit_theme_options',
			'panel'       => 'styling',
		),
		'page_layout'                  => array(
			'title'      => esc_html__( 'Page Layout', 'grd' ),
			'priority'   => 10,
			'capability' => 'edit_theme_options',
			'panel'      => 'page',
		),
		'page_header'                  => array(
			'title'       => esc_html__( 'Page Header', 'grd' ),
			'description' => esc_html__( 'Work on page default.', 'grd' ),
			'priority'    => 10,
			'capability'  => 'edit_theme_options',
			'panel'       => 'page',
		),
		'blog_page_header'             => array(
			'title'       => esc_html__( 'Page Header on Blog Page', 'grd' ),
			'description' => '',
			'priority'    => 10,
			'capability'  => 'edit_theme_options',
			'panel'       => 'blog',
		),
		'blog_page'                    => array(
			'title'       => esc_html__( 'Blog Page', 'grd' ),
			'description' => '',
			'priority'    => 10,
			'capability'  => 'edit_theme_options',
			'panel'       => 'blog',
		),
		'single_page_header'           => array(
			'title'       => esc_html__( 'Page Header on Single Blog', 'grd' ),
			'description' => '',
			'priority'    => 10,
			'capability'  => 'edit_theme_options',
			'panel'       => 'blog',
		),
		'single_post'                  => array(
			'title'       => esc_html__( 'Single Post', 'grd' ),
			'description' => '',
			'priority'    => 10,
			'capability'  => 'edit_theme_options',
			'panel'       => 'blog',
		),
		'service_page_header'          => array(
			'title'       => esc_html__( 'Page Header on Service Page', 'grd' ),
			'description' => '',
			'priority'    => 9,
			'capability'  => 'edit_theme_options',
			'panel'       => 'services',
		),
		'service_layout'               => array(
			'title'      => esc_html__( 'Service Layout', 'grd' ),
			'priority'   => 10,
			'capability' => 'edit_theme_options',
			'panel'      => 'services',
		),
		'single_service_page_header'   => array(
			'title'       => esc_html__( 'Page Header on Single Service', 'grd' ),
			'description' => '',
			'priority'    => 11,
			'capability'  => 'edit_theme_options',
			'panel'       => 'services',
		),
		'single_service'               => array(
			'title'       => esc_html__( 'Single Service', 'grd' ),
			'description' => '',
			'priority'    => 11,
			'capability'  => 'edit_theme_options',
			'panel'       => 'services',
		),
		'portfolio_page_header'        => array(
			'title'       => esc_html__( 'Page Header on Portfolio Page', 'grd' ),
			'description' => '',
			'priority'    => 10,
			'capability'  => 'edit_theme_options',
			'panel'       => 'portfolio',
		),
		'portfolio_layout'             => array(
			'title'      => esc_html__( 'Portfolio Layout', 'grd' ),
			'priority'   => 10,
			'capability' => 'edit_theme_options',
			'panel'      => 'portfolio',
		),
		'portfolio_single'             => array(
			'title'      => esc_html__( 'Portfolio Single', 'grd' ),
			'priority'   => 10,
			'capability' => 'edit_theme_options',
			'panel'      => 'portfolio',
		),
		'single_portfolio_page_header' => array(
			'title'       => esc_html__( 'Page Header on Single Portfolio', 'grd' ),
			'description' => '',
			'priority'    => 10,
			'capability'  => 'edit_theme_options',
			'panel'       => 'portfolio',
		),
		'shop_page_header'             => array(
			'title'       => esc_html__( 'Page Header on Shop Page', 'grd' ),
			'description' => '',
			'priority'    => 10,
			'capability'  => 'edit_theme_options',
			'panel'       => 'woocommerce',
		),
		'woocommerce_product_catalog'  => array(
			'title'       => esc_html__( 'Product Catalog', 'grd' ),
			'description' => '',
			'priority'    => 10,
			'capability'  => 'edit_theme_options',
			'panel'       => 'woocommerce',
		),
		'single_product_page_header'   => array(
			'title'       => esc_html__( 'Page Header on Single Product', 'grd' ),
			'description' => '',
			'priority'    => 10,
			'capability'  => 'edit_theme_options',
			'panel'       => 'woocommerce',
		),
		'single_product'               => array(
			'title'       => esc_html__( 'Single Product', 'grd' ),
			'description' => '',
			'priority'    => 10,
			'capability'  => 'edit_theme_options',
			'panel'       => 'woocommerce',
		),
		'shop_badge'                   => array(
			'title'       => esc_html__( 'Badges', 'grd' ),
			'description' => '',
			'priority'    => 80,
			'panel'       => 'woocommerce',
			'capability'  => 'edit_theme_options',
		),
		'footer'                       => array(
			'title'       => esc_html__( 'Footer', 'grd' ),
			'description' => '',
			'priority'    => 30,
			'capability'  => 'edit_theme_options',
		),
	);

	$fields = array(
		// Topbar
		'topbar_enable'                          => array(
			'type'     => 'toggle',
			'label'    => esc_html__( 'Show Topbar', 'grd' ),
			'section'  => 'topbar',
			'default'  => 1,
			'priority' => 10,
		),
		'topbar_mobile'                          => array(
			'type'     => 'toggle',
			'label'    => esc_html__( 'Show Topbar On Mobile', 'grd' ),
			'section'  => 'topbar',
			'default'  => 0,
			'priority' => 10,
		),

		// Typography
		'body_typo'                             => array(
			'type'     => 'typography',
			'label'    => esc_html__( 'Body', 'grd' ),
			'section'  => 'body_typo',
			'priority' => 10,
			'default'  => array(
				'font-family'    => 'Rubik',
				'variant'        => '400',
				'font-size'      => '16px',
				'line-height'    => '1.6',
				'letter-spacing' => '0',
				'subsets'        => array( 'latin-ext' ),
				'color'          => '#848484',
				'text-transform' => 'none',
			),
		),
		'heading1_typo'                         => array(
			'type'     => 'typography',
			'label'    => esc_html__( 'Heading 1', 'grd' ),
			'section'  => 'heading_typo',
			'priority' => 10,
			'default'  => array(
				'font-family'    => 'Poppins',
				'variant'        => '700',
				'font-size'      => '36px',
				'line-height'    => '1.2',
				'letter-spacing' => '0',
				'subsets'        => array( 'latin-ext' ),
				'color'          => '#848484',
				'text-transform' => 'none',
			),
		),
		'heading2_typo'                         => array(
			'type'     => 'typography',
			'label'    => esc_html__( 'Heading 2', 'grd' ),
			'section'  => 'heading_typo',
			'priority' => 10,
			'default'  => array(
				'font-family'    => 'Poppins',
				'variant'        => '700',
				'font-size'      => '30px',
				'line-height'    => '1.2',
				'letter-spacing' => '0',
				'subsets'        => array( 'latin-ext' ),
				'color'          => '#848484',
				'text-transform' => 'none',
			),
		),
		'heading3_typo'                         => array(
			'type'     => 'typography',
			'label'    => esc_html__( 'Heading 3', 'grd' ),
			'section'  => 'heading_typo',
			'priority' => 10,
			'default'  => array(
				'font-family'    => 'Poppins',
				'variant'        => '700',
				'font-size'      => '24px',
				'line-height'    => '1.2',
				'letter-spacing' => '0',
				'subsets'        => array( 'latin-ext' ),
				'color'          => '#848484',
				'text-transform' => 'none',
			),
		),
		'heading4_typo'                         => array(
			'type'     => 'typography',
			'label'    => esc_html__( 'Heading 4', 'grd' ),
			'section'  => 'heading_typo',
			'priority' => 10,
			'default'  => array(
				'font-family'    => 'Poppins',
				'variant'        => '700',
				'font-size'      => '18px',
				'line-height'    => '1.2',
				'letter-spacing' => '0',
				'subsets'        => array( 'latin-ext' ),
				'color'          => '#848484',
				'text-transform' => 'none',
			),
		),
		'heading5_typo'                         => array(
			'type'     => 'typography',
			'label'    => esc_html__( 'Heading 5', 'grd' ),
			'section'  => 'heading_typo',
			'priority' => 10,
			'default'  => array(
				'font-family'    => 'Poppins',
				'variant'        => '700',
				'font-size'      => '16px',
				'line-height'    => '1.2',
				'letter-spacing' => '0',
				'subsets'        => array( 'latin-ext' ),
				'color'          => '#848484',
				'text-transform' => 'none',
			),
		),
		'heading6_typo'                         => array(
			'type'     => 'typography',
			'label'    => esc_html__( 'Heading 6', 'grd' ),
			'section'  => 'heading_typo',
			'priority' => 10,
			'default'  => array(
				'font-family'    => 'Poppins',
				'variant'        => '700',
				'font-size'      => '12px',
				'line-height'    => '1.2',
				'letter-spacing' => '0',
				'subsets'        => array( 'latin-ext' ),
				'color'          => '#848484',
				'text-transform' => 'none',
			),
		),
		'menu_typo'                             => array(
			'type'     => 'typography',
			'label'    => esc_html__( 'Menu', 'grd' ),
			'section'  => 'header_typo',
			'priority' => 10,
			'default'  => array(
				'font-family'    => 'Rubik',
				'variant'        => '500',
				'subsets'        => array( 'latin-ext' ),
				'font-size'      => '14px',
				'color'          => '#2e2e2e',
				'text-transform' => 'uppercase',
			),
		),
		'sub_menu_typo'                         => array(
			'type'     => 'typography',
			'label'    => esc_html__( 'Sub Menu', 'grd' ),
			'section'  => 'header_typo',
			'priority' => 10,
			'default'  => array(
				'font-family'    => 'Rubik',
				'variant'        => '500',
				'subsets'        => array( 'latin-ext' ),
				'font-size'      => '16px',
				'color'          => '#2e2e2e',
				'text-transform' => 'capitalize',
			),
		),
		'footer_text_typo'                      => array(
			'type'     => 'typography',
			'label'    => esc_html__( 'Footer Text', 'grd' ),
			'section'  => 'footer_typo',
			'priority' => 10,
			'default'  => array(
				'font-family' => 'Rubik',
				'variant'     => '400',
				'subsets'     => array( 'latin-ext' ),
				'font-size'   => '16px',
				'color'   => '#a2b1a5',
			),
		),

		// Header layout
		'header_layout'                          => array(
			'type'     => 'select',
			'label'    => esc_html__( 'Header Layout', 'grd' ),
			'section'  => 'header',
			'default'  => 'v1',
			'priority' => 9,
			'choices'  => array(
				'v1' => esc_html__( 'Header v1', 'grd' ),
				'v2' => esc_html__( 'Header v2', 'grd' ),
				'v3' => esc_html__( 'Header v3', 'grd' ),
				'v4' => esc_html__( 'Header v4', 'grd' ),
			),
		),
		'header_item_cart'                       => array(
			'type'            => 'toggle',
			'label'           => esc_html__( 'Cart Item', 'grd' ),
			'section'         => 'header',
			'default'         => '1',
			'priority'        => 10,
			'active_callback' => array(
				array(
					'setting'  => 'header_layout',
					'operator' => 'in',
					'value'    => array( 'v1', 'v2' ),
				),
			),
		),
		'header_item_schedule'                   => array(
			'type'            => 'toggle',
			'label'           => esc_html__( 'Schedule Item', 'grd' ),
			'section'         => 'header',
			'default'         => '1',
			'priority'        => 10,
			'active_callback' => array(
				array(
					'setting'  => 'header_layout',
					'operator' => 'in',
					'value'    => array( 'v1', 'v2', 'v4' ),
				),
			),
		),
		'header_item_schedule_icon'              => array(
			'type'            => 'text',
			'label'           => esc_html__( 'Schedule Icon', 'grd' ),
			'section'         => 'header',
			'default'         => esc_html__( 'calendar', 'grd' ),
			'description' => esc_html__( 'Change name icon to font awesome', 'grd' ),
			'priority'        => 10,
			'active_callback' => array(
				array(
					'setting'  => 'header_layout',
					'operator' => 'in',
					'value'    => array( 'v1', 'v2', 'v4' ),
				),
				array(
					'setting'  => 'header_item_schedule',
					'operator' => '==',
					'value'    => '1',
				),
			),
		),
		'header_item_schedule_text'              => array(
			'type'            => 'text',
			'label'           => esc_html__( 'Schedule Text', 'grd' ),
			'section'         => 'header',
			'default'         => '',
			'priority'        => 10,
			'active_callback' => array(
				array(
					'setting'  => 'header_layout',
					'operator' => 'in',
					'value'    => array( 'v1', 'v2', 'v4' ),
				),
				array(
					'setting'  => 'header_item_schedule',
					'operator' => '==',
					'value'    => '1',
				),
			),
		),
		'header_item_schedule_link'              => array(
			'type'            => 'text',
			'label'           => esc_html__( 'Schedule link', 'grd' ),
			'section'         => 'header',
			'default'         => '',
			'priority'        => 10,
			'active_callback' => array(
				array(
					'setting'  => 'header_layout',
					'operator' => 'in',
					'value'    => array( 'v1', 'v2', 'v4' ),
				),
				array(
					'setting'  => 'header_item_schedule',
					'operator' => '==',
					'value'    => '1',
				),
			),
		),
		'header_item_search'                     => array(
			'type'            => 'toggle',
			'label'           => esc_html__( 'Search Item', 'grd' ),
			'section'         => 'header',
			'default'         => '1',
			'priority'        => 10,
			'active_callback' => array(
				array(
					'setting'  => 'header_layout',
					'operator' => 'in',
					'value'    => array( 'v2', 'v3', 'v4' ),
				),
			),
		),
		'header_transparent'                     => array(
			'type'            => 'toggle',
			'label'           => esc_html__( 'Header Transparent', 'grd' ),
			'section'         => 'header',
			'default'         => '',
			'priority'        => 9,
			'active_callback' => array(
				array(
					'setting'  => 'header_layout',
					'operator' => '==',
					'value'    => 'v3',
				),
			),
		),
		'header_transparent_header_color'        => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Header Color', 'grd' ),
			'default'         => '',
			'section'         => 'header',
			'priority'        => 10,
			'active_callback' => array(
				array(
					'setting'  => 'header_transparent',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'header_transparent_nav_color'           => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Navigation Color', 'grd' ),
			'default'         => '',
			'section'         => 'header',
			'priority'        => 10,
			'active_callback' => array(
				array(
					'setting'  => 'header_transparent',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'post_custom_field_1'                    => array(
			'type'    => 'custom',
			'section' => 'header',
			'default' => '<hr/>',
		),
		'header_social'                          => array(
			'type'            => 'repeater',
			'label'           => esc_html__( 'Socials', 'grd' ),
			'section'         => 'header',
			'priority'        => 20,
			'default'         => array(
				array(
					'link_url' => '',
				),
				array(
					'link_url' => '',
				),
				array(
					'link_url' => '',
				),
				array(
					'link_url' => '',
				),
			),
			'fields'          => array(
				'link_url' => array(
					'type'        => 'text',
					'label'       => esc_html__( 'Social URL', 'grd' ),
					'description' => esc_html__( 'Enter the URL for this social', 'grd' ),
					'default'     => '',
				),
			),
			'active_callback' => array(
				array(
					'setting'  => 'header_layout',
					'operator' => 'in',
					'value'    => array( 'v4' ),
				),
			),
		),

		// Logo
		'logo_image'                             => array(
			'type'     => 'image',
			'label'    => esc_html__( 'Logo', 'grd' ),
			'section'  => 'logo',
			'default'  => '',
			'priority' => 10,
		),
		'logo_image_sticky'                             => array(
			'type'     => 'image',
			'label'    => esc_html__( 'Logo Sticky', 'grd' ),
			'section'  => 'logo',
			'default'  => '',
			'priority' => 10,
		),
		'logo_width'                             => array(
			'type'     => 'number',
			'label'    => esc_html__( 'Logo Width', 'grd' ),
			'section'  => 'logo',
			'default'  => '253',
			'priority' => 10,
		),
		'logo_height'                            => array(
			'type'     => 'number',
			'label'    => esc_html__( 'Logo Height', 'grd' ),
			'section'  => 'logo',
			'default'  => '',
			'priority' => 10,
		),
		'logo_position'                          => array(
			'type'     => 'spacing',
			'label'    => esc_html__( 'Logo Margin', 'grd' ),
			'section'  => 'logo',
			'priority' => 10,
			'default'  => array(
				'top'    => '0',
				'bottom' => '0',
				'left'   => '0',
				'right'  => '0',
			),
		),

		'header_sticky'                   => array(
			'type'     => 'toggle',
			'label'    => esc_html__( 'Header Sticky', 'grd' ),
			'default'  => 0,
			'section'  => 'header',
			'priority' => 100,
		),

		// Color Scheme
		'color_scheme'                          => array(
			'type'     => 'palette',
			'label'    => esc_html__( 'Base Color Scheme', 'grd' ),
			'default'  => '',
			'section'  => 'color_scheme',
			'priority' => 10,
			'choices'  => array(
				'' => array( '#9cc212' ),
				'#00baff' => array( '#00baff' ),
				'#ee6012' => array( '#ee6012' ),
				'#00cc00' => array( '#00cc00' ),
				'#e83f39' => array( '#e83f39' ),
			),
		),
		'custom_color_scheme'                   => array(
			'type'     => 'toggle',
			'label'    => esc_html__( 'Custom Color Scheme', 'grd' ),
			'default'  => 0,
			'section'  => 'color_scheme',
			'priority' => 10,
		),
		'custom_color'                          => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Color', 'grd' ),
			'default'         => '',
			'section'         => 'color_scheme',
			'priority'        => 10,
			'active_callback' => array(
				array(
					'setting'  => 'custom_color_scheme',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),

		// Page
		'page_layout'                            => array(
			'type'        => 'select',
			'label'       => esc_html__( 'Page Layout', 'grd' ),
			'section'     => 'page_layout',
			'default'     => 'full-content',
			'priority'    => 10,
			'description' => esc_html__( 'Select default sidebar for page default.', 'grd' ),
			'choices'     => array(
				'full-content'    => esc_html__( 'Full Content', 'grd' ),
				'sidebar-content' => esc_html__( 'Left Sidebar', 'grd' ),
				'content-sidebar' => esc_html__( 'Right Sidebar', 'grd' ),
			),
		),
		'page_page_header'                       => array(
			'type'        => 'toggle',
			'label'       => esc_html__( 'Page Header', 'grd' ),
			'default'     => 1,
			'section'     => 'page_header',
			'priority'    => 10,
			'description' => esc_html__( 'Check this option to show the page header below the header.', 'grd' ),
		),
		'page_page_header_els'                   => array(
			'type'            => 'multicheck',
			'label'           => esc_html__( 'Page Header Elements', 'grd' ),
			'section'         => 'page_header',
			'default'         => array( 'breadcrumb', 'title' ),
			'priority'        => 20,
			'choices'         => array(
				'breadcrumb' => esc_html__( 'BreadCrumb', 'grd' ),
				'title'      => esc_html__( 'Title', 'grd' ),
			),
			'description'     => esc_html__( 'Select which elements you want to show.', 'grd' ),
			'active_callback' => array(
				array(
					'setting'  => 'page_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'page_page_header_color'                 => array(
			'type'     => 'color',
			'label'    => esc_html__( 'Background Color Overlay', 'grd' ),
			'section'  => 'page_header',
			'default'  => '',
			'priority' => 30,
			'choices'  => array(
				'alpha' => true,
			),
		),
		'page_page_header_bg'                    => array(
			'type'            => 'image',
			'label'           => esc_html__( 'Background Image', 'grd' ),
			'section'         => 'page_header',
			'default'         => '',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'page_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'page_page_header_title_color'           => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Title Color', 'grd' ),
			'default'         => '',
			'section'         => 'page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'page_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'page_page_header_breadcrumb_color'      => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Breadcrumb Color', 'grd' ),
			'default'         => '',
			'section'         => 'page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'page_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'page_page_header_breadcrumb_link_color' => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Breadcrumb Link Color', 'grd' ),
			'default'         => '',
			'section'         => 'page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'page_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'page_page_header_parallax'              => array(
			'type'            => 'toggle',
			'label'           => esc_html__( 'Parallax', 'grd' ),
			'default'         => 1,
			'section'         => 'page_header',
			'priority'        => 30,
			'description'     => esc_html__( 'Check this option to enable parallax for the page header.', 'grd' ),
			'active_callback' => array(
				array(
					'setting'  => 'page_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),

		// Blog Page Header
		'blog_page_header'                       => array(
			'type'        => 'toggle',
			'label'       => esc_html__( 'Page Header', 'grd' ),
			'default'     => 1,
			'section'     => 'blog_page_header',
			'priority'    => 10,
			'description' => esc_html__( 'Check this option to show the page header below the header.', 'grd' ),
		),
		'blog_page_header_els'                   => array(
			'type'            => 'multicheck',
			'label'           => esc_html__( 'Page Header Elements', 'grd' ),
			'section'         => 'blog_page_header',
			'default'         => array( 'breadcrumb', 'title' ),
			'priority'        => 20,
			'choices'         => array(
				'breadcrumb' => esc_html__( 'BreadCrumb', 'grd' ),
				'title'      => esc_html__( 'Title', 'grd' ),
			),
			'description'     => esc_html__( 'Select which elements you want to show.', 'grd' ),
			'active_callback' => array(
				array(
					'setting'  => 'blog_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'blog_page_header_color'                 => array(
			'type'     => 'color',
			'label'    => esc_html__( 'Background Color Overlay', 'grd' ),
			'section'  => 'blog_page_header',
			'default'  => '',
			'priority' => 30,
			'choices'  => array(
				'alpha' => true,
			),
		),
		'blog_page_header_bg'                    => array(
			'type'            => 'image',
			'label'           => esc_html__( 'Bacground Image', 'grd' ),
			'section'         => 'blog_page_header',
			'default'         => '',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'blog_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'blog_page_header_title_color'           => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Title Color', 'grd' ),
			'default'         => '',
			'section'         => 'blog_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'blog_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'blog_page_header_breadcrumb_color'      => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Breadcrumb Color', 'grd' ),
			'default'         => '',
			'section'         => 'blog_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'blog_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'blog_page_header_breadcrumb_link_color' => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Breadcrumb Link Color', 'grd' ),
			'default'         => '',
			'section'         => 'blog_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'blog_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'blog_page_header_parallax'              => array(
			'type'            => 'toggle',
			'label'           => esc_html__( 'Parallax', 'grd' ),
			'default'         => 1,
			'section'         => 'blog_page_header',
			'priority'        => 30,
			'description'     => esc_html__( 'Check this option to enable parallax for the page header.', 'grd' ),
			'active_callback' => array(
				array(
					'setting'  => 'blog_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),

		// Blog
		'blog_layout'                            => array(
			'type'        => 'select',
			'label'       => esc_html__( 'Blog Layout', 'grd' ),
			'section'     => 'blog_page',
			'default'     => 'content-sidebar',
			'priority'    => 10,
			'description' => esc_html__( 'Select default sidebar for blog page.', 'grd' ),
			'choices'     => array(
				'content-sidebar' => esc_html__( 'Right Sidebar', 'grd' ),
				'sidebar-content' => esc_html__( 'Left Sidebar', 'grd' ),
				'full-content'    => esc_html__( 'Full Content', 'grd' ),
			),
		),
		'blog_view'                              => array(
			'type'     => 'radio',
			'label'    => esc_html__( 'Blog Style', 'grd' ),
			'section'  => 'blog_page',
			'default'  => 'classic',
			'priority' => 10,
			'choices'  => array(
				'classic' => esc_html__( 'Classic', 'grd' ),
				'grid'    => esc_html__( 'Grid', 'grd' ),
			),
		),
		'blog_grid_columns'                      => array(
			'type'            => 'select',
			'label'           => esc_html__( 'Blog Grid Columns', 'grd' ),
			'section'         => 'blog_page',
			'default'         => '3',
			'priority'        => 10,
			'choices'         => array(
				'3' => esc_html__( '3 Columns', 'grd' ),
				'2' => esc_html__( '2 Columns', 'grd' ),
			),
			'active_callback' => array(
				array(
					'setting'  => 'blog_view',
					'operator' => '==',
					'value'    => 'grid',
				),
			),
		),

		'blog_classic_excerpt_length'                        => array(
			'type'     => 'number',
			'label'    => esc_html__( 'Blog Classic Excerpt Length', 'grd' ),
			'section'  => 'blog_page',
			'default'  => 30,
			'priority' => 10,
		),
		'blog_entry_meta'                                    => array(
			'type'     => 'multicheck',
			'label'    => esc_html__( 'Entry Meta', 'grd' ),
			'section'  => 'blog_page',
			'default'  => array( 'date', 'author' ),
			'choices'  => array(
				'date'    => esc_html__( 'Date', 'grd' ),
				'author'  => esc_html__( 'Author', 'grd' ),
				'cat'     => esc_html__( 'Cat', 'grd' ),
				'comment' => esc_html__( 'Comment', 'grd' ),
			),
			'priority' => 10,
		),

		// Post Page Header
		'single_page_header'                                 => array(
			'type'        => 'toggle',
			'label'       => esc_html__( 'Page Header', 'grd' ),
			'default'     => 1,
			'section'     => 'single_page_header',
			'priority'    => 10,
			'description' => esc_html__( 'Check this option to show the page header below the header.', 'grd' ),
		),
		'single_page_header_els'                             => array(
			'type'            => 'multicheck',
			'label'           => esc_html__( 'Page Header Elements', 'grd' ),
			'section'         => 'single_page_header',
			'default'         => array( 'breadcrumb', 'title' ),
			'priority'        => 20,
			'choices'         => array(
				'breadcrumb' => esc_html__( 'BreadCrumb', 'grd' ),
				'title'      => esc_html__( 'Title', 'grd' ),
			),
			'description'     => esc_html__( 'Select which elements you want to show.', 'grd' ),
			'active_callback' => array(
				array(
					'setting'  => 'single_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'single_page_header_color'                           => array(
			'type'     => 'color',
			'label'    => esc_html__( 'Background Color Overlay', 'grd' ),
			'section'  => 'single_page_header',
			'default'  => '',
			'priority' => 30,
			'choices'  => array(
				'alpha' => true,
			),
		),
		'single_page_header_bg'                              => array(
			'type'            => 'image',
			'label'           => esc_html__( 'Bacground Image', 'grd' ),
			'section'         => 'single_page_header',
			'default'         => '',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'single_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'single_page_header_title_color'                     => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Title Color', 'grd' ),
			'default'         => '',
			'section'         => 'single_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'single_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'single_page_header_breadcrumb_color'                => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Breadcrumb Color', 'grd' ),
			'default'         => '',
			'section'         => 'single_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'single_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'single_page_header_breadcrumb_link_color'           => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Breadcrumb Link Color', 'grd' ),
			'default'         => '',
			'section'         => 'single_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'single_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'single_page_header_parallax'                        => array(
			'type'            => 'toggle',
			'label'           => esc_html__( 'Parallax', 'grd' ),
			'default'         => 1,
			'section'         => 'single_page_header',
			'priority'        => 30,
			'description'     => esc_html__( 'Check this option to enable parallax for the page header.', 'grd' ),
			'active_callback' => array(
				array(
					'setting'  => 'single_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),

		// Single Posts
		'single_post_layout'                                 => array(
			'type'        => 'select',
			'label'       => esc_html__( 'Single Post Layout', 'grd' ),
			'section'     => 'single_post',
			'default'     => 'full-content',
			'priority'    => 5,
			'description' => esc_html__( 'Select default sidebar for the single post page.', 'grd' ),
			'choices'     => array(
				'content-sidebar' => esc_html__( 'Right Sidebar', 'grd' ),
				'sidebar-content' => esc_html__( 'Left Sidebar', 'grd' ),
				'full-content'    => esc_html__( 'Full Content', 'grd' ),
			),
		),

		'post_custom_field_2'                                => array(
			'type'    => 'custom',
			'section' => 'single_post',
			'default' => '<hr/>',
		),
		'post_share_box'                                     => array(
			'type'        => 'toggle',
			'label'       => esc_html__( 'Show Sharing Icons', 'grd' ),
			'section'     => 'single_post',
			'default'     => 0,
			'description' => esc_html__( 'Display social sharing icons on single post', 'grd' ),
			'priority'    => 20,
		),
		'post_social_icons'                                  => array(
			'type'            => 'multicheck',
			'label'           => esc_html__( 'Social Icons', 'grd' ),
			'section'         => 'single_post',
			'default'         => array( 'facebook', 'twitter', 'pinterest', 'google', 'linkedin', 'vkontakte' ),
			'priority'        => 60,
			'choices'         => array(
				'facebook'  => esc_html__( 'Facebook', 'grd' ),
				'twitter'   => esc_html__( 'Twitter', 'grd' ),
				'google'    => esc_html__( 'Google Plus', 'grd' ),
				'pinterest' => esc_html__( 'Pinterest', 'grd' ),
				'linkedin'  => esc_html__( 'Linkedin', 'grd' ),
				'vkontakte' => esc_html__( 'Vkontakte', 'grd' ),
			),
			'active_callback' => array(
				array(
					'setting'  => 'post_share_box',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),

		// Service Page Header
		'service_page_header'                                => array(
			'type'        => 'toggle',
			'label'       => esc_html__( 'Page Header', 'grd' ),
			'default'     => 1,
			'section'     => 'service_page_header',
			'priority'    => 10,
			'description' => esc_html__( 'Check this option to show the page header below the header.', 'grd' ),
		),
		'service_page_header_els'                            => array(
			'type'            => 'multicheck',
			'label'           => esc_html__( 'Page Header Elements', 'grd' ),
			'section'         => 'service_page_header',
			'default'         => array( 'breadcrumb', 'title' ),
			'priority'        => 20,
			'choices'         => array(
				'breadcrumb' => esc_html__( 'BreadCrumb', 'grd' ),
				'title'      => esc_html__( 'Title', 'grd' ),
			),
			'description'     => esc_html__( 'Select which elements you want to show.', 'grd' ),
			'active_callback' => array(
				array(
					'setting'  => 'service_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'service_page_header_color'                          => array(
			'type'     => 'color',
			'label'    => esc_html__( 'Background Color Overlay', 'grd' ),
			'section'  => 'service_page_header',
			'default'  => '',
			'priority' => 30,
			'choices'  => array(
				'alpha' => true,
			),
		),
		'service_page_header_bg'                             => array(
			'type'            => 'image',
			'label'           => esc_html__( 'Bacground Image', 'grd' ),
			'section'         => 'service_page_header',
			'default'         => '',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'service_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'service_page_header_title_color'                    => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Title Color', 'grd' ),
			'default'         => '',
			'section'         => 'service_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'service_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'service_page_header_breadcrumb_color'               => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Breadcrumb Color', 'grd' ),
			'default'         => '',
			'section'         => 'service_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'service_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'service_page_header_breadcrumb_link_color'          => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Breadcrumb Link Color', 'grd' ),
			'default'         => '',
			'section'         => 'service_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'service_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'service_page_header_parallax'                       => array(
			'type'            => 'toggle',
			'label'           => esc_html__( 'Parallax', 'grd' ),
			'default'         => 1,
			'section'         => 'service_page_header',
			'priority'        => 30,
			'description'     => esc_html__( 'Check this option to enable parallax for the page header.', 'grd' ),
			'active_callback' => array(
				array(
					'setting'  => 'service_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),

		// Service Page Layout
		'service_layout'                                     => array(
			'type'     => 'select',
			'label'    => esc_html__( 'Service layout', 'grd' ),
			'priority' => 10,
			'default'  => 'grid',
			'section'  => 'service_layout',
			'choices'  => array(
				'grid'       => esc_html__( 'Grid', 'grd' ),
				'full-width' => esc_html__( 'List', 'grd' ),

			),
		),
		'service_columns'                                    => array(
			'type'            => 'select',
			'label'           => esc_html__( 'Columns', 'grd' ),
			'priority'        => 10,
			'default'         => '3',
			'section'         => 'service_layout',
			'choices'         => array(
				'2' => esc_html__( '2 Columns', 'grd' ),
				'3' => esc_html__( '3 Columns', 'grd' ),
				'4' => esc_html__( '4 Columns', 'grd' ),
			),
			'active_callback' => array(
				array(
					'setting'  => 'service_layout',
					'operator' => '==',
					'value'    => 'grid',
				),
			),
		),
		'service_limit'                                      => array(
			'type'     => 'number',
			'label'    => esc_html__( 'Content Limit', 'grd' ),
			'priority' => 10,
			'default'  => '20',
			'section'  => 'service_layout',
		),

		// Single Service Page Header
		'single_service_page_header'                         => array(
			'type'        => 'toggle',
			'label'       => esc_html__( 'Page Header', 'grd' ),
			'default'     => 1,
			'section'     => 'single_service_page_header',
			'priority'    => 10,
			'description' => esc_html__( 'Check this option to show the page header below the header.', 'grd' ),
		),
		'single_service_page_header_els'                     => array(
			'type'            => 'multicheck',
			'label'           => esc_html__( 'Page Header Elements', 'grd' ),
			'section'         => 'single_service_page_header',
			'default'         => array( 'breadcrumb', 'title' ),
			'priority'        => 20,
			'choices'         => array(
				'breadcrumb' => esc_html__( 'BreadCrumb', 'grd' ),
				'title'      => esc_html__( 'Title', 'grd' ),
			),
			'description'     => esc_html__( 'Select which elements you want to show.', 'grd' ),
			'active_callback' => array(
				array(
					'setting'  => 'single_service_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'single_service_page_header_color'                   => array(
			'type'     => 'color',
			'label'    => esc_html__( 'Background Color Overlay', 'grd' ),
			'section'  => 'single_service_page_header',
			'default'  => '',
			'priority' => 30,
			'choices'  => array(
				'alpha' => true,
			),
		),
		'single_service_page_header_bg'                      => array(
			'type'            => 'image',
			'label'           => esc_html__( 'Bacground Image', 'grd' ),
			'section'         => 'single_service_page_header',
			'default'         => '',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'single_service_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'single_service_page_header_title_color'             => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Title Color', 'grd' ),
			'default'         => '',
			'section'         => 'single_service_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'single_service_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'single_service_page_header_breadcrumb_color'        => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Breadcrumb Color', 'grd' ),
			'default'         => '',
			'section'         => 'single_service_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'single_service_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'single_service_page_header_breadcrumb_link_color'   => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Breadcrumb Link Color', 'grd' ),
			'default'         => '',
			'section'         => 'single_service_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'single_service_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'single_service_page_header_parallax'                => array(
			'type'            => 'toggle',
			'label'           => esc_html__( 'Parallax', 'grd' ),
			'default'         => 1,
			'section'         => 'single_service_page_header',
			'priority'        => 30,
			'description'     => esc_html__( 'Check this option to enable parallax for the page header.', 'grd' ),
			'active_callback' => array(
				array(
					'setting'  => 'single_service_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),

		// Single Service
		'single_service_layout'                              => array(
			'type'        => 'select',
			'label'       => esc_html__( 'Single Service Layout', 'grd' ),
			'section'     => 'single_service',
			'default'     => 'content-sidebar',
			'priority'    => 5,
			'description' => esc_html__( 'Select default sidebar for the single service page.', 'grd' ),
			'choices'     => array(
				'content-sidebar' => esc_html__( 'Right Sidebar', 'grd' ),
				'sidebar-content' => esc_html__( 'Left Sidebar', 'grd' ),
				'full-content'    => esc_html__( 'Full Content', 'grd' ),
			),
		),

		// Portfolio Page Header
		'portfolio_page_header'                              => array(
			'type'        => 'toggle',
			'label'       => esc_html__( 'Page Header', 'grd' ),
			'default'     => 1,
			'section'     => 'portfolio_page_header',
			'priority'    => 10,
			'description' => esc_html__( 'Check this option to show the page header below the header.', 'grd' ),
		),
		'portfolio_page_header_els'                          => array(
			'type'            => 'multicheck',
			'label'           => esc_html__( 'Page Header Elements', 'grd' ),
			'section'         => 'portfolio_page_header',
			'default'         => array( 'breadcrumb', 'title' ),
			'priority'        => 20,
			'choices'         => array(
				'breadcrumb' => esc_html__( 'BreadCrumb', 'grd' ),
				'title'      => esc_html__( 'Title', 'grd' ),
			),
			'description'     => esc_html__( 'Select which elements you want to show.', 'grd' ),
			'active_callback' => array(
				array(
					'setting'  => 'portfolio_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'portfolio_page_header_color'                        => array(
			'type'     => 'color',
			'label'    => esc_html__( 'Background Color Overlay', 'grd' ),
			'section'  => 'portfolio_page_header',
			'default'  => '',
			'priority' => 30,
			'choices'  => array(
				'alpha' => true,
			),
		),
		'portfolio_page_header_bg'                           => array(
			'type'            => 'image',
			'label'           => esc_html__( 'Bacground Image', 'grd' ),
			'section'         => 'portfolio_page_header',
			'default'         => '',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'portfolio_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'portfolio_page_header_title_color'                  => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Title Color', 'grd' ),
			'default'         => '',
			'section'         => 'portfolio_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'portfolio_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'portfolio_page_header_breadcrumb_color'             => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Breadcrumb Color', 'grd' ),
			'default'         => '',
			'section'         => 'portfolio_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'portfolio_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'portfolio_page_header_breadcrumb_link_color'        => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Breadcrumb Link Color', 'grd' ),
			'default'         => '',
			'section'         => 'portfolio_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'portfolio_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'portfolio_page_header_parallax'                     => array(
			'type'            => 'toggle',
			'label'           => esc_html__( 'Parallax', 'grd' ),
			'default'         => 1,
			'section'         => 'portfolio_page_header',
			'priority'        => 30,
			'description'     => esc_html__( 'Check this option to enable parallax for the page header.', 'grd' ),
			'active_callback' => array(
				array(
					'setting'  => 'portfolio_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),

		// Page Layout Portfolio
		'portfolio_layout'                                   => array(
			'type'     => 'select',
			'label'    => esc_html__( 'Portfolio Layout', 'grd' ),
			'priority' => 10,
			'default'  => 'full-width',
			'section'  => 'portfolio_layout',
			'choices'  => array(
				'classic'    => esc_html__( 'Classic', 'grd' ),
				'modern'     => esc_html__( 'Modern', 'grd' ),
				'full-width' => esc_html__( 'Full width', 'grd' ),
			),
		),
		'portfolio_cats_filters'                             => array(
			'type'     => 'toggle',
			'label'    => esc_html__( 'Portfolio Categories Filters', 'grd' ),
			'priority' => 10,
			'default'  => '1',
			'section'  => 'portfolio_layout',

		),
		'portfolio_cat_number'                               => array(
			'type'            => 'number',
			'label'           => esc_html__( 'Categorize  number', 'grd' ),
			'priority'        => 10,
			'default'         => '10',
			'section'         => 'portfolio_layout',
			'active_callback' => array(
				array(
					'setting'  => 'portfolio_cats_filters',
					'operator' => '==',
					'value'    => '1',
				),
			),

		),
		'portfolio_pagination'                               => array(
			'type'     => 'toggle',
			'label'    => esc_html__( 'Pagination', 'grd' ),
			'priority' => 10,
			'default'  => '1',
			'section'  => 'portfolio_layout',

		),
		'portfolio_pagination_style'                         => array(
			'type'            => 'radio',
			'label'           => esc_html__( 'Pagination style', 'grd' ),
			'priority'        => 10,
			'default'         => '1',
			'section'         => 'portfolio_layout',
			'choices'         => array(
				'1' => esc_html__( 'Number', 'grd' ),
				'2' => esc_html__( 'Load more', 'grd' ),
			),
			'active_callback' => array(
				array(
					'setting'  => 'portfolio_pagination',
					'operator' => '==',
					'value'    => '1',
				),
			),

		),
		'portfolio_single_thumbnail'                         => array(
			'type'     => 'toggle',
			'label'    => esc_html__( 'Featured Image', 'grd' ),
			'priority' => 10,
			'default'  => '1',
			'section'  => 'portfolio_page',
		),
		'portfolio_single_title'                             => array(
			'type'     => 'toggle',
			'label'    => esc_html__( 'Title', 'grd' ),
			'priority' => 10,
			'default'  => '1',
			'section'  => 'portfolio_page',
		),

		// Single Portfolio Page Header
		'single_portfolio_page_header'                       => array(
			'type'        => 'toggle',
			'label'       => esc_html__( 'Page Header', 'grd' ),
			'default'     => 1,
			'section'     => 'single_portfolio_page_header',
			'priority'    => 10,
			'description' => esc_html__( 'Check this option to show the page header below the header.', 'grd' ),
		),
		'single_portfolio_page_header_els'                   => array(
			'type'            => 'multicheck',
			'label'           => esc_html__( 'Page Header Elements', 'grd' ),
			'section'         => 'single_portfolio_page_header',
			'default'         => array( 'breadcrumb', 'title' ),
			'priority'        => 20,
			'choices'         => array(
				'breadcrumb' => esc_html__( 'BreadCrumb', 'grd' ),
				'title'      => esc_html__( 'Title', 'grd' ),
			),
			'description'     => esc_html__( 'Select which elements you want to show.', 'grd' ),
			'active_callback' => array(
				array(
					'setting'  => 'single_portfolio_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'single_portfolio_page_header_color'                 => array(
			'type'     => 'color',
			'label'    => esc_html__( 'Background Color Overlay', 'grd' ),
			'section'  => 'single_portfolio_page_header',
			'default'  => '',
			'priority' => 30,
			'choices'  => array(
				'alpha' => true,
			),
		),
		'single_portfolio_page_header_bg'                    => array(
			'type'            => 'image',
			'label'           => esc_html__( 'Bacground Image', 'grd' ),
			'section'         => 'single_portfolio_page_header',
			'default'         => '',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'single_portfolio_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'single_portfolio_page_header_title_color'           => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Title Color', 'grd' ),
			'default'         => '',
			'section'         => 'single_portfolio_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'single_portfolio_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'single_portfolio_page_header_breadcrumb_color'      => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Breadcrumb Color', 'grd' ),
			'default'         => '',
			'section'         => 'single_portfolio_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'single_portfolio_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'single_portfolio_page_header_breadcrumb_link_color' => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Breadcrumb Link Color', 'grd' ),
			'default'         => '',
			'section'         => 'single_portfolio_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'single_portfolio_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'single_portfolio_page_header_parallax'              => array(
			'type'            => 'toggle',
			'label'           => esc_html__( 'Parallax', 'grd' ),
			'default'         => 1,
			'section'         => 'single_portfolio_page_header',
			'priority'        => 30,
			'description'     => esc_html__( 'Check this option to enable parallax for the page header.', 'grd' ),
			'active_callback' => array(
				array(
					'setting'  => 'single_portfolio_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		// Single Portfolio
		'portfolio_single_nav'                               => array(
			'type'     => 'toggle',
			'label'    => esc_html__( 'Navigation', 'grd' ),
			'default'  => 1,
			'section'  => 'portfolio_single',
			'priority' => 10,

		),
		'portfolio_single_project'                           => array(
			'type'            => 'text',
			'label'           => esc_html__( 'Go to Project Link', 'grd' ),
			'default'         => '',
			'section'         => 'portfolio_single',
			'priority'        => 10,
			'active_callback' => array(
				array(
					'setting'  => 'portfolio_single_nav',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),

		// Page Header for Shop
		'page_header_shop'                                   => array(
			'type'        => 'toggle',
			'label'       => esc_html__( 'Page Header', 'grd' ),
			'default'     => 1,
			'section'     => 'shop_page_header',
			'priority'    => 10,
			'description' => esc_html__( 'Check this option to show the page header below the header.', 'grd' ),
		),
		'page_header_shop_els'                               => array(
			'type'            => 'multicheck',
			'label'           => esc_html__( 'Page Header Elements', 'grd' ),
			'section'         => 'shop_page_header',
			'default'         => array( 'breadcrumb', 'title' ),
			'priority'        => 20,
			'choices'         => array(
				'breadcrumb' => esc_html__( 'BreadCrumb', 'grd' ),
				'title'      => esc_html__( 'Title', 'grd' ),
			),
			'description'     => esc_html__( 'Select which elements you want to show.', 'grd' ),
			'active_callback' => array(
				array(
					'setting'  => 'page_header_shop',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'page_header_shop_color'                             => array(
			'type'     => 'color',
			'label'    => esc_html__( 'Background Color Overlay', 'grd' ),
			'section'  => 'shop_page_header',
			'default'  => '',
			'priority' => 30,
			'choices'  => array(
				'alpha' => true,
			),
		),
		'page_header_shop_bg'                                => array(
			'type'            => 'image',
			'label'           => esc_html__( 'Bacground Image', 'grd' ),
			'section'         => 'shop_page_header',
			'default'         => '',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'page_header_shop',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'page_header_shop_title_color'                       => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Title Color', 'grd' ),
			'default'         => '',
			'section'         => 'shop_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'page_header_shop',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'page_header_shop_breadcrumb_color'                  => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Breadcrumb Color', 'grd' ),
			'default'         => '',
			'section'         => 'shop_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'page_header_shop',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'page_header_shop_breadcrumb_link_color'             => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Breadcrumb Link Color', 'grd' ),
			'default'         => '',
			'section'         => 'shop_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'page_header_shop',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'page_header_shop_parallax'                          => array(
			'type'            => 'toggle',
			'label'           => esc_html__( 'Parallax', 'grd' ),
			'default'         => 1,
			'section'         => 'shop_page_header',
			'priority'        => 30,
			'description'     => esc_html__( 'Check this option to enable parallax for the page header.', 'grd' ),
			'active_callback' => array(
				array(
					'setting'  => 'page_header_shop',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),

		// Shop Page
		'shop_layout'                                        => array(
			'type'        => 'select',
			'label'       => esc_html__( 'Shop Layout', 'grd' ),
			'default'     => 'full-content',
			'section'     => 'woocommerce_product_catalog',
			'priority'    => 20,
			'description' => esc_html__( 'Select default sidebar for shop page.', 'grd' ),
			'choices'     => array(
				'sidebar-content' => esc_html__( 'Left Sidebar', 'grd' ),
				'content-sidebar' => esc_html__( 'Right Sidebar', 'grd' ),
				'full-content'    => esc_html__( 'Full Content', 'grd' ),
			),
		),

		// Single Product Page Header
		'single_product_page_header'                         => array(
			'type'        => 'toggle',
			'label'       => esc_html__( 'Page Header', 'grd' ),
			'default'     => 1,
			'section'     => 'single_product_page_header',
			'priority'    => 10,
			'description' => esc_html__( 'Check this option to show the page header below the header.', 'grd' ),
		),
		'single_product_page_header_els'                     => array(
			'type'            => 'multicheck',
			'label'           => esc_html__( 'Page Header Elements', 'grd' ),
			'section'         => 'single_product_page_header',
			'default'         => array( 'breadcrumb', 'title' ),
			'priority'        => 20,
			'choices'         => array(
				'breadcrumb' => esc_html__( 'BreadCrumb', 'grd' ),
				'title'      => esc_html__( 'Title', 'grd' ),
			),
			'description'     => esc_html__( 'Select which elements you want to show.', 'grd' ),
			'active_callback' => array(
				array(
					'setting'  => 'single_product_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'single_product_page_header_color'                   => array(
			'type'     => 'color',
			'label'    => esc_html__( 'Background Color Overlay', 'grd' ),
			'section'  => 'single_product_page_header',
			'default'  => '',
			'priority' => 30,
			'choices'  => array(
				'alpha' => true,
			),
		),
		'single_product_page_header_bg'                      => array(
			'type'            => 'image',
			'label'           => esc_html__( 'Bacground Image', 'grd' ),
			'section'         => 'single_product_page_header',
			'default'         => '',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'single_product_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'single_product_page_header_title_color'             => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Title Color', 'grd' ),
			'default'         => '',
			'section'         => 'single_product_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'single_product_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'single_product_page_header_breadcrumb_color'        => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Breadcrumb Color', 'grd' ),
			'default'         => '',
			'section'         => 'single_product_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'single_product_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'single_product_page_header_breadcrumb_link_color'   => array(
			'type'            => 'color',
			'label'           => esc_html__( 'Breadcrumb Link Color', 'grd' ),
			'default'         => '',
			'section'         => 'single_product_page_header',
			'priority'        => 30,
			'active_callback' => array(
				array(
					'setting'  => 'single_product_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),
		'single_product_page_header_parallax'                => array(
			'type'            => 'toggle',
			'label'           => esc_html__( 'Parallax', 'grd' ),
			'default'         => 1,
			'section'         => 'single_product_page_header',
			'priority'        => 30,
			'description'     => esc_html__( 'Check this option to enable parallax for the page header.', 'grd' ),
			'active_callback' => array(
				array(
					'setting'  => 'single_product_page_header',
					'operator' => '==',
					'value'    => 1,
				),
			),
		),

		//Badge
		'show_badges'                                        => array(
			'type'        => 'toggle',
			'label'       => esc_html__( 'Show Badges', 'grd' ),
			'section'     => 'shop_badge',
			'default'     => 1,
			'priority'    => 20,
			'description' => esc_html__( 'Check this to show badges on every products.', 'grd' ),
		),
		'hot_text'                                           => array(
			'type'            => 'text',
			'label'           => esc_html__( 'Custom Hot Text', 'grd' ),
			'section'         => 'shop_badge',
			'default'         => 'Hot',
			'priority'        => 20,
			'active_callback' => array(
				array(
					'setting'  => 'show_badges',
					'operator' => '==',
					'value'    => 1,
				),
				array(
					'setting'  => 'badges',
					'operator' => 'contains',
					'value'    => 'hot',
				),
			),
		),

		// Single Product
		'single_product_layout'                              => array(
			'type'        => 'select',
			'label'       => esc_html__( 'Single Product Layout', 'grd' ),
			'default'     => 'full-content',
			'section'     => 'single_product',
			'priority'    => 10,
			'description' => esc_html__( 'Select default sidebar for the single post page.', 'grd' ),
			'choices'     => array(
				'sidebar-content' => esc_html__( 'Left Sidebar', 'grd' ),
				'content-sidebar' => esc_html__( 'Right Sidebar', 'grd' ),
				'full-content'    => esc_html__( 'Full Content', 'grd' ),
			),
		),
		'single_product_custom_field_1'                      => array(
			'type'    => 'custom',
			'section' => 'single_product',
			'default' => '<hr/>',
		),
		'related_product'                                    => array(
			'type'        => 'toggle',
			'label'       => esc_html__( 'Related Products', 'grd' ),
			'section'     => 'single_product',
			'description' => esc_html__( 'Check this option to show related posts in the single post page.', 'grd' ),
			'default'     => 0,
			'priority'    => 20,
		),
		'related_product_title'                              => array(
			'type'     => 'text',
			'label'    => esc_html__( 'Related Products Title', 'grd' ),
			'section'  => 'single_product',
			'default'  => esc_html__( 'Related Products', 'grd' ),
			'priority' => 20,

			'active_callback' => array(
				array(
					'setting'  => 'related_product',
					'operator' => '==',
					'value'    => true,
				),
			),
		),
		'related_product_numbers'                            => array(
			'type'            => 'number',
			'label'           => esc_html__( 'Related Products Numbers', 'grd' ),
			'section'         => 'single_product',
			'default'         => '3',
			'priority'        => 20,
			'active_callback' => array(
				array(
					'setting'  => 'related_product',
					'operator' => '==',
					'value'    => true,
				),
			),
		),
		'related_product_columns'                            => array(
			'type'        => 'select',
			'label'       => esc_html__( 'Related Products Columns', 'grd' ),
			'default'     => '4',
			'section'     => 'single_product',
			'priority'    => 20,
			'description' => esc_html__( 'Select product columns for related product.', 'grd' ),
			'choices'     => array(
				'4' => esc_html__( '4 Columns', 'grd' ),
				'3' => esc_html__( '3 Columns', 'grd' ),
			),
		),

		// Footer
		'back_to_top'                                        => array(
			'type'     => 'toggle',
			'label'    => esc_html__( 'Back to Top', 'grd' ),
			'section'  => 'extra_settings',
			'default'  => 0,
			'priority' => 10,
		),
		'footer_custom_1'                                    => array(
			'type'     => 'custom',
			'section'  => 'footer',
			'default'  => '<hr/>',
			'priority' => 20,
		),
		'footer_widget'                                      => array(
			'type'     => 'toggle',
			'label'    => esc_html__( 'Footer Widgets', 'grd' ),
			'section'  => 'footer',
			'default'  => 1,
			'priority' => 10,
		),
		'footer_widget_columns'                              => array(
			'type'            => 'select',
			'label'           => esc_html__( 'Footer Columns', 'grd' ),
			'section'         => 'footer',
			'default'         => '4',
			'priority'        => 20,
			'choices'         => array(
				'2' => esc_html__( '2 Columns', 'grd' ),
				'3' => esc_html__( '3 Columns', 'grd' ),
				'4' => esc_html__( '4 Columns', 'grd' ),
			),
			'description'     => esc_html__( 'Go to Appearance > Widgets > Footer 1, 2, 3, 4 to add widgets content.', 'grd' ),
			'active_callback' => array(
				array(
					'setting'  => 'footer_widget',
					'operator' => '==',
					'value'    => true,
				),
			),
		),
		'footer_custom_2'                                    => array(
			'type'     => 'custom',
			'section'  => 'footer',
			'default'  => '<hr/>',
			'priority' => 20,
		),
		'footer_widget_middle'                               => array(
			'type'     => 'toggle',
			'label'    => esc_html__( 'Footer Widgets Middle', 'grd' ),
			'section'  => 'footer',
			'default'  => 0,
			'priority' => 20,
		),
		'footer_widget_middle_email'                         => array(
			'type'     => 'text',
			'label'    => esc_html__( 'Email Address', 'grd' ),
			'section'  => 'footer',
			'default'  => '',
			'priority' => 20,
		),
		'footer_widget_middle_phone'                         => array(
			'type'     => 'text',
			'label'    => esc_html__( 'Phone Number', 'grd' ),
			'section'  => 'footer',
			'default'  => '',
			'priority' => 20,
		),
		'footer_widget_middle_social'                        => array(
			'type'     => 'repeater',
			'label'    => esc_html__( 'Socials', 'grd' ),
			'section'  => 'footer',
			'priority' => 20,
			'fields'   => array(
				'link_url' => array(
					'type'        => 'text',
					'label'       => esc_html__( 'Social URL', 'grd' ),
					'description' => esc_html__( 'Enter the URL for this social', 'grd' ),
					'default'     => '',
				),
			),
		),
		'footer_custom_3'                                    => array(
			'type'     => 'custom',
			'section'  => 'footer',
			'default'  => '<hr/>',
			'priority' => 20,
		),
		'footer_copyright'                                   => array(
			'type'        => 'textarea',
			'label'       => esc_html__( 'Footer Copyright', 'grd' ),
			'description' => esc_html__( 'Shortcodes are allowed', 'grd' ),
			'section'     => 'footer',
			'default'     => '',
			'priority'    => 20,
		),
	);


	$settings['panels']   = apply_filters( 'grd_customize_panels', $panels );
	$settings['sections'] = apply_filters( 'grd_customize_sections', $sections );
	$settings['fields']   = apply_filters( 'grd_customize_fields', $fields );

	return $settings;
}

$grd_customize = new Grd_Customize( grd_customize_settings() );


