<?php
/**
 * Grd functions and definitions
 *
 * @package Grd
 */


/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * @since  1.0
 *
 * @return void
 */
function grd_setup() {
	// Sets the content width in pixels, based on the theme's design and stylesheet.
	$GLOBALS['content_width'] = apply_filters( 'grd_content_width', 840 );

	// Make theme available for translation.
	load_theme_textdomain( 'grd', get_template_directory() . '/lang' );

	// Theme supports
	add_theme_support( 'woocommerce' );
	add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'wc-product-gallery-slider' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'post-formats', array('gallery', 'video') );
	add_theme_support( 'html5', array(
		'comment-list',
		'search-form',
		'comment-form',
		'gallery',
	) );

	add_editor_style( 'css/editor-style.css' );


	// Load regular editor styles into the new block-based editor.
	add_theme_support( 'editor-styles' );

	// Load default block styles.
	add_theme_support( 'wp-block-styles' );

	// Add support for responsive embeds.
	add_theme_support( 'responsive-embeds' );

	add_theme_support( 'align-wide' );

	add_theme_support( 'align-full' );

	add_image_size( 'grd-portfolio-grid', 485, 592, true );
	add_image_size( 'grd-portfolio-grid-dual-horizontal', 792, 375, true );
	add_image_size( 'grd-portfolio-grid-dual-vertical',375, 792, true );
	add_image_size( 'grd-portfolio-grid-single',480, 480, true );
	add_image_size( 'grd-portfolio-full-width', 485, 404, true );
	add_image_size( 'grd-service-grid-thumb', 480, 260, true );
	add_image_size( 'grd-blog-grid-thumb', 600, 340, true );
	add_image_size( 'grd-blog-single-thumb', 1170, 608, true );

	// Register theme nav menu
	register_nav_menus( array(
		'primary' => esc_html__( 'Primary Menu', 'grd' ),
	) );

	new Grd_WooCommerce;
}
add_action( 'after_setup_theme', 'grd_setup' );

/**
 * Register widgetized area and update sidebar with default widgets.
 *
 * @since 1.0
 *
 * @return void
 */
function grd_register_sidebar() {
    $sidebars = array(
        'blog-sidebar' 	    => esc_html__( 'Blog Sidebar', 'grd' ),
        'service-sidebar' 	=> esc_html__( 'Single Service Sidebar', 'grd' ),
        'shop-sidebar' 	    => esc_html__( 'Catalog Sidebar', 'grd' ),
    );
    // Register sidebar
    foreach ( $sidebars as $id => $name ) {
        register_sidebar(
            array(
                'name'          => $name,
                'id'            => $id,
                'description'	=> esc_html__( 'Add widgets here in order to display on pages', 'grd' ),
                'before_widget' => '<div id="%1$s" class="widget %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h4 class="widget-title">',
                'after_title'   => '</h4>',
            )
        );
    }

	register_sidebar(
		array(
			'name'          => esc_html__( 'Top Bar Left', 'grd' ),
			'id'            => 'topbar-left',
			'description'	=> esc_html__( 'Add a widget here in order to be shown on the left side of the topbar of Header 2', 'grd' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'footer copyright menu', 'grd' ),
			'id'            => 'footer-copyright-menu',
			'description'	=> esc_html__( 'Add a widget here in order to be shown on the footer copyright right menu', 'grd' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Top Bar Right', 'grd' ),
			'id'            => 'topbar-right',
			'description'	=> esc_html__( 'Add a widget here in order to be shown on the right side of the topbar of Header 2', 'grd' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Top Bar Mobile', 'grd' ),
			'id'            => 'topbar-mobile',
			'description'	=> esc_html__( 'Add widgets here in order to display on mobile', 'grd' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Header Bar', 'grd' ),
			'id'            => 'header-bar',
			'description'	=> esc_html__( 'Add widgets here in order to display on header bar all header layout', 'grd' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		)
	);

	// Register footer sidebars
	for ( $i = 1; $i <= 4; $i++ ) {
		register_sidebar( array(
			'name'          => esc_html__( 'Footer', 'grd' ) . " $i",
			'id'            => "footer-sidebar-$i",
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		) );
	}
}
add_action( 'widgets_init', 'grd_register_sidebar' );

/**
 * Load theme
 */

require get_template_directory() . '/inc/backend/customizer.php';
require get_template_directory() . '/inc/backend/editor.php';

// Woocommerce hooks
require get_template_directory() . '/inc/frontend/woocommerce.php';


if ( is_admin() ) {
	require get_template_directory() . '/inc/libs/class-tgm-plugin-activation.php';
	require get_template_directory() . '/inc/backend/plugins.php';
	require get_template_directory() . '/inc/backend/meta-boxes.php';
}

// Frontend functions and shortcodes
require get_template_directory() . '/inc/functions/media.php';
require get_template_directory() . '/inc/functions/nav.php';
require get_template_directory() . '/inc/functions/entry.php';
require get_template_directory() . '/inc/functions/comments.php';
require get_template_directory() . '/inc/functions/options.php';
require get_template_directory() . '/inc/functions/breadcrumbs.php';

// Frontend hooks
require get_template_directory() . '/inc/frontend/layout.php';
require get_template_directory() . '/inc/frontend/header.php';
require get_template_directory() . '/inc/frontend/footer.php';
require get_template_directory() . '/inc/frontend/nav.php';
require get_template_directory() . '/inc/frontend/entry.php';
require get_template_directory() . '/inc/frontend/comments.php';