<?php
/**
 * Custom functions for Visual Composer
 *
 * @package    Grd
 * @subpackage Visual Composer
 */

if ( ! function_exists( 'is_plugin_active' ) ) {
	require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
}

/**
 * Class Grd
 *
 * @since 1.0.0
 */
class Grd_VC {

	/**
	 * Construction
	 */
	function __construct() {
		// Stop if VC is not installed
		if ( ! is_plugin_active( 'js_composer/js_composer.php' ) ) {
			return false;
		}

		add_action( 'init', array( $this, 'map_shortcodes' ), 20 );

		add_filter( 'vc_autocomplete_grd_blog_grid_cats_callback', array(
			$this,
			'blogCatsAutocompleteSuggester',
		), 10, 1 );
		add_filter( 'vc_autocomplete_grd_blog_grid_cats_render', array( $this, 'blogCatsAutocompleteRender', ), 10, 1 );
	}



	/**
	 * Get category for auto complete field
	 *
	 * @param string $taxonomy Taxnomy to get terms
	 *
	 * @return array
	 */
	protected function get_terms( $taxonomy = 'portfolio_category' ) {
		// We don't want to query all terms again
		if ( isset( $this->terms[$taxonomy] ) ) {
			return $this->terms[$taxonomy];
		}

		$cats = get_terms( $taxonomy );
		if ( ! $cats || is_wp_error( $cats ) ) {
			return array();
		}

		$categories = array();
		foreach ( $cats as $cat ) {
			$categories[] = array(
				'label' => $cat->name,
				'value' => $cat->slug,
				'group' => 'category',
			);
		}

		// Store this in order to avoid double query this
		$this->terms[$taxonomy] = $categories;

		return $categories;
	}
	/**
	 * Add new params or add new shortcode to VC
	 *
	 * @since 1.0
	 *
	 * @return void
	 */
	function map_shortcodes() {

		// Empty Space
		vc_map(
			array(
				'name'     => esc_html__( 'Grd Empty Space', 'grd' ),
				'base'     => 'grd_empty_space',
				'class'    => '',
				'category' => esc_html__( 'Grd', ',' ),
				'params'   => array(
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Height(px)', 'grd' ),
						'param_name'  => 'height',
						'admin_label' => true,
						'description' => esc_html__( 'Enter empty space height on Desktop.', 'grd' )
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Height on Tablet(px)', 'grd' ),
						'param_name'  => 'height_tablet',
						'admin_label' => true,
						'description' => esc_html__( 'Enter empty space height on Mobile. Leave empty to use the height of the desktop', 'grd' )
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Height on Mobile(px)', 'grd' ),
						'param_name'  => 'height_mobile',
						'admin_label' => true,
						'description' => esc_html__( 'Enter empty space height on Mobile. Leave empty to use the height of the tablet', 'grd' )
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Background Color', 'grd' ),
						'param_name' => 'bg_color',
						'value'      => '',
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Extra class name', 'grd' ),
						'param_name'  => 'el_class',
						'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'grd' ),
					),
				),
			)
		);
		// Images Carousel
		vc_map(
			array(
				'name'     => esc_html__( 'Images Carousel', 'grd' ),
				'base'     => 'grd_images_carousel',
				'class'    => '',
				'value'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(
					array(
						'type'       => 'param_group',
						'heading'    => esc_html__( 'Images Carousel', 'grd' ),
						'value'      => '',
						'param_name' => 'setting',
						'params'     => array(
							array(
								'type'       => 'attach_image',
								'heading'    => esc_html__( 'Image box', 'grd' ),
								'param_name' => 'image_gr',
							),
							array(
								'heading'    => esc_html__( 'URL (Link)', 'grd' ),
								'type'       => 'vc_link',
								'param_name' => 'link',
							),
						),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Columns', 'grd' ),
						'param_name' => 'columns',
						'value'      => array(
							esc_html__( '1', 'grd' ) => '1',
							esc_html__( '2', 'grd' ) => '2',
							esc_html__( '3', 'grd' ) => '3',
							esc_html__( '4', 'grd' ) => '4',
							esc_html__( '5', 'grd' ) => '5',
						),
					),
					array(
						'heading'     => esc_html__( 'Image size', 'grd' ),
						'description' => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'grd' ),
						'type'        => 'textfield',
						'param_name'  => 'image_size',
						'value'       => '',

					),
					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'Show nav', 'grd' ),
						'param_name' => 'nav',
						'value'      => array( esc_html__( 'Yes', 'grd' ) => '1' ),
					),
					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'Show Dots', 'grd' ),
						'param_name' => 'dots',
						'value'      => array( esc_html__( 'Yes', 'grd' ) => '1' ),
					),
					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'Autoplay', 'grd' ),
						'param_name' => 'autoplay',
						'value'      => array( esc_html__( 'Yes', 'grd' ) => '1' ),
						'dependency' => array(
							'element' => 'type',
							'value'   => array( esc_html__( 'Yes', 'grd' ) => '1' ),
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Autoplay speed', 'grd' ),
						'param_name'  => 'speed',
						'value'       => '2000',
						'description' => esc_html__( 'Set auto play speed (in ms).', 'grd' ),
						'dependency'  => array(
							'element' => 'autoplay',
							'value'   => array( '1' ),
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Extra class name', 'grd' ),
						'param_name'  => 'el_class',
						'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'grd' ),
					),
				),
			)
		);
		// FAQ 
		vc_map(
			array(
				'name'     => esc_html__( 'FAQ', 'grd' ),
				'base'     => 'grd_faq',
				'class'    => '',
				'value'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Text color', 'grd' ),
						'param_name' => 'text_color',
						'value'      => array(
							esc_html__( 'Text dark', 'grd' )  => 'dark',
							esc_html__( 'Text light', 'grd' ) => 'light',
						),
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'param_group',
						'heading'    => esc_html__( 'FAQ', 'grd' ),
						'value'      => '',
						'param_name' => 'setting',
						'params'     => array(
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__( 'Style', 'grd' ),
								'param_name' => 'style',
								'value'      => array(
									esc_html__( 'Style 1', 'grd' ) => '1',
									esc_html__( 'Style 2', 'grd' ) => '2',
								),
								'group'      => esc_html__( 'Style', 'grd' ),
								'dependency' => array(
									'element' => 'type',
								),
							'admin_label' => true,
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__( 'Question title', 'grd' ),
								'param_name' => 'question_t',
								'value'      => '',
								'dependency' => array(
									'element' => 'style',
									'value'   => array( '2' ),
								),
								'admin_label' => true,
							),
							array(
								'type'       => 'textarea',
								'heading'    => esc_html__( 'Question content', 'grd' ),
								'param_name' => 'question_c',
								'value'      => '',
								'admin_label' => true,
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__( 'Question color', 'grd' ),
								'param_name' => 'color_qu',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__( 'Answer title', 'grd' ),
								'param_name' => 'answer_t',
								'value'      => '',
								'dependency' => array(
									'element' => 'style',
									'value'   => array( '2' ),
								),
							),
							array(
								'type'       => 'textarea',
								'heading'    => esc_html__( 'Answer content', 'grd' ),
								'param_name' => 'content',
								'value'      => '',
							),
						),
						'group'      => esc_html__( 'General', 'grd' ),
					),

					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Extra class name', 'grd' ),
						'param_name'  => 'el_class',
						'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'grd' ),
						'group'       => esc_html__( 'Add class', 'grd' ),
					),
				),
			)
		);
		//Timeline
		vc_map(
			array(
				'name'     => esc_html__( 'Timeline', 'grd' ),
				'base'     => 'grd_timeline',
				'class'    => '',
				'value'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(

					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'Show nav', 'grd' ),
						'param_name' => 'nav',
						'value'      => array( esc_html__( 'Yes', 'grd' ) => '1' ),
					),
					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'Autoplay', 'grd' ),
						'param_name' => 'autoplay',
						'value'      => array( esc_html__( 'Yes', 'grd' ) => '1' ),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Autoplay speed', 'grd' ),
						'param_name'  => 'speed',
						'value'       => '',
						'description' => esc_html__( '2000 => 2s', 'grd' )
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Columns', 'grd' ),
						'param_name' => 'columns',
						'value'      => array(
							esc_html__( '3', 'grd' ) => '3',
							esc_html__( '4', 'grd' ) => '4',
						),
					),
					array(
						'type'       => 'param_group',
						'heading'    => esc_html__( 'Box Carousel', 'grd' ),
						'value'      => '',
						'param_name' => 'setting',
						'params'     => array(
							array(
								'heading'    => esc_html__( 'Year', 'grd' ),
								'type'       => 'textfield',
								'param_name' => 'year',
								'admin_label' => true,
							),
							array(
								'heading'    => esc_html__( 'Image box', 'grd' ),
								'type'       => 'attach_image',
								'param_name' => 'image',
							),
							array(
								'heading'    => esc_html__( 'Title', 'grd' ),
								'type'       => 'textfield',
								'param_name' => 'title',
								'admin_label' => true,
							),
							array(
								'heading'    => esc_html__( 'Description', 'grd' ),
								'type'       => 'textarea',
								'param_name' => 'desc',
							),
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Extra class name', 'grd' ),
						'param_name'  => 'el_class',
						'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'grd' ),
					),
				),
			)
		);
		// Members
		vc_map(
			array(
				'name'     => esc_html__( 'Members', 'grd' ),
				'base'     => 'grd_members',
				'class'    => '',
				'value'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Style box', 'grd' ),
						'param_name' => 'style_box',
						'value'      => array(
							esc_html__( 'Box member', 'grd' ) => '1',
							esc_html__( 'Box text', 'grd' )   => '2',
						),
						'group'      => esc_html__( 'General', 'grd' ),
						'dependency' => array(
							'element' => 'type',
						),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Style box hover', 'grd' ),
						'param_name' => 'style_hover',
						'value'      => array(
							esc_html__( 'Style 1', 'grd' ) => '1',
							esc_html__( 'Style 2', 'grd' ) => '2',
						),
						'group'      => esc_html__( 'General', 'grd' ),
						'dependency' => array(
							'element' => 'style_box',
							'value'   => array( '1' ),
						),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Name', 'grd' ),
						'param_name' => 'name',
						'value'      => '',
						'dependency' => array(
							'element' => 'style_box',
							'value'   => array( '1' ),
						),
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'heading'    => esc_html__( 'Avatar image', 'grd' ),
						'type'       => 'attach_image',
						'param_name' => 'image',
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Office', 'grd' ),
						'param_name' => 'office',
						'value'      => '',
						'dependency' => array(
							'element' => 'style_box',
							'value'   => array( '1' ),
						),
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'param_group',
						'heading'    => esc_html__( 'Contact', 'grd' ),
						'value'      => '',
						'param_name' => 'setting',
						'params'     => array(
							array(
								'heading'     => esc_html__( 'Icon', 'grd' ),
								'description' => esc_html__( 'Select icon from library.', 'grd' ),
								'type'        => 'iconpicker',
								'param_name'  => 'icon_fontawesome',
								'value'       => 'fa fa-adjust',
								'settings'    => array(
									'emptyIcon'    => false,
									'iconsPerPage' => 4000,
								),
								'dependency'  => array(
									'element' => 'icon_type',
									'value'   => 'fontawesome',
								),
							),
							array(
								'heading'    => esc_html__( 'URL (Link)', 'grd' ),
								'type'       => 'vc_link',
								'param_name' => 'link',
							),
						),
						'dependency' => array(
							'element' => 'style_box',
							'value'   => array( '1' ),
						),
						'group'      => esc_html__( 'Social contact', 'grd' ),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Text color', 'grd' ),
						'param_name' => 'text_color',
						'value'      => array(
							esc_html__( 'Text dark', 'grd' )  => 'text-dark',
							esc_html__( 'Text light', 'grd' ) => 'text-light',
						),
						'dependency' => array(
							'element' => 'style_box',
							'value'   => array( '2' ),
						),
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Title box', 'grd' ),
						'param_name' => 'title',
						'value'      => '',
						'dependency' => array(
							'element' => 'style_box',
							'value'   => array( '2' ),
						),
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'vc_link',
						'heading'    => esc_html__( 'Link (URL)', 'grd' ),
						'param_name' => 'link',
						'value'      => '',
						'dependency' => array(
							'element' => 'style_box',
							'value'   => array( '2' ),
						),
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Extra class name', 'grd' ),
						'param_name'  => 'el_class',
						'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'grd' ),
						'group'       => esc_html__( 'Add class', 'grd' ),
					),
				),
			)
		);
		//Counter
		vc_map(
			array(
				'name'     => esc_html__( 'Counter', 'grd' ),
				'base'     => 'grd_counter',
				'class'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Style counter', 'grd' ),
						'param_name' => 'style',
						'value'      => array(
							esc_html__( 'Style 1', 'grd' ) => '1',
							esc_html__( 'Style 2', 'grd' ) => '2',
						),
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Number Counter', 'grd' ),
						'param_name' => 'number',
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Number Color', 'grd' ),
						'param_name' => 'number_color',
						'value'      => '',
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Border Color', 'grd' ),
						'param_name' => 'border_color',
						'value'      => '',
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Duration', 'grd' ),
						'param_name'  => 'duration',
						'group'       => esc_html__( 'General', 'grd' ),
						'description' => esc_html__( 'Add number ex: 1, 2, 3... (1 -> 1s) ', 'grd' ),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Text after counter', 'grd' ),
						'param_name' => 'text_after',
						'group'      => esc_html__( 'After counter', 'grd' ),
					),

					array(
						'type'       => 'textarea_html',
						'heading'    => esc_html__( 'Content counter', 'grd' ),
						'param_name' => 'content',
						'value'      => '',
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Text Color', 'grd' ),
						'param_name' => 'text_color',
						'value'      => '',
						'group'      => esc_html__( 'General', 'grd' ),
					),
				)
			)
		);
		// Prices table
		vc_map(
			array(
				'name'     => esc_html__( 'Prices table', 'grd' ),
				'base'     => 'grd_prices_table_1',
				'class'    => '',
				'value'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Title type', 'grd' ),
						'param_name' => 'title',
						'value'      => '',
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Service', 'grd' ),
						'param_name' => 'service',
						'value'      => '',
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Text color', 'grd' ),
						'param_name' => 'text_color',
						'value'      => array(
							esc_html__( 'Text dark', 'grd' )  => 'dark',
							esc_html__( 'Text light', 'grd' ) => 'light',
						),
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'param_group',
						'heading'    => esc_html__( 'Content', 'grd' ),
						'value'      => '',
						'param_name' => 'setting',
						'params'     => array(
							array(
								'heading'    => esc_html__( 'Title', 'grd' ),
								'type'       => 'textfield',
								'param_name' => 'title_gr',
								'admin_label' => true,
							),
							array(
								'heading'    => esc_html__( 'Service table', 'grd' ),
								'type'       => 'param_group',
								'param_name' => 'service_box',
								'params'     => array(
									array(
										'heading'     => esc_html__( 'Name service', 'grd' ),
										'type'        => 'textfield',
										'param_name'  => 'name_sv',
										'admin_label' => true,
									),
								),
							),
							array(
								'heading'    => esc_html__( 'Prices', 'grd' ),
								'type'       => 'textfield',
								'param_name' => 'price_gr',
								'admin_label' => true,
							),
							array(
								'heading'    => esc_html__( 'Unit', 'grd' ),
								'type'       => 'textfield',
								'param_name' => 'unit_gr',
								'admin_label' => true,
							),
							array(
								'heading'    => esc_html__( 'Color price', 'grd' ),
								'type'       => 'colorpicker',
								'param_name' => 'color_pr',
							),
							array(
								'heading'    => esc_html__( 'Background price', 'grd' ),
								'type'       => 'colorpicker',
								'param_name' => 'background_pr',
							),
						),
						'group'      => esc_html__( 'Main', 'grd' ),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Extra class name', 'grd' ),
						'param_name'  => 'el_class',
						'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'grd' ),
						'group'       => esc_html__( 'Add class', 'grd' ),
					),
				),
			)
		);
		// Prices table 2
		vc_map(
			array(
				'name'     => esc_html__( 'Prices table 2', 'grd' ),
				'base'     => 'grd_prices_table_2',
				'class'    => '',
				'value'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Title service', 'grd' ),
						'param_name' => 'title_sv',
						'value'      => '',
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Background service', 'grd' ),
						'param_name' => 'bk_sv',
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Title price', 'grd' ),
						'param_name' => 'title_pr',
						'value'      => '',
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Background price', 'grd' ),
						'param_name' => 'bk_pr',
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Text color', 'grd' ),
						'param_name' => 'text_color',
						'value'      => array(
							esc_html__( 'Text dark', 'grd' )  => 'dark',
							esc_html__( 'Text light', 'grd' ) => 'light',
						),
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'param_group',
						'heading'    => esc_html__( 'Content service', 'grd' ),
						'value'      => '',
						'param_name' => 'setting',
						'params'     => array(
							array(
								'heading'    => esc_html__( 'Title', 'grd' ),
								'type'       => 'textfield',
								'param_name' => 'title_gr',
								'admin_label' => true,					
							),
							array(
								'heading'    => esc_html__( 'Background title', 'grd' ),
								'type'       => 'colorpicker',
								'param_name' => 'background_tit',
							),
							array(
								'heading'    => esc_html__( 'Prices', 'grd' ),
								'type'       => 'textfield',
								'param_name' => 'price_gr',
								'admin_label' => true,
							),
							array(
								'heading'    => esc_html__( 'Background price', 'grd' ),
								'type'       => 'colorpicker',
								'param_name' => 'background_pr',
							),
							array(
								'heading'    => esc_html__( 'Color price', 'grd' ),
								'type'       => 'colorpicker',
								'param_name' => 'color_pr',
							),
						),
						'group'      => esc_html__( 'Main', 'grd' ),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Extra class name', 'grd' ),
						'param_name'  => 'el_class',
						'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'grd' ),
						'group'       => esc_html__( 'Add class', 'grd' ),
					),
				),
			)
		);
		// Prices table 3
		vc_map(
			array(
				'name'     => esc_html__( 'Prices table 3', 'grd' ),
				'base'     => 'grd_prices_table_3',
				'class'    => '',
				'value'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Style prices table', 'grd' ),
						'param_name' => 'style',
						'value'      => array(
							esc_html__( 'Style 1', 'grd' ) => '1',
							esc_html__( 'Style 2', 'grd' ) => '2',
						),
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Title type', 'grd' ),
						'param_name' => 'title',
						'value'      => '',
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Text color', 'grd' ),
						'param_name' => 'text_color',
						'value'      => array(
							esc_html__( 'Text dark', 'grd' )  => 'dark',
							esc_html__( 'Text light', 'grd' ) => 'light',
						),
						'group'      => esc_html__( 'Style', 'grd' ),
					),
					array(
						'heading'    => esc_html__( 'Service table', 'grd' ),
						'type'       => 'param_group',
						'param_name' => 'service_box',
						'params'     => array(
							array(
								'heading'     => esc_html__( 'Name service', 'grd' ),
								'type'        => 'textfield',
								'param_name'  => 'name_sv',
								'admin_label' => true,
							),
						),
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Price', 'grd' ),
						'param_name' => 'price',
						'value'      => '',
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Price color', 'grd' ),
						'param_name' => 'price_color',
						'value'      => '',
						'group'      => esc_html__( 'Style', 'grd' ),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Unit', 'grd' ),
						'param_name' => 'unit',
						'value'      => '',
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'textarea',
						'heading'    => esc_html__( 'Text after price', 'grd' ),
						'param_name' => 'text_after_price',
						'value'      => '',
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Text after color', 'grd' ),
						'param_name' => 'text_after_color',
						'value'      => '',
						'group'      => esc_html__( 'Style', 'grd' ),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Sale off', 'grd' ),
						'param_name' => 'sale',
						'value'      => '',
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'vc_link',
						'heading'    => esc_html__( 'Link (URL)', 'grd' ),
						'param_name' => 'link',
						'value'      => '',
						'group'      => esc_html__( 'General', 'grd' ),
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Color button', 'grd' ),
						'param_name' => 'btn_color',
						'value'      => '',
						'group'      => esc_html__( 'Style', 'grd' ),
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Border color', 'grd' ),
						'param_name' => 'border_color',
						'value'      => '',
						'group'      => esc_html__( 'Style', 'grd' ),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Extra class name', 'grd' ),
						'param_name'  => 'el_class',
						'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'grd' ),
						'group'       => esc_html__( 'Add class', 'grd' ),
					),
				),
			)
		);
		//Portfolio Attribute
		vc_map(
			array(
				'name'     => esc_html__( 'Portfolio Attribute', 'grd' ),
				'base'     => 'grd_portfolio_attribute',
				'class'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Client', 'grd' ),
						'param_name' => 'client',
					),
					array(
						'heading'    => esc_html__( 'Start On', 'grd' ),
						'type'       => 'textfield',
						'param_name' => 'start',
					),
					array(
						'heading'    => esc_html__( 'Ends On', 'grd' ),
						'type'       => 'textfield',
						'param_name' => 'ends',
					),
					array(
						'heading'    => esc_html__( 'Location', 'grd' ),
						'type'       => 'textfield',
						'param_name' => 'location',
					),
					array(
						'heading'    => esc_html__( 'Budget', 'grd' ),
						'type'       => 'textfield',
						'param_name' => 'budget',
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Rating', 'grd' ),
						'param_name'  => 'rating',
						'value'       => array(
							esc_html__( '1 star', 'grd' ) => '1',
							esc_html__( '2 star', 'grd' ) => '2',
							esc_html__( '3 star', 'grd' ) => '3',
							esc_html__( '4 star', 'grd' ) => '4',
							esc_html__( '5 star', 'grd' ) => '5',
						),
						'admin_label' => true,
					),
				),
			)
		);
		//Portfolio Carousel
		vc_map(
			array(
				'name'     => esc_html__( 'Portfolio Carousel', 'grd' ),
				'base'     => 'grd_portfolio_carousel',
				'class'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(


					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Items per row', 'grd' ),
						'param_name' => 'colum',
						'value'      => array(
							esc_html__( '2 items', 'grd' ) => '2',
							esc_html__( '3 items', 'grd' ) => '3',
							esc_html__( '4 items', 'grd' ) => '4',
							esc_html__( '5 items', 'grd' ) => '5',
							esc_html__( '6 items', 'grd' ) => '6',
						),

						'admin_label' => true,
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Portfolio items show at most', 'grd' ),
						'param_name' => 'value_item',
						'value'      => '',
					),
					array(
						'heading'     => esc_html__( 'Image size', 'grd' ),
						'description' => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'grd' ),
						'type'        => 'textfield',
						'param_name'  => 'image_size',
						'value'       => '',
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Excerpt content', 'grd' ),
						'param_name' => 'excerpt_content',
						'value'      => '',
					),
				),

			)
		);
		//section title
		vc_map(
			array(
				'name'     => esc_html__( 'Section title', 'grd' ),
				'base'     => 'grd_section_title',
				'class'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(


					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Style title', 'grd' ),
						'param_name'  => 'style',
						'value'       => array(
							esc_html__( 'Style 1', 'grd' ) => '1',
							esc_html__( 'Style 2', 'grd' ) => '2',
							esc_html__( 'Style 3', 'grd' ) => '3',
							esc_html__( 'Style 4', 'grd' ) => '4',
						),
						'description' => esc_html__( 'Select style title you want show.', 'grd' ),
						'admin_label' => true,
					),

					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Theme', 'grd' ),
						'param_name' => 'theme',
						'value'      => array(
							esc_html__( 'Dark', 'grd' )  => 'dark',
							esc_html__( 'Light', 'grd' ) => 'light',
						),
					),

					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Title', 'grd' ),
						'param_name'  => 'title',
						'value'       => '',
						'admin_label' => true,
					),

					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Font size', 'grd' ),
						'param_name'  => 'font_size',
						'value'       => '',
						'admin_label' => true,
					),

					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Title Color', 'grd' ),
						'param_name' => 'text_color',
						'value'      => '',
					),

					array(
						'type'       => 'textarea_html',
						'heading'    => esc_html__( 'Description', 'grd' ),
						'param_name' => 'content',
						'value'      => '',
					),
					array(
						'heading'     => esc_html__( 'Extra class name', 'grd' ),
						'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'grd' ),
						'param_name'  => 'el_class',
						'type'        => 'textfield',
						'value'       => '',
						'group'       => esc_html__( 'Class', 'grd' )
					),
				),
			)
		);
		//Grd button
		vc_map(
			array(
				'name'     => esc_html__( 'Button', 'grd' ),
				'base'     => 'grd_button',
				'class'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(

					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Text Button', 'grd' ),
						'param_name'  => 'text_bt',
						'value'       => '',
						'admin_label' => true,
					),
					array(
						'heading'    => esc_html__( 'URL (Link)', 'grd' ),
						'type'       => 'vc_link',
						'param_name' => 'link',
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Button Border', 'grd' ),
						'param_name' => 'bt_border',
						'value'      => '',
						'group'      => esc_html__( 'Setting', 'grd' )
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Button Border Color', 'grd' ),
						'param_name' => 'bt_border_color',
						'value'      => '',
						'group'      => esc_html__( 'Setting', 'grd' )
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Button Border Style', 'grd' ),
						'param_name' => 'bt_border_style',
						'value'      => array(
							esc_html__( 'Hidden', 'grd' ) => 'hidden',
							esc_html__( 'Solid', 'grd' )  => 'solid',
							esc_html__( 'Dotted', 'grd' ) => 'dotted',
							esc_html__( 'Dashed', 'grd' ) => 'dashed',
							esc_html__( 'Double', 'grd' ) => 'double',
						),
						'group'      => esc_html__( 'Setting', 'grd' )
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Button Background Color', 'grd' ),
						'param_name' => 'bt_bg_color',
						'value'      => '',
						'group'      => esc_html__( 'Setting', 'grd' )
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Button Text Color', 'grd' ),
						'param_name' => 'bt_text_color',
						'value'      => '',
						'group'      => esc_html__( 'Setting', 'grd' )
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Border radius', 'grd' ),
						'param_name' => 'border_radius',
						'value'      => '',
						'group'      => esc_html__( 'Setting', 'grd' )
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Padding', 'grd' ),
						'param_name' => 'padding',
						'value'      => '',
						'group'      => esc_html__( 'Setting', 'grd' )
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Button Hover', 'grd' ),
						'param_name' => 'bt_hover',
						'value'      => array(
							esc_html__( 'Style 1', 'grd' ) => '1',
							esc_html__( 'Style 2', 'grd' ) => '2',
							esc_html__( 'Style 3', 'grd' ) => '3',
						),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Button Align', 'grd' ),
						'param_name' => 'bt_align',
						'value'      => array(
							esc_html__( 'Left', 'grd' )   => 'left',
							esc_html__( 'Center', 'grd' ) => 'center',
							esc_html__( 'Right', 'grd' )  => 'right',
						),
					),
					array(
						'heading'     => esc_html__( 'Icon library', 'grd' ),
						'description' => esc_html__( 'Select icon library.', 'grd' ),
						'param_name'  => 'icon_type',
						'type'        => 'dropdown',
						'value'       => array(
							esc_html__( 'None', 'grd' )         => 'none',
							esc_html__( 'Font Awesome', 'grd' ) => 'fa_font',
							esc_html__( 'Svg icon', 'grd' )     => 'svg_icon',
							esc_html__( 'Custom image', 'grd' ) => 'image',
						),
					),
					array(
						'heading'     => esc_html__( 'Icon', 'grd' ),
						'description' => esc_html__( 'Pick an icon from library.', 'grd' ),
						'type'        => 'iconpicker',
						'param_name'  => 'icon_fontawesome',
						'value'       => 'fa fa-adjust',
						'settings'    => array(
							'emptyIcon'    => false,
							'iconsPerPage' => 4000,
						),
						'dependency'  => array(
							'element' => 'icon_type',
							'value'   => 'fa_font',
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Svg icon', 'grd' ),
						'param_name'  => 'value_icon',
						'value'       => '',
						'description' => esc_html__( 'Enter name svg icon from grd theme' ),
						'dependency'  => array(
							'element' => 'icon_type',
							'value'   => 'svg_icon',
						),
					),
					array(
						'heading'     => esc_html__( 'Icon Image', 'grd' ),
						'description' => esc_html__( 'Upload icon image', 'grd' ),
						'type'        => 'attach_image',
						'param_name'  => 'image',
						'value'       => '',
						'dependency'  => array(
							'element' => 'icon_type',
							'value'   => 'image',
						),
					),
					array(
						'heading'     => esc_html__( 'Image size', 'grd' ),
						'description' => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'grd' ),
						'type'        => 'textfield',
						'param_name'  => 'image_size',
						'value'       => '',
						'dependency'  => array(
							'element' => 'icon_type',
							'value'   => 'image',
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Extra class name', 'grd' ),
						'param_name'  => 'el_class',
						'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'grd' ),
						'group'       => esc_html__( 'Setting', 'grd' )
					),
				),
			)
		);
		//Portfolio Attribute
		vc_map(
			array(
				'name'     => esc_html__( 'Contact Box', 'grd' ),
				'base'     => 'grd_contact_box',
				'class'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Phone', 'grd' ),
						'param_name' => 'phone',
					),
					array(
						'heading'    => esc_html__( 'Email', 'grd' ),
						'type'       => 'textfield',
						'param_name' => 'email',
					),
					array(
						'heading'    => esc_html__( 'Working Hours in Summer', 'grd' ),
						'type'       => 'textfield',
						'param_name' => 'hours_summer',
					),
					array(
						'heading'    => esc_html__( 'Working Hours in Winter', 'grd' ),
						'type'       => 'textfield',
						'param_name' => 'hours_winter',
					),
				)
			)
		);
		//Grd Portfolio
		vc_map(
			array(
				'name'     => esc_html__( 'Portfolio', 'grd' ),
				'base'     => 'grd_portfolio',
				'class'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Style', 'grd' ),
						'param_name' => 'style',
						'value'      => array(
							esc_html__( 'Grid', 'grd' )       => 'grid',
							esc_html__( 'Masonry', 'grd' )    => 'masonry',
							esc_html__( 'Full width', 'grd' ) => 'full-width',
						),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Items per row', 'grd' ),
						'param_name' => 'items',
						'value'      => array(
							esc_html__( '2 items', 'grd' ) => '2',
							esc_html__( '3 items', 'grd' ) => '3',
							esc_html__( '4 items', 'grd' ) => '4',
						),
						'dependency' => array(
							'element' => 'style',
							'value'   => array( 'grid', 'full-width' ),
						),
					),
					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'Portfolio categorized filter', 'grd' ),
						'param_name' => 'filter',
						'value'      => array( esc_html__( 'Yes', 'grd' ) => '1' ),
					),
					array(
						'type'       => 'textarea',
						'heading'    => esc_html__( 'Categories slug', 'grd' ),
						'param_name' => 'slug_cate',
						'description'=> esc_html__( 'Enter categories slug you want to display. Each slug is separated by comma character ",". If empty, it will display default', 'grd' ),
						'dependency' => array(
							'element' => 'filter',
							'value'   => '1',
						),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Post per page', 'grd' ),
						'param_name' => 'posts_per_page',
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Order', 'grd' ),
						'param_name' => 'order',
						'value'      => array(
							esc_html__( 'DESC', 'grd' ) => 'DESC',
							esc_html__( 'ASC', 'grd' )  => 'ASC',
						),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Order by', 'grd' ),
						'param_name' => 'orderby',
						'value'      => array(
							esc_html__( 'None', 'grd' )   => 'none',
							esc_html__( 'Name', 'grd' )   => 'title',
							esc_html__( 'Random', 'grd' ) => 'ran',
							esc_html__( 'ID', 'grd' )     => 'id',
						),
					),
				),
			)
		);
		// Video Banner
		vc_map(
			array(
				'name'     => esc_html__( 'Video Banner', 'grd' ),
				'base'     => 'grd_video_banner',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Video file URL', 'grd' ),
						'description' => esc_html__( 'Only support YouTube and Vimeo', 'grd' ),
						'param_name'  => 'video',
						'value'       => '',
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Min Height(px)', 'grd' ),
						'param_name' => 'min_height',
						'value'      => '500',
					),
					array(
						'type'       => 'attach_image',
						'heading'    => esc_html__( 'Video Background Image', 'grd' ),
						'param_name' => 'image',
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Image size', 'grd' ),
						'param_name'  => 'image_size',
						'description' => esc_html__( 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height)).', 'grd' ),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Extra Class', 'grd' ),
						'param_name' => 'el_class',
						'value'      => '',

					),

				),
			)
		);
		//Image box
		vc_map(
			array(
				'name'     => esc_html__( 'Image Box', 'grd' ),
				'base'     => 'grd_image_box',
				'class'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Style', 'grd' ),
						'param_name'  => 'style',
						'value'       => array(
							esc_html__( 'Style 1', 'grd' ) => '1',
							esc_html__( 'Style 2', 'grd' ) => '2',
							esc_html__( 'Style 3', 'grd' ) => '3',
							esc_html__( 'Style 4', 'grd' ) => '4',
							esc_html__( 'Style 5', 'grd' ) => '5',
							esc_html__( 'Style 6', 'grd' ) => '6',
							esc_html__( 'Style 7', 'grd' ) => '7',
						),
						'description' => esc_html__( 'Select style image box.', 'grd' ),
						'admin_label' => true,
					),

					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Theme', 'grd' ),
						'param_name' => 'theme',
						'value'      => array(
							esc_html__( 'Dark', 'grd' )  => 'dark',
							esc_html__( 'Light', 'grd' ) => 'light',
						),
					),

					array(
						'heading'    => esc_html__( 'Title', 'grd' ),
						'type'       => 'vc_link',
						'param_name' => 'title',

					),

					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Title Color', 'grd' ),
						'param_name' => 'text_color',
						'value'      => '',
					),

					array(
						'type'       => 'textarea_html',
						'heading'    => esc_html__( 'Description', 'grd' ),
						'param_name' => 'content',
						'value'      => '',

					),


					array(
						'heading'     => esc_html__( 'Image', 'grd' ),
						'description' => esc_html__( 'Upload image', 'grd' ),
						'type'        => 'attach_image',
						'param_name'  => 'image',
						'value'       => '',

					),
					array(
						'heading'     => esc_html__( 'Image size', 'grd' ),
						'description' => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'grd' ),
						'type'        => 'textfield',
						'param_name'  => 'image_size',
						'value'       => '',
					),
					array(
						'heading'     => esc_html__( 'Image Background', 'grd' ),
						'description' => esc_html__( 'Upload image background', 'grd' ),
						'type'        => 'attach_image',
						'param_name'  => 'image_background',
						'value'       => '',
						'dependency'  => array(
							'element' => 'style',
							'value'   => '6',
						),
					),
					array(
						'heading'     => esc_html__( 'Image background size', 'grd' ),
						'description' => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'grd' ),
						'type'        => 'textfield',
						'param_name'  => 'image_bg_size',
						'value'       => '',
						'dependency'  => array(
							'element' => 'style',
							'value'   => '6',
						),
					),

					array(
						'heading'     => esc_html__( 'Icon library', 'grd' ),
						'description' => esc_html__( 'Select icon library.', 'grd' ),
						'param_name'  => 'icon_type',
						'type'        => 'dropdown',
						'value'       => array(
							esc_html__( 'Font Awesome', 'grd' ) => 'icon_fontawesome',
							esc_html__( 'Svg icon', 'grd' )     => 'svg_icon',
						),

					),
					array(
						'heading'     => esc_html__( 'Icon', 'grd' ),
						'description' => esc_html__( 'Pick an icon from library.', 'grd' ),
						'type'        => 'iconpicker',
						'param_name'  => 'icon_fontawesome',
						'value'       => 'fa fa-adjust',
						'settings'    => array(
							'emptyIcon'    => false,
							'iconsPerPage' => 4000,
						),
						'dependency'  => array(
							'element' => 'icon_type',
							'value'   => 'icon_fontawesome',
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Svg icon', 'grd' ),
						'param_name'  => 'name_icon',
						'value'       => '',
						'description' => esc_html__( 'Enter name svg icon from grd theme' ),
						'dependency'  => array(
							'element' => 'icon_type',
							'value'   => 'svg_icon',
						),
					),

					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Icon Color', 'grd' ),
						'param_name' => 'icon_color',
						'value'      => '',
						'dependency' => array(
							'element' => 'icon_type',
							'value'   => array( 'fa_font', 'svg_icon' ),
						),
					),

					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Icon size', 'grd' ),
						'param_name'  => 'icon_size',
						'description' => esc_html__( 'Font size for icon example: 15px,22px.', 'grd' ),
						'dependency'  => array(
							'element' => 'icon_type',
							'value'   => array( 'fa_font', 'svg_icon' ),
						),
					),

				),
			)
		);
		//Icon box
		vc_map(
			array(
				'name'     => esc_html__( 'Icon Box', 'grd' ),
				'base'     => 'grd_icon_box',
				'class'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Style', 'grd' ),
						'param_name'  => 'style',
						'value'       => array(
							esc_html__( 'Style 1', 'grd' )  => '1',
							esc_html__( 'Style 2', 'grd' )  => '2',
							esc_html__( 'Style 3', 'grd' )  => '3',
							esc_html__( 'Style 4', 'grd' )  => '4',
							esc_html__( 'Style 5', 'grd' )  => '5',
							esc_html__( 'Style 6', 'grd' )  => '6',
							esc_html__( 'Style 7', 'grd' )  => '7',
							esc_html__( 'Style 8', 'grd' )  => '8',
							esc_html__( 'Style 9', 'grd' )  => '9',
							esc_html__( 'Style 10', 'grd' ) => '10',
							esc_html__( 'Style 11', 'grd' ) => '11',
						),
						'admin_label' => true,
					),
					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'Show border', 'grd' ),
						'param_name' => 'border_box',
						'value'      => '',
						'dependency' => array(
							'element' => 'style',
							'value'   => '3',
						),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Text button', 'grd' ),
						'param_name' => 'text_button',
						'value'      => '',
						'dependency' => array(
							'element' => 'style',
							'value'   => '3',
						),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Position', 'grd' ),
						'param_name' => 'position',
						'value'      => array(
							esc_html__( 'Left', 'grd' )  => 'left',
							esc_html__( 'Right', 'grd' ) => 'right',
						),
						'dependency' => array(
							'element' => 'style',
							'value'   => '9',
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Text Header', 'grd' ),
						'param_name'  => 'text_header',
						'value'       => '',
						'description' => esc_html__( 'Enter name svg icon from grd theme' ),
						'dependency'  => array(
							'element' => 'style',
							'value'   => '8',
						),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Theme', 'grd' ),
						'param_name' => 'theme',
						'value'      => array(
							esc_html__( 'Dark', 'grd' )  => 'dark',
							esc_html__( 'Light', 'grd' ) => 'light',
						),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Background icon', 'grd' ),
						'param_name' => 'bg_icon_color',
						'value'      => array(
							esc_html__( 'Color 1', 'grd' ) => '1',
							esc_html__( 'Color 2', 'grd' ) => '2',
						),
						'dependency' => array(
							'element' => 'style',
							'value'   => '2',
						),
					),
					array(
						'heading'    => esc_html__( 'Title', 'grd' ),
						'type'       => 'vc_link',
						'param_name' => 'link',

					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Title Color', 'grd' ),
						'param_name' => 'text_color',
						'value'      => '',
					),
					array(
						'type'       => 'textarea_html',
						'heading'    => esc_html__( 'Description', 'grd' ),
						'param_name' => 'content',
						'value'      => '',
					),
					array(
						'heading'     => esc_html__( 'Icon library', 'grd' ),
						'description' => esc_html__( 'Select icon library.', 'grd' ),
						'param_name'  => 'icon_type',
						'type'        => 'dropdown',
						'value'       => array(
							esc_html__( 'Font Awesome', 'grd' ) => 'fa_font',
							esc_html__( 'Svg icon', 'grd' )     => 'svg_icon',
							esc_html__( 'Custom image', 'grd' ) => 'image',
						),
					),
					array(
						'heading'     => esc_html__( 'Icon', 'grd' ),
						'description' => esc_html__( 'Pick an icon from library.', 'grd' ),
						'type'        => 'iconpicker',
						'param_name'  => 'icon_fontawesome',
						'value'       => 'fa fa-adjust',
						'settings'    => array(
							'emptyIcon'    => false,
							'iconsPerPage' => 4000,
						),
						'dependency'  => array(
							'element' => 'icon_type',
							'value'   => 'fa_font',
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Svg icon', 'grd' ),
						'param_name'  => 'value_icon',
						'value'       => '',
						'description' => esc_html__( 'Enter name svg icon from grd theme' ),
						'dependency'  => array(
							'element' => 'icon_type',
							'value'   => 'svg_icon',
						),
					),
					array(
						'heading'     => esc_html__( 'Icon Image', 'grd' ),
						'description' => esc_html__( 'Upload icon image', 'grd' ),
						'type'        => 'attach_image',
						'param_name'  => 'image',
						'value'       => '',
						'dependency'  => array(
							'element' => 'icon_type',
							'value'   => 'image',
						),
					),
					array(
						'heading'     => esc_html__( 'Image size', 'grd' ),
						'description' => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'grd' ),
						'type'        => 'textfield',
						'param_name'  => 'image_size',
						'value'       => '',
						'dependency'  => array(
							'element' => 'icon_type',
							'value'   => 'image',
						),
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Icon Color', 'grd' ),
						'param_name' => 'icon_color',
						'value'      => '',
						'dependency' => array(
							'element' => 'icon_type',
							'value'   => array( 'fa_font', 'svg_icon' ),
						),
					),

					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Icon size', 'grd' ),
						'param_name'  => 'icon_size',
						'description' => esc_html__( 'Font size for icon example: 15px,22px.', 'grd' ),
						'dependency'  => array(
							'element' => 'icon_type',
							'value'   => array( 'fa_font', 'svg_icon' ),
						),
					),
					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'Show read more', 'grd' ),
						'param_name' => 'checkbox',
						'value'      => '',
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Add text footer', 'grd' ),
						'param_name' => 'text_footer',
						'dependency' => array(
							'element' => 'style',
							'value'   => array( '4', '5' ),
						),
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Text Footer Color', 'grd' ),
						'param_name' => 'text_footer_color',
						'value'      => '',
						'dependency' => array(
							'element' => 'style',
							'value'   => array( '4', '5' ),
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Border icon box', 'grd' ),
						'param_name'  => 'border_icon_box',
						'value'       => '',
						'description' => esc_html__( 'Example: 5px 5px 5px' ),
						'group'       => esc_html__( 'Setting', 'grd' )
					),
					array(
						'heading'     => esc_html__( 'Background Image', 'grd' ),
						'description' => esc_html__( 'Upload image', 'grd' ),
						'type'        => 'attach_image',
						'param_name'  => 'bg_image',
						'value'       => '',
						'group'       => esc_html__( 'Setting', 'grd' )

					),
					array(
						'heading'    => esc_html__( 'Background size', 'grd' ),
						'param_name' => 'bg_size',
						'type'       => 'dropdown',
						'value'      => array(
							esc_html__( 'Auto', 'grd' )    => 'auto',
							esc_html__( 'Cover', 'grd' )   => 'cover',
							esc_html__( 'Contain', 'grd' ) => 'contain',
							esc_html__( 'Inherit', 'grd' ) => 'inherit',
							esc_html__( 'Initial', 'grd' ) => 'initial',
							esc_html__( 'Unset', 'grd' )   => 'unset',
						),
						'group'      => esc_html__( 'Setting', 'grd' )

					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Extra class name', 'grd' ),
						'param_name'  => 'el_class',
						'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'grd' ),
						'group'       => esc_html__( 'Setting', 'grd' )
					),
				),
			)

		);
		//Team carousel
		vc_map(
			array(
				'name'     => esc_html__( 'Team carousel', 'grd' ),
				'base'     => 'grd_team_carousel',
				'class'    => '',
				'value'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Title', 'grd' ),
						'param_name' => 'title',
						'value'      => '',
					),
					array(
						'type'       => 'textarea',
						'heading'    => esc_html__( 'Description', 'grd' ),
						'param_name' => 'desc',
						'value'      => '',
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Columns', 'grd' ),
						'param_name' => 'item',
						'value'      => array(
							esc_html__( '3 item', 'grd' ) => '3',
							esc_html__( '4 item', 'grd' ) => '4',
						),
					),
					array(
						'heading'     => esc_html__( 'Avatar image size', 'grd' ),
						'description' => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'grd' ),
						'type'        => 'textfield',
						'param_name'  => 'image_size',
						'value'       => '',
					),
					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'Show Nav', 'grd' ),
						'param_name' => 'nav',
						'value'      => array( esc_html__( 'Yes', 'grd' ) => '1' ),
					),
					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'Show Dots', 'grd' ),
						'param_name' => 'dots',
						'value'      => array( esc_html__( 'Yes', 'grd' ) => '1' ),
					),
					array(
						'type'        => 'checkbox',
						'heading'     => esc_html__( 'Autoplay', 'grd' ),
						'param_name'  => 'autoplay',
						'value'       => array( esc_html__( 'Yes', 'grd' ) => 'yes' ),
						'description' => esc_html__( 'If "YES" Enable autoplay', 'grd' ),
						'dependency'  => array(
							'element' => 'type',
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Autoplay speed', 'grd' ),
						'param_name'  => 'autoplay_speed',
						'value'       => '2000',
						'description' => esc_html__( 'Set auto play speed (in ms).', 'grd' ),
						'dependency'  => array(
							'element' => 'autoplay',
							'value'   => array( 'yes' ),
						),
					),
					array(
						'type'       => 'param_group',
						'heading'    => esc_html__( 'Members', 'grd' ),
						'value'      => '',
						'param_name' => 'setting',
						'params'     => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__( 'Name', 'grd' ),
								'param_name' => 'name',
								'value'      => '',
								'admin_label' => true,
							),
							array(
								'heading'    => esc_html__( 'Avatar image', 'grd' ),
								'type'       => 'attach_image',
								'param_name' => 'image',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__( 'Office', 'grd' ),
								'param_name' => 'office',
								'value'      => '',
								'admin_label' => true,
							),
							array(
								'type'       => 'param_group',
								'heading'    => esc_html__( 'Icon contact', 'grd' ),
								'value'      => '',
								'param_name' => 'setting_icon',
								'params'     => array(
									array(
										'heading'     => esc_html__( 'Icon', 'grd' ),
										'description' => esc_html__( 'Select icon from library.', 'grd' ),
										'type'        => 'iconpicker',
										'param_name'  => 'icon_fontawesome',
										'value'       => 'fa fa-adjust',
										'settings'    => array(
											'emptyIcon'    => false,
											'iconsPerPage' => 4000,
										),
										'dependency'  => array(
											'element' => 'icon_type',
											'value'   => 'fontawesome',
										),
									),
									array(
										'heading'    => esc_html__( 'URL (Link)', 'grd' ),
										'type'       => 'vc_link',
										'param_name' => 'link',
									),
								),
							),

						),
						'group'      => esc_html__( 'Infor member', 'grd' ),
					),
					array(
						'type'       => 'textarea',
						'heading'    => esc_html__( 'Title banner', 'grd' ),
						'param_name' => 'title_ban',
						'value'      => '',
						'group'      => esc_html__( 'Banner', 'grd' ),
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Title color', 'grd' ),
						'param_name' => 'title_color',
						'value'      => '',
						'group'      => esc_html__( 'Banner', 'grd' ),
					),
					array(
						'type'       => 'vc_link',
						'heading'    => esc_html__( 'Link banner', 'grd' ),
						'param_name' => 'link',
						'value'      => '',
						'group'      => esc_html__( 'Banner', 'grd' ),
					),
					array(
						'type'       => 'attach_image',
						'heading'    => esc_html__( 'Image banner', 'grd' ),
						'param_name' => 'image_ban',
						'value'      => '',
						'group'      => esc_html__( 'Banner', 'grd' ),
					),
					array(
						'heading'     => esc_html__( 'Banner image size', 'grd' ),
						'description' => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'grd' ),
						'type'        => 'textfield',
						'param_name'  => 'image_size_ban',
						'value'       => '',
						'group'      => esc_html__( 'Banner', 'grd' ),					
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Extra class name', 'grd' ),
						'param_name'  => 'el_class',
						'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'grd' ),
						'group'       => esc_html__( 'Add class', 'grd' ),
					),
				),
			)
		);
		// Testimorial carousel
		vc_map(
			array(
				'name'     => esc_html__( 'Testimorial Carousel', 'grd' ),
				'base'     => 'grd_testimorial_carousel',
				'class'    => '',
				'value'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Style', 'grd' ),
						'param_name' => 'style',
						'value'      => array(
							esc_html__( 'Style 1', 'grd' ) => '1',
							esc_html__( 'Style 2', 'grd' ) => '2',
							esc_html__( 'Style 3', 'grd' ) => '3',
							esc_html__( 'Style 4', 'grd' ) => '4',
						),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Style box title', 'grd' ),
						'param_name' => 'style_title',
						'value'      => array(
							esc_html__( 'Left', 'grd' )   => '1',
							esc_html__( 'Center', 'grd' ) => '2',
						),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Title', 'grd' ),
						'param_name' => 'title',
						'value'      => '',
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Color title', 'grd' ),
						'param_name' => 'color_tit',
						'value'      => '',
					),
					array(
						'type'       => 'textarea',
						'heading'    => esc_html__( 'Description', 'grd' ),
						'param_name' => 'desc',
						'value'      => '',
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Columns', 'grd' ),
						'param_name' => 'item',
						'value'      => array(
							esc_html__( '2 item', 'grd' ) => '2',
							esc_html__( '1 item', 'grd' ) => '1',
						),
					),
					array(
						'type'        => 'checkbox',
						'heading'     => esc_html__( 'Show Nav', 'grd' ),
						'param_name'  => 'nav',
						'value'       => array( esc_html__( 'Yes', 'grd' ) => '1' ),
						'description' => esc_html__( 'If box "style 4" => no nav', 'grd' ),
					),
					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'Show Dots', 'grd' ),
						'param_name' => 'dots',
						'value'      => array( esc_html__( 'Yes', 'grd' ) => '1' ),
					),
					array(
						'type'        => 'checkbox',
						'heading'     => esc_html__( 'Autoplay', 'grd' ),
						'param_name'  => 'autoplay',
						'value'       => array( esc_html__( 'Yes', 'grd' ) => 'yes' ),
						'description' => esc_html__( 'If "YES" Enable autoplay', 'grd' ),
						'dependency'  => array(
							'element' => 'type',
							'value'   => array( esc_html__( 'Yes', 'grd' ) => '1' ),
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Autoplay speed', 'grd' ),
						'param_name'  => 'autoplay_speed',
						'value'       => '2000',
						'description' => esc_html__( 'Set auto play speed (in ms).', 'grd' ),
						'dependency'  => array(
							'element' => 'autoplay',
							'value'   => array( 'yes' ),
						),
					),
					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'Show star', 'grd' ),
						'param_name' => 'star',
						'value'      => array( esc_html__( 'Yes', 'grd' ) => '1' ),
					),
					array(
						'type'       => 'param_group',
						'heading'    => esc_html__( 'Element carousel', 'grd' ),
						'value'      => '',
						'param_name' => 'setting',
						'params'     => array(

							array(
								'type'       => 'attach_image',
								'heading'    => esc_html__( 'Image', 'grd' ),
								'param_name' => 'image',
							),
							array(
								'heading'    => esc_html__( 'Name', 'grd' ),
								'type'       => 'textfield',
								'param_name' => 'name',
								'admin_label' => true,
							),
							array(
								'heading'    => esc_html__( 'Description', 'grd' ),
								'type'       => 'textarea',
								'param_name' => 'desc',
							),
							array(
								'heading'    => esc_html__( 'Address', 'grd' ),
								'type'       => 'textfield',
								'param_name' => 'address',
								'dependency' => array(
									'element' => 'style',
									'value'   => array( '1', '3' ),
								),
							),
							array(
								'heading'    => esc_html__( 'Choose star', 'grd' ),
								'type'       => 'dropdown',
								'param_name' => 'star',
								'value'      => array(
									esc_html__( '1 star', 'grd' ) => '1',
									esc_html__( '2 star', 'grd' ) => '2',
									esc_html__( '3 star', 'grd' ) => '3',
									esc_html__( '4 star', 'grd' ) => '4',
									esc_html__( '5 star', 'grd' ) => '5',
								),
								'dependency' => array(
									'element' => 'style',
									'value'   => array( '2', '4' ),
								),
								'admin_label' => true,								
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__( 'Name color', 'grd' ),
								'param_name' => 'name_color',
								'value'      => '',
								'group'      => esc_html__( 'Style', 'grd' )
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__( 'Description color', 'grd' ),
								'param_name' => 'desc_color',
								'value'      => '',
								'group'      => esc_html__( 'Style', 'grd' )
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__( 'Icon color', 'grd' ),
								'param_name' => 'icon_color',
								'value'      => '',
								'group'      => esc_html__( 'Style', 'grd' )
							),
						),
						'group'      => esc_html__( 'Element testimorial', 'grd' ),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Extra class name', 'grd' ),
						'param_name'  => 'el_class',
						'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'grd' ),
						'group'       => esc_html__( 'Add class', 'grd' ),
					),
				),
			)
		);
		// banner
		vc_map(
			array(
				'name'     => esc_html__( 'Banner', 'grd' ),
				'base'     => 'grd_banner',
				'class'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Style', 'grd' ),
						'param_name'  => 'style',
						'value'       => array(
							esc_html__( 'Style 1', 'grd' ) => '1',
							esc_html__( 'Style 2', 'grd' ) => '2',
							esc_html__( 'Style 3', 'grd' ) => '3',
						),
						'admin_label' => true,
					),

					array(
						'heading'     => esc_html__( 'Image', 'grd' ),
						'description' => esc_html__( 'Upload image', 'grd' ),
						'type'        => 'attach_image',
						'param_name'  => 'image',
						'value'       => '',

					),
					array(
						'heading'     => esc_html__( 'Image size', 'grd' ),
						'description' => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'grd' ),
						'type'        => 'textfield',
						'param_name'  => 'image_size',
						'value'       => '',

					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Title', 'grd' ),
						'param_name' => 'title',
						'dependency' => array(
							'element' => 'style',
							'value'   => '3',
						),
					),
					array(
						'type'       => 'textarea_html',
						'heading'    => esc_html__( 'Description', 'grd' ),
						'param_name' => 'content',
						'value'      => '',
					),
					array(
						'heading'    => esc_html__( 'Button', 'grd' ),
						'type'       => 'vc_link',
						'param_name' => 'link',

					),


					array(
						'heading'     => esc_html__( 'Icon library', 'grd' ),
						'description' => esc_html__( 'Select icon library.', 'grd' ),
						'param_name'  => 'icon_type',
						'type'        => 'dropdown',
						'value'       => array(
							esc_html__( 'Font Awesome', 'grd' ) => 'fa_font',
							esc_html__( 'Svg icon', 'grd' )     => 'svg_icon',
						),
						'dependency'  => array(
							'element' => 'style',
							'value'   => '2',
						),

					),
					array(
						'heading'     => esc_html__( 'Icon', 'grd' ),
						'description' => esc_html__( 'Pick an icon from library.', 'grd' ),
						'type'        => 'iconpicker',
						'param_name'  => 'icon_fontawesome',
						'value'       => 'fa fa-adjust',
						'settings'    => array(
							'emptyIcon'    => false,
							'iconsPerPage' => 4000,
						),
						'dependency'  => array(
							'element' => 'icon_type',
							'value'   => 'fa_font',
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Svg icon', 'grd' ),
						'param_name'  => 'name_svg',
						'value'       => '',
						'description' => esc_html__( 'Enter name svg icon from grd theme' ),
						'dependency'  => array(
							'element' => 'icon_type',
							'value'   => 'svg_icon',
						),
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Icon Color', 'grd' ),
						'param_name' => 'icon_color',
						'value'      => '',
						'dependency' => array(
							'element' => 'icon_type',
							'value'   => array( 'fa_font', 'svg_icon' ),
						),

					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Icon size', 'grd' ),
						'param_name'  => 'icon_size',
						'description' => esc_html__( 'Font size for icon example: 15px,22px.', 'grd' ),
						'dependency'  => array(
							'element' => 'icon_type',
							'value'   => array( 'fa_font', 'svg_icon' ),
						),
					),

				),
			)
		);
		// Award Carousel
		vc_map(
			array(
				'name'     => esc_html__( 'Award Carousel', 'grd' ),
				'base'     => 'grd_award_carousel',
				'class'    => '',
				'value'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Columns', 'grd' ),
						'param_name' => 'item',
						'value'      => array(
							esc_html__( '1 item', 'grd' ) => '1',
							esc_html__( '2 item', 'grd' ) => '2',
						),
					),

					array(
						'heading'    => esc_html__( 'Align content', 'grd' ),
						'param_name' => 'align_content',
						'type'       => 'dropdown',
						'value'      => array(
							esc_html__( 'Left', 'grd' )   => 'left',
							esc_html__( 'Center', 'grd' ) => 'center',
							esc_html__( 'Right', 'grd' )  => 'right',
						),
					),
					array(
						'heading'    => esc_html__( 'Theme', 'grd' ),
						'param_name' => 'theme',
						'type'       => 'dropdown',
						'value'      => array(
							esc_html__( 'Dark', 'grd' )  => 'dark',
							esc_html__( 'Light', 'grd' ) => 'light',
						),
					),
					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'Show Arrow', 'grd' ),
						'param_name' => 'nav',
						'value'      => array( esc_html__( 'Yes', 'grd' ) => '1' ),
					),
					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'Infinite', 'grd' ),
						'param_name' => 'infinite',
						'value'      => array( esc_html__( 'Yes', 'grd' ) => '1' ),
					),
					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'Show Dots', 'grd' ),
						'param_name' => 'dots',
						'value'      => array( esc_html__( 'Yes', 'grd' ) => '1' ),
					),
					array(
						'type'        => 'checkbox',
						'heading'     => esc_html__( 'Autoplay', 'grd' ),
						'param_name'  => 'autoplay',
						'value'       => array( esc_html__( 'Yes', 'grd' ) => 'yes' ),
						'description' => esc_html__( 'If "YES" Enable autoplay', 'grd' ),
						'dependency'  => array(
							'element' => 'type',
							'value'   => array( esc_html__( 'Yes', 'grd' ) => '1' ),
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Auto play speed', 'grd' ),
						'param_name'  => 'autoplay_speed',
						'value'       => '2000',
						'description' => esc_html__( 'Set auto play speed (in ms).', 'grd' ),
						'dependency'  => array(
							'element' => 'autoplay',
							'value'   => array( 'yes' ),
						),
					),
					array(
						'type'       => 'param_group',
						'heading'    => esc_html__( 'Element carousel', 'grd' ),
						'value'      => '',
						'param_name' => 'setting',
						'params'     => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__( 'Title', 'grd' ),
								'param_name' => 'title',
								'value'      => '',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__( 'Title color', 'grd' ),
								'param_name' => 'title_color',
								'value'      => '',
								'group'      => esc_html__( 'Style', 'grd' )
							),

							array(
								'heading'     => esc_html__( 'Icon library', 'grd' ),
								'description' => esc_html__( 'Select icon library.', 'grd' ),
								'param_name'  => 'icon_style',
								'type'        => 'dropdown',
								'value'       => array(
									esc_html__( 'Font Awesome', 'grd' ) => 'fa_font',
									esc_html__( 'Svg icon', 'grd' )     => 'svg_icon',
									esc_html__( 'Custom image', 'grd' ) => 'image',
								),

							),
							array(
								'heading'     => esc_html__( 'Icon', 'grd' ),
								'description' => esc_html__( 'Pick an icon from library.', 'grd' ),
								'type'        => 'iconpicker',
								'param_name'  => 'icon_fontawesome',
								'value'       => 'fa fa-adjust',
								'settings'    => array(
									'emptyIcon'    => false,
									'iconsPerPage' => 4000,
								),
								'dependency'  => array(
									'element' => 'icon_style',
									'value'   => 'fa_font',
								),
							),
							array(
								'type'        => 'textfield',
								'heading'     => esc_html__( 'Svg icon', 'grd' ),
								'param_name'  => 'value_icon',
								'value'       => '',
								'description' => esc_html__( 'Enter name svg icon from grd theme' ),
								'dependency'  => array(
									'element' => 'icon_style',
									'value'   => 'svg_icon',
								),
							),
							array(
								'heading'     => esc_html__( 'Icon Image', 'grd' ),
								'description' => esc_html__( 'Upload icon image', 'grd' ),
								'type'        => 'attach_image',
								'param_name'  => 'image',
								'value'       => '',
								'dependency'  => array(
									'element' => 'icon_style',
									'value'   => 'image',
								),
							),
							array(
								'heading'     => esc_html__( 'Image size', 'grd' ),
								'description' => esc_html__( 'Enter image size', 'grd' ),
								'type'        => 'textfield',
								'param_name'  => 'image_size',
								'value'       => '',
								'dependency'  => array(
									'element' => 'icon_style',
									'value'   => 'image',
								),
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__( 'Icon Color', 'grd' ),
								'param_name' => 'icon_color',
								'value'      => '',
								'dependency' => array(
									'element' => 'icon_style',
									'value'   => array( 'fa_font', 'svg_icon' ),
								),
							),
							array(
								'type'        => 'textfield',
								'heading'     => esc_html__( 'Icon size', 'grd' ),
								'param_name'  => 'icon_size',
								'description' => esc_html__( 'Font size for icon example: 15px,22px.', 'grd' ),
								'dependency'  => array(
									'element' => 'icon_style',
									'value'   => array( 'fa_font', 'svg_icon' ),
								),
							),


							array(
								'type'       => 'textfield',
								'heading'    => esc_html__( 'Description', 'grd' ),
								'param_name' => 'description',
								'value'      => '',
							),

							array(
								'type'        => 'textfield',
								'heading'     => esc_html__( 'Text Button', 'grd' ),
								'param_name'  => 'text_bt',
								'value'       => '',
								'admin_label' => true,
							),
							array(
								'heading'    => esc_html__( 'URL (Link)', 'grd' ),
								'type'       => 'vc_link',
								'param_name' => 'link',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__( 'Button Border', 'grd' ),
								'param_name' => 'bt_border',
								'value'      => '',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__( 'Button Border Color', 'grd' ),
								'param_name' => 'bt_border_color',
								'value'      => '',
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__( 'Button Border Style', 'grd' ),
								'param_name' => 'bt_border_style',
								'value'      => array(
									esc_html__( 'Hidden', 'grd' ) => 'hidden',
									esc_html__( 'Solid', 'grd' )  => 'solid',
									esc_html__( 'Dotted', 'grd' ) => 'dotted',
									esc_html__( 'Dashed', 'grd' ) => 'dashed',
									esc_html__( 'Double', 'grd' ) => 'double',
								),
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__( 'Button Background Color', 'grd' ),
								'param_name' => 'bt_bg_color',
								'value'      => '',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__( 'Button Text Color', 'grd' ),
								'param_name' => 'bt_text_color',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__( 'Border radius', 'grd' ),
								'param_name' => 'border_radius',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__( 'Button padding', 'grd' ),
								'param_name' => 'button_padding',
								'value'      => '',
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__( 'Button Align', 'grd' ),
								'param_name' => 'bt_align',
								'value'      => array(
									esc_html__( 'Left', 'grd' )   => 'left',
									esc_html__( 'Center', 'grd' ) => 'center',
									esc_html__( 'Right', 'grd' )  => 'right',
								),
							),

						),
						'group'      => esc_html__( 'Element Award Carousel', 'grd' ),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Extra class name', 'grd' ),
						'param_name'  => 'el_class',
						'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'grd' ),
						'group'       => esc_html__( 'Add class', 'grd' ),
					),
				),
			)
		);
		// Blog Grid
		vc_map(
			array(
				'name'     => esc_html__( 'Blog Grid', 'grd' ),
				'base'     => 'grd_blog_grid',
				'class'    => '',
				'category' => esc_html__( 'Grd', ',' ),
				'params'   => array(
					array(
						'type'        => 'autocomplete',
						'heading'     => esc_html__( 'Categories', 'grd' ),
						'param_name'  => 'cats',
						'settings'    => array(
							'multiple' => true,
							'sortable' => true,
						),
						'save_always' => true,
						'description' => esc_html__( 'Enter categories', 'grd' )
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Posts per view', 'grd' ),
						'param_name'  => 'per_page',
						'value'       => '3',
						'description' => esc_html__( 'Set numbers of posts you want to display at the same time.', 'grd' ),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Order By', 'grd' ),
						'param_name'  => 'orderby',
						'value'       => array(
							''                                => '',
							esc_html__( 'Date', 'grd' )       => 'date',
							esc_html__( 'Title', 'grd' )      => 'title',
							esc_html__( 'Menu Order', 'grd' ) => 'menu_order',
							esc_html__( 'Random', 'grd' )     => 'rand',
						),
						'description' => esc_html__( 'Select to order posts. Leave empty to use the default order by of theme.', 'grd' ),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Order', 'grd' ),
						'param_name'  => 'order',
						'value'       => array(
							''                                 => '',
							esc_html__( 'Ascending ', 'grd' )  => 'asc',
							esc_html__( 'Descending ', 'grd' ) => 'desc',
						),
						'description' => esc_html__( 'Select to sort posts. Leave empty to use the default sort of theme', 'grd' ),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Show images', 'grd' ),
						'param_name' => 'images',
						'value'      => array(
							esc_html__( 'True ', 'grd' )  => '1',
							esc_html__( 'False ', 'grd' ) => '0',
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Extra class name', 'grd' ),
						'param_name'  => 'el_class',
						'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'grd' ),
					),
				),
			)
		);
		// Add Google Map
		vc_map(
			array(
				'name'     => esc_html__( 'Google Maps', 'grd' ),
				'base'     => 'grd_gmap',
				'category' => esc_html__( 'Grd', '' ),
				'params'   => array(
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Api Key', 'grd' ),
						'param_name'  => 'api_key',
						'value'       => '',
						'description' => sprintf( __( 'Please go to <a href="%s">Google Maps APIs</a> to get a key', 'grd' ), esc_url( 'https://developers.google.com/maps/documentation/javascript/get-api-key#get-an-api-key' ) ),
					),
					array(
						'type'        => 'attach_image',
						'heading'     => esc_html__( 'Marker', 'grd' ),
						'param_name'  => 'marker',
						'value'       => '',
						'description' => esc_html__( 'Choose an image from media library', 'grd' ),
					),
					array(
						'type'       => 'param_group',
						'heading'    => esc_html__( 'Address Infomation', 'grd' ),
						'value'      => '',
						'param_name' => 'info',
						'params'     => array(
							array(
								'type'        => 'textfield',
								'heading'     => esc_html__( 'Address', 'grd' ),
								'param_name'  => 'address',
								'admin_label' => true,
							),
							array(
								'type'       => 'textarea',
								'heading'    => esc_html__( 'Details', 'grd' ),
								'param_name' => 'details',
							),
						),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Width(px)', 'grd' ),
						'param_name' => 'width',
						'value'      => '',
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Height(px)', 'grd' ),
						'param_name' => 'height',
						'value'      => '500',
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Zoom', 'grd' ),
						'param_name' => 'zoom',
						'value'      => '13',
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Style', 'grd' ),
						'param_name' => 'style',
						'value'      => array(
							esc_html__( 'Style 1', 'grd' ) => '1',
							esc_html__( 'Style 2', 'grd' ) => '2',
						),
					),

					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Map Colors', 'grd' ),
						'param_name' => 'map_color',
						'value'      => '#efba2c',
						'dependency' => array(
							'element' => 'style',
							'value'   => array( '1' ),
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Extra class name', 'grd' ),
						'param_name'  => 'el_class',
						'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file . ', 'grd' ),
					),
				),
			)
		);
		// List
		vc_map(
			array(
				'name'     => esc_html__( 'List Nav', 'grd' ),
				'base'     => 'grd_list',
				'class'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Theme', 'grd' ),
						'param_name' => 'theme',
						'value'      => array(
							esc_html__( 'Dark', 'grd' )  => 'dark',
							esc_html__( 'Light', 'grd' ) => 'light',
						),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Title', 'grd' ),
						'param_name' => 'title',
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Title Color', 'grd' ),
						'param_name' => 'title_color',
						'value'      => '',
					),
					array(
						'type'       => 'textarea_html',
						'heading'    => esc_html__( 'Description', 'grd' ),
						'param_name' => 'content',
						'value'      => '',
					),
					array(
						'heading'     => esc_html__( 'Icon library', 'grd' ),
						'description' => esc_html__( 'Select icon library.', 'grd' ),
						'param_name'  => 'icon_library',
						'type'        => 'dropdown',
						'value'       => array(
							esc_html__( 'Font Awesome', 'grd' ) => '1',
							esc_html__( 'Svg icon', 'grd' )     => '2',
						),
					),
					array(
						'heading'     => esc_html__( 'Icon', 'grd' ),
						'description' => esc_html__( 'Pick an icon from library.', 'grd' ),
						'type'        => 'iconpicker',
						'param_name'  => 'icon_fontawesome',
						'value'       => 'fa fa-adjust',
						'settings'    => array(
							'emptyIcon'    => false,
							'iconsPerPage' => 4000,
						),
						'dependency'  => array(
							'element' => 'icon_library',
							'value'   => '1',
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Svg icon', 'grd' ),
						'param_name'  => 'name_svg',
						'value'       => '',
						'description' => esc_html__( 'Enter name svg icon from grd theme' ),
						'dependency'  => array(
							'element' => 'icon_library',
							'value'   => '2',
						),
					),
					array(
						'type'       => 'colorpicker',
						'heading'    => esc_html__( 'Icon Color', 'grd' ),
						'param_name' => 'icon_color',
						'value'      => '',
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Icon size', 'grd' ),
						'param_name'  => 'icon_size',
						'description' => esc_html__( 'Font size for icon example: 15px,22px.', 'grd' ),
					),
					array(
						'type'       => 'param_group',
						'heading'    => esc_html__( 'Element carousel', 'grd' ),
						'value'      => '',
						'param_name' => 'setting',
						'params'     => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__( 'Li', 'grd' ),
								'param_name' => 'content_list',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__( 'Li Color', 'grd' ),
								'param_name' => 'li_color',
								'value'      => '',
							),
							array(
								'heading'    => esc_html__( 'URL (Link)', 'grd' ),
								'type'       => 'vc_link',
								'param_name' => 'link',
							),
						),
					)
				),
			)
		);
		//Icon list
		vc_map(
			array(
				'name'     => esc_html__( 'Icon List', 'grd' ),
				'base'     => 'grd_icon_list',
				'class'    => '',
				'category' => esc_html__( 'Grd', 'grd' ),
				'params'   => array(
					array(
						'type'       => 'param_group',
						'heading'    => esc_html__( 'Element carousel', 'grd' ),
						'value'      => '',
						'param_name' => 'setting',
						'params'     => array(
							array(
								'type'        => 'dropdown',
								'heading'     => esc_html__( 'Style', 'grd' ),
								'param_name'  => 'style',
								'value'       => array(
									esc_html__( 'Style 1', 'grd' ) => '1',
									esc_html__( 'Style 2', 'grd' ) => '2',
								),
								'admin_label' => true,
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__( 'Theme', 'grd' ),
								'param_name' => 'theme',
								'value'      => array(
									esc_html__( 'Dark', 'grd' )  => 'dark',
									esc_html__( 'Light', 'grd' ) => 'light',
								),
							),
							array(
								'heading'    => esc_html__( 'Title', 'grd' ),
								'type'       => 'vc_link',
								'param_name' => 'link',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__( 'Title Color', 'grd' ),
								'param_name' => 'text_color',
								'value'      => '',
							),
							array(
								'type'       => 'textarea',
								'heading'    => esc_html__( 'Description', 'grd' ),
								'param_name' => 'desc',
								'value'      => '',
								'dependency' => array(
									'element' => 'style',
									'value'   => '1',
								),
							),
							array(
								'heading'     => esc_html__( 'Icon library', 'grd' ),
								'description' => esc_html__( 'Select icon library.', 'grd' ),
								'param_name'  => 'icon_type',
								'type'        => 'dropdown',
								'value'       => array(
									esc_html__( 'Font Awesome', 'grd' ) => 'fa_font',
									esc_html__( 'Svg icon', 'grd' )     => 'svg_icon',
								),
								'dependency'  => array(
									'element' => 'style',
									'value'   => '1',
								),
							),
							array(
								'heading'     => esc_html__( 'Icon', 'grd' ),
								'description' => esc_html__( 'Pick an icon from library.', 'grd' ),
								'type'        => 'iconpicker',
								'param_name'  => 'icon_fontawesome',
								'value'       => 'fa fa-adjust',
								'settings'    => array(
									'emptyIcon'    => false,
									'iconsPerPage' => 4000,
								),
								'dependency'  => array(
									'element' => 'icon_type',
									'value'   => 'fa_font',
								),
							),
							array(
								'type'        => 'textfield',
								'heading'     => esc_html__( 'Svg icon', 'grd' ),
								'param_name'  => 'value_icon',
								'value'       => '',
								'description' => esc_html__( 'Enter name svg icon from grd theme' ),
								'dependency'  => array(
									'element' => 'icon_type',
									'value'   => 'svg_icon',
								),
							),
							array(
								'type'        => 'textfield',
								'heading'     => esc_html__( 'Extra class name', 'grd' ),
								'param_name'  => 'el_class',
								'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'grd' ),
								'group'       => esc_html__( 'Setting', 'grd' )
							),
						),
						array(
							'type'        => 'textfield',
							'heading'     => esc_html__( 'Extra class name', 'grd' ),
							'param_name'  => 'el_class',
							'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'grd' ),
							'group'       => esc_html__( 'Setting', 'grd' )
						),
					),
				),
			)

		);
	}

	/**
	 * Suggester for autocomplete by slug
	 *
	 *
	 * @return array - id's from portfolio cat with title/slug.
	 */
	public function blogCatsAutocompleteSuggester( $query ) {
		global $wpdb;
		$cat_id          = (int) $query;
		$query           = trim( $query );
		$post_meta_infos = $wpdb->get_results(
			$wpdb->prepare(
				"SELECT a.term_id AS id, b.name as name, b.slug AS slug
						FROM {$wpdb->term_taxonomy} AS a
						INNER JOIN {$wpdb->terms} AS b ON b.term_id = a.term_id
						WHERE a.taxonomy = 'category' AND (a.term_id = '%d' OR b.slug LIKE '%%%s%%' OR b.name LIKE '%%%s%%' )", $cat_id > 0 ? $cat_id : - 1, stripslashes( $query ), stripslashes( $query )
			), ARRAY_A
		);

		$result = array();
		if ( is_array( $post_meta_infos ) && ! empty( $post_meta_infos ) ) {
			foreach ( $post_meta_infos as $value ) {
				$data          = array();
				$data['value'] = $value['slug'];
				$data['label'] = esc_html__( 'Id', 'grd' ) . ': ' . $value['id'] . ' - ' . esc_html__( 'Name', 'grd' ) . ': ' . $value['name'];
				$result[]      = $data;
			}
		}

		return $result;
	}

	/**
	 * Find post cat by slug
	 * @since 4.4
	 *
	 * @param $query
	 *
	 * @return bool|array
	 */
	public function blogCatsAutocompleteRender( $query ) {
		$query = $query['value'];
		$query = trim( $query );
		$term  = get_term_by( 'slug', $query, 'category' );

		if ( is_wp_error( $term ) || ! $term ) {
			return false;
		}

		$data          = array();
		$data['value'] = $term->slug;
		$data['label'] = esc_html__( 'Id', 'grd' ) . ': ' . $term->term_id . ' - ' . esc_html__( 'Name', 'grd' ) . ': ' . $term->name;


		return $data;
	}
}