<?php

/**
 * Define theme shortcodes
 *
 * @package Grd
 */
class Grd_Shortcodes {

	/**
	 * Store variables for js
	 *
	 * @var array
	 */
	public $l10n = array();

	public $api_key = '';

	/**
	 * Store variables for maps
	 *
	 * @var array
	 */
	public $maps = array();

	/**
	 * Check if WooCommerce plugin is actived or not
	 *
	 * @var bool
	 */
	private $wc_actived = false;

	/**
	 * Construction
	 *
	 * @return Grd_Shortcodes
	 */
	function __construct() {
		$this->wc_actived = function_exists( 'is_woocommerce' );

		$shortcodes = array(
			'grd_empty_space',
			'grd_images_carousel',
			'grd_faq',
			'grd_timeline',
			'grd_members',
			'grd_counter',
			'grd_font_size_handle',
			'grd_prices_table_1',
			'grd_prices_table_2',
			'grd_prices_table_3',
			'grd_portfolio_carousel',
			'grd_portfolio_attribute',
			'grd_addons_btn',
			'grd_section_title',
			'grd_button',
			'grd_contact_box',
			'grd_image_box',
			'grd_icon_box',
			'grd_portfolio',
			'grd_team_carousel',
			'grd_video_banner',
			'grd_testimorial_carousel',
			'grd_banner',
			'grd_award_carousel',
			'grd_blog_grid',
			'grd_gmap',
			'grd_list',
			'grd_icon_list'
		);

		foreach ( $shortcodes as $shortcode ) {
			add_shortcode( $shortcode, array( $this, $shortcode ) );
		}

		add_action( 'wp_footer', array( $this, 'footer' ) );
	}

	public function footer() {
		// Load Google maps only when needed
		if ( isset( $this->l10n['map'] ) ) {
			echo '<script>if ( typeof google !== "object" || typeof google.maps !== "object" )
				document.write(\'<script src="//maps.google.com/maps/api/js?sensor=false&key=' . $this->api_key . '"><\/script>\')</script>';
		}

		wp_enqueue_script(
			'shortcodes', GRD_ADDONS_URL . '/assets/js/frontend.js', array(
			'jquery',
		), '20171018', true
		);

		$this->l10n['isRTL'] = is_rtl();

		wp_localize_script( 'shortcodes', 'grdShortCode', $this->l10n );
	}

	/**
	 * Get empty space
	 *
	 * @since  1.0
	 *
	 * @return string
	 */
	function grd_empty_space( $atts, $content ) {
		$atts = shortcode_atts(
			array(
				'height'        => '',
				'height_mobile' => '',
				'height_tablet' => '',
				'bg_color'      => '',
				'el_class'      => '',
			), $atts
		);

		$css_class = array(
			'grd-empty-space',
			$atts['el_class'],
		);

		$style = '';

		if ( $atts['bg_color'] ) {
			$style = 'background-color:' . $atts['bg_color'] . ';';
		}

		$height        = $atts['height'] ? (float) $atts['height'] : 0.0;
		$height_tablet = $atts['height_tablet'] ? (float) $atts['height_tablet'] : $height;
		$height_mobile = $atts['height_mobile'] ? (float) $atts['height_mobile'] : $height_tablet;

		$inline_css        = $height >= 0.0 ? ' style="height: ' . esc_attr( $height ) . 'px"' : '';
		$inline_css_mobile = $height_mobile >= 0.0 ? ' style="height: ' . esc_attr( $height_mobile ) . 'px"' : '';
		$inline_css_tablet = $height_tablet >= 0.0 ? ' style="height: ' . esc_attr( $height_tablet ) . 'px"' : '';

		return sprintf(
			'<div class="%s" style="%s">' .
			'<div class="grd_empty_space_lg visible-lg" %s></div>' .
			'<div class="grd_empty_space_md visible-md visible-sm" %s></div>' .
			'<div class="grd_empty_space_xs visible-xs" %s></div>' .
			'</div>',
			esc_attr( implode( ' ', $css_class ) ),
			$style,
			$inline_css,
			$inline_css_tablet,
			$inline_css_mobile
		);
	}

	function grd_images_carousel( $atts, $content ) {
		$atts = shortcode_atts(
			array(
				'image_size' => '',
				'nav'        => '',
				'dots'       => '',
				'autoplay'   => '',
				'speed'      => '3500',
				'columns'    => '1',
				'setting'    => '',
				'el_class'   => '',
			), $atts
		);

		$columns = intval( $atts['columns'] );
		$speed   = intval( $atts['speed'] );


		if ( $atts['dots'] ) {
			$dot = true;
		} else {
			$dot = false;
		}

		if ( $atts['nav'] ) {
			$nav = true;
		} else {
			$nav = false;
		}

		if ( $atts['autoplay'] ) {
			$autoplay = true;
		} else {
			$autoplay = false;
		}

		$id = uniqid( 'grd-img-slick-' );

		$this->l10n['imagesCarousel'][ $id ] = array(
			'slide'    => $columns,
			'scroll'   => $columns,
			'speed'    => $speed,
			'nav'      => $nav,
			'dot'      => $dot,
			'autoplay' => $autoplay,

		);

		$infor   = vc_param_group_parse_atts( $atts['setting'] );
		$outputs = array();

		if ( ! empty( $infor ) ) {
			foreach ( $infor as $key => $value ) {

				if ( ! isset( $value['image_gr'] ) ) {
					continue;
				}

				if ( empty( $value['image_gr'] ) ) {
					continue;
				}

				$image = grd_load_image( $value['image_gr'], $atts['image_size'] );

				$button = '';
				if ( isset( $value['link'] ) && ! empty( $value['link'] ) ) {
					$link = vc_build_link( $value['link'] );

					if ( isset( $link['url'] ) && ! empty( $link['url'] ) ) {
						$href   = $link['url'];
						$button = sprintf( '<a href="%s">%s</a>', $href, $image );
					}

				}

				if( empty( $button ) ) {
					$button = sprintf( '%s', $image );
				}


				$outputs[] = sprintf(
					'<div class="box-img">' .
					'%s' .
					'</div>',
					$button
				);
			}
		}

		return sprintf(
			'<div id="%s" class="carousel-img">' .
			'%s' .
			'</div>',
			$id,
			implode( '', $outputs )
		);

	}

	function grd_faq( $atts, $content ) {
		$atts = shortcode_atts(
			array(
				'text_color' => 'dark',
				'setting'    => '',
				'el_class'   => '',
			), $atts
		);

		$css_class = array(
			'dl_faq',
			$atts['el_class'],
		);

		$infor   = vc_param_group_parse_atts( $atts['setting'] );
		$outputs = array();

		if ( ! empty( $infor ) ) {
			foreach ( $infor as $key => $value ) {
				$style = array(
					'side_faq',
					'style-' . $value['style'],
					'text-' . $atts['text_color'],
				);
				//check color
				if ( ! empty( $value['color_qu'] ) && isset( $value['color_qu'] ) ) {
					$style_color = sprintf( 'style = "color:%s"', $value['color_qu'] );
				} else {
					$style_color = "";
				}

				if ( ! empty( $value['question_t'] ) ) {
					$question_t = sprintf( '<h2>%s</h2>', $value['question_t'] );
				}
				if ( ! empty( $value['answer_t'] ) ) {
					$answer_t = sprintf( '<h2>%s</h2>', $value['answer_t'] );
				}
				if ( ! empty( $value['question_c'] ) ) {
					$question_c = sprintf( '<h3 %s>%s</h3>', $style_color, $value['question_c'] );
				}
				if ( ! empty( $value['content'] ) ) {
					$answer_c = sprintf( '<p>%s</p>', $value['content'] );
				}
				$icon = sprintf( '<span class="svg-icon icon-question"><svg viewbox="0 0 512 512" %s><use xlink:href="#question"></use></svg></span>', $style_color );

				if ( $value['style'] == 1 ) {

					$outputs[] = sprintf(
						'<div class="%s">' .
						'<div class="box-icon">' .
						'%s' .
						'</div>' .
						'<div class="box-faq">' .
						'%s' .
						'%s' .
						'</div>' .
						'</div>',
						esc_attr( implode( ' ', $style ) ),
						$icon,
						$question_c,
						$answer_c
					);
				} else {
					$outputs[] = sprintf(
						'<div class="%s">' .
						'<div class="row">' .
						'<div class="col-sm-4 question">' .
						'%s' .
						'%s' .
						'</div>' .
						'<div class="col-sm-8 asked">' .
						'%s' .
						'%s' .
						'</div>' .
						'</div>' .
						'</div>',
						esc_attr( implode( ' ', $style ) ),
						$question_t,
						$question_c,
						$answer_t,
						$answer_c
					);
				}


			}

			return sprintf(
				'<div class="%s">' .
				'%s' .
				'</div>',
				implode( '', $css_class ),
				implode( '', $outputs )
			);
		}

	}

	function grd_timeline( $atts, $content ) {
		$atts = shortcode_atts(
			array(
				'nav'      => '',
				'autoplay' => '',
				'speed'    => '3500',
				'columns'  => '3',
				'setting'  => '',
				'el_class' => '',
			), $atts
		);

		$columns = intval( $atts['columns'] );
		$speed   = intval( $atts['speed'] );

		$fix_overlay = "";
		if ( $atts['columns'] == "4" ) {
			$fix_overlay = "fix-overlay";
		}

		$css_class = array(
			'dl_timeline ',
			$fix_overlay,
			$atts['el_class'],
		);

		if ( $atts['nav'] ) {
			$nav = true;
		} else {
			$nav = false;
		}

		if ( $atts['autoplay'] ) {
			$autoplay = true;
		} else {
			$autoplay = false;
		}

		$id = uniqid( 'grd-timeline-slick-' );

		$this->l10n['timelineCarousel'][ $id ] = array(
			'slide'    => $columns,
			'speed'    => $speed,
			'nav'      => $nav,
			'autoplay' => $autoplay,

		);

		$infor   = vc_param_group_parse_atts( $atts['setting'] );
		$outputs = array();

		if ( ! empty( $infor ) ) {
			foreach ( $infor as $key => $value ) {

				if ( isset( $value['image'] ) ) {
					$image = wp_get_attachment_image_src( $value['image'], 'full' );
					if ( $image ) {
						$src = $image[0];
					}
				}

				if ( isset( $value['year'] ) ) {
					$year = sprintf( '<h4>%s</h4>', $value['year'] );
				}
				if ( isset( $value['title'] ) ) {
					$title = sprintf( '<h2>%s</h2>', $value['title'] );
				}
				if ( isset( $value['desc'] ) ) {
					$desc = sprintf( '<p>%s</p>', $value['desc'] );
				}
				$outputs[] = sprintf(

					'<div class="box-timeline">' .
					'<div class="hook">' .
					'<span><p></p></span>' .
					'<span></span>' .
					'</div>' .
					'%s' .
					'<div class="box-img">' .
					'<img alt="%s" src="%s">' .
					'<div class="overlay">' .
					'%s' .
					'%s' .
					'</div>' .
					'</div>' .
					'</div>',
					$year,
					$title,
					$src,
					$title,
					$desc
				);
			}
		}

		return sprintf(
			'<div id="%s" class="%s">' .
			'%s' .
			'</div>',
			$id,
			implode( '', $css_class ),
			implode( '', $outputs )
		);
	}

	function grd_members( $atts, $content ) {
		$atts = shortcode_atts(
			array(
				'text_color'  => 'text-dark',
				'title'       => '',
				'link'        => '',
				'style_box'   => '1',
				'style_hover' => '1',
				'name'        => '',
				'image'       => '',
				'office'      => '',
				'setting'     => '',
				'el_class'    => '',
			), $atts
		);

		$css_class = array(
			'dl_members ',
			'box-' . $atts['style_box'],
			' style-' . $atts['style_hover'],
			$atts['el_class']
		);
		//box text
		if ( ! empty( $atts['title'] ) ) {
			$title = sprintf( '<h2>%s</h2>', $atts['title'] );
		}
		$btn        = $this->grd_addons_btn( $atts );
		$check_link = vc_build_link( $atts['link'] );
		$dl_btn     = '';
		if ( isset( $atts['link'] ) && ! empty( $atts['link'] ) && ! empty( $check_link['url'] ) ) {
			$dl_btn = sprintf(
				'<div class="btn-team">' .
				'<span class="svg-icon icon-right-arrow"><svg viewbox="0 0 512 512"><use xlink:href="#right-arrow"></use></svg></span>' .
				'%s' .
				'</div>',
				$btn
			);
		}

		// box member
		if ( ! empty( $atts['name'] ) ) {
			$name = sprintf( '<h3>%s</h3>', $atts['name'] );
		}
		if ( ! empty( $atts['office'] ) ) {
			$office = sprintf( '<div class="job">%s</div>', $atts['office'] );
		}
		if ( isset( $atts['image'] ) ) {
			$image = wp_get_attachment_image_src( $atts['image'], 'full' );
			if ( $image ) {
				$src = $image[0];
			}
			$avatar = sprintf( '<img alt="%s" src="%s">', $atts['name'], $src );
		}

		$infor   = vc_param_group_parse_atts( $atts['setting'] );
		$outputs = array();

		if ( ! empty( $infor ) ) {
			foreach ( $infor as $key => $value ) {

				$link = vc_build_link( $value['link'] );

				if ( ! empty( $link['url'] ) ) {
					$href = $link['url'];
				}

				$outputs[] = sprintf(
					'<li>' .
					'<a href="%s"><i class="%s"></i></a>' .
					'</li>',
					$href,
					$value['icon_fontawesome']
				);
			}

		}
		$content_contact = sprintf(
			'<ul>' .
			'%s' .
			'</ul>',
			implode( '', $outputs )
		);
		if ( $atts['style_box'] == 1 ) {
			return sprintf(
				'<div class="%s">' .
				'<div class="box-member">' .
				'%s' .
				'<div class="box-img">' .
				'%s' .
				'<div class="overlay-link">' .
				'%s' .
				'</div>' .
				'</div>' .
				'%s' .
				'</div>' .
				'</div>',
				implode( '', $css_class ),
				$name,
				$avatar,
				$content_contact,
				$office
			);
		} else {
			return sprintf(
				'<div class="%s %s">' .
				'<div class="box-img">' .
				'%s' .
				'</div>' .
				'<div class="box-text">' .
				'%s' .
				'%s' .
				'</div>' .
				'</div>',
				implode( '', $css_class ),
				$atts['text_color'],
				$avatar,
				$title,
				$dl_btn
			);
		}

	}

	function grd_counter( $atts, $content ) {
		$atts = shortcode_atts(
			array(
				'style'        => '1',
				'number'       => '',
				'number_color' => '',
				'text_color'   => '',
				'duration'     => '1',
				'border_color' => '',
				'text_after'   => '',
				'el_class'     => '',
			), $atts
		);

		$css_class = array(
			'dl_counter ',
			'style-' . $atts['style'],
			$atts['el_class']
		);

		if ( ! empty( $atts['number_color'] ) ) {
			$number_color = sprintf( 'color:%s', $atts['number_color'] );
		}

		$color_text = '';
		if ( ! empty( $atts['text_color'] ) ) {
			$color_text = sprintf( 'color:%s', $atts['text_color'] );
		}

		$border_color = "";
		if ( ! empty( $atts['border_color'] ) && $atts['style'] == 1 ) {
			$border_color = sprintf( '<div class="border" style ="border-color:%s"></div>', $atts['border_color'] );
		}

		$border_right = "";
		if ( ! empty( $atts['border_color'] ) && $atts['style'] == 2 ) {
			$border_right = sprintf( '<div class="border-right" style ="background-color:%s"></div>', $atts['border_color'] );
		}

		if ( ! empty( $atts['number'] ) ) {
			$number = sprintf( '<span class="counter-number" style="%s" data-duration="%s">%s</span>', $number_color, $atts['duration'], $atts['number'] );
		}

		$text_after = '';
		if ( ! empty( $atts['text_after'] ) ) {
			$text_after = sprintf( '<span style="%s">%s</span>', $number_color, $atts['text_after'] );
		}

		if ( ! empty( $content ) ) {
			$content = sprintf( '<p style="%s">%s</p>', $color_text, $content );
		}

		return sprintf(
			'<div class="%s counter-value" data-duration="%s">' .
			'%s' .
			'<div class="content">' .
			'%s' .
			'<h3>' .
			'%s' .
			'%s' .
			'</h3>' .
			'%s' .
			'</div>' .
			'</div>',
			implode( '', $css_class ),
			$atts['duration'],
			$border_color,
			$border_right,
			$number,
			$text_after,
			$content
		);
	}

	function grd_prices_table_1( $atts, $content ) {
		$atts = shortcode_atts(
			array(
				'title'      => '',
				'service'    => '',
				'text_color' => 'dark',
				'setting'    => '',
				'el_class'   => '',
			), $atts
		);

		$css_class = array(
			'dl_prices_1 ',
			'text-' . $atts['text_color'],
			$atts['el_class'],
		);

		$infor   = vc_param_group_parse_atts( $atts['setting'] );
		$outputs = array();

		if ( ! empty( $infor ) ) {
			foreach ( $infor as $key => $value ) {

				$sv        = vc_param_group_parse_atts( $value['service_box'] );
				$output_sv = array();
				if ( ! empty( $sv ) ) {
					foreach ( $sv as $keys => $val ) {
						$output_sv[] = sprintf( '<li><i class="fa fa-leaf"></i>%s</li>', $val['name_sv'] );
					}
					$count       = count( $output_sv );
					$line_height = 36 * $count;

					$list_sv = sprintf(
						'<ul>' .
						'%s' .
						'</ul>',
						implode( '', $output_sv )
					);
				}

				$style_height = sprintf( 'style="line-height:%spx"', $line_height );

				if ( ! empty( $value['color_pr'] ) ) {
					$color = sprintf( 'style="color:%s"', $value['color_pr'] );
				}
				if ( ! empty( $value['background_pr'] ) ) {
					$bk = sprintf( 'style="background-color:%s"', $value['background_pr'] );
				} else {
					$bk = "";
				}

				if ( ! empty( $value['title_gr'] ) ) {
					$title = sprintf( '<h3 %s>%s</h3>', $style_height, $value['title_gr'] );
				}

				if ( ! empty( $value['unit_gr'] ) ) {
					$unit = sprintf( '<span %s>%s</span>', $color, $value['unit_gr'] );
				} else {
					$unit = '';
				}

				if ( ! empty( $value['price_gr'] ) ) {
					$price = sprintf( '<p %s><span %s>%s</span>%s</p>', $style_height, $color, $value['price_gr'], $unit );
				}

				$outputs[] = sprintf(
					'<div class="main_table form">' .
					'<div>' .
					'%s' .
					'</div>' .
					'<div>' .
					'%s' .
					'</div>' .
					'<div %s>' .
					'%s' .
					'</div>' .
					'</div>',
					$title,
					$list_sv,
					$bk,
					$price
				);
			}

			return sprintf(
				'<div class="%s ">' .
				'<div class="title-price form">' .
				'<div>' .
				'%s' .
				'</div>' .
				'<div>' .
				'%s' .
				'</div>' .
				'<div>' .
				'</div>' .
				'</div>' .
				'%s' .
				'</div>',
				implode( '', $css_class ),
				$atts['title'],
				$atts['service'],
				implode( '', $outputs )
			);
		}
	}

	function grd_prices_table_2( $atts, $content ) {
		$atts = shortcode_atts(
			array(
				'title_sv'   => '',
				'bk_sv'      => '',
				'title_pr'   => '',
				'bk_pr'      => '',
				'text_color' => 'dark',
				'setting'    => '',
				'el_class'   => '',
			), $atts
		);

		$css_class = array(
			'dl_prices_2 ',
			'text-' . $atts['text_color'],
			$atts['el_class'],
		);

		if ( ! empty( $atts['bk_sv'] ) ) {
			$bk_sv = sprintf( 'style="background-color:%s; border:none"', $atts['bk_sv'] );
		}

		if ( ! empty( $atts['bk_pr'] ) ) {
			$bk_pr = sprintf( 'style="background-color:%s; border:none"', $atts['bk_pr'] );
		}

		$infor   = vc_param_group_parse_atts( $atts['setting'] );
		$outputs = array();

		if ( ! empty( $infor ) ) {
			foreach ( $infor as $key => $value ) {

				$color = '';
				if ( ! empty( $value['color_pr'] ) ) {
					$color = sprintf( 'style="color:%s"', $value['color_pr'] );
				}

				if ( ! empty( $value['background_tit'] ) ) {
					$bk_tit = sprintf( 'style="background-color:%s"', $value['background_tit'] );
				} else {
					$bk_tit = "";
				}

				if ( ! empty( $value['background_pr'] ) ) {
					$bk_pr_gr = sprintf( 'style="background-color:%s"', $value['background_pr'] );
				} else {
					$bk_pr_gr = "";
				}

				if ( ! empty( $value['title_gr'] ) ) {
					$title = sprintf( '<p %s>%s</p>', $color, $value['title_gr'] );
				}

				if ( ! empty( $value['price_gr'] ) ) {
					$price = sprintf( '<p %s>%s</p>', $color, $value['price_gr'] );
				}

				$outputs[] = sprintf(
					'<div class="main_price form">' .
					'<div %s>' .
					'%s' .
					'</div>' .
					'<div %s>' .
					'%s' .
					'</div>' .
					'</div>',
					$bk_tit,
					$title,
					$bk_pr_gr,
					$price
				);
			}


		}

		return sprintf(
			'<div class="%s ">' .
			'<div class="title-price form">' .
			'<div %s>' .
			'%s' .
			'</div>' .
			'<div %s>' .
			'%s' .
			'</div>' .
			'</div>' .
			'%s' .
			'</div>',
			implode( '', $css_class ),
			$bk_sv,
			$atts['title_sv'],
			$bk_pr,
			$atts['title_pr'],
			implode( '', $outputs )
		);
	}

	function grd_prices_table_3( $atts, $content ) {
		$atts = shortcode_atts(
			array(
				'style'            => '1',
				'title'            => '',
				'text_color'       => 'dark',
				'service_box'      => '',
				'price'            => '',
				'price_color'      => '',
				'unit'             => '',
				'text_after_price' => '',
				'text_after_color' => '',
				'sale'             => '',
				'link'             => '',
				'btn_color'        => '',
				'border_color'     => '',
				'el_class'         => '',
			), $atts
		);

		$css_class = array(
			'dl_prices_3 ',
			'style-' . $atts['style'],
			' text-' . $atts['text_color'],
			$atts['el_class'],
		);
		// check color
		$price_color = '';
		if ( ! empty( $atts['price_color'] ) ) {
			$price_color = sprintf( 'style="color:%s"', $atts['price_color'] );
		}
		$text_after_color = '';
		if ( ! empty( $atts['text_after_color'] ) ) {
			$text_after_color = sprintf( 'style="color:%s"', $atts['text_after_color'] );
		}

		$sale = '';
		if ( ! empty( $atts['sale'] ) ) {
			$sale = sprintf( '<span class="sale">%s<br/> OFF</span>', $atts['sale'] );
		}
		if ( ! empty( $atts['title'] ) ) {
			$title = sprintf( '<h3>%s %s</h3>', $atts['title'], $sale );
		}
		if ( ! empty( $atts['unit'] ) ) {
			$unit = sprintf( '<span class="unit-pr">%s</span>', $atts['unit'] );
		}

		if ( ! empty( $atts['text_after_price'] ) ) {
			$text_after = sprintf( '<span class="text-after" %s>%s</span>', $text_after_color, $atts['text_after_price'] );
		}
		$price = sprintf( '<div class="price" %s>%s<span class="price-main">%s</span>%s</div>', $price_color, $unit, $atts['price'], $text_after );


		$infor   = vc_param_group_parse_atts( $atts['service_box'] );
		$outputs = array();

		if ( ! empty( $infor ) ) {
			foreach ( $infor as $key => $value ) {
				if ( ! isset( $value['name_sv'] ) ) {
					continue;
				}

				if ( empty( $value['name_sv'] ) ) {
					continue;
				}
				$outputs[] = sprintf( '<li>%s</li>', $value['name_sv'] );
			}
			$list_sv = sprintf(
				'<ul>' .
				'%s' .
				'</ul>',
				implode( '', $outputs )
			);
		}
		$btn[] = $this->grd_addons_btn( $atts );

		return sprintf(
			'<div class="%s ">' .
			'%s' .
			'%s' .
			'%s' .
			'%s' .
			'</div>',
			implode( '', $css_class ),
			$title,
			$list_sv,
			$price,
			implode( '', $btn )
		);

	}

	/**
	 * @param string $atts
	 *
	 * @return string
	 */
	function grd_font_size_handle( $atts ) {
		$atts = preg_replace( '/\s+/', '', $atts );

		$pattern = '/^(\d*(?:\.\d+)?)\s*(px|\%|in|cm|mm|em|rem|ex|pt|pc|vw|vh|vmin|vmax)?$/';
		// allowed metrics: http://www.w3schools.com/cssref/css_units.asp
		$regexr   = preg_match( $pattern, $atts, $matches );
		$value    = isset( $matches[1] ) ? (float) $matches[1] : (float) $atts;
		$unit     = isset( $matches[2] ) ? $matches[2] : 'px';
		$fontSize = $value . $unit;

		return $fontSize;
	}


	function grd_addons_btn( $atts ) {
		$css_class = array(
			'dl-button',
			$atts['el_class'],
		);

		$style_css = array();
		if ( isset( $atts['btn_color'] ) && ! empty( $atts['btn_color'] ) ) {
			$style_css[] = sprintf( 'color:%s', $atts['btn_color'] );
		}

		if ( isset( $atts['bg_color'] ) && ! empty( $atts['bg_color'] ) ) {
			$style_css[] = sprintf( ';background-color:%s', $atts['bg_color'] );
		}

		if ( ! empty( $atts['border_color'] ) ) {
			$style_css[] = sprintf( ';border-color:%s', $atts['border_color'] );
		}
		if ( ! empty( $style_css ) ) {
			$style = sprintf( 'style ="%s"', implode( ' ', $style_css ) );
		} else {
			$style = '';
		}

		if ( ! empty( $style_css ) ) {
			$style = sprintf( 'style ="%s"', implode( ' ', $style_css ) );
		} else {
			$style = '';
		}

		$attributes = array();

		$link = vc_build_link( $atts['link'] );

		if ( ! empty( $link['url'] ) ) {
			$attributes['href'] = $link['url'];
		}

		$label = $link['title'];

		if ( ! $label ) {
			$attributes['title'] = $label;
		}

		if ( ! empty( $link['target'] ) ) {
			$attributes['target'] = $link['target'];
		}

		if ( ! empty( $link['rel'] ) ) {
			$attributes['rel'] = $link['rel'];
		}

		$attr = array();

		foreach ( $attributes as $name => $v ) {
			$attr[] = $name . '="' . esc_attr( $v ) . '"';
		}

		$button = sprintf(
			'<%1$s %2$s %3$s>%4$s</%1$s>',
			empty( $attributes['href'] ) ? 'span' : 'a',
			implode( ' ', $attr ),
			$style,
			$label
		);

		return sprintf(
			'<div class="%s">%s</div>',
			esc_attr( implode( ' ', $css_class ) ),
			$button
		);
	}

	/**
	 **
	 * Get portfolio attribute
	 *
	 * @since  1.0
	 *
	 * @return string
	 */
	function grd_portfolio_attribute( $atts, $content ) {
		$atts = shortcode_atts(
			array(
				'client'   => '',
				'rating'   => '',
				'start'    => '',
				'ends'     => '',
				'location' => '',
				'budget'   => '',
			), $atts
		);

		$client   = $atts['client'];
		$rating   = $atts['rating'];
		$start    = $atts['start'];
		$ends     = $atts['ends'];
		$location = $atts['location'];
		$budget   = $atts['budget'];
		$terms    = get_the_terms( get_the_ID(), 'portfolio_category' );
		$category = '';

		if ( $terms && ! is_wp_error( $terms ) ) :
			$category_link = get_term_link( $terms[0]->term_id, 'portfolio_category' );
			$category_name = $terms[0]->name;
			$category      = "<a class='category' href='$category_link'>$category_name</a>";
		endif;


		$category = ! empty( $category ) ? "<li><p>" . esc_html__( 'Category ', 'grd' ) . "</p><span>:</span><span> $category</span></li>" : '';
		$client   = ! empty( $client ) ? "<li><p>" . esc_html__( 'Client ', 'grd' ) . "</p><span>:</span><span> $client</span></li>" : '';
		$start    = ! empty( $start ) ? "<li><p>" . esc_html__( 'Starts On ', 'grd' ) . " </p><span>:</span><span> $start</span></li>" : '';
		$ends     = ! empty( $ends ) ? "<li><p>" . esc_html__( 'Ends On ', 'grd' ) . " </p><span>:</span><span> $ends</span></li>" : '';
		$location = ! empty( $location ) ? "<li><p>" . esc_html__( 'Location ', 'grd' ) . " </p><span>:</span><span> $location</span></li>" : '';
		$budget   = ! empty( $budget ) ? "<li><p>" . esc_html__( 'Budget ', 'grd' ) . " </p><span>:</span><span> $budget</span></li>" : '';
		$star     = "<i class='fa fa-star'></i>";
		$star_o   = "<i class='fa fa-star-o'></i>";

		$rating        = intval( $rating );
		$rating_star   = array();
		$rating_star_0 = array();
		$count         = $rating;

		for ( $count; $count >= 1; $count -- ) {
			$rating_star[] = $star;
		}
		for ( $count; $count < 5; $count ++ ) {
			if ( $count == 5 - $rating ): break;endif;
			$rating_star_0[] = $star_o;
		}

		$star_count = implode( '', $rating_star );
		$star_count .= implode( '', $rating_star_0 );


		return sprintf( "<div class='col-xs-12 grd_portfolio_atrrs'>
						<ul>%s
						%s 
						%s 
						%s 
						%s 
						%s
						<li class='rating'><p>%s</p><span>:</span><span>%s</span></li></ul></div>",
			$category, $client, $start, $ends, $location, $budget, esc_html__( 'Rating', 'grd' ), $star_count
		);
	}


	/**
	 * Get section title
	 *
	 * @since  1.0
	 *
	 * @return string
	 */
	function grd_section_title( $atts, $content ) {
		$atts       = shortcode_atts(
			array(

				'title'      => '',
				'font_size'  => '',
				'style'      => '1',
				'el_class'   => '',
				'text_color' => '',
				'theme'      => 'dark',

			), $atts
		);
		$font_size  = $atts['font_size'];
		$title      = $atts['title'];
		$style      = $atts['style'];
		$el_class   = $atts['el_class'];
		$text_color = $atts['text_color'];
		$theme      = $atts['theme'];
		if ( $style == 1 ):$class_layout = '12 text-center';
		else:$class_layout = '12';endif;
		$font_size    = ! empty( $font_size ) ? "font-size: $font_size;" : '';
		$text_color   = ! empty( $text_color ) ? "color: $text_color" : '';
		$style_text   = "style='$font_size $text_color'";
		$layout_descr = sprintf( '<div class="no-padding col-xs-12 col-sm-%s desc"><p>%s</p></div>', $class_layout, $content );

		if ( $style == 3 ) {
			$layout_descr = sprintf( '<div class="no-padding col-xs-12 col-sm-%s desc"><div class="content"><span class="line"></span><span>%s</span><span class="line"></span></div></div>',
				$class_layout, $content );
		}

		return sprintf( "<div class='col-xs-12 col-sm-12 no-padding grd-section-title sc-%s grd_title-type-%s %s' >
		<h3 class='no-padding col-xs-12 col-sm-%s title' %s>%s</h3> %s </div>", $theme, $style, $el_class, $class_layout, $style_text, $title, $layout_descr );
	}

	/**
	 * Get button
	 *
	 * @since  1.0
	 *
	 * @return string
	 */
	function grd_button( $atts, $content ) {
		$atts            = shortcode_atts(
			array(

				'text_bt'          => '',
				'link'             => '',
				'bt_border'        => '',
				'bt_border_color'  => '',
				'bt_border_style'  => '',
				'bt_bg_color'      => '',
				'bt_text_color'    => '',
				'border_radius'    => '',
				'bt_align'         => 'left',
				'icon_type'        => 'none',
				'icon_color'       => '',
				'icon_size'        => '50px',
				'value_icon'       => '',
				'icon_fontawesome' => '',
				'image_size'       => '',
				'image'            => '',
				'padding'          => '',
				'bt_hover'         => '1',
				'el_class'         => '',

			), $atts
		);
		$value_icon      = $atts['value_icon'];
		$icon_type       = $atts['icon_type'];
		$text_bt         = $atts['text_bt'];
		$link            = vc_build_link( $atts['link'] );
		$link            = $link['url'];
		$bt_border       = $atts['bt_border'];
		$bt_border_color = $atts['bt_border_color'];
		$bt_border_style = $atts['bt_border_style'];
		$bt_bg_color     = $atts['bt_bg_color'];
		$bt_text_color   = $atts['bt_text_color'];
		$border_radius   = $atts['border_radius'];
		$bt_align        = $atts['bt_align'];
		$bt_hover        = $atts['bt_hover'];
		$padding         = $atts['padding'];
		$el_class        = $atts['el_class'];
		$image_ids       = $atts['image'];
		$bt_bg_color     = ! empty( $bt_bg_color ) ? "background-color: $bt_bg_color;" : '';
		$bt_text_color   = ! empty( $bt_text_color ) ? "color: $bt_text_color;" : '';
		$border_radius   = ! empty( $border_radius ) ? "border-radius: $border_radius;" : '';
		$padding         = ! empty( $padding ) ? "padding: $padding;" : '';
		$border          = '';
		if ( $bt_border || $bt_border_color || $bt_border_style ): $border = sprintf( "border: %s %s %s;", $bt_border, $bt_border_style, $bt_border_color );endif;

		$style          = sprintf( 'style="%s" ', $bt_bg_color . $bt_text_color . $border . $border_radius . $padding );
		$style_ic_color = ! empty( $icon_color ) ? "color:$icon_color;" : '';
		$icon_size      = ! empty( $icon_size ) ? "font-size:$icon_size;" : '';
		$style_ic       = "style='$style_ic_color $icon_size '";

		switch ( $icon_type ) {
			case 'none':
				$icon = '';
				break;
			case 'fa_font':
				$value = $atts['icon_fontawesome'];
				$icon  = "<span class='$value svg-icon' $style_ic></span>";
				break;
			case 'svg_icon':
				$icon = "<span class='svg-icon'  $style_ic><svg viewBox='0 0 20 20'><use xlink:href='#$value_icon'></use></svg></span>";
				break;
			case 'image':
				$image_thumb = grd_load_image( $image_ids, $atts['image_size'] );
				$icon        = "<span class='svg-icon'>$image_thumb</span>";
				break;
			default:
				$icon = "";
		}

		return sprintf( '<div class="grd-button-group grd-align-%s"><a href="%s" class="grd-button %s hover-%s" %s>%s<span>%s</span></a></div>', $bt_align, $link, $el_class, $bt_hover, $style, $icon, $text_bt );
	}

	/**
	 **
	 * Get Contact
	 *
	 * @since  1.0
	 *
	 * @return string
	 */
	function grd_contact_box( $atts, $content ) {
		$atts = shortcode_atts(
			array(
				'phone'        => '',
				'email'        => '',
				'hours_summer' => '',
				'hours_winter' => '',
			), $atts
		);

		$out_put      = array();
		$phone        = $atts['phone'];
		$email        = $atts['email'];
		$hours_summer = $atts['hours_summer'];
		$hours_winter = $atts['hours_winter'];

		$tx_phone    = esc_html__( 'Phone', 'grd' );
		$tx_email    = esc_html__( 'Email', 'grd' );
		$tx_w_hour   = esc_html__( 'Working Hours', 'grd' );
		$tx_summer   = esc_html__( 'Summer', 'grd' );
		$tx_winter   = esc_html__( 'Winter', 'grd' );
		$tx_maytonow = esc_html__( 'May to Nov', 'grd' );
		$tx_dectoapr = esc_html__( 'Dec to Apr', 'grd' );

		if ( $phone ) : $out_put[] = sprintf( "<li><p class='name'>%s</p><p class='value'>%s</p></li>", $tx_phone, $phone );endif;
		if ( $email ) : $out_put[] = sprintf( "<li><p class='name'>%s</p><p class='value'>%s</p></li>", $tx_email, $email );endif;
		if ( $hours_summer || $hours_winter ) : $out_put[] = sprintf( "<li><p class='name'>%s</p></li>", $tx_w_hour );endif;
		if ( $hours_summer ) : $out_put[] = sprintf( "<li><p class='seasons'>%s</p><p class='value'><span class='text-green'>(%s): </span>%s</p></li>", $tx_summer, $tx_maytonow, $hours_summer );endif;
		if ( $hours_winter ) : $out_put[] = sprintf( "<li><p class='seasons'>%s</p><p class='value'><span class='text-green'>(%s): </span>%s</p></li>", $tx_winter, $tx_dectoapr, $hours_winter );endif;

		$value = implode( '', $out_put );

		return sprintf( "<div class='grd-contact-box'><ul>%s</ul></div>", $value );
	}

	/**
	 * Get image box
	 *
	 * @since  1.0
	 *
	 * @return string
	 */
	function grd_image_box( $atts, $content ) {
		$atts = shortcode_atts(
			array(
				'style'            => '1',
				'title'            => '',
				'text_color'       => '',
				'image'            => '',
				'image_size'       => '',
				'icon_type'        => '',
				'name_icon'        => '',
				'icon_color'       => '',
				'icon_fontawesome' => '',
				'icon_size'        => '50px',
				'theme'            => 'dark',
				'image_background' => '',
				'image_bg_size'    => '',

			), $atts
		);

		$style            = $atts['style'];
		$link             = vc_build_link( $atts['title'] );
		$text_color       = $atts['text_color'];
		$icon_type        = $atts['icon_type'];
		$name_icon        = $atts['name_icon'];
		$title            = $link['title'];
		$url              = $link['url'];
		$text_color       = ! empty( $text_color ) ? "style='color:$text_color;'" : '';
		$theme            = $atts['theme'];
		$style_ic_color   = ! empty( $icon_color ) ? "color:$icon_color;" : '';
		$icon_size        = ! empty( $icon_size ) ? "font-size:$icon_size;" : '';
		$style_ic         = "style='$style_ic_color $icon_size'";
		$image_background = $out_put = $image_thumb = '';
		switch ( $icon_type ) {
			case 'icon_fontawesome':
				$value = $atts['icon_fontawesome'];
				$icon  = "<span class='$value svg-icon' $style_ic></span>";
				break;
			case 'svg_icon':
				$icon = "<span class='svg-icon' $style_ic><svg viewBox='0 0 20 20'><use xlink:href='#$name_icon'></use></svg></span>";
				break;
			default:
				$icon = "";
		}

		if ( $atts['image'] ) :
			$image_thumb = grd_load_image( $atts['image'], $atts['image_size'] );
		endif;
		if ( $atts['image_background'] ) :
			$image_background = grd_load_image( $atts['image_background'], $atts['image_bg_size'] );
		endif;

		$icon_readmore = "<span class='svg-icon arrow'><svg viewBox='0 0 20 20'><use xlink:href='#right-arrow'></use></svg></span>";
		$div_icon      = sprintf( '<div class="entry-icon">%s</div>', $icon );
		$div_title     = sprintf( '<div class="entry-title"><a href="%s"><h4 class="title" %s>%s</h4></a></div>', $url, $text_color, $title );
		$div_content   = sprintf( '<div class="entry-content">%s</div>', $content );
		$div_image = '';
		if ( ! empty( $image_thumb ) ) {
			$div_image = sprintf( '<div class="entry_thumbnail">%s<a href="%s" class="hover"></a></div>', $image_thumb, $url );
		}
		$read_more            = sprintf( '<div class="entry-read-more"><a href="%s">%s%s</a></div>', $url, $icon_readmore, esc_html__( 'Read more', 'grd' ) );
		$div_image_background = sprintf( '<div class="image-background">%s</div>', $image_background );

		$style_bk = '';
		if ( $atts['image_background'] ) {
			$image = wp_get_attachment_image_src( $atts['image_background'], 'full' );
			if ( $image ) {
				$src = $image[0];
			}
			$style_bk = 'style="background-image:url(' . $src . ');background-position: center; background-repeat: no-repeat;background-size: cover;"';
		}

		if ( $style == 1 ):$out_put = sprintf( '%s%s%s%s', $div_title, $div_icon, $div_image, $div_content );endif;
		if ( $style == 2 || $style == 5 ):$out_put = sprintf( '%s<div class="show">%s%s</div>', $div_image, $div_title, $div_content ); endif;
		if ( $style == 3 ):$out_put = sprintf( '<div class="top">%s%s</div><div class="bottom">%s %s %s</div>', $div_image, $div_icon, $div_title, $div_content, $read_more );endif;
		if ( $style == 4 ):$out_put = sprintf( '%s%s%s', $div_title, $div_image, $div_content );endif;
		if ( $style == 6 ):$out_put = sprintf( '<div class="box-img">%s<div class="bottom">%s %s</div>%s</div><div class="fix-box" %s>%s<div class="fix-top">%s</div><div class="fix-bottom"> %s %s</div> %s</div>', $div_image, $div_title, $div_content, $read_more, $style_bk, $div_image, $div_icon, $div_title, $div_content, $read_more );endif;
		if ( $style == 7 ):$out_put = sprintf( '%s<div class="right">%s%s</div>', $div_image, $div_title, $div_content ); endif;

		return sprintf( "<div class='grd-image-box-%s icon-theme-%s' >%s</div>", $style, $theme, $out_put );

	}

	/**
	 * Get icon box
	 *
	 * @since  1.0
	 *
	 * @return string
	 */
	function grd_icon_box( $atts, $content ) {

		$atts = shortcode_atts(
			array(
				'style'             => '1',
				'border_box'        => '',
				'text_button'       => '',
				'link'              => '',
				'text_color'        => '',
				'font_size'         => '',
				'value_icon'        => '',
				'icon_fontawesome'  => '',
				'image_size'        => '',
				'image'             => '',
				'bg_color'          => '',
				'checkbox'          => '0',
				'icon_type'         => 'fa_font',
				'icon_color'        => '',
				'icon_size'         => '50px',
				'el_class'          => '',
				'theme'             => 'dark',
				'text_footer'       => '',
				'text_footer_color' => '',
				'position'          => 'left',
				'bg_icon_color'     => '1',
				'border_icon_box'   => '',
				'bg_image'          => '',
				'bg_size'           => 'auto',
				'text_header'       => '',

			), $atts
		);

		$style             = $atts['style'];
		$link              = vc_build_link( $atts['link'] );
		$text_color        = $atts['text_color'];
		$icon_type         = $atts['icon_type'];
		$value_icon        = $atts['value_icon'];
		$icon_color        = $atts['icon_color'];
		$checkbox          = $atts['checkbox'];
		$el_class          = $atts['el_class'];
		$icon_size         = $atts['icon_size'];
		$theme             = $atts['theme'];
		$text_footer       = $atts['text_footer'];
		$text_footer_color = $atts['text_footer_color'];
		$title             = $link['title'];
		$title_link        = $link['url'];
		$image_ids         = $atts['image'];
		$text_header       = $atts['text_header'];
		$position          = $atts['position'];
		$background        = $bg_icon = '';


		// check
		if ( $atts['border_box'] ) {
			$css_border = 'border';
		} else {
			$css_border = "";
		}
		if ( ! empty( $link['url'] ) ) {
			$href = $link['url'];
		}
		$button = '';
		if ( ! empty( $atts['text_button'] ) ) {
			$button = sprintf(
				'<div class="box_btn">' .
				'<a href="%s">%s</a>' .
				'</div>',
				$href,
				$atts['text_button']
			);
		}
		if ( $style == 9 ) : $position = "grd-position-icon-$position";
		else : $position = ''; endif;

		$text_color     = ! empty( $text_color ) ? "style='color:$text_color;'" : '';
		$style_ic_color = ! empty( $icon_color ) ? "color:$icon_color;" : '';
		$icon_size      = ! empty( $icon_size ) ? "font-size:$icon_size;" : '';

		if ( $style == 4 ) {
			$text_footer_color = ! empty( $text_footer_color ) ? "style='color:$text_footer_color;'" : '';
			$text_footer       = ! empty( $text_footer ) ? "<div class='text-footer' $text_footer_color>$text_footer</div>" : '';
		}
		if ( $style == 5 ) {
			$arrow             = "<span class='svg-icon arrow'><svg viewBox='0 0 20 20'><use xlink:href='#right-arrow'></use></svg></span>";
			$text_footer_color = ! empty( $text_footer_color ) ? "style='color:$text_footer_color;'" : '';
			$text_footer       = ! empty( $text_footer ) ? "<a href='$title_link' class='text-footer' $text_footer_color>$arrow $text_footer</a>" : '';
		}
		if ( $style == 2 ) {
			$bg_icon = ! empty( $atts['bg_icon_color'] ) ? $atts['bg_icon_color'] : '';
		}
		if ( $atts['bg_image'] ) :
			$image_thumb = wp_get_attachment_image_src( $atts['bg_image'], "full" );
			$imgSrc      = $image_thumb[0];
			$bg_size     = sprintf( "background-size: %s;", $atts['bg_size'] );
			$background  = sprintf( "background: url(%s); %s", $imgSrc, $bg_size );
		endif;

		$border_icon_box = ! empty( $atts['border_icon_box'] ) ? "border-radius:" . $atts['border_icon_box'] . ";" : '';
		$style_sheet     = "style='$border_icon_box $background'";

		$style_ic = "style='$style_ic_color $icon_size '";

		switch ( $icon_type ) {
			case 'fa_font':
				$value = $atts['icon_fontawesome'];
				$icon  = "<span class='$value background-$bg_icon svg-icon' $style_ic></span>";
				break;
			case 'svg_icon':
				$icon = "<span class='svg-icon background-$bg_icon'  $style_ic><svg viewBox='0 0 20 20'><use xlink:href='#$value_icon'></use></svg></span>";
				break;
			case 'image':
				$image_thumb = grd_load_image( $image_ids, $atts['image_size'] );
				$icon        = "<span class='svg-icon background-$bg_icon'>$image_thumb</span>";
				break;
			default:
				$icon = "";
		}
		$header = $icon2 = '';
		if ( $style == 9 ):$icon2 = "<div class='icon-top'>$icon</div>"; endif;
		if ( $style == 8 ):$header = "<div class='icon-header'>$text_header</div>"; endif;

		$show_read_more = '';
		$text_readmore  = esc_html__( 'Read more', 'grd' );
		if ( $checkbox == true && $style == 7 ): $show_read_more = "<div class='readmore'><a href='$title_link'><span class='svg-icon arrow'><svg viewBox='0 0 20 20'><use xlink:href='#right-arrow'></use></svg></span></a></div> ";endif;
		if ( $checkbox == true && $style == 10 ): $show_read_more = "<div class='readmore'><a href='$title_link'><span class='svg-icon arrow'><svg viewBox='0 0 20 20'><use xlink:href='#right-arrow'></use></svg></span></a></div> ";endif;
		if ( $checkbox == true && ( $style == 8 || $style == 9 ) ): $show_read_more = "<div class='readmore'><a href='$title_link'><span class='svg-icon arrow'><svg viewBox='0 0 20 20'><use xlink:href='#right-arrow'></use></svg></span>$text_readmore</a></div> ";endif;

		$icon_output    = sprintf( "<a href='%s' class='icon'><div class='icon-content'>%s</div></a>", $title_link, $icon );
		$title_output   = sprintf( "<a href='%s' class='emtry-title'><p class='title' title='%s' %s>%s</p></a>", $title_link, $title, $text_color, $title );
		$content_output = sprintf( "<div class='content'><div class='descreption'>%s</div>%s</div>", $content, $show_read_more );

		$out_put = $header . $icon_output . $title_output . $content_output;
		if ( $style == 1 ) {
			$out_put = $title_output . $icon_output . $content_output;
		}

		return sprintf( "<div class='col-xs-12 grd-icon-box grd-icon-box-%s icon-theme-%s %s %s %s' %s >
			<div class='icon-box-wrapter'>%s</div>
			%s%s%s
			</div>"
			, $style, $theme, $el_class, $position, $css_border, $style_sheet, $out_put, $text_footer, $icon2, $button );
	}

	/**
	 * Get icon list
	 *
	 * @since  1.0
	 *
	 * @return string
	 */
	function grd_icon_list( $atts, $content ) {

		$atts = shortcode_atts(
			array(
				'setting'  => '',
				'el_class' => '',
			), $atts
		);

		$infor   = vc_param_group_parse_atts( $atts['setting'] );
		$outputs = array();
		$title   = $url = '';

		if ( ! empty( $infor ) ) {
			foreach ( $infor as $key => $value ) {

				$el_class   = ! empty( $value['el_class'] ) ? $value['el_class'] : '';
				$style      = ! empty( $value['style'] ) ? $value['style'] : '';
				$text_color = ! empty( $value['text_color'] ) ? sprintf( 'style="color: %s;"', $value['text_color'] ) : '';
				$icon_type  = ! empty( $value['icon_type'] ) ? $value['icon_type'] : '';

				$value_icon = ! empty( $value['value_icon'] ) ? $value['value_icon'] : '';
				$theme      = ! empty( $value['theme'] ) ? $value['theme'] : '';
				$desc       = ! empty( $value['desc'] ) ? $value['desc'] : '';

				if ( ! empty( $value['link'] ) ) {
					$link  = vc_build_link( $value['link'] );
					$title = $link['title'];
					$url   = $link['url'];
				}

				switch ( $icon_type ) {
					case 'fa_font':
						$value_icon = ! empty( $value['icon_fontawesome'] ) ? $value['icon_fontawesome'] : '';
						$icon       = "<span class='$value_icon svg-icon'></span>";
						break;
					case 'svg_icon':
						$icon = "<span class='svg-icon' ><svg viewBox='0 0 20 20'><use xlink:href='#$value_icon'></use></svg></span>";
						break;
					default:
						$icon = "";
				}

				$icon_output    = sprintf( "<a href='%s' class='icon'><div class='icon-content'>%s</div></a>", $url, $icon );
				$title_output   = sprintf( "<a href='%s' class='emtry-title' %s><h3 class='title' title='%s' >%s</h3></a>", $url, $text_color, $title, $title );
				$content_output = sprintf( "<div class='content'><div class='descreption'>%s</div></div>", $desc );

				$content_list = $icon_output . $title_output . $content_output;
				if ( $style == 2 ) {
					$content_list = $title_output;
				}
				$outputs[] = sprintf( "<div class='col-xs-12 icon-box-list-items grd-icon-box-list-%s icon-theme-%s %s'><div class='icon-box-wrapter'>%s</div></div>"
					, $style, $theme, $el_class, $content_list );
			}
		}

		return sprintf( '<div class="icon-box-list">%s</div>', implode( '', $outputs ) );
	}

	/**portfolio
	 *
	 * @since  1.0
	 *
	 * @return string
	 */
	function grd_portfolio( $atts, $content ) {

		$atts           = shortcode_atts(
			array(
				'style'          => '1',
				'posts_per_page' => '9',
				'filter'         => '',
				'slug_cate'      => '',
				'orderby'        => 'none',
				'order'          => 'DESC',
				'items'          => '4',
			), $atts
		);
		$style          = $atts['style'];
		$posts_per_page = $atts['posts_per_page'];
		$filter         = $atts['filter'];
		$oderby         = $atts['orderby'];
		$items          = $atts['items'];
		$columns        = 12 / $items;
		$width          = 100 / $items . '%';

		if ( $oderby == 'none' ): $oderby = ''; endif;
		$oder          = $atts['order'];
		$args          = array(
			'post_type'      => 'portfolio',
			'posts_per_page' => $posts_per_page,
			'order'          => $oder,
			'orderby'        => $oderby
		);
		$the_query     = new WP_Query( $args );
		$list_category = $value = $cats = array();

		if ( $the_query->have_posts() ) :
			while ( $the_query->have_posts() ) : $the_query->the_post();
				$permalink = get_permalink();
				$the_title = get_the_title();
				$id        = get_the_ID();

				$category = '';
				$slug     = '';
				$terms    = get_the_terms( get_the_ID(), 'portfolio_category' );
				if ( $terms && ! is_wp_error( $terms ) ) :
					$category_link = get_term_link( $terms[0]->term_id, 'portfolio_category' );
					$category_name = $terms[0]->name;
					$slug          = $terms[0]->slug;
					$category      = "<a class='category' href='$category_link'>$category_name</a>";
					foreach ( $terms as $cat ) {
						if ( empty( $cats[ $cat->term_id ] ) ) {
							$cats[ $cat->term_id ] = array( 'name' => $cat->name, 'slug' => $cat->slug, );
						}
					}
				endif;

				$text_readmore   = esc_html__( 'Read more', 'grd' );
				$thumb_size      = "grd-portfolio-grid";
				$portfolio_class = sprintf( 'col-xs-6 col-sm-6 col-md-%s portfolio-grid', $columns );
				if ( $style == 'masonry' ) {
					$mod = $the_query->current_post % 9;
					if ( in_array( $mod, array( 0, 8 ) ) ) {
						$thumb_size      = 'grd-portfolio-grid-dual-horizontal';
						$portfolio_class = 'col-xs-12 col-sm-6 col-mdgutter-sizer-6 portfolio-horizontal item-modern';
					} elseif ( $mod == 2 ) {
						$thumb_size      = 'grd-portfolio-grid-dual-vertical';
						$portfolio_class = 'col-xs-12 col-sm-6 col-md-3 portfolio-vertical item-modern';
					} else {
						$thumb_size      = 'grd-portfolio-grid-single';
						$portfolio_class = 'col-xs-12 col-sm-6 col-md-3 portfolio-nomal item-modern';
					}
				} elseif ( $style == 'full-width' ) {
					$thumb_size      = 'grd-portfolio-full-width';
					$portfolio_class = sprintf( 'col-xs-12 col-sm-6 col-md-%s portfolio-full-width item-full-width', $columns );
				}
				$class           = $portfolio_class;
				$thumb           = get_the_post_thumbnail_url( $id, $thumb_size );
				$img             = "<img alt='$the_title' src='$thumb'/>";
				$entry_thumbnail = sprintf( '<a href="%s" class="entry-thumbnail">%s</a>', $permalink, $img );
				$entry_category  = sprintf( '<div class="entry-meta">%s</div>', $category );
				$read_more       = sprintf( '<a href="%s" class="entry-read-more"><div class="read-more"><span class="svg-icon icon-arrow-right">
				<svg><use xlink:href="#right-arrow"></use></svg></span> %s</div></a>', $permalink, $text_readmore );

				$value[] = sprintf( "<div id='%s' class='%s element-item portfolio-wrapper portfolio-item %s' data-category='%s'>
						<div class='content-item'>
						<div class='entry-header'>%s</div>
						<div class='entry-content'><div class='entry-title'><a href='%s'><h3 class='title'>%s</h3></a>%s</div> 
						<div class='readmore'>%s</div>
						</div>
						</div>
					</div>",
					$id, $class, $slug, $slug, $entry_thumbnail, $permalink, $the_title, $entry_category, $read_more );
			endwhile;
			wp_reset_postdata();
		endif;

		// List category
		$cats_slug = $atts['slug_cate'];
		if ( $cats_slug ) {
			$cats_slug = explode( ',', $cats_slug );

			foreach ( $cats_slug as $slug ) {
				$cat = get_term_by( 'slug', $slug, 'portfolio_category' );

				if ( $cat ) {
					$list_category[] = sprintf( '<span data-filter =".%s" class="button">%s</span>',  esc_attr( $cat->slug ), esc_html( $cat->name ) );
				}
			}
		}

		else{
			foreach ( $cats as $category ) {
				$slug            = esc_attr( $category['slug'] );
				$cate_name       = esc_attr( $category['name'] );
				$list_category[] = "<span class='button' data-filter='.$slug'>$cate_name</span>";
			}
		}

		if ( $filter ) :
			$str_viewall   = esc_html__( 'View all', 'grd' );
			$list_category = implode( ' ', $list_category );
			$out_put       = sprintf( "<div class='container text-center categories-filter portfolio-cats-filters'>
					            <div id='filters' class='button-group'><span class='button active' data-filter='*'>%s</span>%s
								</div></div>", $str_viewall, $list_category );
		else: $out_put = '';
		endif;
		$class_grid = "grd_portfolio_grid_ez";
		if ( $filter || ( $style == 'masonry' ) ) :
			$class_grid = "grd_portfolio_grid";
		endif;
		$value = implode( '', $value );

		return sprintf( '<div class="row grd-portfolio-shortcode grd-%s">%s
					<div class="%s"><div class="portfolio-sizer" style="width: %s"></div><div class="gutter-sizer"></div>%s</div>
					</div> ', $style, $out_put, $class_grid, $width, $value );
	}

	/**
	 * Get video banner
	 *
	 * @since  1.0
	 *
	 * @return string
	 */
	function grd_video_banner( $atts, $content = null ) {
		$atts = shortcode_atts(
			array(
				'video'      => '',
				'min_height' => '500',
				'image'      => '',
				'image_size' => '',
				'btn_text'   => esc_html__( 'Watch Project Video', 'grd' ),
				'el_class'   => '',

			), $atts
		);

		if ( empty( $atts['video'] ) ) {
			return '';
		}

		$css_class = array(
			'mf-video-banner',
			$atts['el_class'],
		);

		$min_height = intval( $atts['min_height'] );
		$video_html = $src = $btn = '';
		$style      = array();
		$video_url  = $atts['video'];
		$video_w    = '1024';
		$video_h    = '768';

		if ( $min_height ) {
			$style[] = 'min-height:' . $min_height . 'px;';
		}

		if ( $atts['image'] ) {
			$image = wp_get_attachment_image_src( $atts['image'], 'full' );
			if ( $image ) {
				$src = $image[0];
			}
			$style[] = 'background-image:url(' . $src . ');';
		}

		if ( filter_var( $video_url, FILTER_VALIDATE_URL ) ) {
			$atts = array(
				'width'  => $video_w,
				'height' => $video_h
			);
			if ( $oembed = @wp_oembed_get( $video_url, $atts ) ) {
				$video_html = $oembed;
			}
			if ( $video_html ) {
				$video_html = sprintf( '<div class="mf-wrapper"><div class="mf-video-wrapper">%s</div></div>', $video_html );
			}
		}

		return sprintf(
			'<div class="grd-video-banner %s" style="%s">
				<div class="mf-video-content"><a href="#" data-href="%s" class="photoswipe"><span class="video-play"></span></a></div>
			</div>',
			esc_attr( implode( ' ', $css_class ) ),
			esc_attr( implode( ' ', $style ) ),
			esc_attr( $video_html )
		);
	}

	/**
	 * Get video banner
	 *
	 * @since  1.0
	 *
	 * @return string
	 */
	function grd_banner( $atts, $content = null ) {
		$atts           = shortcode_atts(
			array(
				'style'      => '1',
				'image'      => '',
				'image_size' => '',
				'link'       => '',
				'icon_type'  => 'fa_font',
				'icon_color' => '',
				'icon_size'  => '50px',
				'name_svg'   => '',
				'title'      => '',
				'el_class'   => '',

			), $atts
		);
		$style          = $atts['style'];
		$link           = vc_build_link( $atts['link'] );
		$title          = $atts['title'];
		$icon_type      = $atts['icon_type'];
		$icon_color     = $atts['icon_color'];
		$icon_size      = $atts['icon_size'];
		$style_ic_color = ! empty( $icon_color ) ? "color:$icon_color;" : '';
		$icon_size      = ! empty( $icon_size ) ? "font-size:$icon_size;" : '';
		$style_ic       = "style='$style_ic_color $icon_size'";
		$name_icon      = $atts['name_svg'];
		$button         = $content_title = $icon = "";

		if ( $atts['image'] ) :
			$image_thumb = grd_load_image( $atts['image'], $atts['image_size'] );
		else :
			$image_thumb = '';
		endif;

		if ( $link ):
			$text_bt = $link['title'];
			$url     = $link['url'];
			$button  = sprintf( '<a href="%s">%s</a>', $url, $text_bt );

		endif;

		if ( $style == 2 ):
			switch ( $icon_type ) {
				case 'fa_font':
					$value = $atts['icon_fontawesome'];
					$icon  = "<span class='$value svg-icon' $style_ic></span>";
					break;
				case 'svg_icon':
					$icon = "<span class='svg-icon' $style_ic><svg viewBox='0 0 20 20'><use xlink:href='#$name_icon'></use></svg></span>";
					break;
				default:
					$icon = "";
			}
			$button = sprintf( "<a href='%s'><span class='svg-icon arrow'><svg viewBox='0 0 20 20'><use xlink:href='#right-arrow'></use></svg></span>%s</a>", $url, $text_bt );
		endif;
		if ( $style == 3 ) :
			$content_title = sprintf( '<div class="content-title"><h4 class="title">%s</h4></div>', $title );
		endif;

		$output = sprintf( '<div class="grd-banner grd-banner-style-%s">
								<div class="image">%s</div>
								<div class="content">
									<div class="icon-banner">%s</div>
									<div class="descr">%s %s</div>
									<div class="button">%s</div>
								</div> 
							</div>', $style, $image_thumb, $icon, $content_title, $content, $button );

		return $output;

	}

	/*
	*	Get team carousel
	*/
	function grd_team_carousel( $atts, $content ) {
		$atts = shortcode_atts(
			array(
				'title'          => '',
				'desc'           => '',
				'item'           => '3',
				'image_size'     => '',
				'nav'            => '',
				'dots'           => '',
				'autoplay'       => '',
				'autoplay_speed' => '2000',
				'setting'        => '',
				'title_ban'      => '',
				'link'           => '',
				'title_color'    => '',
				'image_ban'      => '',
				'image_size_ban' => '',
				'el_class'       => '',
			), $atts
		);

		$css_class = array(
			'dl_team_carousel',
			$atts['el_class']
		);

		//check title
		if ( isset ( $atts['title'] ) && ! empty( $atts['title'] ) ) {
			$title = sprintf( '<h2>%s</h2>', $atts['title'] );
		}
		if ( isset ( $atts['desc'] ) && ! empty( $atts['desc'] ) ) {
			$desc = sprintf( '<p>%s</p>', $atts['desc'] );
		}

		// check box banner
		if ( isset ( $atts['title_color'] ) && ! empty( $atts['title_color'] ) ) {
			$color_tit = sprintf( 'style=color:%s', $atts['title_color'] );
		} else {
			$color_tit = "";
		}

		if ( isset( $atts['image_ban'] ) && ! empty( $atts['image_ban'] ) || ! empty ( $atts['title_ban'] ) || isset( $atts['link'] ) ) {
			$img_ban   = grd_load_image( $atts['image_ban'], $atts['image_size_ban'] );
			$fix_col_1 = "col-lg-3 col-md-12";
			$fix_col_2 = "col-lg-9 col-md-12";
		} else {
			$fix_col_1 = "";
			$fix_col_2 = "col-md-12";
		}
		if ( isset( $atts['title_ban'] ) && ! empty( $atts['title_ban'] ) ) {
			$tit_ban = sprintf( '<h2 %s>%s</h2>', $color_tit, $atts['title_ban'] );
		}
		if ( $atts['link'] ) {
			$btn_ban = $this->grd_addons_btn( $atts );
		}

		$output_ban = sprintf(
			'<div class="box-banner">' .
			'%s' .
			'<div class="text-banner">' .
			'%s' .
			'%s' .
			'</div>' .
			'</div>',
			$img_ban,
			$tit_ban,
			$btn_ban
		);

		if ( $atts['nav'] ) {
			$nav = true;
		} else {
			$nav = false;
		}

		if ( $atts['dots'] ) {
			$dot = true;
		} else {
			$dot = false;
		}

		if ( $atts['autoplay'] ) {
			$autoplay = true;
		} else {
			$autoplay = false;
		}

		$id    = uniqid( 'grd-team-carousel-' );
		$slide = intval( $atts['item'] );
		$speed = intval( $atts['autoplay_speed'] );

		$this->l10n['teamCarousel'][ $id ] = array(
			'slide'    => $slide,
			'nav'      => $nav,
			'dot'      => $dot,
			'autoplay' => $autoplay,
			'speed'    => $speed,

		);

		$infor   = vc_param_group_parse_atts( $atts['setting'] );
		$outputs = array();

		if ( ! empty( $infor ) ) {
			foreach ( $infor as $key => $value ) {

				if ( ! empty( $value['name'] ) ) {
					$name = sprintf( '<h3>%s</h3>', $value['name'] );
				}
				if ( ! empty( $value['office'] ) ) {
					$office = sprintf( '<div class="job">%s</div>', $value['office'] );
				}
				if ( isset( $value['image'] ) ) {
					$image = grd_load_image( $value['image'], $atts['image_size'] );
				}

				$icon         = vc_param_group_parse_atts( $value['setting_icon'] );
				$outputs_icon = array();

				if ( ! empty( $icon ) ) {
					foreach ( $icon as $key_icon => $ic ) {
						$link = vc_build_link( $ic['link'] );

						if ( ! empty( $link['url'] ) ) {
							$href = $link['url'];
						}

						$outputs_icon[] = sprintf(
							'<li>' .
							'<a href="%s"><i class="%s"></i></a>' .
							'</li>',
							$href,
							$ic['icon_fontawesome']
						);
					}
					$content_contact = sprintf(
						'<ul>' .
						'%s' .
						'</ul>',
						implode( '', $outputs_icon )
					);
				}
				$outputs[] = sprintf(
					'<div class="item-team">' .
					'<div class="box-member">' .
					'%s' .
					'<div class="box-img">' .
					'%s' .
					'<div class="overlay-link">' .
					'%s' .
					'</div>' .
					'</div>' .
					'%s' .
					'</div>' .
					'</div>',
					$name,
					$image,
					$content_contact,
					$office
				);
			}
		}

		return sprintf(
			'<div  class="%s dl_members">' .
			'<div class="row">' .
			'<div class="%s">' .
			'</div>' .
			'<div class="%s">' .
			'<div class="box-team">' .
			'<div class="dl-box-title">' .
			'%s' .
			'%s' .
			'</div>' .
			'<div id="%s" class="row">' .
			'%s' .
			'</div>' .
			'%s' .
			'</div>' .
			'</div>' .
			'</div>' .
			'</div>',
			implode( '', $css_class ),
			$fix_col_1,
			$fix_col_2,
			$title,
			$desc,
			$id,
			implode( '', $outputs ),
			$output_ban
		);
	}

	/*
	*	Get testimorial carousel
	*/
	function grd_testimorial_carousel( $atts, $content ) {
		$atts = shortcode_atts(
			array(
				'style'          => '1',
				'style_title'    => '1',
				'title'          => '',
				'color_tit'      => '',
				'desc'           => '',
				'item'           => '2',
				'nav'            => '',
				'dots'           => '',
				'autoplay'       => '',
				'autoplay_speed' => '2000',
				'star'           => '',
				'setting'        => '',
				'el_class'       => '',
			), $atts
		);

		$css_class = array(
			'dl_testimorial_carousel',
			$atts['el_class']
		);
		$box_title = '';
		//check title
		$css_title = 'box-' . $atts['style_title'];
		if ( isset ( $atts['color_tit'] ) && ! empty( $atts['color_tit'] ) ) {
			$color_tit = sprintf( 'style=color:%s', $atts['color_tit'] );
		} else {
			$color_tit = "";
		}
		if ( isset ( $atts['title'] ) && ! empty( $atts['title'] ) ) {
			$title     = sprintf( '<h2 %s>%s</h2>', $color_tit, $atts['title'] );
			$box_title = sprintf(
				'<div class="dl-box-title %s">' .
				'%s' .
				'%s' .
				'</div>',
				$css_title,
				$title,
				$atts['desc']
			);
		}


		if ( $atts['nav'] ) {
			$nav = true;
		} else {
			$nav = false;
		}

		if ( $atts['dots'] ) {
			$dot = true;
		} else {
			$dot = false;
		}

		if ( $atts['autoplay'] ) {
			$autoplay = true;
		} else {
			$autoplay = false;
		}

		if ( $atts['star'] ) {
			$css_star = '';
		} else {
			$css_star = 'no-star';
		}

		$id    = uniqid( 'grd-testimorial-carousel-' );
		$slide = intval( $atts['item'] );
		$speed = intval( $atts['autoplay_speed'] );

		$this->l10n['testimorialCarousel'][ $id ] = array(
			'slide'    => $slide,
			'nav'      => $nav,
			'dot'      => $dot,
			'autoplay' => $autoplay,
			'speed'    => $speed,

		);

		$infor   = vc_param_group_parse_atts( $atts['setting'] );
		$outputs = array();
		$style_bk = $avatar = '';
		$css_style = 'style-' . $atts['style'];

		if ( ! empty( $infor ) ) {
			foreach ( $infor as $key => $value ) {


				// bk & avatar
				$avatar = '';
				if ( isset( $value['image'] ) && ! empty($value['image'])) {
					if ($atts['style'] == '1' ){
						$avatar = grd_load_image( $value['image'], '80' );
					}
					elseif ($atts['style'] == '3'){
						$avatar = grd_load_image( $value['image'], '99' );
					}
					else{
						$bk = wp_get_attachment_image_src( $value['image'], 'full' );
						$style_bk = sprintf( 'style=background-image:url(%s)', $bk[0] );
					}
				}

				// icon
				$icon   = '<div class="svg-icon icon-quotation"><svg viewbox="0 0 512 512"><use xlink:href="#quotation"></use></svg></div>';
				$icon_2 = '<div class="svg-icon icon-quotation-2"><svg viewbox="0 0 512 512"><use xlink:href="#quotation_2"></use></svg></div>';
				// check color
				if ( ! empty( $value['name_color'] ) ) {
					$name_cl = sprintf( 'style=color:%s', $value['name_color'] );
				} else {
					$name_cl = "";
				}
				if ( ! empty( $value['desc_color'] ) ) {
					$desc_cl = sprintf( 'style=color:%s', $value['desc_color'] );
				} else {
					$desc_cl = "";
				}
				if ( ! empty( $value['icon_color'] ) ) {
					$icon_cl = sprintf( 'style=color:%s', $value['icon_color'] );
				} else {
					$icon_cl = "";
				}

				// check text
				$name = '';
				if ( ! empty( $value['name'] ) ) {
					$name = sprintf( '<h3 %s> %s </h3>', $name_cl, $value['name'] );
				}
				$desc = '';
				if ( ! empty( $value['desc'] ) ) {
					$desc = sprintf( '<p %s class="content"> %s </p>', $desc_cl, $value['desc'] );
				}
				$address = '';
				if ( ! empty( $value['address'] ) ) {
					$address = sprintf( '<p class="address"> %s </p>', $value['address'] );
				}

				//check star
				$show_star   = array();
				$show_star_o = array();
				$star        = "<i class='fa fa-star'></i>";
				$star_o      = "<i class='fa fa-star-o'></i>";
				$count       = intval( $value['star'] );
				$count_o     = 5 - intval( $value['star'] );

				for ( $i = 1; $i <= $count; $i ++ ) {
					$show_star[] = $star;
				}
				for ( $count; $i <= 5; $i ++ ) {
					if ( $count_o = 0 ) : break; endif;
					$show_star_o[] = $star_o;
				}
				$allstar   = implode( '', $show_star );
				$allstar   .= implode( '', $show_star_o );
				$star_list = sprintf( '<span class="list-star">%s</span>', $allstar );

				if ( $atts['style'] == 1 ) {
					$outputs[] = sprintf(
						'<div class="item-testi %s">' .
						'<div class="box-text">' .
						'%s' .
						'%s' .
						'</div>' .
						'<div class="box-avatar">' .
						'%s' .
						'%s' .
						'%s' .
						'%s' .
						'</div>' .
						'</div>',
						$css_style,
						$icon,
						$desc,
						$avatar,
						$name,
						$address,
						$star_list
					);
				} elseif ( $atts['style'] == 3 ) {
					$outputs[] = sprintf(
						'<div class="item-testi %s">' .
						'<div class="box-text" >' .
						'%s' .
						'%s' .
						'%s' .
						'%s' .
						'%s' .
						'<div class="box-avatar">'.
						'%s' .
						'</div>'.
						'</div>' .
						'</div>',
						$css_style,
						$icon,
						$desc,
						$name,
						$address,
						$star_list,
						$avatar
					);
				} elseif ( $atts['style'] == 2 ) {
					$outputs[] = sprintf(
						'<div class="item-testi %s">' .
						'<div class="box-text" %s>' .
						'%s' .
						'%s' .
						'%s' .
						'<div class="box-star">' .
						'%s' .
						'</div>' .
						'</div>' .
						'</div>',
						$css_style,
						$style_bk,
						$icon,
						$desc,
						$name,
						$star_list
					);
				} else {
					$outputs[] = sprintf(
						'<div class="item-testi %s">' .
						'<div class="box-text" %s>' .
						'%s' .
						'<div class="hook"></div>' .
						'<div class="box-icon">%s</div>' .
						'<div class="box-star">' .
						'%s' .
						'%s' .
						'</div>' .
						'</div>' .
						'</div>',
						$css_style,
						$style_bk,
						$desc,
						$icon_2,
						$name,
						$star_list
					);
				}
			}
		}

		return sprintf(
			'<div class="%s %s">' .
			'%s' .
			'<div class="row">' .
			'<div id="%s">' .
			'%s' .
			'</div>' .
			'</div>' .
			'</div>',
			implode( '', $css_class ),
			$css_star,
			$box_title,
			$id,
			implode( '', $outputs )
		);
	}

	/*
		*	Get testimorial carousel
		*/
	function grd_award_carousel( $atts, $content ) {
		$atts = shortcode_atts(
			array(
				'item'           => '1',
				'dots'           => '',
				'nav'            => '',
				'autoplay'       => '',
				'autoplay_speed' => '2000',
				'setting'        => '',
				'align_content'  => '',
				'theme'          => 'dark',
				'infinite'       => '',
				'el_class'       => '',

			), $atts
		);

		$css_class = array(
			'grd-award-carousel',
			$atts['el_class']
		);

		if ( $atts['nav'] ) {
			$nav = true;
		} else {
			$nav = false;
		}
		if ( $atts['infinite'] ) {
			$infinite = true;
		} else {
			$infinite = false;
		}

		if ( $atts['dots'] ) {
			$dot = true;
		} else {
			$dot = false;
		}

		if ( $atts['autoplay'] ) {
			$autoplay = true;
		} else {
			$autoplay = false;
		}

		$id    = uniqid( 'grd-award-carousel-' );
		$slide = intval( $atts['item'] );

		$speed = intval( $atts['autoplay_speed'] );

		$this->l10n['awardCarousel'][ $id ] = array(
			'infinite' => $infinite,
			'nav'      => $nav,
			'slide'    => $slide,
			'dot'      => $dot,
			'autoplay' => $autoplay,
			'speed'    => $speed,
		);

		$infor   = vc_param_group_parse_atts( $atts['setting'] );
		$outputs = array();

		if ( ! empty( $infor ) ) {
			foreach ( $infor as $key => $value ) {

				$icon = "";

				if ( $value['title'] ) {
					$text_color = ! empty( $value['title_color'] ) ? "style='color:" . $value['title_color'] . ";'" : '';
					$title      = sprintf( "<h3 class='title' %s>%s</h3>", $text_color, $value['title'] );
				}

				if ( $value['icon_style'] ) {
					$icon_style     = $value['icon_style'];
					$value_icon     = ! empty( $value['value_icon'] ) ? $value['value_icon'] : '';
					$style_ic_color = ! empty( $value['icon_color'] ) ? "color:" . $value['icon_color'] . ";" : '';
					$icon_size      = ! empty( $value['icon_size'] ) ? "font-size:" . $value['icon_size'] . ";" : '';
					$style_ic       = "style='$style_ic_color $icon_size'";

					switch ( $icon_style ) {
						case 'fa_font':
							$value_icon = $value['icon_fontawesome'];
							$icon       = sprintf( "<span class='%s svg-icon' %s></span>", $value_icon, $style_ic );
							break;
						case 'svg_icon':
							$icon = sprintf( "<span class='svg-icon' %s><svg viewBox='0 0 20 20'><use xlink:href='#%s'></use></svg></span>", $style_ic, $value_icon );
							break;
						case 'image':
							if ( $value['image'] ) {
								$image_thumb = grd_load_image( $value['image'], $value['image_size'] );
								$icon        = sprintf( "<span class='svg-icon'>%s</span>", $image_thumb );
							}
							break;
						default:
							$icon = "";
					}
				}

				$bt_bg_color     = ! empty( $value['bt_bg_color'] ) ? sprintf( "background-color: %s;", $value['bt_bg_color'] ) : '';
				$bt_text_color   = ! empty( $value['bt_text_color'] ) ? sprintf( "color: %s;", $value['bt_text_color'] ) : '';
				$border_radius   = ! empty( $value['border_radius'] ) ? sprintf( "border-radius: %s;", $value['border_radius'] ) : '';
				$button_padding  = ! empty( $value['button_padding'] ) ? sprintf( "padding: %s;", $value['button_padding'] ) : '';
				$border          = '';
				$text_bt         = ! empty( $value['text_bt'] ) ? $value['text_bt'] : '';
				$link            = ! empty( $value['link'] ) ? vc_build_link( $value['link'] ) : '';
				$url             = $link['url'];
				$bt_border       = ! empty( $value['bt_border'] ) ? $value['bt_border'] : '';
				$bt_border_color = ! empty( $value['bt_border_color'] ) ? $value['bt_border_color'] : '';
				$bt_border_style = ! empty( $value['bt_border_style'] ) ? $value['bt_border_style'] : '';
				$bt_align        = ! empty( $value['bt_align'] ) ? $value['bt_align'] : '';
				$description     = ! empty( $value['description'] ) ? "<div class='content'>" . $value['description'] . "</div>" : '';

				if ( $bt_border || $bt_border_color || $bt_border_style ):
					$border = sprintf( "border: %s %s %s;", $bt_border, $bt_border_style, $bt_border_color );endif;
				$style = sprintf( 'style="%s" ', $bt_bg_color . $bt_text_color . $border . $border_radius . $button_padding );

				$button    = sprintf( '<div class="grd-button-group grd-align-%s"><a href="%s" class="grd-button" %s>%s</a></div>', $bt_align, $url, $style, $text_bt );
				$outputs[] = sprintf( '<div class="item text-%s icon-theme-%s">%s%s%s%s</div>', $atts['align_content'], $atts['theme'], $icon, $title, $description, $button );

			}
		}

		return sprintf(
			'<div id="%s"  class="%s"><div class="carousel-wrapper">%s</div></div>',
			$id,
			implode( '', $css_class ),
			implode( '', $outputs )
		);
	}

	/**
	 * Get empty space
	 *
	 * @since  1.0
	 *
	 * @return string
	 */
	function grd_blog_grid( $atts, $content ) {
		$atts = shortcode_atts(
			array(
				'cats'     => '',
				'per_page' => '3',
				'orderby'  => 'date',
				'order'    => 'desc',
				'images'   => '1',
				'el_class' => '',
			), $atts
		);

		$css_class[] = $atts['el_class'];
		$output      = array();

		$args = array(
			'ignore_sticky_posts' => true,
			'post_type'           => 'post',
		);

		$args['orderby'] = $atts['orderby'];
		$args['order']   = $atts['order'];
		$args['images']  = $atts['images'];

		$args['posts_per_page'] = intval( $atts['per_page'] );

		if ( $atts['cats'] ) {
			$args['category_name'] = $atts['cats'];
		}

		if ( $atts['images'] ) {
			$atts['images'] = '';
		} else {
			$atts['images'] = 'no-images';
		}

		$query = new WP_Query( $args );
		while ( $query->have_posts() ) : $query->the_post();
			global $mf_post;
			$mf_post['css'] = ' blog-wrapper-col-3 col-md-4 col-sm-6 col-xs-6 hidden-child';

			ob_start();
			get_template_part( 'parts/content', get_post_format() );
			$output[] = ob_get_clean();

		endwhile;
		wp_reset_postdata();

		return sprintf(
			'<div class="grd-posts %s %s">' .
			'<div class="row">' .
			'%s' .
			'</div>' .
			'</div>',
			esc_attr( $atts['images'] ),
			esc_attr( implode( ' ', $css_class ) ),
			implode( '', $output )
		);
	}

	/**
	 * Map shortcode
	 *
	 * @since 1.0.0
	 *
	 * @param array $atts
	 * @param string $content
	 *
	 * @return string
	 */
	function grd_gmap( $atts, $content ) {
		$atts = shortcode_atts(
			array(
				'api_key'   => '',
				'marker'    => '',
				'info'      => '',
				'width'     => '',
				'height'    => '500',
				'zoom'      => '13',
				'el_class'  => '',
				'style'     => '1',
				'map_color' => '#2685f9',
			), $atts
		);

		$class = array(
			'dl-map-shortcode',
			$atts['el_class'],
		);

		$style = '';
		if ( $atts['width'] ) {
			$unit = 'px;';
			if ( strpos( $atts['width'], '%' ) ) {
				$unit = '%;';
			}

			$atts['width'] = intval( $atts['width'] );
			$style         .= 'width: ' . $atts['width'] . $unit;
		}
		if ( $atts['height'] ) {
			$unit = 'px;';
			if ( strpos( $atts['height'], '%' ) ) {
				$unit = '%;';
			}

			$atts['height'] = intval( $atts['height'] );
			$style          .= 'height: ' . $atts['height'] . $unit;
		}
		if ( $atts['zoom'] ) {
			$atts['zoom'] = intval( $atts['zoom'] );
		}

		if ( $atts['style'] ) {
			$atts['style'] = intval( $atts['style'] );
		}

		$id   = uniqid( 'dl_map_' );
		$html = sprintf(
			'<div class="%s"><div id="%s" class="dl-map" style="%s"></div></div>',
			implode( ' ', $class ),
			$id,
			$style
		);

		$lats    = array();
		$lng     = array();
		$info    = array();
		$i       = 0;
		$fh_info = vc_param_group_parse_atts( $atts['info'] );

		foreach ( $fh_info as $key => $value ) {

			$coordinates = $this->get_coordinates( $value['address'], $atts['api_key'] );
			$lats[]      = $coordinates['lat'];
			$lng[]       = $coordinates['lng'];
			$info[]      = isset( $value['details'] ) ? $value['details'] : '';

			if ( isset( $coordinates['error'] ) ) {
				return $coordinates['error'];
			}

			$i ++;
		}

		$marker = '';
		if ( $atts['marker'] ) {

			if ( filter_var( $atts['marker'], FILTER_VALIDATE_URL ) ) {
				$marker = $atts['marker'];
			} else {
				$attachment_image = wp_get_attachment_image_src( intval( $atts['marker'] ), 'full' );
				$marker           = $attachment_image ? $attachment_image[0] : '';
			}
		}

		$this->api_key = $atts['api_key'];

		$this->l10n['map'][ $id ] = array(
			'type'      => 'normal',
			'lat'       => $lats,
			'lng'       => $lng,
			'zoom'      => $atts['zoom'],
			'marker'    => $marker,
			'height'    => $atts['height'],
			'info'      => $info,
			'number'    => $i,
			'style'     => $atts['style'],
			'map_color' => $atts['map_color'],
		);

		return $html;

	}

	/**
	 * Helper function to get coordinates for map
	 *
	 * @since 1.0.0
	 *
	 * @param string $address
	 * @param bool $refresh
	 *
	 * @return array
	 */
	function get_coordinates( $address, $api_key, $refresh = false ) {
		$address_hash = md5( $address );
		$coordinates  = get_transient( $address_hash );
		$results      = array( 'lat' => '', 'lng' => '' );

		if ( $refresh || $coordinates === false ) {
			$args     = array( 'address' => urlencode( $address ), 'sensor' => 'false', 'key' => $api_key  );
			$url      = add_query_arg( $args, 'https://maps.googleapis.com/maps/api/geocode/json' );
			$response = wp_remote_get( $url );

			if ( is_wp_error( $response ) ) {
				$results['error'] = esc_html__( 'Can not connect to Google Maps APIs', 'grd' );

				return $results;
			}

			$data = wp_remote_retrieve_body( $response );

			if ( is_wp_error( $data ) ) {
				$results['error'] = esc_html__( 'Can not connect to Google Maps APIs', 'grd' );

				return $results;
			}

			if ( $response['response']['code'] == 200 ) {
				$data = json_decode( $data );

				if ( $data->status === 'OK' ) {
					$coordinates = $data->results[0]->geometry->location;

					$results['lat']     = $coordinates->lat;
					$results['lng']     = $coordinates->lng;
					$results['address'] = (string) $data->results[0]->formatted_address;

					// cache coordinates for 3 months
					set_transient( $address_hash, $results, 3600 * 24 * 30 * 3 );
				} elseif ( $data->status === 'ZERO_RESULTS' ) {
					$results['error'] = esc_html__( 'No location found for the entered address.', 'grd' );
				} elseif ( $data->status === 'INVALID_REQUEST' ) {
					$results['error'] = esc_html__( 'Invalid request. Did you enter an address?', 'grd' );
				} else {
					$results['error'] = esc_html__( 'Something went wrong while retrieving your map, please ensure you have entered the short code correctly.', 'grd' );
				}
			} else {
				$results['error'] = esc_html__( 'Unable to contact Google API service.', 'grd' );
			}
		} else {
			$results = $coordinates; // return cached results
		}

		return $results;
	}

	/**
	 * Get list Nav
	 *
	 * @since  1.0
	 *
	 * @return string
	 */
	function grd_list( $atts, $content ) {
		$atts = shortcode_atts(
			array(
				'title'            => '',
				'icon_library'     => '1',
				'icon_fontawesome' => '',
				'name_svg'         => '',
				'icon_color'       => '',
				'icon_size'        => '',
				'title_color'      => '',
				'setting'          => '',
				'theme'            => 'dark',
			), $atts
		);

		$title       = $atts['title'];
		$icon_type   = $atts['icon_library'];
		$value_icon  = $atts['name_svg'];
		$icon_color  = $atts['icon_color'];
		$icon_size   = $atts['icon_size'];
		$title_color = $atts['title_color'];
		$theme       = $atts['theme'];
		$fa_font     = $atts['icon_fontawesome'];

		$style_ic_color = ! empty( $icon_color ) ? "color:$icon_color;" : '';
		$icon_size      = ! empty( $icon_size ) ? "font-size:$icon_size;" : '';
		$style          = ! empty( $title_color ) ? sprintf( "style='color:%s;'", $title_color ) : '';
		$content        = ! empty( $content ) ? sprintf( "<div class='desc'>%s</div>", $content ) : '';

		$style_ic = "style='$style_ic_color $icon_size '";

		switch ( $icon_type ) {
			case '1':
				$icon = "<span class='$fa_font svg-icon' $style_ic></span>";
				break;
			case '2':
				$icon = "<span class='svg-icon' $style_ic><svg viewBox='0 0 20 20'><use xlink:href='#$value_icon'></use></svg></span>";
				break;
			default:
				$icon = "";
		}
		$infor   = vc_param_group_parse_atts( $atts['setting'] );
		$outputs = array();


		if ( ! empty( $infor ) ) {
			foreach ( $infor as $key => $value ) {
				if ( $value['content_list'] ) {
					$text_color = isset($value['li_color']) && ! empty( $value['li_color'] )  ? "style='color:" . $value['li_color'] . ";'" : '';
					$link       = isset($value['link']) && ! empty( $value['link'] ) ? $value['link'] : '';
					if ( ! empty($link ) ) {
						$link_url  = vc_build_link( $value['link'] );
						$url   = $link_url['url'];
						$outputs[] = sprintf( "<li %s><a href='%s'>%s %s</a></li>", $text_color, $url, $icon, $value['content_list'] );
					} else {
						$outputs[] = sprintf( "<li %s>%s %s</li>", $text_color, $icon, $value['content_list'] );
					}
				}
			}
		}

		$titleContent = "";
		if ( ! empty( $title_color ) ) {
			$titleContent = '<h3 class="title" ' . $style . '>' . $title . '</h3>';
		}

		return sprintf( "<div class='grd-list icon-theme-%s'>%s %s<ul>%s</ul></div>",
			$theme, $titleContent, $content, implode( '', $outputs ) );
	}

}
