<?php
/**
 * Hooks for importer
 *
 * @package grd
 */


/**
 * Importer the demo content
 *
 * @since  1.0
 *
 */
function grd_vc_addons_importer() {
	return array(
		array(
			'name'       => 'Homepage 1',
			'preview'    => 'http://steelthemes.com/soo-importer/grd/screenshot.jpg',
			'content'    => 'http://steelthemes.com/soo-importer/grd/demo-content.xml',
			'customizer' => 'http://steelthemes.com/soo-importer/grd/customizer.dat',
			'widgets'    => 'http://steelthemes.com/soo-importer/grd/widgets.wie',
			'sliders'    => 'http://steelthemes.com/soo-importer/grd/sliders.zip',
			'pages'      => array(
				'front_page' => 'Home Page 1',
				'blog'       => 'Blog',
				'shop'       => 'Shop',
				'cart'       => 'Cart',
				'checkout'   => 'Checkout',
				'my_account' => 'My account',
				'portfolio'  => 'Gallery',
				'service'    => 'Services'
			),
			'menus'      => array(
				'primary' => 'primary-menu',
			),
			'options'    => array(
				'shop_catalog_image_size'   => array(
					'width'  => 480,
					'height' => 480,
					'crop'   => 1,
				),
				'shop_single_image_size'    => array(
					'width'  => 600,
					'height' => 600,
					'crop'   => 1,
				),
				'shop_thumbnail_image_size' => array(
					'width'  => 70,
					'height' => 70,
					'crop'   => 1,
				),
			),
		),
		array(
			'name'       => 'Homepage 2',
			'preview'    => 'http://steelthemes.com/soo-importer/grd/home-2/screenshot.jpg',
			'content'    => 'http://steelthemes.com/soo-importer/grd/demo-content.xml',
			'customizer' => 'http://steelthemes.com/soo-importer/grd/home-2/customizer.dat',
			'widgets'    => 'http://steelthemes.com/soo-importer/grd/home-2/widgets.wie',
			'sliders'    => 'http://steelthemes.com/soo-importer/grd/home-2/sliders.zip',
			'pages'      => array(
				'front_page' => 'Home Page 2',
				'blog'       => 'Blog',
				'shop'       => 'Shop',
				'cart'       => 'Cart',
				'checkout'   => 'Checkout',
				'my_account' => 'My account',
				'portfolio'  => 'Gallery',
				'service'    => 'Services'
			),
			'menus'      => array(
				'primary' => 'primary-menu',
			),
			'options'    => array(
				'shop_catalog_image_size'   => array(
					'width'  => 480,
					'height' => 480,
					'crop'   => 1,
				),
				'shop_single_image_size'    => array(
					'width'  => 600,
					'height' => 600,
					'crop'   => 1,
				),
				'shop_thumbnail_image_size' => array(
					'width'  => 70,
					'height' => 70,
					'crop'   => 1,
				),
			),
		),
		array(
			'name'       => 'Homepage 3',
			'preview'    => 'http://steelthemes.com/soo-importer/grd/home-3/screenshot.jpg',
			'content'    => 'http://steelthemes.com/soo-importer/grd/demo-content.xml',
			'customizer' => 'http://steelthemes.com/soo-importer/grd/home-3/customizer.dat',
			'widgets'    => 'http://steelthemes.com/soo-importer/grd/home-3/widgets.wie',
			'sliders'    => 'http://steelthemes.com/soo-importer/grd/home-3/sliders.zip',
			'pages'      => array(
				'front_page' => 'Home Page 3',
				'blog'       => 'Blog',
				'shop'       => 'Shop',
				'cart'       => 'Cart',
				'checkout'   => 'Checkout',
				'my_account' => 'My account',
				'portfolio'  => 'Gallery',
				'service'    => 'Services'
			),
			'menus'      => array(
				'primary' => 'primary-menu',
			),
			'options'    => array(
				'shop_catalog_image_size'   => array(
					'width'  => 480,
					'height' => 480,
					'crop'   => 1,
				),
				'shop_single_image_size'    => array(
					'width'  => 600,
					'height' => 600,
					'crop'   => 1,
				),
				'shop_thumbnail_image_size' => array(
					'width'  => 70,
					'height' => 70,
					'crop'   => 1,
				),
			),
		),
		array(
			'name'       => 'Homepage 4',
			'preview'    => 'http://steelthemes.com/soo-importer/grd/home-4/screenshot.jpg',
			'content'    => 'http://steelthemes.com/soo-importer/grd/demo-content.xml',
			'customizer' => 'http://steelthemes.com/soo-importer/grd/home-4/customizer.dat',
			'widgets'    => 'http://steelthemes.com/soo-importer/grd/home-4/widgets.wie',
			'sliders'    => 'http://steelthemes.com/soo-importer/grd/sliders.zip',
			'pages'      => array(
				'front_page' => 'Home Page 4',
				'blog'       => 'Blog',
				'shop'       => 'Shop',
				'cart'       => 'Cart',
				'checkout'   => 'Checkout',
				'my_account' => 'My account',
				'portfolio'  => 'Gallery',
				'service'    => 'Services'
			),
			'menus'      => array(
				'primary' => 'primary-menu',
			),
			'options'    => array(
				'shop_catalog_image_size'   => array(
					'width'  => 480,
					'height' => 480,
					'crop'   => 1,
				),
				'shop_single_image_size'    => array(
					'width'  => 600,
					'height' => 600,
					'crop'   => 1,
				),
				'shop_thumbnail_image_size' => array(
					'width'  => 70,
					'height' => 70,
					'crop'   => 1,
				),
			),
		),
	);
}

add_filter( 'soo_demo_packages', 'grd_vc_addons_importer', 20 );

/**
 * Update more page options
 *
 * @param $pages
 */
function grd_addons_import_portfolio( $pages ) {

	if ( isset( $pages['portfolio'] ) ) {
		$portfolio = get_page_by_title( $pages['portfolio'] );

		if ( $portfolio ) {
			update_option( 'grd_portfolio_page_id', $portfolio->ID );
		}
	}
}

add_action( 'soodi_after_setup_pages', 'grd_addons_import_portfolio' );

/**
 * Update more page options
 *
 * @param $pages
 */
function grd_addons_import_services( $pages ) {

	if ( isset( $pages['service'] ) ) {
		$services = get_page_by_title( $pages['service'] );

		if ( $services ) {
			update_option( 'grd_service_page_id', $services->ID );
		}
	}
}

add_action( 'soodi_after_setup_pages', 'grd_addons_import_services' );