<?php

/**

 * Plugin Name: Grd Addons

 * Plugin URI: http://steelthemes.com/plugins/grd-addons.zip

 * Description: Extra elements for Visual Composer. It was built for Grd theme.

 * Version: 1.1

 * Author: SteelThemes

 * Author URI: http://steelthemes.com

 * License: GPL2+

 * Text Domain: grd

 * Domain Path: /lang/

 */

if ( ! defined( 'ABSPATH' ) ) {

	die( '-1' );

}



if ( ! defined( 'GRD_ADDONS_DIR' ) ) {

	define( 'GRD_ADDONS_DIR', plugin_dir_path( __FILE__ ) );

}



if ( ! defined( 'GRD_ADDONS_URL' ) ) {

	define( 'GRD_ADDONS_URL', plugin_dir_url( __FILE__ ) );

}



require_once GRD_ADDONS_DIR . '/inc/visual-composer.php';

require_once GRD_ADDONS_DIR . '/inc/shortcodes.php';

require_once GRD_ADDONS_DIR . '/inc/portfolio.php';

require_once GRD_ADDONS_DIR . '/inc/services.php';

require_once GRD_ADDONS_DIR . '/inc/widgets/widgets.php';



if ( is_admin() ) {

	require_once GRD_ADDONS_DIR . '/inc/importer.php';

}



/**

 * Init

 */

function grd_vc_addons_init() {

	load_plugin_textdomain( 'grd', false, dirname( plugin_basename( __FILE__ ) ) . '/lang' );



	new Grd_VC;

	new Grd_Shortcodes;

	new Grd_Portfolio;

	new Grd_Services;

}



add_action( 'after_setup_theme', 'grd_vc_addons_init', 20 );

