<?php
/**
 * Form template
 *
 * @package Social Contact Form
 * @since 1.0.0
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit(); ?>

<div class="scf-icon <?php echo esc_attr( $args['alignment'] ); ?>" style="
<?php
echo wp_sprintf(
	'top: %s; right: %s; bottom: %s; left: %s; %s; display: none',
	esc_attr( $args['icon_position']['top'] ),
	esc_attr( $args['icon_position']['right'] ),
	esc_attr( $args['icon_position']['bottom'] ),
	esc_attr( $args['icon_position']['left'] )
);
?>
">

	<!-- call to action text  -->
	<?php
	if (
	isset( $args['scf']['call_to_action']['text'] ) &&
	! empty( $args['scf']['call_to_action']['text'] )
	) :
		?>
		<div class="scf-cta" style="
			<?php
				echo wp_sprintf(
				'font-size: %spx; color: %s; background: %s',
				esc_attr( $args['cta_size'] ),
				esc_attr( $args['scf']['call_to_action']['color'] ),
				esc_attr( $args['scf']['call_to_action']['background'] )
				);
			?>
		">
			<?php echo esc_html( $args['scf']['call_to_action']['text'] ); ?>
		</div>
	<?php endif; ?>

	<!-- icon  -->
	<div class="scf-icon-image" style="<?php echo wp_sprintf( 'width: %spx', esc_attr( $args['icon_size'] ) ); ?> ">
		<img class="w-full" src="<?php echo esc_html( isset( $args['scf']['icon']['image'] ) && ! empty( $args['scf']['icon']['image'] ) ? $args['scf']['icon']['image'] : SCF_PUBLIC . '/images/whatsapp.svg' ); ?>">
	</div>
	<?php do_action( 'scf_after_icon' ); ?>
</div>
