<?php
/**
 * Form template
 *
 * @package Social Contact Form
 * @since 1.0.0
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;
$scf        = scf_get_options();
$selected = $scf['contact_form_7']['selectedmode'];
$formrender = $scf['contact_form_7']['formrender'];
// $cf7NotActivated = $scf['contact_form_7']['cf7NotActivated'];

/**
 * Sanitize inputs.
 *
 * @param mixed $input Array or string.
 * @return mixed
 */
function sanitize_html_input( $input ) {
	// Define allowed tags and attributes.
	$allowed_tags = [
		'form' => [
			'action' => [],
			'method' => [],
			'class' => [],
			'aria-label' => [],
			'novalidate' => [],
			'data-status' => [],
			'style' => [],
		],
		'div' => [
			'class' => [],
			'id' => [],
			'lang' => [],
			'dir' => [],
			'style' => [],
		],
		'span' => [
			'class' => [],
			'data-name' => [],
			'style' => [],
		],
		'input' => [
			'size' => [],
			'class' => [],
			'autocomplete' => [],
			'aria-required' => [],
			'aria-invalid' => [],
			'placeholder' => [],
			'value' => [],
			'type' => [],
			'name' => [],
			'style' => [],
			'min' => [],
			'max' => [],
		],
		'textarea' => [
			'cols' => [],
			'rows' => [],
			'class' => [],
			'aria-invalid' => [],
			'placeholder' => [],
			'name' => [],
			'style' => [],
		],
		'select' => [
			'name' => [],
			'class' => [],
			'id' => [],
			'style' => [],
		],
		'option' => [
			'value' => [],
			'selected' => [],
			'disabled' => [],
			'label' => [],
			'class' => [],
			'style' => [],
		],
		'label' => [
			'for' => [],
			'style' => [],
		],
		'p' => [
			'role' => [],
			'aria-live' => [],
			'aria-atomic' => [],
			'style' => [],
		],
		'ul' => [],
		'li' => [],
		'br' => [],
	];

	// Define allowed protocols for links.
	$allowed_protocols = wp_allowed_protocols();
	$allowed_protocols[] = 'data';

	// Sanitize input using wp_kses.
	$sanitized_input = wp_kses( $input, $allowed_tags, $allowed_protocols );

	return $sanitized_input;
}


$args['bottom'] = $args['icon_size'] + 10; ?>

<!-- overlay  -->
<div class="scf-form-overlay" style="display: none;"></div>

<div class="scf-form <?php echo esc_attr( $args['alignment'] ); ?>" style="
	<?php
	echo wp_sprintf(
		'width: %spx; display: %s; left: %s; top: %s; right: %s; bottom: %s; margin-bottom: %spx',
		esc_attr( $args['size'] ),
		esc_attr( $args['is_open'] ? 'block' : 'none'),
		esc_attr( $args['position']['left'] ),
		esc_attr( $args['position']['top'] ),
		esc_attr( $args['position']['right'] ),
		esc_attr( $args['position']['bottom'] ),
		esc_attr( $args['bottom'] )
	);
	?>
">

	<!-- header  -->
	<div class="scf-form-header colored">
		<div class="scf-form-title">
			<?php echo esc_html( $args['form']['title'] ); ?>
		</div>
		<!-- close  -->
		<div class="scf-form-close">
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16">
				<path fill-rule="evenodd"
					d="M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z" />
			</svg>
		</div>
	</div>

	<!-- SCF form -->
	<?php if ( 'scf' === $selected ) : ?>
	<form action="
			<?php
			echo esc_url( admin_url( 'admin-ajax.php' ) );
			?>
			" class="scf-form-content" id="scf-form-content">
		<?php do_action( 'scf_before_form' ); ?>
		<!-- action  -->
		<input type="hidden" name="action" value="scf_form_action">
		<input type="hidden" name="nonce" value="
				<?php
				// Create nonce field.
				echo esc_attr( wp_create_nonce( 'scf_form_action' ) );
				?>
				">

		<?php if ( isset( $args['form']['header'] ) && ! empty( $args['form']['header'] ) ) : ?>
		<div class="text-sm text-slate-500">
			<?php echo esc_html( $args['form']['header'] ); ?>
		</div>
		<?php endif; ?>

		<div class="py-1.5"></div>

		<?php
					$args['fields'] = \WPPOOL\SCF\App::fields();

		if ( ! empty( $args['fields'] ) ) {
			foreach ( $args['fields'] as $args['field'] ) {
				new \WPPOOL\SCF\Field( $args['field'] );
			}
		}
		?>


		<?php do_action( 'scf_after_form' ); ?>

		<?php if ( ! empty( $args['form']['footer'] ) ) : ?>
		<div class="scf-form-footer">
			<?php echo esc_html( $args['form']['footer'] ); ?>
		</div>
		<?php endif; ?>
		<!-- submit  -->
		<button class="scf-form-submit colored" type="submit">
			<svg xmlns="http://www.w3.org/2000/svg" class="fill-current w-4" viewBox="0 0 16 16">
				<path
					d="M13.601 2.326A7.854 7.854 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.933 7.933 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.898 7.898 0 0 0 13.6 2.326zM7.994 14.521a6.573 6.573 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.557 6.557 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592zm3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.729.729 0 0 0-.529.247c-.182.198-.691.677-.691 1.654 0 .977.71 1.916.81 2.049.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232z" />
			</svg>
			<?php echo esc_html( $args['form']['submit'] ); ?>
		</button>
	</form>
	<?php endif; ?>
	<!-- End of SCF form  -->
	<!-- CF7 Form Render  -->

	<?php if ( 'cf7' === $selected ) : ?>

		<?php if ( isset( $args['form']['header'] ) && ! empty( $args['form']['header'] ) ) : ?>
	<div class="text-sm text-slate-500 scf-cf7-form-header">
			<?php echo esc_html( $args['form']['header'] ); ?>
	</div>
	<?php endif; ?>

	<div class="py-1.5"></div>

		<?php
						// phpcs:ignore
						echo sanitize_html_input( $formrender );
		?>

		<?php do_action( 'scf_after_form' ); ?>
		<?php if ( ! empty( $args['form']['footer'] ) ) : ?>
	<div class="scf-form-footer">
			<?php echo esc_html( $args['form']['footer'] ); ?>
	</div>
	<?php endif; ?>

	<?php endif; ?>
	<!-- End  -->

</div>
