<?php
/**
 * Base template for Social Contact Form Frontend
 *
 * @package Social Contact Form
 * @since 1.0.0
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

global $scf;
$icon      = $scf['icon'];
$icon_size = [
	'small'  => '45',
	'medium' => '60',
	'large'  => '85',
	'custom' => isset( $icon['size_custom'] ) ? $icon['size_custom'] : '60',
][ $scf['icon']['size'] ];

$icon_position = [
	'left'   => [
		'top'    => 'auto',
		'right'  => 'auto',
		'bottom' => '16px',
		'left'   => '16px',
	],
	'right'  => [
		'top'    => 'auto',
		'right'  => '16px',
		'bottom' => '16px',
		'left'   => 'auto',
	],
	'custom' => [
		'top'    => $scf['icon']['position_top'] ? $scf['icon']['position_top'] . 'px' : 'auto',
		'right'  => $scf['icon']['position_right'] ? $scf['icon']['position_right'] . 'px' : 'auto',
		'bottom' => $scf['icon']['position_bottom'] ? $scf['icon']['position_bottom'] . 'px' : 'auto',
		'left'   => $scf['icon']['position_left'] ? $scf['icon']['position_left'] . 'px' : 'auto',
	],
][ $scf['icon']['position'] ];

$cta_size = [
	'small'  => '16',
	'medium' => '18',
	'large'  => '20',
	'custom' => isset( $scf['call_to_action']['size_custom'] ) ? $scf['call_to_action']['size_custom'] : '18',
][ $scf['call_to_action']['size'] ];


$alignment = isset( $icon['position'] ) ? $icon['position'] : 'left';
if ( 'custom' === $alignment ) {
	$alignment = 'auto' === $icon_position['left'] ? 'right' : 'left';
}


$icon = $scf['icon'];
$form = $scf['form'];

$form_size = [
	'small'  => '280',
	'medium' => '350',
	'large'  => '420',
	'custom' => isset( $form['size_custom'] ) ? $form['size_custom'] : '350',
][ $form['size'] ];

$is_open = scf_is_true( $form['open_by_default'] );

?>

<div class="scf-widget">
	<?php

	scf_render( 'frontend/icon', [
		'scf'           => $scf,
		'icon'          => $icon,
		'icon_size'     => $icon_size,
		'icon_position' => $icon_position,
		'cta_size'      => $cta_size,
		'alignment'     => $alignment,
	] );

	scf_render( 'frontend/form', [
		'scf'       => $scf,
		'form'      => $form,
		'size'      => $form_size,
		'icon_size' => $icon_size,
		'is_open'   => $is_open,
		'alignment' => $alignment,
		'position'  => $icon_position,
	] );

	?>
</div>
