<?php

/**
 * Admin Settings Setup Finished
 *
 * @package Social Contact Form
 * @since 1.0.0
 */
?>
<div x-show="state.finished" class="p-3 bg-slate-100 w-full" x-transition.opacity>
	<!-- finished setup  -->
	<div class="flex items-center justify-center">
		<lottie-player autoplay loop mode="normal" src="
			<?php echo esc_url( SCF_PUBLIC ); ?>/json/animation.json" class="w-28">
		</lottie-player>
	</div>
	<div class="text-center text-slate-600 text-2xl py-2 flex items-center justify-center gap-2">
		<?php esc_html_e( 'Setup Finished!', 'social-contact-form' ); ?>
	</div>
	<div x-show="is_true(options.enabled)" class="text-center text-slate-500 text-lg py-1">
		<?php echo wp_sprintf( '%s <a class="text-indigo-600" href="https://go.wppool.dev/2rc7">%s</a>', esc_html__( 'Now you can use', 'social-contact-form' ), esc_html__( 'Social Contact Form', 'social-contact-form' ) ); ?>
	</div>
	<div x-show="!is_true(options.enabled)" class="text-center text-slate-500 text-lg py-1">
		<?php echo wp_sprintf( 'Social Contact Form is inactive, you can\'t use the form on your website right now.', esc_html__( '<a class="text-indigo-600" href="https://go.wppool.dev/2rc7">Social Contact Form</a>', 'social-contact-form' ), esc_html__( 'Social Contact Form', 'social-contact-form' ) ); ?>
	</div>


	<div class="flex items-center justify-center max-w-md mx-auto my-6 gap-4 h-32">
		<div @click.prevent="state.finished = false; state.saving = false; state.step = 1" class="w-32 px-6 py-4 text-lg font-semibold rounded-md bg-white text-center text-slate-600 flex items-center justify-center cursor-pointer hover:opacity-90 hover:text-white hover:bg-indigo-600 transition duration-150 ring ring-indigo-600 hover:ring-indigo-600">
			<?php esc_html_e( 'Done', 'social-contact-form' ); ?>
		</div>
		<template x-if="!isPro">
			<div @click.prevent="upgradeAfterSetup" class="px-6 py-4 text-lg font-semibold rounded-md bg-white text-center text-slate-600 flex items-center justify-center cursor-pointer hover:bg-red-600 hover:text-white transition duration-150 ring ring-red-300 hover:ring-red-600">
				<?php esc_html_e( 'Upgrade all features', 'social-contact-form' ); ?>
			</div>
		</template>
	</div>
</div>
