<?php

/**
 * Admin Settings Section WhatsApp
 *
 * @package Social Contact Form
 * @since 1.0.0
 */
?>
<div x-show="currentStep.id === 'whatsapp'" x-transition.opacity>

	<?php
	do_action( 'scf_before_whatsapp_fields' );
	?>

	<!-- input text  -->
	<div class="mb-5">

		<label for="whatsapp_number"
			class="form-label"><?php esc_html_e( 'WhatsApp Number', 'social-contact-form' ); ?></label>
		<div class="flex gap-2 flex-row justify-between">
			<div class="w-24">
				<div x-show="state.showCountryList" class="absolute top-0 left-0 w-full h-full z-10"
					@click.prevent="state.showCountryList = false"></div>
				<div class="relative w-full">

					<button class="w-full scf-input px-2 block py-2 h-10 sm:h-9 flex items-center gap-2 font-medium"
						@click.prevent="state.showCountryList = !state.showCountryList; setTimeout(() => {$refs.search_country.focus()}, 50)">
						<span x-show="currentCountry" x-html="currentCountry.emoji || ''">🇦🇫</span>
						<span x-show="currentCountry" x-text="currentCountry.phone_code"></span>
						<span x-show="!currentCountry"
							class="italic text-indigo-600"><?php esc_html_e( 'Select a country', 'social-contact-form' ); ?></span>
					</button>


					<div x-show="state.showCountryList" x-transition.opacity
						class="absolute z-50 bg-white rounded-md w-64 h-56 overflow-y-auto mt-2 shadow-lg z-10 scrollbar scrollbar-thin scrollbar-track-slate-200 scrollbar-thumb-indigo-600">
						<!-- search  -->
						<div class="p-1 w-full pr-3">
							<input x-ref="search_country" x-model="state.search_country" class="scf-input w-full"
								@keydown.enter="options.whatsapp.phone_code = countries[0].phone_code; state.showCountryList = false"
								type="text"
								placeholder="<?php esc_html_e( 'Search country', 'social-contact-form' ); ?>">
						</div>
						<template x-for="country in countries">
							<label
								@click.prevent="options.whatsapp.phone_code = country.phone_code; state.showCountryList = false"
								class="flex items-center py-2 px-4 hover:bg-gray-100">
								<span x-html="`${country.emoji} (${country.phone_code}) - ${country.name}`"></span>
							</label>
						</template>
					</div>
				</div>
			</div>
			<div class="w-full">

				<input id="whatsapp_number"
					placeholder="<?php esc_html_e( 'WhatsApp number', 'social-contact-form' ); ?>" type="text"
					maxlength="15" class="w-full scf-input" x-model="options.whatsapp.phone_number"
					@keyup="options.whatsapp.phone_number = options.whatsapp.phone_number.replace(/[^0-9]/g, '')"
					x-ref="whatsapp_number" @input="state.errors.whatsapp = ''" />
			</div>
		</div>
		<div x-show="state.errors.whatsapp" x-transition class="text-sm text-red-400 bg-red-50 p-2 mt-2 rounded-md"
			x-text="state.errors.whatsapp || ''">
		</div>
	</div>

	<!-- whatsapp web for desktop  -->
	<div class="mb-3" @click="upgradeModal">
		<div class="scf-switch whatsAppredirect"
			@click.prevent="isPro ? (options.whatsapp.direct_web = is_true(options.whatsapp.direct_web) ? false : true) : ''"
			:class="[is_true(options.whatsapp.direct_web) ? 'active' : 'inactive']">
			<div :class="not_free" style="width: 2.25rem;"></div>
			<label class="gap-1">
				<span class="scf_auto_whatsapp_redi"
					:class="not_free"><?php esc_html_e( 'Open WhatsApp web when accessing from desktop', 'social-contact-form' ); ?>
				</span>
				<info-tip>
					<?php echo wp_kses_post( 'By enabling this feature, WhatsApp will be automatically opened on your web browser when accessed from a laptop/PC.', 'social-contact-form' ); ?>
				</info-tip>
				<ultimate-badge />
			</label>
		</div>
	</div>

	<?php do_action( 'scf_after_whatsapp_fields' ); ?>

	<!-- textarea  -->
	<div class="mb-0" @click="upgradeModal">
		<div class="flex items-center justify-between">
			<label for="whatsapp_preset" class="form-label">
				<span :class="not_free"><?php esc_html_e( 'Preset message', 'social-contact-form' ); ?> </span>
				<info-tip>
					<?php esc_html_e( 'Preset Message is a convenient way of sending quick messages. You can also customize your preset message through this section.', 'social-contact-form' ); ?>
				</info-tip>
				<ultimate-badge />
			</label>
			<div :class="not_free"
				class="sm:-mb-1 flex items-center justify-end border border-slate-100 text-xs text-slate-500  rounded-t-sm gap-0.5">
				<label class="px-2 py-0.5 rounded-t-sm " :class="state.preset_preview ? 'bg-slate-200' : 'bg-white'"
					@click.prevent="state.preset_preview = 0"><?php esc_html_e( 'Editor', 'social-contact-form' ); ?></label>
				<label class="px-2  py-0.5 rounded-t-sm" :class="state.preset_preview ? 'bg-white' : 'bg-slate-200'"
					@click.prevent="state.preset_preview = 1"><?php esc_html_e( 'Preview', 'social-contact-form' ); ?></label>
			</div>
		</div>

		<!-- message  -->
		<textarea x-ref="preset" x-show="!state.preset_preview" :class="not_free" id="whatsapp_preset"
			:disabled="!isPro" placeholder="<?php esc_html_e( 'Message format', 'social-contact-form' ); ?>" rows="4"
			class="w-full scf-input" :value="getPreset" @input="setPreset"></textarea>

		<!-- preview  -->
		<div x-show="state.preset_preview" class="bg-slate-100 text-slate-600 text-sm rounded-md p-3"
			x-html="preset_message"></div>


		<div class="form-help cursor-pointer py-0"
			@click.prevent="isPro ? state.show_format_guide = !state.show_format_guide : ''">
			<?php esc_html_e( 'Format preset message', 'social-contact-form' ); ?>

			<info-tip><?php esc_html_e( 'Learn how to format preset message.', 'social-contact-form' ); ?></info-tip>

		</div>
		<div :class="not_free" x-show="state.show_format_guide" x-transition.opacity.delay.50ms
			class="bg-slate-100 p-3 rounded-dm shadow-sm text-slate-600 relative">

			<!-- close  -->
			<div class="absolute -top-8 -right-2 p-2 cursor-pointer hover:text-red-500 transition duration-200"
				@click.prevent="state.show_format_guide = 0">
				<svg class="fill-current text-slate-500 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
					<path
						d="M10 8.586L2.929 1.515 1.515 2.929 8.586 10l-7.071 7.071 1.414 1.414L10 11.414l7.071 7.071 1.414-1.414L11.414 10l7.071-7.071-1.414-1.414L10 8.586z" />
				</svg>
			</div>

			<div class="flex flex-wrap items-center justify-center gap-1 mb-2">
				<?php

				$tags = \WPPOOL\SCF\App::supported_tags();

				foreach ( $tags as $custom_tag => $label ) {
					echo '<div class="text-xs bg-indigo-600 mb-1 hover:opacity-90 transition duration-150 text-white px-2 py-1 rounded-md cursor-pointer" @click.prevent="addPresetTag(\'' . esc_html( $custom_tag ) . '\', \'' . esc_html( $label ) . '\')">{' . esc_html( $custom_tag ) . '}</div>';
				}

				?>
			</div>

			<table class="leading-normal">
				<tr>
					<td><strong><?php esc_html_e( 'Bold', 'social-contact-form' ); ?></strong></td>
					<td><?php esc_html_e( 'Place an asterisk on either side (*bold*).', 'social-contact-form' ); ?>
					</td>
				</tr>
				<tr>
					<td><em><?php esc_html_e( 'Italicize', 'social-contact-form' ); ?></em></td>
					<td><?php esc_html_e( 'Place an underscore on either side (_italic_).', 'social-contact-form' ); ?>
					</td>
				</tr>
				<tr>
					<td><s><?php esc_html_e( 'Strikethrough', 'social-contact-form' ); ?></s></td>
					<td><?php esc_html_e( 'Place a tilde on either side (~strikethrough~).', 'social-contact-form' ); ?>
					</td>
				</tr>
				<tr>
					<td>
						<pre><?php esc_html_e( 'Monospace', 'social-contact-form' ); ?></pre>
					</td>
					<td><?php esc_html_e( 'Place three back ticks on either side (```monospace```).', 'social-contact-form' ); ?>
					</td>
				</tr>
			</table>
		</div>

	</div>

	<?php do_action( 'scf_after_whatsapp_pro_fields' ); ?>

</div>
